import React, { useState } from 'react';
import TopBar from '@QPComponents/TopBar';
import QPLabel from '@QPComponents/Labels/QPLabel';
import { __ } from '@wordpress/i18n';
import Certificate from './pages/Certificate';
import { getAddonActiveStatus, route_path } from '@QPUtils/helper';
import { useSelector } from 'react-redux';
import { Link, useLocation } from 'react-router-dom';
import SubTopBar from '@QPComponents/SubTopBar';

import './styles.scss';

function useQuery() {
	const { search } = useLocation();

	return React.useMemo( () => new URLSearchParams( search ), [ search ] );
}

const Tools = () => {
	const allAddons = useSelector( ( state ) => state.addons );
	const location = useQuery();
	const path = location.get( 'path' ) || 'reset_certificate';

	const CertificateTabs = getAddonActiveStatus( allAddons, 'certificates' )
		? [
				{
					title: __( 'Quizpress Certificates', 'quizpress' ),
					icon: 'certificate',
					name: 'reset_certificate',
					slug: 'reset_certificate',
					route: `&path=reset_certificate`,
				},
		  ]
		: [];

	const tabs = [ ...CertificateTabs ];

	const renderSwitch = ( urlPath ) => {
		switch ( urlPath ) {
			case 'reset_certificate':
				return <Certificate />;
			default:
				return <Certificate />;
		}
	};

	return (
		<>
			<TopBar
				leftContent={ () => (
					<>
						<span className="quizpress-topbar-logo quizpress-icon quizpress-icon--quizpress" />
						<span className="quizpress-icon quizpress-icon--angle-right quizpress-muted" />
						<QPLabel
							as="h2"
							color="#4F46E5"
							type="subtitle"
							fontWeight="medium"
							label={ __( 'Tools', 'quizpress' ) }
						/>
					</>
				) }
			/>
			<SubTopBar heading={ __( 'Tools', 'quizpress' ) } />
			<div className="quizpress-page-content quizpress-page-content--tools">
				<div className="quizpress-tab-panel">
					{ tabs.map( ( tabItem, tabIndex ) => {
						return (
							<div
								className={ `quizpress-tab-panel-control quizpress-tab-panel__item ${
									tabItem.name === path
										? 'quizpress-tab-panel__item--is-open'
										: ''
								}` }
								key={ tabIndex }
							>
								{ tabItem.link ? (
									<Button
										type="link"
										label={ tabItem.title }
										link={ tabItem?.link }
										className={ `quizpress-tab-item ${
											path === tabItem.name
												? 'quizpress-tab-item--is-active'
												: ''
										}` }
										icon={
											<span
												className={ `quizpress-icon quizpress-icon--${ tabItem.icon }` }
											/>
										}
									/>
								) : (
									<Link
										to={ `${ route_path }admin.php?page=quizpress-tools${ tabItem.route }` }
										className={ `quizpress-tab-item ${
											path === tabItem.name
												? 'quizpress-tab-item--is-active'
												: ''
										}` }
									>
										<span
											className={ `quizpress-icon quizpress-icon--${ tabItem.icon }` }
										/>
										{ tabItem.title }
									</Link>
								) }
							</div>
						);
					} ) }
				</div>

				<div className="quizpress-page-content--tools__content">
					{ renderSwitch( path ) }
				</div>
			</div>
		</>
	);
};

export default Tools;
