import ListTable from '@QPComponents/ListTable';
import { makeRequest } from '@QPUtils/helper';
import { __ } from '@wordpress/i18n';
import React, { useEffect, useState } from 'react';
import { primaryBtn } from '../../../../../../assets/scss/chakra/recipe';
import { Button } from '@chakra-ui/react';

const columns = [
	{
		name: __( 'ID', 'quizpress' ),
		sortable: true,
		cell: ( row ) => (
			<div className="quizpress-table-title-wrap">
				<div className="">{ row.ID }</div>
			</div>
		),
	},
	{
		name: __( 'Certificate Name', 'quizpress' ),
		sortable: true,
		cell: ( row ) => (
			<div className="quizpress-table-title-wrap">
				<div className="quizpress-table-title">
					{ Object.values( row?.title ) }
				</div>
			</div>
		),
	},
	{
		name: __( 'Certificates Slug', 'quizpress' ),
		sortable: true,
		cell: ( row ) => (
			<div className="quizpress-table-title-wrap">
				<div className="quizpress-table-title">{ row.slug }</div>
			</div>
		),
	},
];

const title = __(
	'Are you sure you want to regenerate the default quizpress certificates?',
	'quizpress'
);

const subTitle = __(
	'This will reset custom certificates that are automatically created when you activate the certificate addon and replace them with the default template.\nClick "OK" to continue or "Cancel" to keep your custom certificates.',
	'quizpress'
);

const Certificate = () => {
	const [ isLoading, setIsLoading ] = useState( false );
	const [ certificates, setCertificates ] = useState( [] );

	const fetchCertificates = () => {
		setIsLoading( true );
		makeRequest( {
			action: 'quizpress_certificates/fetch_quizpress_certificates',
		} )
			.then( ( response ) => {
				setCertificates( response?.data || [] );
			} )
			.finally( () => {
				setIsLoading( false );
			} );
	};
	useEffect( () => {
		fetchCertificates();
	}, [] );

	const reGeneratePageHandler = () => {
		if ( window.confirm( title + '\n\n' + subTitle ) ) {
			setIsLoading( true );
			makeRequest( {
				action: 'quizpress_certificates/regenerate_quizpress_certificates',
			} )
				.then( () => {
					fetchCertificates();
					showNotification( {
						message: __(
							'Successfully Re-Generated Certificates.',
							'quizpress'
						),
						isShow: true,
						type: 'success',
					} );
				} )
				.finally( () => {
					setIsLoading( false );
				} );
		}
	};
	return (
		<div className="quizpress-tools-page__short-code">
			<h3 className="quizpress-heading">
				{ __( 'Quizpress Certificates', 'quizpress' ) }
			</h3>
			<div className="quizpress-tools-page-quizpress__body">
				<ListTable
					className="quizpress-list-wrap"
					columns={ columns }
					data={ certificates?.data }
					noDataText={ __(
						'No pages data was found to see the available list here.',
						'quizpress'
					) }
					progressPending={ isLoading }
					showColumnFilter={ false }
					isRowSelectable={ false }
					suffix="tools-certificates"
					showSubHeader={ false }
				/>
				<Button
					{ ...primaryBtn }
					isLoading={ isLoading }
					onClick={ reGeneratePageHandler }
					marginTop="12px"
				>
					{ __( 'Re-Generate Certificates', 'quizpress' ) }
				</Button>
			</div>
		</div>
	);
};

export default Certificate;
