import React from 'react';
import { __ } from '@wordpress/i18n';
import { useSelector } from 'react-redux';
import Quiz from './step';
import AttemptsStarter from './AttemptsStarter';

export default function QuizView( {
	steps,
	ID,
	currentAttempt,
	attemptsData,
	setSteps,
	handleFetchAttempts,
	handleStartQuiz,
} ) {
	const quizzes = useSelector( ( state ) => state.quizzes );
	const currentQuiz = quizzes.data[ 0 ];

	switch ( steps ) {
		case 0:
			return (
				<AttemptsStarter
					handleStartQuiz={ handleStartQuiz }
					attemptsData={ attemptsData }
					quizID={ ID }
					handleFetchAttempts={ handleFetchAttempts }
					currentAttempt={ currentAttempt }
				/>
			);
		case 1:
			return (
				<Quiz
					ID={ ID }
					setSteps={ setSteps }
					currentAttempt={ currentAttempt }
					attemptId={ currentAttempt?.attempt_id }
					totalAttempts={ attemptsData?.attempts }
					handleFetchAttempts={ handleFetchAttempts }
					handleStartQuiz={ handleStartQuiz }
					currentQuiz={ currentQuiz }
				/>
			);
		default:
			return null;
	}
}
