import { Button, Flex, Text } from '@chakra-ui/react';
import { __, sprintf } from '@wordpress/i18n';
import React, { useEffect, useState } from 'react';
import { primaryBtn } from '../../../../assets/scss/chakra/recipe';
import { useSelector } from 'react-redux';
import { Span } from '@chakra-ui/react';
import QuizDetailsModal from './QuizDetailsModal';
import { addons, certificate_url, makeRequest } from '@QPUtils/helper';
import { InstructorFeedBack, isAllowReAttempt } from '../helper';

const Congratulatory = ( {
	attempts,
	submittedAttempt,
	type = 'quiz',
	handleStartQuiz,
} ) => {
	const quizzes = useSelector( ( state ) => state.quizzes );
	const [ openQuizDetails, setOpenDetailsModal ] = useState( false );
	const [ feedback, setFeedback ] = useState( '' );

	const congratulatoryModalOpen = () => {
		setOpenDetailsModal( true );
	};

	const currentQuiz = quizzes.data[ 0 ];
	const isShowReAttemptBtn =
		currentQuiz?.meta?.quizpress_quiz_pass_reattempt &&
		isAllowReAttempt(
			currentQuiz?.meta?.quizpress_quiz_feedback_mode,
			currentQuiz?.meta?.quizpress_quiz_max_attempts_allowed,
			attempts?.length
		);

	const congratulatorySubTitle = () => {
		switch ( type ) {
			case 'quiz':
				return 'You have successfully passed the quiz';
			case 'survey':
				return 'You have successfully completed the survey';
			case 'exams':
				return 'You have successfully passed the exams';
			default:
				return 'Your have successfully completed the poll';
		}
	};
	const isQuiz = type === 'quiz' || type === 'exams';

	const successAttempts = attempts.filter(
		( att ) => att.attempt_status === 'passed'
	);

	useEffect( () => {
		makeRequest( `frontend/get_user_attempt_feedback`, {
			attempt_id: submittedAttempt?.attempt_id,
		} ).then( ( res ) => {
			setFeedback( res );
		} );
	}, [] );

	return (
		<>
			<Flex width="100%" maxW="420px" flexDirection="column" gap={ 6 }>
				<Flex
					flexDirection="column"
					background="#EFF6FF"
					boxShadow="0 0 1px 0 rgba(20, 26, 36, 0.30), 0 2px 4px 0 rgba(20, 26, 36, 0.10)"
					padding={ 6 }
					gap={ 6 }
				>
					<Flex
						flexDirection="column"
						alignItems="center"
						paddingTop={ 3 }
					>
						<Flex justifyContent="center">
							<Span
								className="quizpress-icon quizpress-icon--congratulations"
								_before={ {
									fontSize: '36px',
								} }
							/>
						</Flex>
						<Text
							color="#13191B"
							fontWeight="500"
							fontSize="1.5rem"
						>
							{ __( 'Congratulations', 'quizpress' ) }
						</Text>
						<Text color="#738496" fontSize="0.875rem">
							{ sprintf(
								__( '%s', 'quizpress' ),
								congratulatorySubTitle()
							) }
						</Text>
					</Flex>
					<Flex flexDirection="column" gap={ 4 } paddingTop={ 6 }>
						<Flex
							alignItems="center"
							justifyContent="space-between"
						>
							<Text fontSize="0.875rem">
								{ __( 'Total Question' ) }
							</Text>
							<Text fontSize="1rem" fontWeight="500">
								{ __(
									currentQuiz?.meta?.quizpress_quiz_questions
										.length,
									'quizpress'
								) }
							</Text>
						</Flex>
						<Flex
							alignItems="center"
							justifyContent="space-between"
						>
							<Text fontSize="0.875rem">
								{ __( 'Quiz Time' ) }
							</Text>
							<Text fontSize="1rem" fontWeight="500">
								{ __(
									currentQuiz?.meta?.quizpress_quiz_time,
									'quizpress'
								) }
							</Text>
						</Flex>
						<Flex
							alignItems="center"
							justifyContent="space-between"
						>
							<Text fontSize="0.875rem">
								{ __( 'Total Attempted' ) }
							</Text>
							<Text fontSize="1rem" fontWeight="500">
								{ __( attempts.length, 'quizpress' ) }
							</Text>
						</Flex>
						{ isQuiz && (
							<Flex
								alignItems="center"
								justifyContent="space-between"
							>
								<Text fontSize="0.875rem">
									{ __( 'Successful Attempted' ) }
								</Text>
								<Text fontSize="1rem" fontWeight="500">
									{ __(
										successAttempts.length,
										'quizpress'
									) }
								</Text>
							</Flex>
						) }
					</Flex>
					{ isQuiz && (
						<Button
							{ ...primaryBtn }
							onClick={ congratulatoryModalOpen }
						>
							{ __( 'View Details', 'quizpress' ) }
						</Button>
					) }
					{ isShowReAttemptBtn && (
						<Button { ...primaryBtn } onClick={ handleStartQuiz }>
							{ __( 'Re-Attempt', 'quizpress' ) }
						</Button>
					) }
					{ addons && addons?.certificates && (
						<Button
							{ ...primaryBtn }
							onClick={ () => {
								window.open(
									`${ certificate_url }&quiz_id=${ currentQuiz?.id }`,
									'_blank'
								);
							} }
						>
							{ __( 'Download Certificate', 'quizpress' ) }
						</Button>
					) }
				</Flex>

				<InstructorFeedBack feedback={ feedback } />
			</Flex>
			{ openQuizDetails && (
				<QuizDetailsModal
					isOpen={ openQuizDetails }
					onRequestClose={ () => setOpenDetailsModal( false ) }
					attempts={ attempts }
					submittedAttempt={ submittedAttempt }
				/>
			) }
		</>
	);
};

export default Congratulatory;
