import { Flex, Text, Textarea } from '@chakra-ui/react';
import { __ } from '@wordpress/i18n';

export const InstructorFeedBack = ( { feedback } ) => {
	if ( ! feedback || feedback === '' ) {
		return;
	}

	return (
		<Flex direction="column" gap={ 2 } width="full">
			<Text
				className="quizpress-title"
				fontSize="1.25rem"
				fontWeight="semibold"
			>
				{ __( 'Instructor Feedback', 'quizpress' ) }
			</Text>

			<Text m={ 0 }>{ feedback }</Text>
		</Flex>
	);
};

export const isAllowReAttempt = (
	feedbackMode,
	maxAllowedAttempts,
	totalAttempts = 0
) => {
	if ( feedbackMode === 'retry_mode' && totalAttempts < maxAllowedAttempts ) {
		return true;
	}
	return false;
};
