import { API, plugin_root_url } from '@Utils/helper';
import React, { useEffect, useState } from 'react';
import PropTypes from 'prop-types';

const propTypes = {
	id: PropTypes.number,
	type: PropTypes.string,
};

export default function Image( props ) {
	const { id = 0 } = props;
	const [ imageObj, setImageObj ] = useState( false );
	useEffect( () => {
		if ( id ) {
			API.get( `wp/v2/media/${ id }` ).then( ( res ) => {
				setImageObj( res.data );
			} );
		}
	}, [ id ] );

	return (
		<React.Fragment>
			<div
				className="quizpress-image"
				style={ {
					backgroundImage: `url(${
						imageObj?.source_url ||
						plugin_root_url +
							'assets/images/thumbnail-placeholder.png'
					})`,
				} }
			></div>
		</React.Fragment>
	);
}

Image.propTypes = propTypes;
