import { Flex, Grid, Span } from '@chakra-ui/react';
import { __, sprintf } from '@wordpress/i18n';
import React from 'react';
import QuizTimer from './QuizTimer';
import { useFormikContext } from 'formik';

const QuizHeader = ( {
	currentQuiz,
	attempts,
	stepIndex,
	currentQuestion,
} ) => {
	const { values } = useFormikContext();

	return (
		<Flex
			justifyContent="space-between"
			alignItems="center"
			width="100%"
			padding={ 4 }
			borderRadius="4px"
			flexWrap="wrap"
			gap={ 3 }
		>
			{ ! currentQuiz?.meta?.quizpress_quiz_hide_question_number && (
				<Flex
					gap={ 2 }
					alignItems="center"
					fontSize="sm"
					m={ 0 }
					fontWeight="500"
				>
					<Span color="var(--quizpress-warn-muted)">
						{ __( 'Question No:', 'quizpress' ) }
					</Span>
					<Span>
						{ sprintf( __( `%s`, 'quizpress' ), stepIndex + 1 ) }
					</Span>
				</Flex>
			) }
			<Flex
				gap={ 2 }
				alignItems="center"
				fontSize="sm"
				m={ 0 }
				fontWeight="500"
			>
				<Span color="var(--quizpress-warn-muted)">
					{ __( 'Total Attempted:', 'quizpress' ) }
				</Span>
				<Span>
					{ sprintf(
						__( `%s/%s`, 'quizpress' ),
						attempts?.length,
						currentQuiz?.meta?.quizpress_quiz_max_attempts_allowed
					) }
				</Span>
			</Flex>

			{ ! currentQuiz?.meta?.quizpress_quiz_hide_quiz_time && (
				<QuizTimer
					isTimeExpire={ values.is_time_expire }
					time={ currentQuiz?.meta?.quizpress_quiz_time }
					unit={ currentQuiz?.meta?.quizpress_quiz_time_unit }
				/>
			) }
			{ currentQuestion?.question_settings?.display_points && (
				<Flex
					gap={ 2 }
					alignItems="center"
					fontSize="sm"
					m={ 0 }
					fontWeight="500"
				>
					<Span color="var(--quizpress-warn-muted)">
						{ __( 'Points:', 'quizpress' ) }
					</Span>
					<Span>{ currentQuestion?.question_score }</Span>
				</Flex>
			) }
		</Flex>
	);
};

export default QuizHeader;
