import React from 'react';
import { Flex, Icon, Image, Text } from '@chakra-ui/react';
import { __ } from '@wordpress/i18n';
import { plugin_root_url } from '@QPUtils/helper';
import { Button } from '@chakra-ui/react';
import { primaryBtn } from '../../../../assets/scss/chakra/recipe';

const QuizTimeExpire = ( { handleStartQuiz, totalAttempts, currentQuiz } ) => {
	return (
		<>
			<Flex
				alignItems={ 'center' }
				justifyContent={ 'center' }
				flexDirection={ 'column' }
				gap={ '10px' }
			>
				<Image
					className="quizpress-expire-image"
					src={ plugin_root_url + 'assets/images/expire.png' }
					alt="expire"
					height="300px"
				/>
				<>
					<Flex alignItems={ 'center' } gap={ '10px' }>
						<Icon size={ 'md' }>
							<svg
								xmlns="http://www.w3.org/2000/svg"
								viewBox="0 0 512 512"
							>
								<path d="M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM232 152C232 138.8 242.8 128 256 128s24 10.75 24 24v128c0 13.25-10.75 24-24 24S232 293.3 232 280V152zM256 400c-17.36 0-31.44-14.08-31.44-31.44c0-17.36 14.07-31.44 31.44-31.44s31.44 14.08 31.44 31.44C287.4 385.9 273.4 400 256 400z" />
							</svg>
						</Icon>
						<Text
							fontSize={ '16px' }
							fontWeight={ '400' }
							textAlign={ 'justify' }
						>
							{ __(
								'Your time limit for this quiz has expired, please reattempt the quiz. Attempts remaining:',
								'quizpress'
							) }{ ' ' }
							{ totalAttempts?.length }/
							{ currentQuiz?.meta
								?.quizpress_quiz_feedback_mode === 'retry_mode'
								? currentQuiz?.meta
										?.quizpress_quiz_max_attempts_allowed
								: 1 }
						</Text>
					</Flex>
					<Button { ...primaryBtn } onClick={ handleStartQuiz }>
						{ __( 'Re-attempt Quiz', 'quizpress' ) }
					</Button>
				</>
			</Flex>
		</>
	);
};

export default QuizTimeExpire;
