import React from 'react';
import { __ } from '@wordpress/i18n';
import { Circle, Flex, Input, Span } from '@chakra-ui/react';
import { Field } from 'formik';

const GridRowColumn = () => {
	const RowUI = () => (
		<Flex gap={ 3 } alignItems="flex-start">
			<Span
				className="quizpress-icon quizpress-icon--close-red"
				cursor="pointer"
			/>
			<Circle border="1px solid #22A06B" padding="4px" cursor="pointer">
				<Span
					className="quizpress-icon quizpress-icon--plus"
					_before={ { color: '#22A06B' } }
				/>
			</Circle>
			<Field
				as={ Input }
				name="answer"
				placeholder={ __( 'Enter answer', 'quizpress' ) }
				className="quizpress-input"
			/>
		</Flex>
	);
	const ColumnUI = () => (
		<Flex gap={ 3 } alignItems="flex-start">
			<Span
				className="quizpress-icon quizpress-icon--close-red"
				cursor="pointer"
			/>
			<Circle border="1px solid #22A06B" padding="4px" cursor="pointer">
				<Span
					className="quizpress-icon quizpress-icon--plus"
					_before={ { color: '#22A06B' } }
				/>
			</Circle>
			<Field
				as={ Input }
				name="answer"
				placeholder={ __( 'Enter answer', 'quizpress' ) }
				className="quizpress-input"
			/>
			<Field
				as={ Input }
				name="points"
				placeholder={ __( 'Enter points', 'quizpress' ) }
				padding="12px !important"
				width="32%"
				border="1px solid var(--quizpress-border-color) !important"
				type="number"
			/>
		</Flex>
	);

	return (
		<Flex direction="column" gap={ 3 }>
			<Flex
				background="var(--quizpress-gray)"
				borderRadius="4px"
				justifyContent="left"
				padding="1.25rem"
			>
				<Span color="var(--quizpress-font-color)">
					{ __( 'Row', 'quizpress' ) }
				</Span>
			</Flex>
			{ [ 1, 2 ].map( ( item ) => RowUI() ) }
			<Flex
				background="var(--quizpress-gray)"
				justifyContent="left"
				padding="1.25rem"
			>
				<Span color="var(--quizpress-font-color)">
					{ __( 'Column', 'quizpress' ) }
				</Span>
			</Flex>
			{ [ 1, 2 ].map( ( item ) => ColumnUI() ) }
		</Flex>
	);
};

export default GridRowColumn;
