import React from 'react';
import { __ } from '@wordpress/i18n';
import { public_text_area_height } from '@QPUtils/helper';
import { Flex, Input, Textarea } from '@chakra-ui/react';
import { useFormikContext } from 'formik';
import Attachment from '@QPComponents/Attachment';

const OptIn = ( { question, answer, questionType } ) => {
	const { setFieldValue, values } = useFormikContext();

	const handleChange = ( e ) => {
		const val = e.target.value;
		setFieldValue( `answers.${ question.question_id }`, val );
	};

	const saveValueHandler = ( name, value ) => {
		setFieldValue( `answers.${ question.question_id }`, [ value ] );
	};
	return (
		<Flex direction="column" gap={ 3 }>
			{ questionType === 'date' && (
				<Input
					type="date"
					placeholder={ __( 'Select a Date', 'quizpress' ) }
					value={ values.answers?.[ question.question_id ] }
					onChange={ ( e ) => handleChange( e ) }
				/>
			) }
			{ questionType === 'short_answer' && (
				<Input
					type="text"
					placeholder={ __(
						'Write Here a Short Answer',
						'quizpress'
					) }
					onChange={ ( e ) => handleChange( e ) }
					value={ values.answers?.[ question.question_id ] }
				/>
			) }
			{ questionType === 'paragraph' && (
				<Textarea
					height={ `${ public_text_area_height }px` ?? '200px' }
					type="text"
					placeholder={ __( 'Write Here a Paragraph', 'quizpress' ) }
					onChange={ ( e ) => handleChange( e ) }
					value={ values.answers?.[ question.question_id ] }
				/>
			) }
			{ questionType === 'number' && (
				<Input
					type="number"
					value={ values.answers?.[ question.question_id ] }
					placeholder={ __( 'Enter a Number', 'quizpress' ) }
					onChange={ ( e ) => handleChange( e ) } //need to conform
				/>
			) }
			{ questionType === 'file_upload' && (
				<Attachment
					name="upload_file"
					saveValueHandler={ saveValueHandler }
					imageSize={ '700x430 pixels' }
					supportedFile={ '.jpg, .jpeg, .gif, .png, .pdf, .docx' }
				/>
			) }
		</Flex>
	);
};
export default OptIn;
