import React from 'react';
import { __ } from '@wordpress/i18n';
import {
	Checkbox,
	Flex,
	RadioGroup,
	CheckboxGroup,
	Text,
} from '@chakra-ui/react';
import { useFormikContext } from 'formik';
import Select from 'react-select';

const SingleChoiceRich = ( {
	question,
	answers,
	questionType,
	handleChange,
} ) => {
	const { values } = useFormikContext();
	const selectedValue = values?.answers?.[ question.question_id ] || '';

	return ! answers.length ? (
		<Text color="gray.500">
			{ __( 'No answers available.', 'quizpress' ) }
		</Text>
	) : (
		<Flex direction="column" gap={ 3 }>
			{ ( questionType === 'single_choice' ||
				questionType === 'single_choice_horizontal' ) && (
				<RadioGroup.Root
					onValueChange={ ( e ) => handleChange( e ) }
					value={ selectedValue[ 0 ] }
				>
					<Flex
						direction={
							questionType === 'single_choice_horizontal'
								? 'row'
								: 'column'
						}
						flexWrap={
							questionType === 'single_choice_horizontal'
								? 'wrap'
								: 'nowrap'
						}
						gap={ 3 }
					>
						{ answers.map( ( ans ) => (
							<RadioGroup.Item
								key={ ans.answer_id }
								value={ ans.answer_id }
							>
								<RadioGroup.ItemHiddenInput />
								<RadioGroup.ItemIndicator
									_checked={ {
										bg: 'var(--quizpress-primary)',
										borderColor: 'var(--quizpress-primary)',
									} }
									borderRadius="full"
								/>
								<RadioGroup.ItemText>
									{ ans.answer_title }
								</RadioGroup.ItemText>
							</RadioGroup.Item>
						) ) }
					</Flex>
				</RadioGroup.Root>
			) }
			{ ( questionType === 'multiple_choice' ||
				questionType === 'multiple_choice_horizontal' ) && (
				<Checkbox.Root
					onValueChange={ ( e ) => handleChange( e ) }
					value={ selectedValue }
				>
					<Flex
						direction={
							questionType === 'multiple_choice_horizontal'
								? 'row'
								: 'column'
						}
						flexWrap={
							questionType === 'multiple_choice_horizontal'
								? 'wrap'
								: 'nowrap'
						}
						gap={ 3 }
					>
						<CheckboxGroup
							onValueChange={ ( val ) => {
								handleChange( { value: val } );
							} }
						>
							{ answers.map( ( ans ) => (
								<Checkbox.Root
									key={ ans.answer_id }
									value={ ans.answer_id }
								>
									<Checkbox.HiddenInput />
									<Checkbox.Control
										_checked={ {
											bg: 'var(--quizpress-primary)',
											borderColor:
												'var(--quizpress-primary)',
										} }
										borderRadius="full"
									/>
									<Checkbox.Label>
										{ ans.answer_title }
									</Checkbox.Label>
								</Checkbox.Root>
							) ) }
						</CheckboxGroup>
					</Flex>
				</Checkbox.Root>
			) }
			{ questionType === 'drop_down' && (
				<Select
					onChange={ ( option ) => {
						handleChange( { value: option.value } );
					} }
					value={
						answers
							.map( ( item ) => ( {
								label: item.answer_title,
								value: item.answer_id,
							} ) )
							.find(
								( opt ) =>
									Number( opt.value ) ===
									Number( selectedValue )
							) || null
					}
					options={ answers.map( ( item ) => ( {
						label: item.answer_title,
						value: item.answer_id,
					} ) ) }
					placeholder={ __( 'Select an option', 'quizpress' ) }
				/>
			) }
		</Flex>
	);
};

export default SingleChoiceRich;
