import React from 'react';
import { __ } from '@wordpress/i18n';
import { Flex, RadioGroup } from '@chakra-ui/react';
import { useFormikContext } from 'formik';

const TrueFalse = ( { question, answers, questionType, handleChange } ) => {
	const { values } = useFormikContext();
	const selectedValue = values?.answers?.[ question.question_id ] || '';

	return (
		<Flex direction="column" gap={ 3 }>
			<RadioGroup.Root
				onValueChange={ ( e ) => handleChange( e ) }
				value={ selectedValue[ 0 ] }
			>
				<Flex direction={ 'column' } gap={ 3 }>
					{ answers.map( ( ans ) => (
						<RadioGroup.Item
							key={ ans.answer_id }
							value={ ans.answer_id }
						>
							<RadioGroup.ItemHiddenInput />
							<RadioGroup.ItemIndicator
								_checked={ {
									bg: 'var(--quizpress-primary)',
									borderColor: 'var(--quizpress-primary)',
								} }
								borderRadius="full"
							/>
							<RadioGroup.ItemText>
								{ ans.answer_title }
							</RadioGroup.ItemText>
						</RadioGroup.Item>
					) ) }
				</Flex>
			</RadioGroup.Root>
		</Flex>
	);
};

export default TrueFalse;
