import { ChakraProvider } from '@chakra-ui/react';
import { createRoot } from 'react-dom/client';
import { BrowserRouter as Router } from 'react-router-dom';
import { theme } from '../assets/scss/chakra/theme';
import { Provider } from 'react-redux';
import store from '@QPRedux/store';
import StartQuiz from '@QPContainers/Frontend';
import Notification from '@QPComponents/Notification';

import '../assets/scss/frontend.scss';

document.addEventListener( 'DOMContentLoaded', () => {
	const wrapper = document.getElementById( 'quizpressFrontendWrap' );
	const quizId = wrapper.getAttribute( 'data-id' );
	const quizLoader = document.getElementById( 'quizpressFrontend__quiz' );
	if ( ! quizLoader ) {
		return;
	}

	const root = createRoot( quizLoader );
	root.render(
		<ChakraProvider value={ theme }>
			<Provider store={ store }>
				<Router>
					<Notification />
					<StartQuiz ID={ quizId } />
				</Router>
			</Provider>
		</ChakraProvider>
	);
} );
