import { createAsyncThunk, createSlice } from '@reduxjs/toolkit';
import { menu, makeRequest } from '@QPUtils/helper';
import { showNotification } from '../notificationSlice/notificationSlice';

export const fetchAdminMenuItems = createAsyncThunk(
	'quizpress/fetchAdminMenuItems',
	( thunkAPI ) => {
		try {
			return makeRequest( 'admin/get_admin_menu_items' ).then(
				( res ) => {
					return res;
				}
			);
		} catch ( error ) {
			thunkAPI.dispatch(
				showNotification( {
					message: error?.response?.data?.message ?? error?.message,
					isShow: true,
					type: 'error',
				} )
			);
		}
	}
);

const menuSlice = createSlice( {
	name: 'menus',
	initialState: {
		data: JSON.parse( menu ),
		loading: false,
	},
	extraReducers: ( builder ) => {
		builder
			.addCase( fetchAdminMenuItems.pending, ( state ) => {
				state.loading = true;
			} )
			.addCase( fetchAdminMenuItems.fulfilled, ( state, action ) => {
				state.loading = false;
				state.data = action.payload;
			} )
			.addCase( fetchAdminMenuItems.rejected, ( state ) => {
				state.loading = false;
			} );
	},
} );

export default menuSlice.reducer;
