import { configureStore } from '@reduxjs/toolkit';
// reducers
import settingsReducer from './Slices/settingsSlice/settingsSlice';
import menuReducer from './Slices/menuSlice/menuSlice';
// import notificationReducer from './Slices/notificationSlice/notificationSlice';
// import quizAttemptsReducer from './Slices/quizAttemptsSlice/quizAttemptsSlice';
// import quizQuestionReducer from './Slices/quizQuestionSlice/quizQuestionSlice';
import questionReducer from './Slices/quizQuestionSlice/quizQuestionSlice';
import quizReducer from './Slices/quizSlice/quizSlice';
import quizInsightsReducer from './Slices/quizInsightsSlice/quizInsightsSlice';
import categoryReducer from './Slices/quizCategorySlice/quizCategorySlice';
import dashboardReducer from './Slices/dashboardSilce/dashboardSilce';
import notificationReducer from './Slices/notificationSlice/notificationSlice';
import analyticsReducer from './Slices/dashboardSilce/dashboardSilce';
import addonReducer from './Slices/addonSlice/addonSlice';
import certificateReducer from './Slices/certificateSlice/certificateSlice';

import logger from 'redux-logger';

let middleware = [];
if ( process.env.NODE_ENV !== 'production' ) {
	middleware = [ logger ];
}

const store = configureStore( {
	reducer: {
		analytics: analyticsReducer,
		addons: addonReducer,
		settings: settingsReducer,
		adminmenu: menuReducer,
		categories: categoryReducer,
		certificates: certificateReducer,
		quizzes: quizReducer,
		questions: questionReducer,
		quizInsights: quizInsightsReducer,
		dashboard: dashboardReducer,
		notification: notificationReducer,
	},
	middleware: ( getDefaultMiddleware ) =>
		getDefaultMiddleware().concat( ...middleware ),
} );

export default store;
