<?php
if (! defined('ABSPATH')) {
    exit;
}

$product_id = absint($product_id);
$is_logged  = is_user_logged_in();
$user_id    = get_current_user_id();

// Early exit: Product ID missing
if ( empty( $product_id ) ) : ?>
    <p class="quizpress-warning quizpress-warning__message">
        <?php echo esc_html__('This quiz is not available. Product removed.', 'quizpress'); ?>
    </p>
<?php
    return;
endif;

// Load product only once
$product = wc_get_product($product_id);
$price   = $product ? $product->get_price_html() : '';

$in_cart      = \QuizPressWoocommerce\Helper::is_product_in_cart($product_id);
$order_status = $is_logged ? \QuizPressWoocommerce\Helper::quizpress_get_product_purchase_status($user_id, $product_id) : false;
?>

<div class="quizpressFrontend__purchase-quiz">
    <h3 class="quizpressFrontend__purchase-quiz__heading">
        <?php esc_html_e( 'Please purchase the Quiz', 'quizpress' ); ?>
    </h3>

    <?php if (! $is_logged) : ?>

        <div class="quizpressFrontend__purchase-quiz__border"></div>

        <div class="quizpressFrontend__purchase-quiz__price">
            <p class="quizpressFrontend__purchase-quiz__price-label"><?php esc_html_e('Price', 'quizpress'); ?></p>
            <p class="quizpressFrontend__purchase-quiz__price-tag">
                <?php echo wp_kses_post($price); ?>
            </p>
        </div>

        <button
            type="button"
            class="quizpressFrontend__purchase-quiz__btn quizpress-btn quizpress-btn--bg-purple quizpress-login-btn"
            onclick="window.location.href='<?php echo esc_url(wp_login_url(get_permalink())); ?>'">
            <?php esc_html_e('Add to cart', 'quizpress'); ?>
        </button>

    <?php elseif ($in_cart) : ?>

        <a class="quizpress-btn quizpress-btn--preset-purple" href="<?php echo esc_url(wc_get_cart_url()); ?>">
            <?php esc_html_e('View Cart', 'quizpress'); ?>
        </a>

    <?php elseif ($order_status) : ?>

        <h3 class="quizpressFrontend__purchase-quiz__order-status">
            <?php
            printf(
                esc_html__('Your order status is: %s. Please wait for admin approval.', 'quizpress'),
                esc_html($order_status)
            );
            ?>
        </h3>

    <?php elseif ($product && $product->is_purchasable()) : ?>

        <div class="quizpressFrontend__purchase-quiz__price">
            <p class="quizpressFrontend__purchase-quiz__price-label"><?php esc_html_e('Price', 'quizpress'); ?></p>
            <p class="quizpressFrontend__purchase-quiz__price-tag">
                <?php echo wp_kses_post($price); ?>
            </p>
        </div>

        <a
            href="<?php echo esc_url($product->add_to_cart_url()); ?>"
            data-quantity="1"
            class="quizpressFrontend__purchase-quiz__btn quizpress-btn quizpress-btn--preset-purple add_to_cart_button ajax_add_to_cart product_type_simple"
            data-product_id="<?php echo esc_attr($product->get_id()); ?>"
            data-product_sku="<?php echo esc_attr($product->get_sku()); ?>"
            type="button">
            <span class="quizpress-icon quizpress-icon--cart" aria-hidden="true"></span>
            <?php echo esc_html($product->add_to_cart_text()); ?>
        </a>

    <?php endif; ?>
</div>
