<?php
/**
 * Readabler
 * Web accessibility for Your WordPress site.
 * Exclusively on https://1.envato.market/readabler
 *
 * @encoding        UTF-8
 * @version         2.0.12
 * @copyright       (C) 2018 - 2024 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Nemirovskiy Vitaliy (nemirovskiyvitaliy@gmail.com), Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 * @license         Envato License https://1.envato.market/KYbje
 **/

namespace Merkulove\Readabler\Tabs;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

use Merkulove\Readabler\Unity\Plugin;
use Merkulove\Readabler\Unity\Tab;

/**
 * @package Merkulove\Readabler
 */
class TabAdvanced extends Tab {

	/**
	 * @var string
	 */
	public static string $key = 'advanced';

	/**
	 * Controls for Analyzer tab.
	 * @return array
	 */
	public static function controls(): array {

		$fields = array();
		$dID    = 0;

		$fields['assets_condition'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Required JS and CSS', 'readabler' ),
			'description' => esc_html__( 'Load only scripts and styles necessary for work with current settings.', 'readabler' ),
			'default'     => 'on',
		];

		$fields['noscript'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Noscript markup', 'readabler' ),
			'description' => esc_html__( 'Add the noscript tag to the site markup.', 'readabler' ),
			'default'     => 'on',
		];

		$fields['late_load'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Late CSS and JS loading', 'readabler' ),
			'description' => esc_html__( 'Enables later loading of styles and scripts. Use this option if some of the pages are missing Readable styles or scripts.', 'readabler' ),
			'default'     => 'off',
		];

		$fields['copyscape_skip'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'CopyScape Skip', 'readabler' ),
			'description' => esc_html__( 'Ignore the markup of the plugin interface when parsing with the CopyScape', 'readabler' ),
			'default'     => 'off',
		];

		// Speaker PHP 7 conditional fields
		if ( is_plugin_active( 'readabler-php7/readabler-php7.php' ) && ! is_plugin_active( 'readabler-ai/readabler-ai.php' ) ) {

			$fields[ self::$key . '_divider_' . $dID ++ ] = [
				'type' => 'divider',
			];

			$php_version              = PHP_VERSION;
			$fields['vendor_version'] = [
				'type'        => 'select',
				'label'       => esc_html__( 'Compatibility', 'readabler' ),
				'placeholder' => esc_html__( 'Compatibility', 'readabler' ),
				'description' => wp_sprintf(
				/* translators: %1$s: bold text, %2$s: br, %3$s: b */
					esc_html__( 'Select a compatible Google Library version. Current server PHP version: %1$s. %2$s Attention: Incorrect selection of the version libraries of the version will throw a %3$s on the entire site.', 'readabler' ),
					'<strong>' . esc_attr( $php_version ) . '</strong>',
					'<br>',
					'<b style="color: red">' . esc_html__( 'Fatal Error', 'readabler' ) . '</b>'
				),
				'default'     => '8.1',
				'options'     => [
					'7.4' => 'For PHP 7.4+',
					'8.1' => 'For PHP 8.1+',
				]
			];
		}

		return $fields;

	}

	/**
	 * Add tab to the settings page.
	 * @return void
	 */
	public static function add_tab() {

		self::add_settings_tab(
			self::$key,
			11,
			'display_settings',
			esc_html__( 'Advanced', 'readabler' ),
			esc_html__( 'Advanced Settings', 'readabler' ),
			esc_html__( 'Advanced settings allow you to configure the plugin to work with your theme. Please make sure you understand what you are doing before changing anything on this tab.', 'readabler' ),
		);

	}

	/**
	 * Add fields to the tab.
	 * @return void
	 */
	public static function add_controls() {
		$tabs                         = Plugin::get_tabs();
		$tabs[ self::$key ]['fields'] = self::controls();
		Plugin::set_tabs( $tabs );
	}

}



