<?php

namespace Merkulove\Readabler\Tabs;

use Merkulove\Readabler\Unity\Plugin;
use Merkulove\Readabler\Unity\Tab;

class TabHotKeys extends Tab {

	/**
	 * @var string
	 */
	public static string $key = 'hot_keys';

	/**
	 * Define controls for Hot Keys tab.
	 *
	 * @return array
	 */
	public static function controls(): array {

		$fields = [];

		# Supported Keys header
		$fields['supported_keys_header'] = [
			'type'        => 'header',
			'label'       => esc_html__( 'Supported Keys', 'readabler' ),
			'description' => self::get_keys_description(),
			'default'     => ''
		];

		# Divider
		$key            = 'divider_popup_scroll';
		$fields[ $key ] = [ 'type' => 'divider', 'default' => '' ];

		# Open the Accessibility Interface
		$fields['hot_key_open_interface'] = [
			'type'        => 'text',
			'label'       => esc_html__( 'Open Hot Key', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Open Hot Key', 'readabler' ),
			'description' => esc_html__( 'Open the Accessibility Interface.', 'readabler' ),
			'default'     => 'Alt+9',
			'attr'        => [
				'maxlength' => '50'
			]
		];

		/** If Keyboard Navigation is enabled. */
		if (
			'on' === ( $options['keyboard_navigation'] ?? 'off' ) ||
			'on' === ( $options['profile_blind_users'] ?? 'off' )
		) {

			# Keyboard Menus Navigation
			$fields['hot_key_menu'] = [
				'type'        => 'text',
				'label'       => esc_html__( 'Keyboard Menus Navigation', 'readabler' ) . ':',
				'placeholder' => esc_html__( 'Menus Navigation Hot Key', 'readabler' ),
				'default'     => 'M',
				'attr'        => [
					'maxlength' => '10'
				]
			];

			# Keyboard Headings Navigation
			$fields['hot_key_headings'] = [
				'type'        => 'text',
				'label'       => esc_html__( 'Keyboard Headings Navigation', 'readabler' ) . ':',
				'placeholder' => esc_html__( 'Headings Navigation Hot Key', 'readabler' ),
				'default'     => 'H',
				'attr'        => [
					'maxlength' => '10'
				]
			];

			# Keyboard Forms Navigation
			$fields['hot_key_forms'] = [
				'type'        => 'text',
				'label'       => esc_html__( 'Keyboard Forms Navigation', 'readabler' ) . ':',
				'placeholder' => esc_html__( 'Forms Navigation Hot Key', 'readabler' ),
				'default'     => 'F',
				'attr'        => [
					'maxlength' => '10'
				]
			];

			# Keyboard Buttons Navigation
			$fields['hot_key_buttons'] = [
				'type'        => 'text',
				'label'       => esc_html__( 'Keyboard Buttons Navigation', 'readabler' ) . ':',
				'placeholder' => esc_html__( 'Buttons Navigation Hot Key', 'readabler' ),
				'default'     => 'B',
				'attr'        => [
					'maxlength' => '10'
				]
			];

			# Keyboard Graphics Navigation
			$fields['hot_key_graphics'] = [
				'type'        => 'text',
				'label'       => esc_html__( 'Keyboard Graphics Navigation', 'readabler' ) . ':',
				'placeholder' => esc_html__( 'Graphics Navigation Hot Key', 'readabler' ),
				'default'     => 'G',
				'attr'        => [
					'maxlength' => '10'
				]
			];
		}

		return $fields;

	}

	/**
	 * Add Hot Keys tab to the settings page.
	 * @return void
	 */
	public static function add_tab() {
		self::add_settings_tab(
			self::$key,
			5,
			'keyboard',
			esc_html__( 'Hot Keys', 'readabler' ),
			esc_html__( 'Hot Keys Settings', 'readabler' ),
			esc_html__( 'Configure keyboard shortcuts for Readabler plugin. Customize hot keys to enhance accessibility and user experience.', 'readabler' ),
		);
	}

	/**
	 * Add fields to the tab.
	 * @return void
	 */
	public static function add_controls() {
		$tabs                         = Plugin::get_tabs();
		$tabs[ self::$key ]['fields'] = self::controls();
		Plugin::set_tabs( $tabs );
	}

	/**
	 * Get description of supported keys for hotkeys.
	 *
	 * @return string
	 */
	private static function get_keys_description(): string {

		return
			esc_html__( 'Hot Keys understands the following modifiers: ', 'readabler' ) .
			'<b>⇧</b> <b>shift</b> <b>option</b> <b>⌥</b> <b>alt</b> <b>ctrl</b> <b>⌃</b> <b>control</b> <b>command</b> <b>⌘</b>' .
			'<br><br>' .
			esc_html__( 'The following special keys can be used for shortcuts: ', 'readabler' ) .
			'<b>backspace</b> <b>tab</b> <b>clear</b> <b>enter</b> <b>return</b> <b>esc</b> <b>escape</b> <b>space</b> <b>up</b> <b>down</b> <b>left</b> <b>right</b> <b>home</b> <b>end</b> <b>pageup</b> <b>pagedown</b> <b>del</b> <b>delete</b> <b>f1..f12</b>' .
			'<br><br>' .
			esc_html__( 'Use the ', 'readabler' ) .
			'<b>+</b>' .
			esc_html__( ' to create key combination and use ', 'readabler' ) .
			'<b>,</b>' .
			esc_html__( ' to join multiple combinations', 'readabler' ) . ': ' .
			'<b>ctrl+b, ⇧+r, ⌘+f</b>';
	}

}
