<?php
/**
 * Readabler
 * Web accessibility for Your WordPress site.
 * Exclusively on https://1.envato.market/readabler
 *
 * @encoding        UTF-8
 * @version         2.0.12
 * @copyright       (C) 2018-2024 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 * @license         Envato License https://1.envato.market/KYbje
 **/

namespace Merkulove\Readabler\Tabs;

use Merkulove\Readabler\Tools;
use Merkulove\Readabler\Unity\Plugin;
use Merkulove\Readabler\Unity\Tab;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

class TabModalPopup extends Tab {

	/**
	 * @var string
	 */
	public static string $key = 'modal_popup';

	/**
	 * Controls for Modal Popup tab.
	 * @return array
	 */
	public static function controls(): array {

		$fields = [];

		$isAi = Tools::is_readabler_ai();

		$fields['popup_position'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Popup position', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Popup position', 'readabler' ),
			'description' => esc_html__( 'Select the initial position of the popup display', 'readabler' ),
			'default'     => 'right',
			'options'     => [
				'right'  => esc_html__( 'Right', 'readabler' ),
				'center' => esc_html__( 'Center', 'readabler' ),
				'left'   => esc_html__( 'Left', 'readabler' ),
			]
		];

		$fields['popup_draggable'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Draggable', 'readabler' ),
			'placeholder' => esc_html__( 'Draggable', 'readabler' ),
			'description' => esc_html__( 'Controls dragging popup', 'readabler' ) . $isAi ? esc_html__( 'This settings has no effect on the AI version.', 'readabler' ) : '',
			'default'     => 'on',
		];

		$key                        = 'light_theme';
		$fields[ $key ]             = [ 'type' => 'divider', 'default' => '' ];
		$fields[ $key . '_header' ] = [
			'type'        => 'header',
			'label'       => esc_html__( 'Day(Light) Theme', 'readabler' ),
			'description' => esc_html__( 'Select colors for the Day(Light) theme', 'readabler' ),
			'default'     => ''
		];

		$fields['popup_background_color'] = [
			'type'        => 'colorpicker',
			'label'       => esc_html__( 'Background Color', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Background Color', 'readabler' ),
			'description' => esc_html__( 'Select modal background-color.', 'readabler' ),
			'default'     => '#ffffff',
			'attr'        => [
				'readonly' => 'readonly',
			]
		];

		$fields['popup_key_color'] = [
			'type'        => 'colorpicker',
			'label'       => esc_html__( 'Key Color', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Key Color', 'readabler' ),
			'description' => esc_html__( 'Select modal key color.', 'readabler' ),
			'default'     => 'rgba(33, 111, 243, 1)',
			'attr'        => [
				'readonly' => 'readonly',
			]
		];

		$fields['popup_text_color'] = [
			'type'        => 'colorpicker',
			'label'       => esc_html__( 'Text Color', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Text Color', 'readabler' ),
			'description' => esc_html__( 'Select modal text color.', 'readabler' ),
			'default'     => '#333',
			'attr'        => [
				'readonly' => 'readonly',
			]
		];

		$key                        = 'dark_theme';
		$fields[ $key ]             = [ 'type' => 'divider', 'default' => '' ];
		$fields[ $key . '_header' ] = [
			'type'        => 'header',
			'label'       => esc_html__( 'Night(Dark) Theme', 'readabler' ),
			'description' => esc_html__( 'Select colors for the Night(Dark) theme', 'readabler' ),
			'default'     => ''
		];

		$fields['popup_background_color_dark'] = [
			'type'        => 'colorpicker',
			'label'       => esc_html__( 'Background Color', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Background Color', 'readabler' ),
			'description' => esc_html__( 'Select modal background-color.', 'readabler' ),
			'default'     => '#16191b',
			'attr'        => [
				'readonly' => 'readonly',
			]
		];

		$fields['popup_key_color_dark'] = [
			'type'        => 'colorpicker',
			'label'       => esc_html__( 'Key Color', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Key Color', 'readabler' ),
			'description' => esc_html__( 'Select modal key color.', 'readabler' ),
			'default'     => 'rgba(33, 111, 243, 1)',
			'attr'        => [
				'readonly' => 'readonly',
			]
		];

		$fields['popup_text_color_dark'] = [
			'type'        => 'colorpicker',
			'label'       => esc_html__( 'Text Color', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Text Color', 'readabler' ),
			'description' => esc_html__( 'Select modal text color.', 'readabler' ),
			'default'     => '#deeffd',
			'attr'        => [
				'readonly' => 'readonly',
			]
		];

		$key                        = 'appearance';
		$fields[ $key ]             = [ 'type' => 'divider', 'default' => '' ];
		$fields[ $key . '_header' ] = [
			'type'        => 'header',
			'label'       => esc_html__( 'Appearance and Behavior', 'readabler' ),
			'description' => esc_html__( 'Set the modal popup appearance and behavior', 'readabler' ),
			'default'     => ''
		];

		$key            = 'popup_border_radius';
		$fields[ $key ] = [
			'type'        => 'slider',
			'label'       => esc_html__( 'Border radius', 'readabler' ) . ':',
			'description' => [
				'prefix' => esc_html__( 'Border radius', 'readabler' ) . ':',
				'unit'   => 'px',
			],
			'min'         => 0,
			'max'         => 100,
			'step'        => 1,
			'default'     => 20,
			'discrete'    => true,
		];

		if ( $isAi ) {
			$fields['popup_animation'] = [
				'type'        => 'select',
				'label'       => esc_html__( 'Animation', 'readabler' ) . ':',
				'placeholder' => esc_html__( 'Animation', 'readabler' ),
				'description' => esc_html__( 'Modal entrance animation.', 'readabler' ),
				'default'     => 'fade',
				'options'     => [
					'none'     => esc_html__( 'None', 'readabler' ),
					'bounce'   => esc_html__( 'Bounce', 'readabler' ),
					'fade'     => esc_html__( 'Fade', 'readabler' ),
					'flip-x'   => esc_html__( 'Flip X', 'readabler' ),
					'flip-y'   => esc_html__( 'Flip Y', 'readabler' ),
					'scale'    => esc_html__( 'Scale', 'readabler' ),
					'slide-tr' => esc_html__( 'Slide to right', 'readabler' ),
					'slide-tl' => esc_html__( 'Slide to left', 'readabler' ),
					'slide-tt' => esc_html__( 'Slide to top', 'readabler' ),
					'slide-tb' => esc_html__( 'Slide to bottom', 'readabler' ),
					'rotate'   => esc_html__( 'Rotate', 'readabler' ),
					'wobble'   => esc_html__( 'Wobble', 'readabler' )
				]
			];

			$key            = 'popup_animation_duration';
			$default        = 600;
			$fields[ $key ] = [
				'type'        => 'slider',
				'label'       => esc_html__( 'Animation Duration', 'readabler' ) . ':',
				'description' => [
					'prefix' => esc_html__( 'Animation duration', 'readabler' ) . ':',
					'unit'   => esc_html__( 'milliseconds', 'readabler' ),
				],
				'min'         => 100,
				'max'         => 5000,
				'step'        => 50,
				'default'     => $default,
				'discrete'    => true,
			];
		}

		$fields['popup_shadow'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Popup Shadow', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Shadow', 'readabler' ),
			'description' => esc_html__( 'Show popup shadow', 'readabler' ),
			'default'     => 'on',
		];

		$fields['popup_overlay'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Overlay', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Overlay', 'readabler' ),
			'description' => esc_html__( 'Show overlay layer', 'readabler' ),
			'default'     => 'off',
		];

		$fields['popup_overlay_color'] = [
			'type'        => 'colorpicker',
			'label'       => esc_html__( 'Overlay Color', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Overlay Color', 'readabler' ),
			'description' => esc_html__( 'Select modal overlay background-color.', 'readabler' ),
			'default'     => '#0253ee',
			'attr'        => [
				'readonly' => 'readonly',
			]
		];

		if (!$isAi) {
			$fields['popup_float'] = [
				'type'        => 'switcher',
				'label'       => esc_html__( 'Floating popup', 'readabler' ) . ':',
				'placeholder' => esc_html__( 'Enable floating', 'readabler' ),
				'description' => esc_html__( 'Leave a popup on the screen while scrolling', 'readabler' ),
				'default'     => 'on',
			];
			$fields['popup_scroll'] = [
				'type'        => 'switcher',
				'label'       => esc_html__( 'Scroll', 'readabler' ) . ':',
				'placeholder' => esc_html__( 'Scroll', 'readabler' ),
				'description' => esc_html__( 'Scrolling on the page while the popup is open.', 'readabler' ),
				'default'     => 'off',
			];
		}

		$fields['popup_close_anywhere'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Close anywhere', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Close anywhere', 'readabler' ),
			'description' => esc_html__( 'Close by clicking outside the popup', 'readabler' ),
			'default'     => 'off',
		];

		$fields['reset_button'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Reset Button', 'readabler' ),
			'placeholder' => esc_html__( 'Reset Button', 'readabler' ),
			'description' => esc_html__( 'Shows and hides the Reset button', 'readabler' ),
			'default'     => 'on',
		];

		$fields['hide_button'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Hide Button', 'readabler' ),
			'placeholder' => esc_html__( 'Hide Button', 'readabler' ),
			'description' => esc_html__( 'Shows and hides the Hide Forever button', 'readabler' ),
			'default'     => 'on',
		];

		return $fields;

	}

	/**
	 * Add tab to the settings page.
	 * @return void
	 */
	public static function add_tab(): void {
		self::add_settings_tab(
			self::$key,
			2,
			'web_asset',
			esc_html__( 'Modal Popup', 'readabler' ),
			esc_html__( 'Modal Popup Settings', 'readabler' ),
			esc_html__( "Design and behaviour of the Accessibility Modal Popup.", 'readabler' ),
		);
	}

	/**
	 * Add fields to the tab.
	 * @return void
	 */
	public static function add_controls() {
		$tabs                         = Plugin::get_tabs();
		$tabs[ self::$key ]['fields'] = self::controls();
		Plugin::set_tabs( $tabs );
	}

}
