<?php
/**
 * Readabler
 * Web accessibility for Your WordPress site.
 * Exclusively on https://1.envato.market/readabler
 *
 * @encoding        UTF-8
 * @version         2.0.12
 * @copyright       (C) 2018-2024 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 * @license         Envato License https://1.envato.market/KYbje
 **/

namespace Merkulove\Readabler\Tabs;

use Merkulove\Readabler\Unity\Plugin;
use Merkulove\Readabler\Unity\Tab;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

class TabOpenButton extends Tab {

	/**
	 * @var string
	 */
	public static string $key = 'open_button';

	/**
	 * Controls for Open Button tab.
	 * @return array
	 */
	public static function controls(): array {

		$fields = [];

		# Show Open Button
		$fields['show_open_button'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Show Open Button', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Show Open Button', 'readabler' ),
			'default'     => 'on',
		];

		$key                                   = 'button_tabindex';
		$fields[ $key ] = [
			'type'        => 'slider',
			'label'       => esc_html__( 'Tabulation index', 'readabler' ) . ':',
			'description' => [
				'prefix' => esc_html__( 'Tabulation index', 'readabler' ) . ':',
			],
			'min'         => - 1,
			'max'         => 3,
			'step'        => 1,
			'default'     => 0,
			'discrete'    => true,
		];

		$key                                   = 'divider_show_open_button';
		$fields[ $key ] = [ 'type' => 'divider', 'default' => '' ];

		$fields['button_position'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Position', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Position', 'readabler' ),
			'description' => esc_html__( 'Select a place on the page to display Floating Button.', 'readabler' ),
			'default'     => 'bottom-right',
			'options'     => [
				'top-left'      => esc_html__( 'Top Left', 'readabler' ),
				'top-right'     => esc_html__( 'Top Right', 'readabler' ),
				'left-center'   => esc_html__( 'Left Center', 'readabler' ),
				'right-center'  => esc_html__( 'Right Center', 'readabler' ),
				'bottom-left'   => esc_html__( 'Bottom Left', 'readabler' ),
				'bottom-center' => esc_html__( 'Bottom Center', 'readabler' ),
				'bottom-right'  => esc_html__( 'Bottom Right', 'readabler' ),
			]
		];

		$fields['button_caption'] = [
			'type'        => 'text',
			'label'       => esc_html__( 'Caption', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Button caption', 'readabler' ),
			'default'     => '',
			'attr'        => [
				'maxlength' => '4500'
			]
		];

		$fields['button_icon'] = [
			'type'        => 'icon',
			'label'       => esc_html__( 'Icon', 'readabler' ) . ':',
			'placeholder' => '',
			'description' => esc_html__( 'Select icon for button.', 'readabler' ),
			'default'     => '_readabler/readabler.svg',
			'meta'        => [
				'_readabler.json',
				'font-awesome.json',
				'material.json'
			]
		];

		$fields['button_icon_position'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Icon Position', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Icon Position', 'readabler' ),
			'default'     => 'before',
			'options'     => [
				'none'   => esc_html__( 'Hide', 'readabler' ),
				'before' => esc_html__( 'Before', 'readabler' ),
				'after'  => esc_html__( 'After', 'readabler' ),
				'above'  => esc_html__( 'Above', 'readabler' ),
				'bellow' => esc_html__( 'Bellow', 'readabler' ),
			],
		];

		$key                                   = 'button_size';
		$fields[ $key ] = [
			'type'        => 'slider',
			'label'       => esc_html__( 'Icon/Caption size', 'readabler' ) . ':',
			'description' => [
				'prefix' => esc_html__( 'Icon/Caption size', 'readabler' ) . ':',
				'unit' => 'px',
			],
			'min'         => 10,
			'max'         => 100,
			'step'        => 1,
			'default'     => 24,
			'discrete'    => true,
		];

		$key                                   = 'divider_button_size';
		$fields[ $key ] = [ 'type' => 'divider', 'default' => '' ];

		$key                                   = 'button_margin';
		$fields[ $key ] = [
			'type'        => 'slider',
			'label'       => esc_html__( 'Margin', 'readabler' ) . ':',
			'description' => [
				'prefix' => esc_html__( 'Button margin', 'readabler' ) . ':',
				'unit' => 'px',
			],
			'min'         => 0,
			'max'         => 100,
			'step'        => 1,
			'default'     => 10,
			'discrete'    => true,
		];

		$key                                   = 'button_padding';
		$fields[ $key ] = [
			'type'        => 'slider',
			'label'       => esc_html__( 'Padding', 'readabler' ) . ':',
			'description' => [
				'prefix' => esc_html__( 'Button padding', 'readabler' ) . ':',
				'unit' => 'px',
			],
			'min'         => 0,
			'max'         => 100,
			'step'        => 1,
			'default'     => 20,
			'discrete'    => true,
		];

		$key                                   = 'button_border_radius';
		$fields[ $key ] = [
			'type'        => 'slider',
			'label'       => esc_html__( 'Border radius', 'readabler' ) . ':',
			'description' => [
				'prefix' => esc_html__( 'Border radius', 'readabler' ) . ':',
				'unit' => 'px',
			],
			'min'         => 0,
			'max'         => 100,
			'step'        => 1,
			'default'     => 50,
			'discrete'    => true,
		];

		$fields['button_color'] = [
			'type'        => 'colorpicker',
			'label'       => esc_html__( 'Icon/Caption Color', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Text Color', 'readabler' ),
			'description' => esc_html__( 'Select icon and text color.', 'readabler' ),
			'default'     => '#ffffff',
			'attr'        => [
				'readonly' => 'readonly',
			]
		];

		$fields['button_color_hover'] = [
			'type'        => 'colorpicker',
			'label'       => esc_html__( 'Icon/Caption Hover Color', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Text Hover Color', 'readabler' ),
			'description' => esc_html__( 'Select icon and text hover color.', 'readabler' ),
			'default'     => 'rgba(33, 111, 243, 1)',
			'attr'        => [
				'readonly' => 'readonly',
			]
		];

		$fields['button_bgcolor'] = [
			'type'        => 'colorpicker',
			'label'       => esc_html__( 'Background Color', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Background Color', 'readabler' ),
			'description' => esc_html__( 'Select button background color.', 'readabler' ),
			'default'     => 'rgba(33, 111, 243, 1)',
			'attr'        => [
				'readonly' => 'readonly',
			]
		];

		$fields['button_bgcolor_hover'] = [
			'type'        => 'colorpicker',
			'label'       => esc_html__( 'Background Hover Color', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Background Hover Color', 'readabler' ),
			'description' => esc_html__( 'Select button hover background color.', 'readabler' ),
			'default'     => '#ffffff',
			'attr'        => [
				'readonly' => 'readonly',
			]
		];

		$key                                   = 'divider_button_bgcolor_hover';
		$fields[ $key ] = [ 'type' => 'divider', 'default' => '' ];

		$key                                   = 'button_entrance_timeout';
		$fields[ $key ] = [
			'type'        => 'slider',
			'label'       => esc_html__( 'Entrance Timeout', 'readabler' ) . ':',
			'description' => [
				'prefix' => esc_html__( 'Entrance Timeout', 'readabler' ) . ':',
				'unit' => esc_html__( 'seconds', 'readabler' ),
			],
			'min'         => 0,
			'max'         => 30,
			'step'        => 1,
			'default'     => 0,
			'discrete'    => true,
		];

		$fields['button_entrance_animation'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Entrance Animation', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Entrance Animation', 'readabler' ),
			'description' => esc_html__( 'Button Entrance animation.', 'readabler' ),
			'default'     => 'fade',
			'options'     => [
				'none'   => esc_html__( 'None', 'readabler' ),
				'bounce' => esc_html__( 'Bounce', 'readabler' ),
				'fade'   => esc_html__( 'Fade', 'readabler' ),
				'flip-x' => esc_html__( 'Flip X', 'readabler' ),
				'flip-y' => esc_html__( 'Flip Y', 'readabler' ),
				'scale'  => esc_html__( 'Scale', 'readabler' ),
				'wobble' => esc_html__( 'Wobble', 'readabler' ),
				'rotate' => esc_html__( 'Rotate', 'readabler' )
			]
		];

		$fields['button_hover_animation'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Hover Animation', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Hover Animation', 'readabler' ),
			'description' => esc_html__( 'Button hover animation.', 'readabler' ),
			'default'     => 'none',
			'options'     => [
				'none'   => esc_html__( 'None', 'readabler' ),
				'bounce' => esc_html__( 'Bounce', 'readabler' ),
				'fade'   => esc_html__( 'Fade', 'readabler' ),
				'flip-x' => esc_html__( 'Flip X', 'readabler' ),
				'flip-y' => esc_html__( 'Flip Y', 'readabler' ),
				'scale'  => esc_html__( 'Scale', 'readabler' ),
				'wobble' => esc_html__( 'Wobble', 'readabler' ),
				'rotate' => esc_html__( 'Rotate', 'readabler' )
			]
		];

		$key                                   = 'divider_button_show_after_scrolling';
		$fields[ $key ] = [ 'type' => 'divider', 'default' => '' ];

		$fields['header_show_after_scrolling'] = [
			'type'        => 'header',
			'label'       => esc_html__( 'Show Open Button after scrolling', 'readabler' ),
			'description' => esc_html__( 'Define how many pixels the user must scroll before the Open Button appears. If the value is greater than zero, the button will be hidden when the page first loads.', 'readabler' ),
			'default'     => ''
		];

		$key                                   = 'button_show_after_scrolling_desktop';
		$fields[ $key ] = [
			'type'        => 'slider',
			'label'       => esc_html__( 'For desktop devices', 'readabler' ) . ':',
			'description' => [
				'prefix' => esc_html__( 'Show button after scrolling', 'readabler' ) . ':',
				'unit' => 'px',
			],
			'min'         => 0,
			'max'         => 300,
			'step'        => 10,
			'default'     => 0,
			'discrete'    => true,
		];

		$fields[ 'button_show_after_scrolling_mobile' ] = [
			'type'        => 'slider',
			'label'       => esc_html__( 'For mobile devices', 'readabler' ) . ':',
			'description' => [
				'prefix' => esc_html__( 'Show button after scrolling', 'readabler' ) . ':',
				'unit' => 'px',
			],
			'min'         => 0,
			'max'         => 300,
			'step'        => 10,
			'default'     => 0,
			'discrete'    => true,
		];

		return $fields;

	}

	/**
	 * Add tab to the settings page.
	 * @return void
	 */
	public static function add_tab() {
		self::add_settings_tab(
			self::$key,
			1,
			'edit_attributes',
			esc_html__( 'Open Button', 'readabler' ),
			esc_html__( 'Open Button Settings', 'readabler' ),
			esc_html__( "Configure design and behavior of the Open Button.", 'readabler' ),
		);
	}

	/**
	 * Add fields to the tab.
	 * @return void
	 */
	public static function add_controls() {
		$tabs                         = Plugin::get_tabs();
		$tabs[ self::$key ]['fields'] = self::controls();
		Plugin::set_tabs( $tabs );
	}

}
