<?php
/**
 * Readabler
 * Web accessibility for Your WordPress site.
 * Exclusively on https://1.envato.market/readabler
 *
 * @encoding        UTF-8
 * @version         2.0.12
 * @copyright       (C) 2018-2024 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 * @license         Envato License https://1.envato.market/KYbje
 **/

namespace Merkulove\Readabler\Tabs;

use Merkulove\Readabler\Unity\Plugin;
use Merkulove\Readabler\Unity\Tab;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

class TabReadablerGeneral extends Tab {

	/**
	 * @var string
	 */
	public static string $key = 'general';

	/**
	 * Controls for General tab.
	 * @return array
	 */
	public static function controls(): array {

		$fields = array();

		# Accessibility profiles header
		$fields['accessibility_profiles_header'] = [
			'type'        => 'header',
			'label'       => esc_html__( 'Accessibility modes', 'readabler' ),
			'description' => esc_html__( 'Select pre-built disability modes.', 'readabler' ),
			'default'     => ''
		];

		$fields['accessibility_profiles_heading'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Section title', 'readabler' ),
			'placeholder' => esc_html__( 'Show section title', 'readabler' ),
			'description' => esc_html__( 'Enable/disable the display of the current section  title.', 'readabler' ),
			'default'     => 'on',
		];

		# Epilepsy Safe Mode
		$fields['profile_epilepsy'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Epilepsy Safe Mode', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Epilepsy Safe Mode', 'readabler' ),
			'description' => esc_html__( 'This profile enables people with epilepsy to use the website safely by eliminating the risk of seizures that result from flashing or blinking animations and risky color combinations.', 'readabler' ),
			'default'     => 'on',
		];

		# Visually Impaired Mode
		$fields['profile_visually_impaired'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Visually Impaired Mode', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Visually Impaired Mode', 'readabler' ),
			'description' => esc_html__( 'This mode adjusts the website for the convenience of users with visual impairments such as Degrading Eyesight, Tunnel Vision, Cataract, Glaucoma, and others.', 'readabler' ),
			'default'     => 'on',
		];

		# Cognitive Disability Mode
		$fields['profile_cognitive_disability'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Cognitive Disability Mode', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Cognitive Disability Mode', 'readabler' ),
			'description' => esc_html__( 'This mode provides different assistive options to help users with cognitive impairments such as Dyslexia, Autism, CVA, and others, to focus on the essential elements of the website more easily.', 'readabler' ),
			'default'     => 'on',
		];

		# ADHD Friendly Mode
		$fields['profile_adhd_friendly'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'ADHD Friendly Mode', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'ADHD Friendly Mode', 'readabler' ),
			'description' => esc_html__( 'This mode helps users with ADHD and Neurodevelopmental disorders to read, browse, and focus on the main website elements more easily while significantly reducing distractions.', 'readabler' ),
			'default'     => 'on',
		];

		# Blind Users Profile
		$fields['profile_blind_users'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Blindness Mode', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Blindness Mode', 'readabler' ),
			'description' => esc_html__( 'This mode configures the website to be compatible with screen-readers such as JAWS, NVDA, VoiceOver, and TalkBack. A screen-reader is software for blind users that is installed on a  computer and smartphone, and websites must be compatible with it.', 'readabler' ),
			'default'     => 'on',
		];

		# Divider
		$key            = 'divider_online_dictionary';
		$fields[ $key ] = [ 'type' => 'divider', 'default' => '' ];


		# Accessibility profiles header
		$fields['online_dictionary_header'] = [
			'type'        => 'header',
			'label'       => esc_html__( 'Online Dictionary', 'readabler' ),
			'description' => esc_html__( 'Select Wikipedia Online Dictionary.', 'readabler' ),
			'default'     => ''
		];

		$fields['online_dictionary_heading'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Section heading', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Section heading', 'readabler' ),
			'description' => esc_html__( 'Enable/disable the display of the current section heading.', 'readabler' ),
			'default'     => 'on',
		];

		# Online Dictionary
		$fields['online_dictionary'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Online Dictionary', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Online Dictionary', 'readabler' ),
			'description' => esc_html__( 'Allows searching for phrases, abbreviations and concepts for Cognitive Disorders.', 'readabler' ),
			'default'     => 'on',
		];

		# Wikipedia Language
		$fields['dictionary_language'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Dictionary language', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Dictionary language', 'readabler' ),
			'description' => esc_html__( 'Select the Wikipedia language to search', 'readabler' ),
			'default'     => 'auto',
			'options'     => [
				'auto' => esc_html__( 'Auto', 'readabler' ),
				'ar'   => esc_html( 'العربية' ), // Al-ʿArabīyah
				'ast'  => esc_html( 'Asturianu' ),
				'az'   => esc_html( 'Azərbaycanca' ),
				'bg'   => esc_html( 'Български' ), // Bǎlgarski
				'nan'  => esc_html( 'Bân-lâm-gú / Hō-ló-oē' ),
				'bn'   => esc_html( 'বাংলা' ), // Bangla
				'be'   => esc_html( 'Беларуская' ), // Belaruskaya
				'ca'   => esc_html( 'Català' ),
				'cs'   => esc_html( 'Čeština' ), // čeština
				'cy'   => esc_html( 'Cymraeg' ), // Cymraeg
				'da'   => esc_html( 'Dansk' ),
				'de'   => esc_html( 'Deutsch' ),
				'et'   => esc_html( 'Eesti' ),
				'el'   => esc_html( 'Ελληνικά' ), // Ellīniká
				'en'   => esc_html( 'English' ), // English
				'es'   => esc_html( 'Español' ),
				'eo'   => esc_html( 'Esperanto' ),
				'eu'   => esc_html( 'Euskara' ),
				'fa'   => esc_html( 'فارسی' ), // Fārsi
				'fr'   => esc_html( 'Français' ),
				'gl'   => esc_html( 'Galego' ),
				'hy'   => esc_html( 'Հայերեն' ), // Hayeren
				'hi'   => esc_html( 'हिन्दी' ), // Hindī
				'hr'   => esc_html( 'Hrvatski' ),
				'id'   => esc_html( 'Bahasa Indonesia' ),
				'it'   => esc_html( 'Italiano' ),
				'is'   => esc_html( 'íslenskur' ),// Islandic
				'he'   => esc_html( 'עברית' ), // Ivrit
				'ka'   => esc_html( 'ქართული' ), // Kartuli
				'la'   => esc_html( 'Latina' ),
				'lv'   => esc_html( 'Latviešu' ),
				'lt'   => esc_html( 'Lietuvių' ),
				'hu'   => esc_html( 'Magyar' ),
				'mk'   => esc_html( 'Македонски' ), // Makedonski
				'arz'  => esc_html( 'مصرى' ), // Maṣrī
				'ms'   => esc_html( 'Bahasa Melayu' ),
				'min'  => esc_html( 'Bahaso Minangkabau' ),
				'my'   => esc_html( 'မြန်မာဘာသာ' ), // Myanmarsar
				'nl'   => esc_html( 'Nederlands' ),
				'ja'   => esc_html( '日本語' ), // Nihongo
				'nb'   => esc_html( 'Norsk (bokmål)' ),
				'nn'   => esc_html( 'Norsk (nynorsk)' ),
				'ce'   => esc_html( 'Нохчийн' ), // Noxçiyn
				'uz'   => esc_html( 'Oʻzbekcha / Ўзбекча' ),
				'pl'   => esc_html( 'Polski' ),
				'pt'   => esc_html( 'Português' ),
				'kk'   => esc_html( 'Қазақша / Qazaqşa / قازاقشا' ),
				'ro'   => esc_html( 'Română' ), // Română
				'ru'   => esc_html( 'Русский' ), // Russkiy
				'ceb'  => esc_html( 'Sinugboanong Binisaya' ),
				'sk'   => esc_html( 'Slovenčina' ),
				'sl'   => esc_html( 'Slovenščina' ),
				'sr'   => esc_html( 'Српски / Srpski' ),
				'sh'   => esc_html( 'Srpskohrvatski / Српскохрватски' ),
				'fi'   => esc_html( 'Suomi' ), // suomi
				'sv'   => esc_html( 'Svenska' ),
				'ta'   => esc_html( 'தமிழ்' ), // Tamiḻ
				'tt'   => esc_html( 'Татарча / Tatarça' ),
				'th'   => esc_html( 'ภาษาไทย' ), // Phasa Thai
				'tg'   => esc_html( 'Тоҷикӣ' ), // Tojikī
				'azb'  => esc_html( 'تۆرکجه' ), // Türkce
				'tr'   => esc_html( 'Türkçe' ), // Türkçe
				'uk'   => esc_html( 'Українська' ), // Ukrayins’ka
				'ur'   => esc_html( 'اردو' ), // Urdu
				'vi'   => esc_html( 'Tiếng Việt' ),
				'vo'   => esc_html( 'Volapük' ),
				'war'  => esc_html( 'Winaray' ),
				'yue'  => esc_html( '粵語' ), // Yuht Yúh / Jyut6 jyu5
				'zh'   => esc_html( '中文' ), // Zhōngwén
				'ko'   => esc_html( '한국어' ), // Hangugeo

			]
		];

		# Divider
		$key            = 'divider_profile_blind_users';
		$fields[ $key ] = [ 'type' => 'divider', 'default' => '' ];

		# Readable Experience header
		$fields['readable_experience_header'] = [
			'type'        => 'header',
			'label'       => esc_html__( 'Readable Experience', 'readabler' ),
			'description' => esc_html__( 'Tools enable users to adjust how the content of your site is displayed, so it is as readable as possible to their particular disability.', 'readabler' ),
			'default'     => ''
		];

		$fields['readable_experience_heading'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Section title', 'readabler' ),
			'placeholder' => esc_html__( 'Show section title', 'readabler' ),
			'description' => esc_html__( 'Enable/disable the display of the current section  title.', 'readabler' ),
			'default'     => 'on',
		];

		# Content Scaling
		$fields['content_scaling'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Content Scaling', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Content Scaling', 'readabler' ),
			'description' => esc_html__( 'The option allows scaling the website content. ', 'readabler' ),
			'default'     => 'on',
		];

		# Readable Font
		$fields['readable_font'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Readable Font', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Readable Font', 'readabler' ),
			'description' => esc_html__( 'The option converts the content font to a more readable one.', 'readabler' ),
			'default'     => 'on',
		];

		# Dyslexia Friendly
		$fields['dyslexia_font'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Dyslexia Friendly', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Dyslexia Friendly', 'readabler' ),
			'description' => esc_html__( 'The option adapts the font to be more convenient for Dyslexic users.', 'readabler' ),
			'default'     => 'on',
		];

		# Highlight Titles
		$fields['highlight_titles'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Highlight Titles', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Highlight Titles', 'readabler' ),
			'description' => esc_html__( 'The option highlights the titles with borders for all site content.', 'readabler' ),
			'default'     => 'on',
		];

		# Highlight Links
		$fields['highlight_links'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Highlight Links', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Highlight Links', 'readabler' ),
			'description' => esc_html__( 'The option highlights the links with borders for all site content.', 'readabler' ),
			'default'     => 'on',
		];

		# Text Magnifier
		$fields['text_magnifier'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Text Magnifier', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Text Magnifier', 'readabler' ),
			'description' => esc_html__( 'The option allows you to display specific text in the magnifier on hover.', 'readabler' ),
			'default'     => 'on',
		];

		$fields['cognitive_reading'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Cognitive Reading', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Cognitive Reading', 'readabler' ),
			'description' => esc_html__( 'The option allows you to turn on the cognitive reading mode for quick understanding of the text based on word recognition by the brain.', 'readabler' ),
			'default'     => 'on',
		];

		# Font Sizing
		$fields['font_sizing'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Font Sizing', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Font Sizing', 'readabler' ),
			'description' => esc_html__( 'The option allows you to change the text font size as a percentage.', 'readabler' ),
			'default'     => 'on',
		];

		# Line Height
		$fields['line_height'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Line Height', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Line Height', 'readabler' ),
			'description' => esc_html__( 'The option allows you to change the font line-height as a percentage', 'readabler' ),
			'default'     => 'on',
		];

		# Letter Spacing
		$fields['letter_spacing'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Letter Spacing', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Letter Spacing', 'readabler' ),
			'description' => esc_html__( 'The option allows you to change the text letter spacing as a percentage.', 'readabler' ),
			'default'     => 'on',
		];

		# Align Center
		$fields['align_center'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Align Center', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Align Center', 'readabler' ),
			'description' => esc_html__( 'The option aligns the website content to the center.', 'readabler' ),
			'default'     => 'on',
		];

		# Align Left
		$fields['align_left'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Align Left', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Align Left', 'readabler' ),
			'description' => esc_html__( 'The option aligns the website content to the left.', 'readabler' ),
			'default'     => 'on',
		];

		# Align Right
		$fields['align_right'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Align Right', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Align Right', 'readabler' ),
			'description' => esc_html__( 'The option aligns the website content to the right.', 'readabler' ),
			'default'     => 'on',
		];

		# Divider
		$key            = 'divider_align_right';
		$fields[ $key ] = [ 'type' => 'divider', 'default' => '' ];

		# Visually Pleasing Experience Header
		$fields['visually_pleasing_experience_header'] = [
			'type'        => 'header',
			'label'       => esc_html__( 'Visually Pleasing Experience', 'readabler' ),
			'description' => esc_html__( 'Tools relating to the colorization of your website.', 'readabler' ),
			'default'     => ''
		];

		$fields['visually_pleasing_heading'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Section title', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Show section title', 'readabler' ),
			'description' => esc_html__( 'Enable/disable the display of the current section  title.', 'readabler' ),
			'default'     => 'on',
		];

		# Dark Contrast
		$fields['dark_contrast'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Dark Contrast', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Dark Contrast', 'readabler' ),
			'description' => esc_html__( 'The option sets a dark contrast for the content of the entire site.', 'readabler' ),
			'default'     => 'on',
		];

		# Light Contrast
		$fields['light_contrast'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Light Contrast', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Light Contrast', 'readabler' ),
			'description' => esc_html__( 'The option sets a light contrast for the content of the entire site.', 'readabler' ),
			'default'     => 'on',
		];

		# Monochrome
		$fields['monochrome'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Monochrome', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Monochrome', 'readabler' ),
			'description' => esc_html__( 'The option applies a monochrome color scheme for the entire site.', 'readabler' ),
			'default'     => 'on',
		];

		# High Saturation
		$fields['high_saturation'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'High Saturation', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'High Saturation', 'readabler' ),
			'description' => esc_html__( 'The option adds color saturation for the entire site content.', 'readabler' ),
			'default'     => 'on',
		];

		# High Contrast
		$fields['high_contrast'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'High Contrast', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'High Contrast', 'readabler' ),
			'description' => esc_html__( 'The option increases color contrast for the entire site content.', 'readabler' ),
			'default'     => 'on',
		];

		# Low Saturation
		$fields['low_saturation'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Low Saturation', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Low Saturation', 'readabler' ),
			'description' => esc_html__( 'The option minimizes color saturation for the entire site content.', 'readabler' ),
			'default'     => 'on',
		];

		# Text Colors
		$fields['text_colors'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Text Colors', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Text Colors', 'readabler' ),
			'description' => esc_html__( 'The option displays a color picker to adjust the text color of website content.', 'readabler' ),
			'default'     => 'on',
		];

		# Title Colors
		$fields['title_colors'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Title Colors', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Title Colors', 'readabler' ),
			'description' => esc_html__( 'The option displays a color picker to adjust the title color of website content.', 'readabler' ),
			'default'     => 'on',
		];

		# Background Colors
		$fields['background_colors'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Background Colors', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Background Colors', 'readabler' ),
			'description' => esc_html__( 'The option displays a color picker to adjust the background color of website content.', 'readabler' ),
			'default'     => 'on',
		];

		# Divider
		$key            = 'divider_background_colors';
		$fields[ $key ] = [ 'type' => 'divider', 'default' => '' ];

		# Easy Orientation
		$fields['easy_orientation_header'] = [
			'type'        => 'header',
			'label'       => esc_html__( 'Easy Orientation', 'readabler' ),
			'description' => esc_html__( 'Tools for people with visual impairments, cognitive disabilities, or motor impairments to orient better at the site.', 'readabler' ),
			'default'     => ''
		];

		$fields['easy_orientation_heading'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Section title', 'readabler' ),
			'placeholder' => esc_html__( 'Show section title', 'readabler' ),
			'description' => esc_html__( 'Enable/disable the display of the current section  title.', 'readabler' ),
			'default'     => 'on',
		];

		# Mute Sounds
		$fields['mute_sounds'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Mute Sounds', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Mute Sounds', 'readabler' ),
			'description' => esc_html__( 'The option mutes all sounds on the site.', 'readabler' ),
			'default'     => 'on',
		];

		# Hide Images
		$fields['hide_images'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Hide Images', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Hide Images', 'readabler' ),
			'description' => esc_html__( 'The option hides all images on the site.', 'readabler' ),
			'default'     => 'on',
		];

		$fields['hide_emoji'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Hide Emojis', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Hide Emojis', 'readabler' ),
			'description' => esc_html__( 'The option hides all emojis on the site.', 'readabler' ),
			'default'     => 'on',
		];

		# Virtual Keyboard
		$fields['virtual_keyboard'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Virtual Keyboard', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Virtual Keyboard', 'readabler' ),
			'description' => esc_html__( 'The option enables the virtual keyboard when any one of the input fields is active.', 'readabler' ),
			'default'     => 'on',
		];

		# Reading Guide
		$fields['reading_guide'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Reading Guide', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Reading Guide', 'readabler' ),
			'description' => esc_html__( 'The option displays a guideline that follows the cursor and helps to concentrate only on the specific text.', 'readabler' ),
			'default'     => 'on',
		];

		# Useful Links
		$fields['useful_links'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Useful Links', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Useful Links', 'readabler' ),
			'description' => esc_html__( 'The option displays a select list of useful site links to get the necessary info without site research.', 'readabler' ),
			'default'     => 'on',
		];

		# Stop Animations
		$fields['stop_animations'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Stop Animations', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Stop Animations', 'readabler' ),
			'description' => esc_html__( 'The option allows disabling animations on the site.', 'readabler' ),
			'default'     => 'on',
		];

		# Reading Mask
		$fields['reading_mask'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Reading Mask', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Reading Mask', 'readabler' ),
			'description' => esc_html__( 'The option creates a horizontal mask of a certain height that follows the cursor and allows you to select and focus only on a certain part of the content.', 'readabler' ),
			'default'     => 'on',
		];

		# Highlight Hover
		$fields['highlight_hover'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Highlight Hover', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Highlight Hover', 'readabler' ),
			'description' => esc_html__( 'The option highlights the hover area by borders.', 'readabler' ),
			'default'     => 'on',
		];

		# Highlight Focus
		$fields['highlight_focus'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Highlight Focus', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Highlight Focus', 'readabler' ),
			'description' => esc_html__( 'The option highlights the focus area by borders.', 'readabler' ),
			'default'     => 'on',
		];

		# Big Black Cursor
		$fields['big_black_cursor'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Big Dark Cursor', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Big Dark Cursor', 'readabler' ),
			'description' => esc_html__( 'The option enables a large black cursor instead of the regular one.', 'readabler' ),
			'default'     => 'on',
		];

		# Big White Cursor
		$fields['big_white_cursor'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Big Light Cursor', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Big Light Cursor', 'readabler' ),
			'description' => esc_html__( 'The option enables a large white cursor instead of the regular one.', 'readabler' ),
			'default'     => 'on',
		];

		# Text to Speech
		$fields['text_to_speech'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Text to Speech', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Text to Speech', 'readabler' ),
			'description' => esc_html__( 'The option enables the Text-to-Speech feature. Audio is generated when the user highlights text. Before activating this feature, please upload the API key file on the "Text to Speech" tab.', 'readabler' ),
			'default'     => 'off',
		];

		$fields['voice_navigation'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Voice Navigation', 'readabler' ),
			'placeholder' => esc_html__( 'Voice Navigation', 'readabler' ),
			'description' => esc_html__( 'The option enables the voice navigation feature. The user can navigate through the site using voice commands.', 'readabler' ),
			'default'     => 'on',
		];

		# Keyboard Navigation
		$fields['keyboard_navigation'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Keyboard Navigation', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Keyboard Navigation', 'readabler' ),
			'description' => esc_html__( 'The option enables a keyboard navigation feature.', 'readabler' ),
			'default'     => 'on',
		];

		return $fields;

	}

	/**
	 * Register General tab.
	 * @return void
	 */
	public static function add_tab() {
		self::add_settings_tab(
			self::$key,
			0,
			'tune',
			esc_html__( 'General', 'readabler' ),
			esc_html__( 'General settings', 'readabler' ),
			esc_html__( "Configure modes and accessibility profiles what you need. Certain modes are connected to specific accessibility settings. If you disable a mode, its button will disappear, but the mode's features will still be available if they're linked to active accessibility profiles.", 'readabler' ),
		);
	}

	/**
	 * Add fields to the tab.
	 * @return void
	 */
	public static function add_controls() {
		$tabs                         = Plugin::get_tabs();
		$tabs[ self::$key ]['fields'] = self::controls();
		Plugin::set_tabs( $tabs );
	}

}
