<?php

namespace Merkulove\Unity;

class Filters
{
    private static ?Filters $instance = null;

    private function __construct()
    {
        // Add a custom cron schedule
	    add_filter('cron_schedules', [$this, 'cron_schedules']);
    }

    /**
     * Add a custom cron schedule
     * @param $schedules
     * @return mixed
     */
    public function cron_schedules($schedules)
    {
        $schedules['every_minute'] = [
            'interval' => 60,
            'display' => esc_html__('Every Minute', 'readabler'),
        ];

	    // Every 3 minutes schedule
	    $schedules['every_three_minutes'] = [
		    'interval' => 180,
		    'display' => esc_html__('Every 3 Minutes', 'readabler'),
	    ];

	    // Every 5 minutes schedule
	    $schedules['every_five_minutes'] = [
		    'interval' => 300,
		    'display' => esc_html__('Every 5 Minutes', 'readabler'),
	    ];

        return $schedules;
    }

    public static function get_instance(): Filters
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __clone()
    {
    }

    public function __wakeup()
    {
    }
}

