<?php
/*
 * User Profile
 */

if ( !defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
if ( !class_exists( 'SRP_User_Profile_Settings' ) ) {

	/**
	 * SRP_User_Profile_Settings Class
	 */
	class SRP_User_Profile_Settings {

		/**
		 * Class initialization
		 */
		public static function init() {

			add_action( 'user_new_form' , array( __CLASS__, 'add_custom_register_data' ) ) ;
			add_action( 'show_user_profile' , array( __CLASS__, 'add_custom_affiliate_data' ) ) ;
			add_action( 'edit_user_profile' , array( __CLASS__, 'add_custom_affiliate_data' ) ) ;

			add_action( 'user_register' , array( __CLASS__, 'enable_reward_program' ) ) ;
			add_action( 'edit_user_profile_update', array( __CLASS__, 'enable_reward_program' ) );
		}

		/**
		 * Add custom register data
		 */
		public static function add_custom_register_data( $operation ) {
			if ( 'add-new-user' !== $operation ) {
				return ;
			}

			if ( 'yes' != get_option( 'rs_enable_reward_program' ) ) {
				return ;
			}
			
			$enable_reward_program  = 'no' ;
			
			include_once SRP_PLUGIN_PATH . '/includes/admin/views/enable-reward-program.php';
		}

		/**
		 * Add custom Affiliate data
		 */
		public static function add_custom_affiliate_data( $user ) {
			if ( 'yes' != get_option( 'rs_enable_reward_program' ) ) {
				return ;
			}
			
			$enable_reward_program  = get_user_meta( $user->ID, 'allow_user_to_earn_reward_points', true) ;
			
			include_once SRP_PLUGIN_PATH . '/includes/admin/views/enable-reward-program.php';
		}

		/**
		 * Add custom Affiliate data
		 */
		public static function enable_reward_program( $user ) {
			$user_id = is_object($user) ? $user->ID : $user;
			if ( isset( $_REQUEST[ 'rs_enable_reward_program_for_user' ] ) ) {
				update_user_meta( $user_id, 'allow_user_to_earn_reward_points', 'yes' );
				update_user_meta( $user_id, 'unsub_value', 'no' );
			} else {
				update_user_meta( $user_id, 'allow_user_to_earn_reward_points', 'no' );
			}
		}
	}

	SRP_User_Profile_Settings::init() ;
}
