<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'SALESGEN' ) ) {
	final class SALESGEN {

		private $options = array();

		private $module_loaders = array();

		private static $instance = null;

		private $minify = true;
		private $core_version = '4.3.5';

		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}
		
		public function __construct() {
			$this->module_loader();
			$this->defines();
			
			add_action( 'admin_init', array( $this, 'initialize_settings' ) );
			add_action( 'admin_menu', array( $this, 'admin_menu' ), 999 );
			add_action( 'wp_ajax_nopriv_sg_module', 	array( &$this, 'module' ) );
			add_action( 'wp_ajax_sg_module', 			array( &$this, 'module' ) );

			add_action( 'admin_enqueue_scripts', array( &$this, 'admin_scripts' ), 10 );

			add_action( 'woocommerce_admin_field_sgdiv', array( &$this, 'output_sgdiv_fields' ) );
			add_action( 'woocommerce_admin_field_sgtitle', array( &$this, 'output_sgtitle_fields' ) );
			
		}

		public function admin_scripts( $hook )	{

			/*
			if ( 'woocommerce_page_sg-main' != $hook ) {
				return;
			}
			*/
			$this->core_version = apply_filters('salesgen_core_version', $this->core_version);
			$this->lang_cfg();
			$this->find_correct_modules();

			$asset_url = 'https://assets.snclouds.com/sg-core/v' . $this->core_version .'/';
			//$asset_url = 'https://dev.local/salesgen-core/';

			if ( !wp_script_is('salesgen-admin') ) {
				wp_enqueue_script( 'jquery-ui-sortable');
				wp_enqueue_script( 'salesgen-admin', $asset_url . 'admin.'. ($this->minify? 'min.': '') .'js?m='.$this->find_correct_modules(), array('jquery'), $this->core_version );
				wp_localize_script( 'salesgen-admin', 'sgcfg', array( 
					'ajax_url' => admin_url( 'admin-ajax.php' ),
					'lang' => $this->lang,
					'nonce' => wp_create_nonce( 'salesgen-admin' )
				) );

				wp_register_style( 'salesgen_admin_css', $asset_url . 'admin.'. ($this->minify? 'min.': '') .'css', false, $this->core_version );
        		wp_enqueue_style( 'salesgen_admin_css' );
        		if ( ! did_action( 'wp_enqueue_media' ) ) {
					wp_enqueue_media();
				}
			}
			
		}

		function find_correct_modules(){
			$m = array();
			foreach ($this->module_loaders as $module => $loader) {
				$m[] = $module;
			}

			return json_encode($m);
		}

		public function module_loader()	{
			$this->module_loaders = apply_filters( 'salesgen_module_loaders', array() );
		}

		public function defines() {
			
			define( 'SALESGEN_PAGE_NAME', 'salesgen' );
			define( 'SALESGEN_SETTINGS_SECTION', 'sg_settings_section' );
			define( 'SALESGEN_OPTIONS_GROUP', 'sg-settings' );

			define( 'SG_ACTION_SETTINGS', 'settings' );
			define( 'SG_SUB_ACTION_SAVE_SETTINGS', 'save_setting' );
		}

		function get_options() {
			return $this->options;
		}

		public function module() {

			$this->lang_cfg();

			$k = isset( $_POST['ls'] )? $_POST['ls'] : '' ;
			$module = isset( $_POST['module'] )? $_POST['module'] : '' ;
			$act = isset( $_POST['act'] )? $_POST['act'] : '' ;
			$result = null;

			$data = array(
				'msg' => '',
				'stt' => 0
			);

			if( isset($this->module_loaders[ $module ]) ) {
				$module_instance = call_user_func( $this->module_loaders[ $module ] . '::get_instance');

				$result = $module_instance->updater->process_ls( array(
					'ls' => $k, 
					'module' => $module,
					'act' => $act 
				));
				//print_r($result);
			}
			
			if( is_array($result)){

				$data['stt'] = $result['stt'];
				$data['msg'] = sprintf($this->lang[ $result['stt'] ], date('F d, Y', $result['epd']));

			}else $data['msg'] = $this->lang[5] . $result;
			
			wp_send_json( $data );
		}

		public function lang_cfg() {
			$this->lang = array(
				1 => __( 'Your license is assigned to this domain successful. Your license expiry date is %s', 'salesgen' ),
				2 => __( 'Your license is invalid, please ensure you copied correct license key.', 'salesgen' ),
				3 => __( 'Your license reached to maximum activation domains. Please extend to higher packages or purchase different license.', 'salesgen' ),
				4 => __( 'Your license is expired, please renew to continue using.', 'salesgen' ),
				5 => __( 'There is a problem with connection to SalesGen server, please try again or contact us to solve issue. https://salesgen.io/contact/', 'salesgen' ),
				6 => __( 'Your license was assigned to this domain before. Your license expiry date is %s', 'salesgen' ),
				7 => __( 'Deactivate license successful, all setting for this module are disabled.', 'salesgen' ),
				8 => __( 'Your license did not assign to this domain. Please check your license again.', 'salesgen' ),
				9 => __( 'Your license was assigned to this domain before. You need to revoke license from old hosting before reactive.', 'salesgen' ),
			);
		}

		public function initialize_settings() {

			// Start: Settings for cart abandonment.
			add_settings_section(
				SALESGEN_SETTINGS_SECTION,
				__( 'SalesGen Licenses', 'salesgen' ),
				array( $this, 'options_callback' ),
				SALESGEN_PAGE_NAME
			);

			do_action( 'sg_init_settings', $this );
		}

		public function ls( $key, $label, $module ) {
			add_settings_field(
				$key,
				$label,
				array( $this, 'ls_callback' ),
				SALESGEN_PAGE_NAME,
				SALESGEN_SETTINGS_SECTION,
				array( 'field_name' => $key, 'desc' => __( 'License key.' ), 'module' => $module )
			);
			
			register_setting(
				SALESGEN_OPTIONS_GROUP,
				$key
			);
		}

		public function ls_callback( $args ) {
			$option = get_option( $args['module'] . '_package', '' );$nswerew = '';
			if ( isset( $option['ls'] ) && !empty( $option['package'] ) ) {$nswerew = $option['ls'];}
			printf(
				'<div class="sg_ls_field"><input type="text" id="'.$args['field_name'].'" name="'.$args['field_name'].'" value="'.$nswerew.'" class="sg_ls_input"/> <a href="javascript:void(0);" class="sg_ls_action" data-action="'. ( empty( $nswerew )? 'activate':'deactivate' ) .'" data-module="'. $args['module'] .'">'. ( empty( $nswerew )? 'Activate':'Deactivate' ) .'</a><div style="padding:4px 0;" class="sg_ls_msg"></div></div>'
			);
			
		}

		public function options_callback() {
			echo '<hr/>';
		}

		public function enable_callback( $args ) {
			$sg_pp_enable = get_option( 'sg_pp_enable' );
			$html          = '';
			printf(
				'<input type="checkbox" id="sg_pp_enable" name="sg_pp_enable" value="on"
				' . checked( 'on', $sg_pp_enable, false ) . ' />'
			);
			$html .= '<label for="sg_pp_enable"> ' . $args[0] . '</label>';
			echo wp_kses_post( $html );
		}

		public function admin_menu() {

			$capability = current_user_can( 'manage_woocommerce' ) ? 'manage_woocommerce' : 'manage_options';

			add_menu_page(
				__( 'SalesGen', 'salesgen' ),
				'SalesGen',
				'manage_options',
				'salesgen',
				array( $this, 'render_admin_page' ),
				'', //icon
				59
			);

			remove_submenu_page ( 'salesgen', 'salesgen' );

			add_submenu_page(
				'salesgen',
				__( 'Licenses', 'salesgen' ),
				__( 'Licenses', 'salesgen' ),
				'manage_options',
				SALESGEN_PAGE_NAME,
				array( $this, 'render_admin_page' ),
				0
			);

			do_action('sg_register_submenu');
		}

		public function render_admin_page() {
			?>
			<div class="wrap">
				<h1 id="salesgen_settings_table"><?php echo esc_html__( 'SalesGen Settings', 'salesgen' ); ?></h1>
				<?php

				$sg_action = filter_input( INPUT_GET, 'action', FILTER_SANITIZE_STRING );
				$sub_action  = filter_input( INPUT_GET, 'sub_action', FILTER_SANITIZE_STRING );

				if ( ! $sg_action ) {
					$sg_action = SG_ACTION_SETTINGS;
				}

				$this->display_tabs();
				?>
				<?php
				echo wp_kses_post( get_transient( 'sg_show_message' ) );
				?>

				<?php if ( SG_ACTION_SETTINGS === $sg_action ) : ?>
					<?php
					$this->display_settings();
					?>
				<?php endif; ?>	

			</div>

			<?php
		}

		public function display_tabs() {

			$sg_action = filter_input( INPUT_GET, 'action', FILTER_SANITIZE_STRING );
			$sub_action  = filter_input( INPUT_GET, 'sub_action', FILTER_SANITIZE_STRING );
	
			if ( ! $sg_action ) {
				$sg_action            = SG_ACTION_SETTINGS;
				$active_settings        = '';
				$active_reports         = '';
				$active_email_templates = '';
			}
	
			$active_settings = 'nav-tab-active';
			// phpcs:disable
		 ?>
			<div class="nav-tab-wrapper woo-nav-tab-wrapper">
				<?php
				$url = add_query_arg( array(
					'page' => SALESGEN_PAGE_NAME,
					'action' => SG_ACTION_SETTINGS
				), admin_url( '/admin.php' ) )
				?>
				<a href="<?php echo $url; ?>"
				   class="nav-tab <?php echo isset( $active_settings )? $active_settings : '';?>">
			  		<?php _e( 'Settings', 'salesgen-paypal-multi' ); ?>
				</a>	
			</div>
			<?php
			// phpcs:enable
		}


		public function display_settings() {
			?>
	
			<form method="post" action="options.php">
			<?php settings_fields( SALESGEN_OPTIONS_GROUP ); ?>
			<?php do_settings_sections( SALESGEN_PAGE_NAME ); ?>
			</form>
	
			<?php
		}

		public function output_sgdiv_fields( $value ) {
			?>
			<tr valign="top">
				<td colspan="2"><hr></td>
			</tr>
			<?php
		}

		public function output_sgtitle_fields( $value ) {
			if ( ! empty( $value['title'] ) ) {
				?>
				<tr valign="top">
					<th colspan="2"><hr><?php echo '<h4 style="margin:1em 0 0;">' . esc_html( $value['title'] ) . '</h4>';?></th>
				</tr>
				<?php
			}
		}

		public function submenu( $args ) {
			
			add_submenu_page(
				'salesgen',
				isset($args['page_title'])? $args['page_title'] : $args['menu_title'],
				$args['menu_title'],
				'manage_options',
				$args['slug'],
				$args['render']
			);
			
		}
	}

	SALESGEN::get_instance();
}



if ( ! class_exists( 'SalesGen_Settings' ) ) {
	/**
	 * 
	 */
	class SalesGen_Settings {
		
		private $group = '';

		private $menu_title = '';

		private $page_title = '';

		private $slug = '';

		private $fields = array();

		private $values = array();

		private $categories = false;

		function __construct( $args ) {

			$this->slug = $args['slug'];

			$this->group = $args['group'];
			
			if( isset($args['menu']) && $args['menu'] ) {

				$this->menu_title = $args['menu_title'];

				$this->page_title = isset($args['page_title'])? $args['page_title'] :  $args['menu_title'];

				add_action('sg_register_submenu', array($this, 'submenu'));
			}

			if( isset($args['fields']) ) {

				$this->fields = $args['fields'];
				$this->values = $args['values'];

				add_action( 'admin_init', array( $this, 'initialize_settings' ) );

				add_action( 'admin_enqueue_scripts', array( &$this, 'admin_scripts' ), 999 );
			}

			
		}


		public function submenu() {
			add_submenu_page(
				'salesgen',
				$this->page_title,
				$this->menu_title,
				'manage_options',
				$this->slug,
				array( $this, 'setting_page' )
			);
		}


		public function setting_page() {
			?>

			<div class="wrap">
				
				<form method="post" action="options.php">
					<h1></h1>
					<div id="salesgen_settings_table" class="salesgen-page-setting-title">
						<span>
							<?php echo $this->page_title; ?>
						</span>
						<?php submit_button(); ?>
					</div>
					<?php settings_errors(); ?>
					<?php settings_fields( $this->group ); ?>
					<?php do_settings_sections( $this->slug ); ?>
					<div class="sg_settings" data-group="<?php echo $this->group;?>">
					</div>
					<?php //submit_button(); ?>
				</form>			
			</div>
			<?php
		}

		public function initialize_settings() {
			
			foreach( $this->fields as $field ) {
				
				if( !isset($field['id']) ) continue;

				$field_id = $field['id'];
			
				register_setting( $this->group, $field_id );
			}
		}


		public function admin_scripts( $hook ) {

			//load current value to option
			foreach( $this->fields as $ind => $field ) {

				if( !isset($field['name']) ) continue;

				$this->fields[$ind]['value'] = isset($this->values[$field['id']]) ? $this->values[$field['id']] :  get_option( $field['id'], '' );

			}

			$group_data = array( 
				'fields' => $this->fields,
				'values' => $this->values
			);
				
			wp_localize_script( 'jquery-core', $this->group, $group_data );

			
			
		}
	}
}



// Ajax handle

/**
 * SalesGen Ajax
 * based on WC ajax class
 */
if ( ! class_exists( 'SG_AJAX' ) ) {

	class SG_AJAX {

		private static $instance = null;

		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}
		
		public function __construct() {
			add_action( 'init', array( __CLASS__, 'define_ajax' ), 0 );
			add_action( 'template_redirect', array( __CLASS__, 'do_sg_ajax' ), 0 );
			
		}

		public static function get_endpoint( $request = '' ) {
			return esc_url_raw( apply_filters( 'salesgen_ajax_get_endpoint', add_query_arg( 'sg-ajax', $request, remove_query_arg( array( '_wpnonce' ), home_url( '/', 'relative' ) ) ), $request ) );
		}

		public static function define_ajax() {
			// phpcs:disable
			if ( ! empty( $_GET['sg-ajax'] ) ) {
				wc_maybe_define_constant( 'DOING_AJAX', true );
				wc_maybe_define_constant( 'SG_DOING_AJAX', true );
				if ( ! WP_DEBUG || ( WP_DEBUG && ! WP_DEBUG_DISPLAY ) ) {
					@ini_set( 'display_errors', 0 ); // Turn off display_errors during AJAX events to prevent malformed JSON.
				}
				$GLOBALS['wpdb']->hide_errors();
			}
			// phpcs:enable
		}

		/**
		 * Send headers for WC Ajax Requests.
		 *
		 * @since 2.5.0
		 */
		private static function wc_ajax_headers() {
			if ( ! headers_sent() ) {
				send_origin_headers();
				send_nosniff_header();
				wc_nocache_headers();
				header( 'Content-Type: text/html; charset=' . get_option( 'blog_charset' ) );
				header( 'X-Robots-Tag: noindex' );
				status_header( 200 );
			} elseif ( Constants::is_true( 'WP_DEBUG' ) ) {
				headers_sent( $file, $line );
				trigger_error( "sg_ajax_headers cannot set headers - headers already sent by {$file} on line {$line}", E_USER_NOTICE ); // @codingStandardsIgnoreLine
			}
		}

		/**
		 * Check for WC Ajax request and fire action.
		 */
		public static function do_sg_ajax() {
			global $wp_query;

			// phpcs:disable WordPress.Security.NonceVerification.Recommended
			if ( ! empty( $_GET['sg-ajax'] ) ) {
				$wp_query->set( 'sg-ajax', sanitize_text_field( wp_unslash( $_GET['sg-ajax'] ) ) );
			}

			$action = $wp_query->get( 'wc-ajax' );

			if ( $action ) {
				self::wc_ajax_headers();
				$action = sanitize_text_field( $action );
				do_action( 'sg_ajax_' . $action );
				wp_die();
			}
			// phpcs:enable
		}

		public static function same_function() {
			if ( true ) {
				//if has error
				wp_send_json_error( 'error_key' );
				wp_die();
			}

			//success data
			wp_send_json_success(
				array(
					'key' => 'val'
				)
			);
		}
	}

	SG_AJAX::get_instance();
}


