<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'SALESGEN_US_Loader' ) ) {
	final class SALESGEN_US_Loader {

		/**
		 * Member Variable
		 *
		 * @var instance
		 */
		private static $instance = null;

		/**
		 * Member Variable
		 *
		 * @var utils
		 */
		public $utils = null;

		public $plugin_slug = '';

		public $updater = null;

		public $valid = -1;

		private $core_version = '4.3.5';
		/**
		 *  Initiator
		 */
		public static function get_instance() {

			if ( is_null( self::$instance ) ) {

				self::$instance = new self();

				do_action( 'salesgen_us_loaded' );
			}

			return self::$instance;
		}

		/**
		 * Constructor
		 */
		public function __construct() {
			global $wpdb;
			$this->define_constants();

			//mirgrate config from salesnudge to salesgen
			if ( function_exists('get_option') ) {
				$is_salesnudge = get_option('salesnudge_upsell_bundle_position', '');
				$is_salesgen = get_option('salesgen_upsell_bundle_position', '');

				if( !empty($is_salesnudge) && empty($is_salesgen) ) {
					$sql = "SELECT * FROM {$wpdb->prefix}options WHERE option_name LIKE 'salesnudge%';";
					$options = $wpdb->get_results($sql);
					
					if ( is_array($options)) {

						foreach ($options as $option) {
							$option_name = str_replace('salesnudge', 'salesgen', $option->option_name);

							$sql = "INSERT INTO {$wpdb->prefix}options (`option_name`, `option_value`) VALUES('{$option_name}','{$option->option_value}');";
							$options = $wpdb->get_results($sql);
						}
					}
					//deactive salesnudge
					require_once ( ABSPATH . 'wp-admin/includes/plugin.php' );
					deactivate_plugins("salesnudge-upsell/salesnudge-upsell.php");
				}	
			}
			

			// Activation hook.
			register_activation_hook( SALESGEN_US_SLUG, array( $this, 'activation_reset' ) );

			// deActivation hook.
			register_deactivation_hook( SGUS_FILE, array( $this, 'deactivation_reset' ) );

			add_action( 'plugins_loaded', array( $this, 'load_plugin' ), 99 );
			
			add_filter( 'salesgen_module_loaders', array( $this, 'loader_plugin' ), 10 );
		}

		function loader_plugin( $loaders ) {
			$loaders[ SALESGEN_US_SHORT_SLUG ] = 'SALESGEN_US_Loader';
			return $loaders;
		}

		/**
		 * Defines all constants
		 *
		 * @since 1.0.0
		 */
		public function define_constants() {
			define( 'SALESGEN_US_VER', SGUS );
			define( 'SALESGEN_US_DIR', plugin_dir_path( SGUS_FILE ) );
			define( 'SALESGEN_US_CORE_DIR', plugin_dir_path( SGUS_FILE ) . 'core/' );			
			define( 'SALESGEN_US_URL', plugin_dir_url( SGUS_FILE ) );
			
			add_filter('salesgen_core_version', array( $this, 'check_core_version'), 99);
			if( !defined('SG_COUPON_GENERATED_BY')) define( 'SG_COUPON_GENERATED_BY', 'salesgen-upsell' );
			define( 'SALESGEN_US_SLUG', 'salesgen-upsell/salesgen-upsell.php');
			define( 'SALESGEN_US_SHORT_SLUG', 'salesgen-upsell');
			define( 'SALESGEN_US_INS', SALESGEN_US_SHORT_SLUG . '_ins');
			define( 'SALESGEN_US_LS', SALESGEN_US_SHORT_SLUG . '_ls');
		}

		function check_core_version($version){

			if ( version_compare($this->core_version, $version) === 1 ) return $this->core_version;

			return $version;
		}

		public function activation_reset() {
			global $wpdb;

			if ( !get_option( SALESGEN_US_INS, false ) ) update_option( SALESGEN_US_INS, time());

			$modules = get_option('sg_modules', array());

			if ( !isset( $modules[ SALESGEN_US_SLUG ] ) ) {
				$modules[ SALESGEN_US_SLUG ] = 1;
				update_option( 'sg_modules', $modules );
			}

			$mirgrate = get_option('salesgen-upsell-migrate', '');
			if ( empty($mirgrate)) {
				//
				require_once ( ABSPATH . 'wp-admin/includes/class-wp-filesystem-base.php' );
				require_once ( ABSPATH . 'wp-admin/includes/class-wp-filesystem-direct.php' );
				$fsys = new WP_Filesystem_Direct(false);

				//$sql = "DELETE FROM {$wpdb->prefix}options WHERE `option_name` LIKE 'salesnudge%';";
				//$wpdb->get_results($sql);
				//remove plugin file
				
				$fsys->rmdir(WP_CONTENT_DIR . 'plugins' . DS . 'salesnudge-upsell', true);
				update_option( 'salesgen-upsell-migrate', 'ok' );
			}
			
		}

		public function deactivation_reset() {
			
			$modules = get_option('sg_modules', array());

			if ( isset( $modules[ SALESGEN_US_SLUG ] ) ) {
				$modules[ SALESGEN_US_SLUG ] = 0;
				update_option( 'sg_modules', $modules );
			}
		}

		public function ivl() {
			$this->sglsc();
			return $this->valid == 1? true: false;
		}

		/**
		 * Loads plugin files.
		 *
		 * @since 1.0.0
		 *
		 * @return void
		 */
		public function load_plugin() {

			if ( ! function_exists( 'WC' ) ) {
				add_action( 'admin_notices', array( $this, 'fails_to_load' ) );
				return;
			}
			
			$this->load_core_files();
			$this->load_modules();

			do_action( 'salesgen_us_init' );
		}

		public function fails_to_load() {

			$screen = get_current_screen();

			if ( isset( $screen->parent_file ) && 'plugins.php' === $screen->parent_file && 'update' === $screen->id ) {
				return;
			}

			$class = 'notice notice-error';
			/* translators: %s: html tags */
			$message = sprintf( __( 'The %1$sUpsell Blast by SalesGen%2$s plugin requires %1$sWooCommerce%2$s plugin installed & activated.', 'salesgen-upsell' ), '<strong>', '</strong>' );
			$plugin  = 'woocommerce/woocommerce.php';

			if ( $this->is_woo_installed() ) {
				if ( ! current_user_can( 'activate_plugins' ) ) {
					return;
				}

				$action_url   = wp_nonce_url( 'plugins.php?action=activate&amp;plugin=' . $plugin . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $plugin );
				$button_label = __( 'Activate WooCommerce', 'salesgen-upsell' );

			} else {
				if ( ! current_user_can( 'install_plugins' ) ) {
					return;
				}

				$action_url   = wp_nonce_url( self_admin_url( 'update.php?action=install-plugin&plugin=woocommerce' ), 'install-plugin_woocommerce' );
				$button_label = __( 'Install WooCommerce', 'salesgen-upsell' );
			}

			$button = '<p><a href="' . $action_url . '" class="button-primary">' . $button_label . '</a></p><p></p>';

			printf( '<div class="%1$s"><p>%2$s</p>%3$s</div>', esc_attr( $class ), wp_kses_post( $message ), wp_kses_post( $button ) );
		}private function sglsc() {
			
			$d = explode(':', $this->updater->get( 'package_exp' ));  if( count($d) < 2) return;  $e=$d[0];
			$diff = ( $e - time())+1;if( $diff < 0 ) {$this->valid = -1;} else $this->valid = 1;
		}

		public function is_woo_installed() {

			$path    = 'woocommerce/woocommerce.php';
			$plugins = get_plugins();

			return isset( $plugins[ $path ] );
		}

		/**
		 * Load core files.
		 */
		public function load_core_files() {
			require_once SALESGEN_US_CORE_DIR . 'salesgen.php';
			require_once SALESGEN_US_CORE_DIR . 'updater.php';
			$this->updater = new SalesGen_Updater( SALESGEN_US_SLUG, SGUS );
		}

		public function load_modules() {
			if ( strpos(SALESGEN_US_DIR, base64_decode('c2FsZXNnZW4=')) > 0 && file_exists(SALESGEN_US_DIR . base64_decode('bW9kdWxlcy91cHNlbGwvbW9kdWxlLnBocA==')) ) {
				include_once SALESGEN_US_DIR . base64_decode('bW9kdWxlcy91cHNlbGwvbW9kdWxlLnBocA==');
			}
		}

	}

	SALESGEN_US_Loader::get_instance();
}