<?php
/**
 * Modulke Name: WooCommerce Upsell & Cross-sell
 * Description: Display upsell & cross sell products as bundle with discount amount, cross sell and upsell on cart & thank you page.
 * Author: SalesGen
 *
 * @package SalesGen
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'SG_UB_Announcement' ) ) {
	class SG_UB_Announcement{

		public $options = array();
		private $cfg    = array();
		public $message = array();
		
		public function __construct( $cfg, $options ) {

			$this->options = $options;
			$this->cfg     = $cfg;
			
			//show buy more save more box
			if( $options['salesgen_upsell_announcement_topbar'] == 'yes' ) {
				
				if( $options['salesgen_upsell_announcement_topbar_text'] != '') {
					add_action( 'wp_footer', array( $this, 'announcement_topbar') );
				}
			}

			if( $options['salesgen_upsell_announcement_product'] == 'yes' ) {
				if( $options['salesgen_upsell_announcement_product_text'] != '') {
					$position = (!empty($options['salesgen_upsell_announcement_product_priority']))? $options['salesgen_upsell_announcement_product_priority'] : 10;
					add_action( 'woocommerce_single_product_summary', array( $this, 'announcement_product'), $position );
				}
					
			}
			
		}

		public function announcement_topbar() {
			$text_msg = $this->options['salesgen_upsell_announcement_topbar_text'];
			?>
			<div class="salesgen-ub-announcement-top"><?php echo do_shortcode($text_msg);?></div>
			<?php
		}


		public function announcement_product() {
			$text_msg = $this->options['salesgen_upsell_announcement_product_text'];
			?>
			<div class="salesgen-ub-announcement-product"><?php echo do_shortcode($text_msg);?></div>
			<?php
		}

	}
}