<?php
/**
 * Modulke Name: WooCommerce Upsell & Cross-sell
 * Description: Display upsell & cross sell products as bundle with discount amount, cross sell and upsell on cart & thank you page.
 * Author: SalesGen
 *
 * @package SalesGen
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

global $bmsm_calc;



if ( ! class_exists( 'SG_BuyMoreSaveMore' ) ) {
	class SG_BuyMoreSaveMore{

		public $options = array();
		private $cfg    = array();
		private $showed_message = false;
		private $showed_message_war = false;
		public $message = array();

		private $bmsm_coupon = 'sgbmsm';
		private $bundle_coupon = 'sgbundle';
		
		public function __construct( $cfg, $options ) {
			global $bmsm_calc;

			$bmsm_calc = 0;

			$this->options = $options;
			$this->cfg     = $cfg;


			$this->path       = SALESGEN_US_DIR . 'modules/upsell';

			//handle price buy more save more and discount bundle
			add_action( 'woocommerce_cart_item_removed', array( $this, 'cart_item_removed'), 10, 2);
			add_action( 'woocommerce_after_calculate_totals', array( $this, 'sale_custom_price' ), 1 );
			add_filter( 'woocommerce_get_shop_coupon_data', array($this, 'get_shop_coupon_data'), 1, 3);
			add_filter( 'woocommerce_cart_totals_coupon_label', array($this, 'coupon_label'), 1, 3);
			add_filter( 'woocommerce_order_item_get_code', array($this, 'admin_coupon_label'), 1, 3);
			
			
			//show buy more save more box
			if( $options['salesgen_bmsm_enable'] == 'yes' ) {

				if ( isset($_POST['action']) && $_POST['action'] == 'sgub_quickview') return;

				add_shortcode( 'sg_bmsm', array( $this, 'shortcode') );
				
				add_filter( 'sg_popup_cart_before_items', array( $this, 'popup_cart_before_items'), 1 );

				if( $options['salesgen_bmsm_position'] != '')
					add_action( $options['salesgen_bmsm_position'], array( $this, 'buy_more_save_more'), $options['salesgen_bmsm_priority'] );
			}
		}

		public function shortcode( $atts = array() ) {
			$atts = shortcode_atts( array(
				'style' => 'default',
			), $atts, 'sg_bmsm' );

			ob_start();
			$this->buy_more_save_more($atts);
			$html = ob_get_contents(); 
    		ob_end_clean();

    		return $html;
		}
		
		public function buy_more_save_more( $atts = array() ) {

			global $woocommerce, $product;

			$enable         = isset($this->options['salesgen_bmsm_enable'])? $this->options['salesgen_bmsm_enable'] : '';
			$heading_enable = isset($this->options['salesgen_bmsm_heading_enable'])? $this->options['salesgen_bmsm_heading_enable'] : 'yes';
			$heading        = isset($this->options['salesgen_bmsm_heading'])? $this->options['salesgen_bmsm_heading'] : 'Buy More Save More!';
			$subtitle       = isset($this->options['salesgen_bmsm_subtitle'])? $this->options['salesgen_bmsm_subtitle'] : "It's time to give thanks for all the little things.";
			$style          = isset($this->options['salesgen_bmsm_style'])? $this->options['salesgen_bmsm_style'] : 'default';
			$discount_type  = isset($this->options['salesgen_bmsm_conditional'])? $this->options['salesgen_bmsm_conditional'] : 'items';
			$by_items       = isset($this->options['salesgen_buy_more_by_items'])? $this->options['salesgen_buy_more_by_items'] : '';
			$icon           = isset($this->options['salesgen_bmsm_heading_icon'])? $this->options['salesgen_bmsm_heading_icon'] : '';
			$add_action_label = (isset($this->options['salesgen_bmsm_add_action_label']) && !empty($this->options['salesgen_bmsm_add_action_label']) )? $this->options['salesgen_bmsm_add_action_label'] : 'Buy {quantity}';
			$add_cart_button = isset($this->options['salesgen_bmsm_add_cart_button'])? $this->options['salesgen_bmsm_add_cart_button'] : 'no';
			$bmsm_categories   = isset($this->options['salesgen_bmsm_categories'])? $this->options['salesgen_bmsm_categories'] : array();

			$bmsm_categories = empty($bmsm_categories)? array(): $bmsm_categories;

			// set style by atts
			if( isset($atts['style']) && !empty($atts['style']) ) {
				$style = $atts['style'];
			}

			$layout = in_array($style, array('style4'))? $style : 'default';

			if( $enable != 'yes') return;

			if ( count($bmsm_categories) > 0 && is_object( $product ) ) {

				$pid   = $product->get_id();
				$cats  = sg_get_product_category_slug( $pid );
				$_cats = array_intersect( $bmsm_categories, $cats );
				
				if ( count($_cats) == 0 ) return;
			}

			include $this->path . '/layouts/bmsm_' . $layout . '.php';
			
		}

		function popup_cart_before_items( $html ) {
			$hide_congrats = isset($this->options['salesgen_bmsm_hide_congrats'])? $this->options['salesgen_bmsm_hide_congrats'] : 'no';
			return ($hide_congrats != 'yes') ? implode('', $this->message) : '';
		}

		
		function sale_custom_price( $cart_object = null ) {

			global $discount_percent, $woocommerce, $bmsm_calc;

			$bmsm_calc++;

			if ( $bmsm_calc > 1 ) return;

			if ( isset($_GET['wc-ajax']) && $_GET['wc-ajax'] == 'apply_coupon' ) return ;
			
			$allow_coupons = get_option('salesgen_bmsm_combie');
			$coupons       = WC()->cart->get_applied_coupons();

			//wc_clear_notices();


			
			
			$enable        = isset($this->options['salesgen_bmsm_enable'])? $this->options['salesgen_bmsm_enable'] : '';
			$discount_based = isset($this->options['salesgen_bmsm_conditional'])? $this->options['salesgen_bmsm_conditional'] : 'items';
			$hide_congrats = isset($this->options['salesgen_bmsm_hide_congrats'])? $this->options['salesgen_bmsm_hide_congrats'] : 'no';
			$hide_remain   = isset($this->options['salesgen_bmsm_hide_remain'])? $this->options['salesgen_bmsm_hide_remain'] : 'no';
			$bmsm_categories   = isset($this->options['salesgen_bmsm_categories'])? $this->options['salesgen_bmsm_categories'] : array();

			$bmsm_categories = empty($bmsm_categories)? array(): $bmsm_categories;

			$total_item = WC()->cart->get_cart_contents_count();

			$_bundles = WC()->session->get( 'sgupsellbundle' );

			$bundle_discount_amount_cfg = isset($this->options['salesgen_upsell_bundle_discount_amount'])? str_replace(array("\r", "\n", "\t"), '', $this->options['salesgen_upsell_bundle_discount_amount']) : '';

			$this->message = array();
			
			//if has discount bundle then disable buy more save more discount
			if ( 
				intval($bundle_discount_amount_cfg ) > 0 && 
				is_array( $_bundles ) && 
				count( $_bundles ) > 0 
			) {

				$prefix = get_option('salesgen_upsell_bundle_prefix');
				$prefix = (!empty($prefix)) ? $prefix : '[FBT]';
				$reason = 'Discount for bundle items';

				$_bundle_discount_amount = 0;
				$discount_type = 'fixed_cart';

				
				//is fixed amount
				if ( strpos($bundle_discount_amount_cfg, '$') !== false ) {
					$_bundle_discount_amount = floatval(str_replace('$', '', $bundle_discount_amount_cfg));
					$_bundle_discount_amount *= count($_bundles);
					
				} else {
					$_bundle_total_price = 0;

					foreach ($_bundles as $_bundle) {
						$_bundle_total_price += $_bundle['total'];
					}

					$_bundle_discount_amount = round(($_bundle_total_price * $bundle_discount_amount_cfg)/100 , 2);
				}


				if ( is_object( $cart_object) ) {
					// $cart_object->add_fee($prefix.'You Saved '. $reason, -1 * $_bundle_discount_amount, true, '');

					$bundle_discount = array(
						'amount' => $_bundle_discount_amount,
						'type' => $discount_type,
						'reason' => $reason
					);

					WC()->session->set( 'sg_bundle', $bundle_discount );
					
					if ( in_array( $this->bmsm_coupon, $coupons) )
						$cart_object->remove_coupon( $this->bmsm_coupon );

					if ( !in_array( $this->bundle_coupon, $coupons) )
						$cart_object->add_discount( $this->bundle_coupon );

				}
				
			} else if ( in_array( $this->bundle_coupon, $coupons) ) {
				$cart_object->remove_coupon( $this->bundle_coupon );
			}


			if( $enable != 'yes') return;

			if ( $allow_coupons != 'yes' ) {

				if ( count($coupons) > 1 && in_array( $this->bmsm_coupon, $coupons) ){
					if ( in_array( $this->bmsm_coupon, $coupons) ) {
						$cart_object->remove_coupon( $this->bmsm_coupon );
					}
					unset($coupons[ $this->bmsm_coupon ]);
				}
				
				if ( 
					count($coupons) > 0
				) {
					if ( is_cart()  && !in_array( $this->bmsm_coupon, $coupons) ) {
						wc_add_notice( '<div class="salesgen-discount-notices">' . sprintf(__( 'Congrats! You got discount from your coupon: <strong>%s</strong>. Buy More Save More discount automatically removed. ' ), implode(', ', $coupons)) . '</div>', 'notice' );
						return true;
					}
					
					
				}
			}

			$has_discount     = false;
			$discount_percent = 0;
			$discount_type    = 'percent';
			$discount_amount  = 0;
			$subtotal_excl_tax = 0;
			$total_item = WC()->cart->get_cart_contents_count();


			if ( count($bmsm_categories) > 0 ) {
				$total_item = 0;
				//get subtotal
				foreach( WC()->cart->get_cart() as $cart_item ) {

					$_product = $cart_item['data'];

					if ( is_object($_product) ) {

						$pid   = $_product->get_parent_id();

						if ( $pid == 0 ) $pid = $_product->get_id();

						$cats  = sg_get_product_category_slug($pid);
						$_cats = array_intersect($bmsm_categories, $cats);

						if ( count($_cats) > 0 ) {
							$total_item += $cart_item['quantity'];;
							$subtotal_excl_tax += $cart_item['line_subtotal'];
						}
					}

			    }
			}

			if ( $discount_based == 'items' ) {

				$by_items   = isset($this->options['salesgen_buy_more_by_items'])? $this->options['salesgen_buy_more_by_items'] : '';
				$congrats_text = isset($this->options['salesgen_bmsm_congrats_items'])? $this->options['salesgen_bmsm_congrats_items'] : '';

				$items      = ($by_items == '')? array('number_item' => array(), 'amount' => array()) : json_decode( urldecode($by_items), true );
				$ind        = 0;
				$values     = array();

				if ( empty($congrats_text) ) $congrats_text = 'Hooray! You got BIG discount [discount_amount] for [items_count] items in your cart!';

				foreach ( $items['number_item'] as $item ) {
					$value = $items['amount'][$ind];
					$ind++;
					$values['amount_' . $item] = $value;
				}

				$sale_amounts = isset($items['number_item'])? $items['number_item'] : array();


				rsort($sale_amounts);

				$select_amount = $sale_amounts[0];
				$_ind_samount  = 0;
				$_found_ind    = -1;

				foreach ( $sale_amounts as $amount ) {
					if( $amount <= $total_item) {
						$select_amount = $amount;
						$_found_ind    = $_ind_samount;
						$has_discount  = true;
						break;
					}
					$_ind_samount++;
				}

				$congrats         = false;
				$discount_percent = $values['amount_' . $select_amount];

				$is_fixed = false;

				if ( strpos($discount_percent, '$') !== false ) {
					$discount_amount  = floatval(trim($discount_percent, '$'));
					$discount_percent = wc_price($discount_amount);
					$discount_type = 'fixed_cart';
					$is_fixed = true;
				} else {
					$discount_amount  = $discount_percent;
					$discount_percent .= '% OFF ';
					$discount_type = 'percent';
				}

				$reason           = '(Discount '. $select_amount.(($select_amount >= 5)? '+':'') . ' items)';

				if ( $_found_ind > -1 ){
					$congrats = true;


					$class_pop = strtolower(wp_generate_password( 8, false, false ));

					//$message_html = '<div class="salesgen-discount-notices">' . sprintf( __( 'Congrats! You have %s items in your cart for <strong>%s%% OFF</strong> your purchase! Discount automatically added at checkout.' ) . '</div>', $total_item, $discount_percent);
					$message_html = '<div class="salesgen-discount-notices '.$class_pop.'">' . $congrats_text. '</div>';

					$message_html = str_replace( array('[items_count]', '[discount_amount]', '% OFF % OFF'), array($total_item, $discount_percent, '% OFF'), $message_html );
					
					if ( $is_fixed ) {
						$message_html = str_replace( array('% OFF'), array(''), $message_html );
					}


					if ( 
						!$this->showed_message &&
						is_cart() && 
						is_object( $cart_object) && 
						$hide_congrats != 'yes' 
					) {
						$this->showed_message = true;
						wc_add_notice( $message_html, 'notice' );	
					}
					if ( $hide_congrats != 'yes' ) $this->message[] = $message_html;
				}

				$_found_ind = ($_found_ind == -1) ? count($sale_amounts) - 1 : $_found_ind - 1;
				
				if ( $_found_ind >= 0 && $total_item < $sale_amounts[ $_found_ind ] ) {

				
					$remain_items = $sale_amounts[ $_found_ind ] - $total_item;
					$dis_per = $values['amount_' . $sale_amounts[ $_found_ind ] ];
					$class_warning = $congrats ? ' salesgen-closest-o' : ' salesgen-closest';
					$class_warning .= ' ' . strtolower(wp_generate_password( 8, false, false ));

					$is_next_fixed = false;

					if ( strpos($dis_per, '$') !== false ) {
						$next_discount_amount  = floatval(trim($dis_per, '$'));
						$dis_per = wc_price($next_discount_amount);
						$is_next_fixed = true;
					} else {
						$dis_per .= '% OFF ';
					}

					//say waring to inform customer to add more items to get % off
					$remain_text = isset($this->options['salesgen_bmsm_remain_items'])? $this->options['salesgen_bmsm_remain_items'] : '';

					if ( empty($remain_text) ) $remain_text = 'Just buy more [remain] & GET discount <strong>[discount_amount]</strong> on each products !';

					$message_html = '<div class="salesgen-discount-notices '.$class_warning.'">' . $remain_text . '</div>';

					$message_html = str_replace( array('[remain]', '[discount_amount]', '% OFF % OFF'), array($remain_items, $dis_per, '% OFF'), $message_html );
					
					if ( $is_next_fixed ) {
						$message_html = str_replace( array('% OFF'), array(''), $message_html );
					}

					if ( 
						!$this->showed_message_war &&
						is_cart() && 
						is_object( $cart_object) &&
						$hide_remain != 'yes'
					) {
						$this->showed_message_war = true;
						wc_add_notice( $message_html, 'notice' );
						$this->message[] = $message_html;
					}

					if ( $hide_remain != 'yes' ) $this->message[] = $message_html;
					

				}

				

			} else if ( $discount_based == 'subtotal' ){

				$congrats = false;
				

				//get subtotal
				if ( count($bmsm_categories) == 0 ) {
					foreach( WC()->cart->get_cart() as $cart_item ) {
				        $subtotal_excl_tax += $cart_item['line_subtotal'];
				    }
			    }

				$working_total  = $subtotal_excl_tax;
				$items          = isset($this->options['salesgen_buy_more_by_amounts'])? $this->options['salesgen_buy_more_by_amounts'] : '[]';
				$items          = json_decode(urldecode($items));
				$price_str      = '';
				$next_level_ind = 0;
				$discount_percent = '';

				for ( $i = 0; $i < count($items->discount_price); $i++ ) {
					$value = $items->discount_amount[$i];

					$min_price = $items->discount_price[$i];

					if ( empty($min_price) ) continue;

					if ( $min_price > 1 && $working_total >= $min_price ) {
						$next_level_ind = $i + 1;
						$discount_percent = $value;
						
						$price_str        = wc_price($min_price);
						$price_str        = strip_tags($price_str);
						$reason           = 'Discount with minimum purchase of '. $price_str;
						$has_discount     = true;

						if ( strpos($discount_percent, '$') !== false ) {
							$discount_amount  = floatval(trim($discount_percent, '$'));
							$discount_percent = wc_price($discount_amount);
							$discount_type = 'fixed_cart';
							$is_fixed = true;
						} else {
							$discount_amount  = $discount_percent;
							$discount_percent .= '% OFF ';
							$discount_type = 'percent';
						}

					}

				}

				if ( $discount_percent != '' ) {
					if ( $hide_congrats != 'yes' ) {
						$congrats = true;
						$congrats_text = isset($this->options['salesgen_bmsm_congrats_subtotal'])? $this->options['salesgen_bmsm_congrats_subtotal'] : '';

						if ( empty($congrats_text) ) $congrats_text = 'Hooray! You got BIG discount <strong>[discount_amount]% OFF</strong> on each products in your cart!';

						$message_html = '<div class="salesgen-discount-notices">' . $congrats_text . '</div>';

						$message_html = str_replace( array('[subtotal_min]', '[discount_amount]', '% OFF % OFF'), array($price_str, $discount_percent, '% OFF' ), $message_html );

						if ( $is_fixed ) {
							$message_html = str_replace( array('% OFF'), array(''), $message_html );
						}
						if ( 
							!$this->showed_message &&
							is_cart() 
						) {
							$this->showed_message = true;
							wc_add_notice( $message_html , 'notice' );	
						} else {
							$this->message[] = $message_html;
						}
					}
					
				}

				if ( 
					count($items->discount_price) > 0 && 
					isset( $items->discount_price[ $next_level_ind ]) && 
					$_SERVER['REQUEST_METHOD'] == 'GET' &&
					$hide_remain != 'yes'
				) {
					
					while ( empty($items->discount_price[ $next_level_ind ]) ) {
						$next_level_ind++;
					}

					$remain_amount = $items->discount_price[ $next_level_ind ] - $working_total;
					$remain_amount_text = wc_price($remain_amount);
					$class_warning = $congrats ? ' salesgen-closest-o' : ' salesgen-closest';
					$dis_per = $items->discount_amount[ $next_level_ind ];
					//say waring to inform customer to add more items to get % off
					$remain_text = isset($this->options['salesgen_bmsm_remain_subtotal'])? $this->options['salesgen_bmsm_remain_subtotal'] : '';

					if ( empty($remain_text)) $remain_text = 'Spend [remain] more and GET discount <strong>[discount_amount]% OFF</strong> on your order today!';

					$is_next_fixed = false;

					if ( strpos($dis_per, '$') !== false ) {
						$next_discount_amount  = floatval(trim($dis_per, '$'));
						$dis_per = wc_price($next_discount_amount);
						$is_next_fixed = true;
					} else {
						$dis_per .= '% OFF ';
					}

					$message_html = '<div class="salesgen-discount-notices '.$class_warning.'">' . $remain_text . '</div>';
					$message_html = str_replace( array('[remain]', '[discount_amount]', '% OFF % OFF'), array($remain_amount_text, $dis_per, '% OFF'), $message_html );

					if ( $is_next_fixed ) {
						$message_html = str_replace( array('% OFF'), array(''), $message_html );
					}

					if ( 
						!$this->showed_message_war &&
						is_object( $cart_object) 
					) {
						$this->showed_message_war = true;
						wc_add_notice( $message_html, 'notice' );
					}

					$this->message[] = $message_html;
			
				}


			}
			


			if ( $has_discount ) {	

				if ( is_object( $cart_object) ) {

					$bmsm_discount = array(
						'amount' => $discount_amount,
						'type' => $discount_type,
						'reason' => $reason
					);

					WC()->session->set( 'sg_bmsm', $bmsm_discount );
					
					if ( !in_array( $this->bmsm_coupon, $coupons) )
						$cart_object->add_discount( $this->bmsm_coupon );

				}
			} else {
				if ( in_array( $this->bmsm_coupon, $coupons) ) {
					$cart_object->remove_coupon( $this->bmsm_coupon );
				}
			}
			
		}

		function cart_item_removed( $cart_item_key, $cart ) {
			$product_id = $cart->removed_cart_contents[ $cart_item_key ]['product_id'];
			//check if product in bundle, remove the bundle
			$_bundles     = WC()->session->get( 'sgupsellbundle' );
			$_new_bundles = array();
			$_has_remove  = false;

			if ( is_array($_bundles) && count($_bundles) > 0 ) {
				foreach ( $_bundles as $_bundle ) {
					if ( in_array($product_id, $_bundle['items']) ) {
						$_has_remove = true;
						continue;
					}
					$_new_bundles[] = $_bundle;
				}
			}

			if ( $_has_remove ) {
				WC()->session->set( 'sgupsellbundle', $_new_bundles );
			}

			$total_item = WC()->cart->get_cart_contents_count();

			if ( $total_item < 1 ) WC()->session->set( 'sgupsellbundle', array() );
		}


		public function admin_coupon_label( $code = '' ) {
			if ( $_GET['action'] == 'edit' ) {
				switch ( $code ) {
					case $this->bmsm_coupon:
						$code = 'Buy More Save More Discount - Code: ' .  $this->bmsm_coupon;
						break;
					case $this->bundle_coupon:
						$code = 'Discount Bundle Product - Code:' .  $this->bundle_coupon;
						break;
					
				}	
			}
			

			return $code;
		}


		public function coupon_label( $label='', $coupon = null ) {
			try {
				if ( 
					isset(WC()->session) && 
					in_array( $coupon->code, array( $this->bmsm_coupon, $this->bundle_coupon) ) 
				) {
					
					switch ($coupon->code) {
						case $this->bmsm_coupon:
							$sgdata = WC()->session->get( 'sg_bmsm' );
							$saved = ($sgdata['type'] == 'percent'? $sgdata['amount'] . '%' : wc_price($sgdata['amount'] ) );
							return "You saved <strong>{$saved}</strong> " . $sgdata['reason'];
							break;
						case $this->bundle_coupon:
							return 'Discount Bundle Product';
							break;
						
					}
				}
			} catch (Exception $e) {
				return $label;
			}
			

			return $label;
		}

		public function get_shop_coupon_data( $sm, $data, $wcc) {
			
			if ( WC()->session && in_array( $data, array( $this->bmsm_coupon, $this->bundle_coupon ) ) ) {

				switch ( $data ) {
					case $this->bmsm_coupon:
						$sgdata          = WC()->session->get( 'sg_bmsm' );
						$discount_amount = $sgdata['amount'];
						$discount_type   = $sgdata['type'];
						break;
					case $this->bundle_coupon:
						$sgdata          = WC()->session->get( 'sg_bundle' );
						$discount_amount = $sgdata['amount'];
						$discount_type   = $sgdata['type'];
						break;
				}

				$cp_data = array(
					'code'                        => $data,
					'amount'                      => $discount_amount,
					'discount_type'               => $discount_type,
					'description'                 => 'UpsellBlast Discount',
					'usage_count'                 => 0,
					'individual_use'              => false,
					'usage_limit'                 => 0,
					'usage_limit_per_user'        => 0,
					'limit_usage_to_x_items'      => null,
					'free_shipping'               => false,
					'virtual'                     => true
				);

				return $cp_data;
				
			}
			return null;
			
		}

		public function icons( $json = false ) {

			$icons =  array(
				'thankyou'  => '<svg height="50pt" viewBox="0 0 512 512" width="50pt" xmlns="http://www.w3.org/2000/svg"><path d="m416.667969 0h-321.335938c-52.566406 0-95.332031 42.765625-95.332031 95.332031v264.53125c0 52.566407 42.765625 95.332031 95.332031 95.332031h97.648438l52.414062 52.410157c2.925781 2.929687 6.765625 4.394531 10.605469 4.394531 3.835938 0 7.675781-1.464844 10.605469-4.394531l52.410156-52.410157h97.648437c52.566407 0 95.332032-42.765624 95.332032-95.332031v-264.53125c.003906-52.566406-42.761719-95.332031-95.328125-95.332031zm65.332031 359.863281c0 36.023438-29.308594 65.332031-65.332031 65.332031h-103.863281c-3.976563 0-7.792969 1.582032-10.605469 4.394532l-46.199219 46.195312-46.199219-46.195312c-2.8125-2.816406-6.625-4.394532-10.605469-4.394532h-103.863281c-36.023437 0-65.332031-29.308593-65.332031-65.332031v-264.53125c0-36.023437 29.308594-65.332031 65.332031-65.332031h321.335938c36.023437 0 65.332031 29.308594 65.332031 65.332031zm0 0"/><path d="m137.859375 134.949219h-50.558594c-2.070312 0-3.75 1.679687-3.75 3.75v10.074219c0 2.070312 1.679688 3.75 3.75 3.75h16.023438v51.378906c0 2.074218 1.679687 3.75 3.75 3.75h11.011719c2.070312 0 3.75-1.675782 3.75-3.75v-51.378906h16.023437c2.070313 0 3.75-1.679688 3.75-3.75v-10.074219c0-2.070313-1.679687-3.75-3.75-3.75zm0 0"/><path d="m160.804688 207.652344c2.070312 0 3.75-1.675782 3.75-3.75v-22.929688h24.871093v22.929688c0 2.074218 1.679688 3.75 3.75 3.75h11.003907c2.074218 0 3.75-1.675782 3.75-3.75v-65.203125c0-2.070313-1.675782-3.75-3.75-3.75h-11.003907c-2.070312 0-3.75 1.679687-3.75 3.75v24.515625h-24.871093v-24.515625c0-2.070313-1.679688-3.75-3.75-3.75h-11.003907c-2.074219 0-3.75 1.679687-3.75 3.75v65.203125c0 2.074218 1.675781 3.75 3.75 3.75zm0 0"/><path d="m257.144531 137.1875c-.597656-1.359375-1.945312-2.238281-3.429687-2.238281h-11.753906c-1.484376 0-2.832032.878906-3.433594 2.238281l-28.730469 65.207031c-.511719 1.15625-.402344 2.496094.292969 3.558594.6875 1.0625 1.871094 1.703125 3.140625 1.703125h11.753906c1.484375 0 2.832031-.878906 3.429687-2.242188l5.546876-12.589843h27.753906l5.546875 12.589843c.597656 1.363282 1.945312 2.242188 3.429687 2.242188h11.753906.023438c2.070312 0 3.75-1.679688 3.75-3.75 0-.675781-.179688-1.304688-.488281-1.851562zm-3.210937 37.964844h-12.191406l6.097656-13.820313zm0 0"/><path d="m351.382812 134.949219h-11.011718c-2.070313 0-3.75 1.679687-3.75 3.75v37.765625l-31.160156-40.066406c-.707032-.914063-1.800782-1.449219-2.957032-1.449219h-11.011718c-2.070313 0-3.75 1.679687-3.75 3.75v65.207031c0 2.070312 1.679687 3.75 3.75 3.75h11.011718c2.070313 0 3.75-1.679688 3.75-3.75v-36.632812l30.222656 38.929687c.710938.917969 1.804688 1.453125 2.960938 1.453125h11.941406c2.070313 0 3.75-1.679688 3.75-3.75v-65.207031c.003906-2.070313-1.675781-3.75-3.746094-3.75zm0 0"/><path d="m402.949219 167.523438 24.140625-26.289063c1.007812-1.09375 1.269531-2.683594.671875-4.042969-.601563-1.363281-1.945313-2.242187-3.433594-2.242187h-13.992187c-1.039063 0-2.027344.429687-2.734376 1.183593l-23.367187 24.898438v-22.332031c0-2.070313-1.679687-3.75-3.75-3.75h-11.007813c-2.070312 0-3.75 1.679687-3.75 3.75v65.203125c0 2.074218 1.679688 3.75 3.75 3.75h11.007813c2.070313 0 3.75-1.675782 3.75-3.75v-16.808594l5.476563-5.90625 18.941406 24.984375c.710937.933594 1.816406 1.480469 2.988281 1.480469h13.058594c1.410156 0 2.703125-.789063 3.34375-2.042969.640625-1.257813.523437-2.765625-.304688-3.90625zm0 0"/><path d="m214.449219 248.808594c-.660157-1.1875-1.914063-1.921875-3.269531-1.921875h-12.035157c-1.316406 0-2.535156.691406-3.214843 1.820312l-14.601563 24.3125-14.601563-24.3125c-.679687-1.128906-1.898437-1.820312-3.214843-1.820312h-12.035157c-1.359374 0-2.609374.734375-3.273437 1.921875-.664063 1.183594-.632813 2.636718.078125 3.792968l23.699219 38.554688v24.6875c0 2.070312 1.679687 3.75 3.75 3.75h11.195312c2.070313 0 3.75-1.679688 3.75-3.75v-24.6875l23.695313-38.554688c.714844-1.160156.742187-2.609374.078125-3.792968zm0 0"/><path d="m247.464844 245.304688c-10.671875 0-19.777344 3.605468-27.0625 10.71875-7.308594 7.140624-11.015625 16.140624-11.015625 26.75 0 10.613281 3.707031 19.613281 11.015625 26.75 7.289062 7.117187 16.394531 10.722656 27.0625 10.722656 10.667968 0 19.769531-3.605469 27.058594-10.722656 7.3125-7.136719 11.019531-16.140626 11.019531-26.75 0-10.609376-3.707031-19.609376-11.019531-26.75-7.285157-7.113282-16.386719-10.71875-27.058594-10.71875zm0 57.367187c-5.457032 0-9.929688-1.886719-13.675782-5.761719-3.777343-3.910156-5.613281-8.53125-5.613281-14.136718 0-5.601563 1.835938-10.226563 5.613281-14.136719 3.746094-3.875 8.21875-5.761719 13.675782-5.761719 5.457031 0 9.929687 1.886719 13.671875 5.757812 3.78125 3.917969 5.621093 8.542969 5.621093 14.140626 0 5.601562-1.839843 10.226562-5.621093 14.136718-3.742188 3.875-8.210938 5.761719-13.671875 5.761719zm0 0"/><path d="m350.074219 246.886719h-11.007813c-2.070312 0-3.75 1.679687-3.75 3.75v36.101562c0 5.023438-1.203125 8.972657-3.574218 11.738281-2.257813 2.636719-5.292969 3.917969-9.28125 3.917969-3.984376 0-7.019532-1.28125-9.277344-3.917969-2.371094-2.765624-3.574219-6.714843-3.574219-11.738281v-36.101562c0-2.070313-1.679687-3.75-3.75-3.75h-11.007813c-2.074218 0-3.75 1.679687-3.75 3.75v36.566406c0 10.394531 2.980469 18.589844 8.863282 24.363281 5.859375 5.757813 13.429687 8.679688 22.496094 8.679688 9.066406 0 16.636718-2.921875 22.5-8.679688 5.882812-5.773437 8.863281-13.96875 8.863281-24.363281v-36.566406c0-2.070313-1.679688-3.75-3.75-3.75zm0 0"/></svg>',
				'thankful'  => '<svg height="368pt" viewBox="0 0 368 368" width="368pt" xmlns="http://www.w3.org/2000/svg"><path d="m328 0h-288c-22.054688 0-40 17.945312-40 40v224c0 22.054688 17.945312 40 40 40h24v56c0 3.230469 1.945312 6.160156 4.9375 7.390625.992188.417969 2.03125.609375 3.0625.609375 2.078125 0 4.128906-.816406 5.65625-2.34375l61.65625-61.65625h188.6875c22.054688 0 40-17.945312 40-40v-224c0-22.054688-17.945312-40-40-40zm24 264c0 13.230469-10.769531 24-24 24h-192c-2.128906 0-4.160156.839844-5.65625 2.34375l-50.34375 50.34375v-44.6875c0-4.425781-3.574219-8-8-8h-32c-13.230469 0-24-10.769531-24-24v-224c0-13.230469 10.769531-24 24-24h288c13.230469 0 24 10.769531 24 24zm0 0"/><path d="m136 144c4.425781 0 8-3.574219 8-8v-64c0-4.425781-3.574219-8-8-8s-8 3.574219-8 8v64c0 4.425781 3.574219 8 8 8zm0 0"/><path d="m232 144c4.425781 0 8-3.574219 8-8v-64c0-4.425781-3.574219-8-8-8s-8 3.574219-8 8v64c0 4.425781 3.574219 8 8 8zm0 0"/><path d="m296 160c-4.425781 0-8 3.574219-8 8 0 30.871094-25.128906 56-56 56h-96c-30.871094 0-56-25.128906-56-56 0-4.425781-3.574219-8-8-8s-8 3.574219-8 8c0 39.703125 32.296875 72 72 72h96c39.703125 0 72-32.296875 72-72 0-4.425781-3.574219-8-8-8zm0 0"/></svg>',
				'handshake' => '<svg id="Capa_1" enable-background="new 0 0 512.016 512.016" height="512" viewBox="0 0 512.016 512.016" width="512" xmlns="http://www.w3.org/2000/svg"><g id="XMLID_1321_"><g id="XMLID_396_"><path id="XMLID_429_" d="m508.803 192.482-13.337-23.101c-2.761-4.782-8.873-6.421-13.66-3.66-4.783 2.761-6.422 8.877-3.66 13.66l13.337 23.101c.704 1.218.547 2.378.391 2.961s-.601 1.667-1.819 2.37l-35.268 20.362c-1.866 1.074-4.256.433-5.332-1.429l-70.95-122.886c-1.076-1.864-.435-4.256 1.429-5.333l35.267-20.361c1.864-1.074 4.258-.436 5.333 1.428l12.612 21.845c2.762 4.784 8.878 6.423 13.66 3.66 4.783-2.761 6.422-8.877 3.66-13.66l-12.612-21.845c-6.589-11.413-21.235-15.34-32.652-8.749l-35.268 20.362c-5.358 3.094-9.065 7.963-10.81 13.439h-99.98c-14.037 0-27.234 5.466-37.161 15.392l-10.244 10.244c-8.982-2.141-18.184-3.242-27.438-3.242h-31.044c-1.551-5.991-5.404-11.383-11.174-14.715l-35.268-20.362c-5.53-3.193-11.974-4.04-18.139-2.388-6.167 1.652-11.322 5.608-14.514 11.137l-70.949 122.887c-3.192 5.529-4.041 11.971-2.389 18.139s5.608 11.322 11.138 14.514l35.268 20.362c3.755 2.168 7.858 3.198 11.911 3.198 1.477 0 2.946-.143 4.39-.411l28.866 28.867c-.442 2.269-.671 4.596-.671 6.96 0 9.609 3.742 18.644 10.537 25.438 6.506 6.505 14.904 9.988 23.439 10.459-.131 1.254-.202 2.52-.202 3.798 0 9.61 3.742 18.644 10.537 25.438 6.795 6.795 15.829 10.537 25.438 10.537.261 0 .519-.013.779-.019-.006.26-.019.518-.019.779 0 9.61 3.742 18.644 10.537 25.438 6.795 6.795 15.829 10.537 25.438 10.537.261 0 .519-.013.779-.019-.006.26-.019.518-.019.779 0 9.609 3.742 18.644 10.537 25.438s15.829 10.537 25.438 10.537 18.644-3.742 25.438-10.537l14.226-14.225c4.171-4.171 7.091-9.123 8.782-14.387 6.32 4.664 13.83 6.997 21.343 6.996 9.211-.001 18.426-3.507 25.438-10.52 4.196-4.196 7.223-9.247 8.929-14.758 5.789 3.785 12.551 5.821 19.629 5.821 9.609 0 18.644-3.742 25.438-10.537 5.049-5.05 8.409-11.336 9.804-18.176 3.612 1.196 7.428 1.827 11.343 1.827 9.609 0 18.645-3.742 25.439-10.538 14.026-14.027 14.026-36.85 0-50.877l-23.34-23.34 42.603-42.603c.946.113 1.899.177 2.856.177 4.053 0 8.157-1.03 11.911-3.197l35.268-20.361c5.529-3.193 9.485-8.347 11.138-14.515s.805-12.607-2.387-18.136zm-486.842 36.45c-1.218-.703-1.662-1.786-1.818-2.37-.156-.583-.313-1.743.391-2.962l70.949-122.888c.703-1.218 1.787-1.662 2.37-1.818.249-.066.603-.133 1.021-.133.563 0 1.242.121 1.94.523l35.268 20.362c1.863 1.076 2.505 3.468 1.429 5.332l-70.949 122.887c-1.077 1.863-3.467 2.505-5.332 1.429zm89.765 76.295c0-4.268 1.662-8.279 4.68-11.297l8.63-8.63c3.114-3.115 7.205-4.672 11.297-4.672 4.09 0 8.182 1.558 11.296 4.672 3.018 3.018 4.68 7.029 4.68 11.296s-1.662 8.279-4.68 11.296l-8.63 8.63c-6.229 6.23-16.364 6.229-22.593 0-3.018-3.016-4.68-7.028-4.68-11.295zm49.75 55.671c-4.268 0-8.279-1.662-11.296-4.679-3.018-3.017-4.68-7.029-4.68-11.296s1.662-8.279 4.68-11.296l14.225-14.225c3.114-3.114 7.205-4.671 11.296-4.671 4.092 0 8.183 1.557 11.297 4.671 3.018 3.017 4.68 7.029 4.68 11.296s-1.662 8.279-4.68 11.296l-14.225 14.225c-3.018 3.018-7.03 4.679-11.297 4.679zm36.735 36.736c-4.268 0-8.279-1.662-11.296-4.679-3.018-3.017-4.68-7.029-4.68-11.296s1.662-8.279 4.68-11.297l14.225-14.225c3.114-3.114 7.205-4.671 11.296-4.671s8.183 1.557 11.297 4.672c3.018 3.017 4.68 7.029 4.68 11.296s-1.662 8.279-4.68 11.296l-14.225 14.225c-3.017 3.017-7.029 4.679-11.297 4.679zm62.257 17.831-14.226 14.226c-3.017 3.017-7.028 4.679-11.296 4.679s-8.279-1.662-11.296-4.679c-3.018-3.018-4.68-7.029-4.68-11.296 0-4.268 1.662-8.279 4.68-11.297l14.225-14.225c3.114-3.115 7.205-4.672 11.297-4.672 4.09 0 8.182 1.558 11.296 4.671 6.229 6.228 6.229 16.364 0 22.593zm156.146-64.271c-3.018 3.018-7.029 4.68-11.297 4.68-4.267 0-8.278-1.662-11.296-4.68l-95.45-95.45c-3.905-3.904-10.235-3.905-14.143 0-3.905 3.905-3.905 10.237 0 14.142l85.6 85.601c3.018 3.017 4.68 7.029 4.68 11.296s-1.662 8.279-4.68 11.297c-3.017 3.017-7.028 4.679-11.296 4.679s-8.279-1.662-11.296-4.679l-102.861-102.861c-3.905-3.904-10.237-3.904-14.143 0-3.905 3.905-3.905 10.237 0 14.142l85.6 85.601c3.018 3.017 4.68 7.029 4.68 11.296s-1.662 8.279-4.68 11.296c-6.228 6.229-16.363 6.231-22.593 0l-18.826-18.826c-.026-.026-.055-.048-.081-.073-7.202-7.159-16.702-10.628-26.138-10.425.006-.265.019-.529.019-.796 0-9.609-3.742-18.644-10.537-25.439-7.211-7.211-16.747-10.704-26.218-10.501.006-.265.019-.529.019-.795 0-9.61-3.742-18.644-10.537-25.439-7.886-7.886-18.553-11.337-28.873-10.356-.413-8.973-4.102-17.351-10.496-23.745-14.027-14.027-36.851-14.024-50.878 0l-8.63 8.63c-.01.01-.02.021-.03.031l-22.206-22.206 69.613-120.574h34.66c3.396 0 6.783.18 10.151.53l-11.431 11.431c-6.795 6.795-10.537 15.83-10.537 25.439 0 9.61 3.742 18.644 10.537 25.439 7.014 7.013 16.227 10.52 25.438 10.52 9.213 0 18.426-3.506 25.439-10.52l26.996-26.996 155.72 155.719c6.229 6.228 6.229 16.364.001 22.592zm-96.078-146.955c14.552-10.532 23.472-27.528 23.472-45.993 0-5.523-4.478-10-10-10s-10 4.477-10 10c0 13.063-6.9 24.978-17.909 31.557l-38.088-38.088c-3.906-3.905-10.227-4.007-14.133-.102l-34.123 34.123c-6.229 6.229-16.364 6.228-22.593 0-3.018-3.017-4.68-7.029-4.68-11.296s1.662-8.279 4.68-11.297l38.963-38.963c6.148-6.148 14.323-9.534 23.019-9.534h102.495l70.495 122.102c.167.289.349.564.526.843l-39.386 39.386z"/><path id="XMLID_436_" d="m464.308 145.414c2.63 0 5.2-1.07 7.07-2.93 1.859-1.87 2.93-4.44 2.93-7.07 0-2.64-1.07-5.21-2.93-7.08-1.87-1.86-4.44-2.92-7.07-2.92-2.64 0-5.21 1.06-7.07 2.92-1.87 1.87-2.93 4.44-2.93 7.08 0 2.63 1.06 5.2 2.93 7.07 1.86 1.861 4.43 2.93 7.07 2.93z"/></g></g></svg>',
				'badges1'   => '<svg id="Layer_1" enable-background="new 0 0 512.002 512.002" height="512" viewBox="0 0 512.002 512.002" width="512" xmlns="http://www.w3.org/2000/svg"><g><g><path d="m303.036 61.58c-5.377-1.295-10.771 2.01-12.065 7.378-1.294 5.369 2.009 10.771 7.378 12.065 81.048 19.541 137.652 91.495 137.652 174.979 0 99.252-80.748 179.999-180 179.999s-180-80.747-180-179.999c0-83.486 56.607-155.44 137.659-174.979 5.369-1.294 8.672-6.696 7.378-12.065-1.294-5.368-6.692-8.673-12.065-7.378-42.882 10.338-81.732 35.124-109.395 69.794-28.509 35.729-43.577 78.826-43.577 124.629 0 110.28 89.72 199.999 200 199.999s200-89.719 200-199.999c0-45.802-15.067-88.896-43.574-124.626-27.661-34.671-66.511-59.459-109.391-69.797z"/><path d="m505.974 231.947-11.698-21.826 1.952-26.984c1.874-17.297-5.025-34.175-18.479-45.184l-19.42-15.902-7.639-23.012c-4.278-17.595-17.642-31.736-34.979-36.973l-23.971-7.242-18.358-21.221c-10.863-12.777-27.305-19.421-43.982-17.785l-24.881 2.479-24.456-12.268c-15.072-8.034-33.042-8.04-48.118-.001l-21.825 11.698-26.983-1.951c-17.296-1.883-34.176 5.024-45.185 18.479l-15.902 19.42-23.012 7.639c-17.595 4.277-31.736 17.64-36.974 34.977l-7.24 23.971-21.223 18.359c-12.775 10.864-19.424 27.302-17.783 43.982l2.479 24.88-12.268 24.458c-8.035 15.071-8.042 33.041-.002 48.115l11.698 21.827-1.951 26.983c-1.876 17.295 5.023 34.174 18.479 45.184l19.42 15.901 7.639 23.014c4.278 17.595 17.641 31.736 34.979 36.974l23.971 7.24 18.358 21.221c10.862 12.776 27.297 19.42 43.983 17.785l24.879-2.48 24.455 12.268c7.539 4.021 15.801 6.031 24.065 6.03 8.258 0 16.518-2.008 24.053-6.027l21.827-11.698 26.981 1.951c17.296 1.879 34.178-5.021 45.186-18.478l15.902-19.421 23.013-7.639c17.595-4.276 31.735-17.64 36.974-34.979l7.24-23.97 21.221-18.358c12.776-10.863 19.426-27.301 17.785-43.983l-2.479-24.879 12.267-24.455c8.037-15.072 8.044-33.042.002-48.119zm-17.693 38.788c-.044.081-.087.163-.128.246l-13.626 27.164c-.849 1.692-1.2 3.591-1.013 5.475l2.766 27.75c.998 10.148-3.053 20.158-10.902 26.832l-23.478 20.311c-1.432 1.238-2.482 2.858-3.03 4.671l-8.079 26.744c-3.221 10.665-11.972 18.863-22.838 21.396-.297.069-.591.152-.88.248l-26.173 8.688c-1.797.597-3.388 1.691-4.587 3.155l-17.742 21.667c-6.737 8.234-17.086 12.444-27.679 11.248-.132-.015-.265-.027-.396-.036l-30.063-2.174c-1.896-.141-3.776.265-5.445 1.16l-24.363 13.058c-9.189 4.898-20.164 4.878-29.357-.056-.081-.044-.163-.087-.245-.128l-27.164-13.627c-1.396-.7-2.932-1.062-4.484-1.062-.33 0-.661.017-.992.049l-27.75 2.767c-10.135.992-20.156-3.053-26.831-10.902l-20.312-23.478c-1.238-1.432-2.858-2.482-4.671-3.03l-26.745-8.079c-10.664-3.221-18.862-11.972-21.396-22.838-.069-.297-.152-.591-.248-.88l-8.688-26.174c-.597-1.797-1.69-3.387-3.155-4.587l-21.666-17.74c-8.235-6.739-12.441-17.087-11.249-27.68.015-.132.027-.265.036-.396l2.174-30.063c.137-1.889-.266-3.777-1.16-5.445l-13.058-24.363c-4.9-9.188-4.879-20.162.057-29.356.043-.081.086-.163.127-.246l13.626-27.165c.849-1.692 1.2-3.591 1.013-5.475l-2.765-27.751c-.998-10.147 3.053-20.157 10.9-26.832l23.478-20.311c1.433-1.238 2.483-2.858 3.031-4.671l8.079-26.745c3.221-10.664 11.972-18.862 22.838-21.396.297-.069.591-.152.88-.248l26.173-8.688c1.797-.597 3.388-1.691 4.587-3.155l17.741-21.666c6.738-8.235 17.086-12.444 27.68-11.249.132.015.265.027.396.036l30.063 2.174c1.892.134 3.777-.265 5.446-1.16l24.361-13.058c9.187-4.9 20.162-4.88 29.358.056.081.043.162.086.244.127l27.164 13.627c1.693.85 3.594 1.196 5.476 1.013l27.752-2.766c10.141-.993 20.157 3.053 26.831 10.902l20.312 23.478c1.238 1.432 2.858 2.482 4.67 3.029l26.745 8.081c10.665 3.221 18.863 11.972 21.396 22.838.069.297.152.591.248.88l8.688 26.173c.597 1.797 1.691 3.388 3.155 4.587l21.666 17.74c8.235 6.738 12.44 17.087 11.249 27.682-.015.132-.027.264-.036.396l-2.175 30.062c-.137 1.889.266 3.777 1.16 5.445l13.059 24.364c4.901 9.187 4.88 20.161-.056 29.357z"/><path d="m170.775 161.193-41.347 62.524c-5.18 7.822-4.482 18.165 1.676 25.133l110.178 125.328c3.748 4.249 9.1 6.688 14.684 6.693h.016c5.565 0 10.905-2.417 14.661-6.634 24.841-27.394 49.703-55.968 73.749-83.603 11.956-13.741 24.319-27.95 36.471-41.771 6.402-7.258 6.881-18.089 1.191-25.896l-41.584-62.884c-3.705-5.599-9.829-8.945-16.394-8.953h-136.174c-7.049.001-13.564 3.843-17.127 10.063zm31.484 83.981 31.238 89.856-78.994-89.856zm71.951-74.043 15.199 54.043h-66.839l15.198-54.043zm14.335 74.043-32.556 93.646-32.556-93.646zm40.759 32.332c-16.74 19.238-33.878 38.927-51.104 58.333l31.519-90.665h47.776c-9.459 10.805-18.946 21.707-28.191 32.332zm30.231-52.332h-49.351l-15.198-54.043h28.811zm-171.403-54.043h28.86l-15.198 54.043h-49.351l35.221-53.262c.165-.248.317-.504.459-.766.003-.005.006-.01.009-.015z"/><path d="m256.008 76.001c5.522 0 10-4.478 10-10s-4.478-10-10-10h-.007c-5.522 0-9.996 4.478-9.996 10s4.48 10 10.003 10z"/></g></g></svg>',
				'badges2'   => '<?xml version="1.0"?><svg xmlns="http://www.w3.org/2000/svg" id="Icons" viewBox="0 0 74 74" width="512" height="512"><path d="M45.275,72a10.712,10.712,0,0,1-4.5-1.491A9.712,9.712,0,0,0,37,69.187a9.708,9.708,0,0,0-3.774,1.323c-1.825.909-3.711,1.848-5.566,1.354-1.931-.517-3.118-2.317-4.266-4.059a9.441,9.441,0,0,0-2.488-2.925,9.566,9.566,0,0,0-3.842-.719c-2.061-.127-4.192-.258-5.579-1.645S9.966,59,9.839,56.938A9.557,9.557,0,0,0,9.12,53.1a9.446,9.446,0,0,0-2.925-2.489c-1.741-1.148-3.542-2.335-4.059-4.266-.5-1.853.445-3.74,1.354-5.565A9.712,9.712,0,0,0,4.813,37,9.708,9.708,0,0,0,3.49,33.226c-.909-1.826-1.85-3.713-1.354-5.566.517-1.931,2.317-3.118,4.059-4.266A9.441,9.441,0,0,0,9.12,20.905a9.566,9.566,0,0,0,.719-3.842c.127-2.061.258-4.192,1.645-5.579S15,9.966,17.062,9.839A9.557,9.557,0,0,0,20.9,9.12a9.446,9.446,0,0,0,2.489-2.925c1.148-1.741,2.335-3.542,4.266-4.059,1.851-.493,3.74.445,5.565,1.354A9.712,9.712,0,0,0,37,4.813,9.708,9.708,0,0,0,40.774,3.49c1.826-.909,3.712-1.847,5.566-1.354,1.931.517,3.118,2.317,4.266,4.059A9.441,9.441,0,0,0,53.095,9.12a9.566,9.566,0,0,0,3.842.719c2.061.127,4.192.258,5.579,1.645S64.034,15,64.161,17.062A9.557,9.557,0,0,0,64.88,20.9a9.446,9.446,0,0,0,2.925,2.489c1.741,1.148,3.542,2.335,4.059,4.266.5,1.853-.445,3.74-1.354,5.565A9.712,9.712,0,0,0,69.187,37a9.708,9.708,0,0,0,1.323,3.774c.909,1.826,1.85,3.713,1.354,5.566-.517,1.931-2.317,3.118-4.059,4.266a9.441,9.441,0,0,0-2.925,2.488,9.566,9.566,0,0,0-.719,3.842c-.127,2.061-.258,4.192-1.645,5.579S59,64.034,56.938,64.161a9.557,9.557,0,0,0-3.842.719,9.446,9.446,0,0,0-2.489,2.925c-1.148,1.741-2.335,3.542-4.266,4.059A4.121,4.121,0,0,1,45.275,72ZM28.729,4a2.113,2.113,0,0,0-.552.069c-1.2.319-2.171,1.8-3.113,3.227a10.7,10.7,0,0,1-3.157,3.556,10.834,10.834,0,0,1-4.721.984c-1.768.109-3.437.212-4.288,1.063s-.954,2.521-1.063,4.288a10.832,10.832,0,0,1-.983,4.721A10.692,10.692,0,0,1,7.3,25.063c-1.43.942-2.908,1.917-3.227,3.113-.3,1.122.435,2.6,1.212,4.157A11,11,0,0,1,6.813,37,11,11,0,0,1,5.28,41.667C4.5,43.228,3.769,44.7,4.068,45.824c.319,1.2,1.8,2.171,3.227,3.113a10.7,10.7,0,0,1,3.556,3.157,10.834,10.834,0,0,1,.984,4.721c.109,1.768.212,3.437,1.063,4.288s2.521.954,4.288,1.063a10.832,10.832,0,0,1,4.721.983A10.692,10.692,0,0,1,25.063,66.7c.942,1.43,1.917,2.908,3.113,3.227,1.124.3,2.6-.435,4.157-1.212A11,11,0,0,1,37,67.187a11,11,0,0,1,4.667,1.533c1.562.778,3.037,1.515,4.157,1.212,1.2-.319,2.171-1.8,3.113-3.227a10.7,10.7,0,0,1,3.157-3.556,10.834,10.834,0,0,1,4.721-.984c1.768-.109,3.437-.212,4.288-1.063s.954-2.521,1.063-4.288a10.832,10.832,0,0,1,.983-4.721A10.692,10.692,0,0,1,66.7,48.937c1.43-.942,2.908-1.917,3.227-3.113.3-1.122-.435-2.6-1.212-4.157A11,11,0,0,1,67.187,37a11,11,0,0,1,1.533-4.667c.777-1.562,1.512-3.036,1.212-4.157-.319-1.2-1.8-2.171-3.227-3.113a10.7,10.7,0,0,1-3.556-3.157,10.834,10.834,0,0,1-.984-4.721c-.109-1.768-.212-3.437-1.063-4.288s-2.521-.954-4.288-1.063a10.832,10.832,0,0,1-4.721-.983A10.692,10.692,0,0,1,48.937,7.3c-.942-1.43-1.917-2.908-3.113-3.227-1.121-.3-2.6.435-4.157,1.212A11,11,0,0,1,37,6.813,11,11,0,0,1,32.333,5.28,9.341,9.341,0,0,0,28.729,4Z"/><path d="M37,61A24,24,0,1,1,61,37,24.027,24.027,0,0,1,37,61Zm0-46A22,22,0,1,0,59,37,22.025,22.025,0,0,0,37,15Z"/><path d="M27.334,48.14a1,1,0,0,1-.708-1.707L46.35,26.7a1,1,0,1,1,1.415,1.414L28.042,47.847A1,1,0,0,1,27.334,48.14Z"/><path d="M43.417,48.076a4.64,4.64,0,1,1,4.64-4.64A4.645,4.645,0,0,1,43.417,48.076Zm0-7.28a2.64,2.64,0,1,0,2.64,2.64A2.643,2.643,0,0,0,43.417,40.8Z"/><path d="M30.583,35.14a4.64,4.64,0,1,1,4.64-4.64A4.645,4.645,0,0,1,30.583,35.14Zm0-7.28a2.64,2.64,0,1,0,2.64,2.64A2.643,2.643,0,0,0,30.583,27.86Z"/></svg>',
				'badges3'   => '<?xml version="1.0" encoding="iso-8859-1"?><svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 503.52 503.52" style="enable-background:new 0 0 503.52 503.52;" xml:space="preserve"><g><g><g><path d="M344.56,121.456c-9.666-6.892-20.065-12.692-31.008-17.296l-12.368,29.504c8.743,3.685,17.055,8.321,24.784,13.824L344.56,121.456z"/><path d="M391.584,173.952c-5.776-10.333-12.683-19.992-20.592-28.8l-23.84,21.344c6.329,7.079,11.861,14.832,16.496,23.12L391.584,173.952z"/><path d="M374.608,215.664c19.829,67.744-19.013,138.736-86.757,158.565c-67.744,19.829-138.736-19.013-158.565-86.757c-19.829-67.744,19.013-138.736,86.757-158.565c18.821-5.509,38.657-6.613,57.973-3.227l5.52-31.536c-9.174-1.582-18.466-2.38-27.776-2.384c-88.268,0.114-159.731,71.762-159.617,160.031s71.762,159.731,160.031,159.617c88.268-0.114,159.731-71.762,159.617-160.031c-0.02-15.12-2.185-30.161-6.431-44.673L374.608,215.664z"/><path d="M503.52,251.76l-40.992-56.48l7.28-69.408l-63.744-28.416l-28.416-63.744l-69.408,7.28L251.76,0l-56.48,40.992l-69.408-7.28L97.456,97.456l-63.744,28.416l7.28,69.408L0,251.76l40.992,56.48l-7.28,69.408l63.744,28.416l28.416,63.744l69.408-7.28l56.48,40.992l56.48-40.992l69.408,7.28l28.416-63.744l63.744-28.416l-7.28-69.408L503.52,251.76z M381.808,381.808l-24,53.744l-58.432-6.192L251.76,464l-47.616-34.64l-58.496,6.128l-24-53.744l-53.744-24l6.256-58.368L39.52,251.76l34.64-47.616l-6.192-58.496l53.744-24l24-53.744l58.496,6.128L251.76,39.52l47.616,34.64l58.496-6.128l24,53.744l53.744,24l-6.256,58.368L464,251.76l-34.64,47.616l6.128,58.496L381.808,381.808z"/><polygon points="183.072,240.448 160.448,263.072 219.76,322.384 327.072,215.072 304.448,192.448 219.76,277.136 "/></g></g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>',
			);

			return $json? rawurlencode(json_encode($icons)) : $icons;
		}

		public function get_icon( $index ) {
			$icons = $this->icons();

			foreach( $icons as $key => $icon) {
				if ( $key == $index ) return $icon;
			}

			return '';
		}
	}
}