<?php

if (!defined('ABSPATH')) {
	exit;
}
if ( ! class_exists( 'SG_WCPA_Form' ) && class_exists('WCPA_Form')  ) {
	/**
	 * Class WCPA_Form
	 */
	class SG_WCPA_Form extends WCPA_Form
	{
		public $_token;
		public $settings = array();
		/**
		 * Constructor function
		 */
		private $cart_error = false;
		public $data = null;
		private $relations = array();
		private $price_depends = array();
		private $label_depends = array();
		public  $product = false;
		private $tax_per_unit = false;
		private $conversion_unit = [false, false];
		private $submited_data = array();
		private $has_custom_fields = false;

		public function __construct()
		{
			$this->_token = WCPA_TOKEN;
			$custom_fields = wcpa_get_option('product_custom_fields');
			if (is_array($custom_fields) && !empty($custom_fields)) {
				$this->has_custom_fields = true;
			}
		}

		public function get_form($form_id = false)
		{
			$this->data = array();
			if ($form_id) {
				$json_string = get_post_meta($form_id, WCPA_FORM_META_KEY, true);

				$this->data = json_decode($json_string);
			} else {
				$post_ids = get_posts(array('post_type' => WCPA_POST_TYPE, 'fields' => 'ids', 'posts_per_page' => -1));
				foreach ($post_ids as $id) {
					$json_string = get_post_meta($id, WCPA_FORM_META_KEY, true);
					$json_encoded = json_decode($json_string);
					if ($json_encoded && is_array($json_encoded)) {
						$this->data = array_unique(array_merge($this->data, $json_encoded));
					}
				}
			}
		}

		/*
		public function get_forms_by_product($product_id = false) {
			parent::get_forms_by_product($product_id);
		}
		*/

		public function set_product($product)
		{
			if (is_object($product)) {
				$this->product = $product;
			} else {
				$this->product = wc_get_product($product);
			}
		}

		public function get_forms_by_product($product_id = false)
		{


			if (($this->data === null || empty($this->data)) && $product_id) {
				$this->data = array();
				$this->cart_error = WCPA_Front_End::get_cart_error($product_id);

				$post_ids = $this->get_form_ids($product_id);
				$prod = wc_get_product($product_id);
				$pric_overide_base_price = false;
				$pric_overide_base_price_if_gt_zero = false;
				$pric_overide_base_price_fully = false;
				$pric_cal_option_once = false;
				$pric_use_as_fee = false;
				$render_after_acb = false;
				$render_before_acb = false;

				$enable_recaptcha = false;

				$bind_quantity = false;
				$quantity_bind_formula = false;


				if (wcpa_get_option('form_loading_order_by_date') === true) {

					if (is_array($post_ids) && count($post_ids)) {
						$post_ids = get_posts(array(
							'posts_per_page' => -1,
							'include' => $post_ids,
							'fields' => 'ids',
							'post_type' => WCPA_POST_TYPE,
							'posts_per_page' => -1
						));
					}
				}

				$post_ids = $this->re_order_forms($post_ids, $product_id);

				//print_r($post_ids);

				foreach ($post_ids as $id) {
					if (get_post_status($id) == 'publish') {

						$json_string = get_post_meta($id, WCPA_FORM_META_KEY, true);

						$json_encoded = json_decode($json_string);


						if ($pric_cal_option_once === false) {
							$pric_cal_option_once = wcpa_get_post_meta($id, 'pric_cal_option_once', false);
						}
						if ($enable_recaptcha === false) {
							$enable_recaptcha = wcpa_get_post_meta($id, 'enable_recaptcha', false);
						}

						if ($pric_use_as_fee === false) {
							$pric_use_as_fee = wcpa_get_post_meta($id, 'pric_use_as_fee', false);
						}

						if ($pric_overide_base_price === false) {
							$pric_overide_base_price = wcpa_get_post_meta($id, 'pric_overide_base_price', false);
							if ($pric_overide_base_price === '') {
								$pric_overide_base_price = false;
							} else if ($pric_overide_base_price === '1') {
								$pric_overide_base_price = true;
							}
						}
						if ($pric_overide_base_price_if_gt_zero === false) {
							$pric_overide_base_price_if_gt_zero = wcpa_get_post_meta($id, 'pric_overide_base_price_if_gt_zero', false);
							if ($pric_overide_base_price_if_gt_zero === '') {
								$pric_overide_base_price_if_gt_zero = false;
							} else if ($pric_overide_base_price_if_gt_zero === '1') {
								$pric_overide_base_price_if_gt_zero = true;
							}

						}

						if ($pric_overide_base_price_fully === false) {
							$pric_overide_base_price_fully = wcpa_get_post_meta($id, 'pric_overide_base_price_fully', false);
							if ($pric_overide_base_price_fully === '') {
								$pric_overide_base_price_fully = false;
							} else if ($pric_overide_base_price_fully === '1') {
								$pric_overide_base_price_fully = true;
							}


						}


						if ($render_after_acb === false) {
							$render_after_acb = wcpa_get_post_meta($id, 'render_after_acb', false);
						}


						if ($bind_quantity === false) {
							$bind_quantity = wcpa_get_post_meta($id, 'bind_quantity', false);
							if ($bind_quantity) {
								$quantity_bind_formula = wcpa_get_post_meta($id, 'quantity_bind_formula', false);
								if (empty($quantity_bind_formula) || trim($quantity_bind_formula) == '') {
									$bind_quantity = false;
								}
							}
						}

						$cont_global = wcpa_get_post_meta($id, 'cont_use_global', true);
						$form_rules = [
							'pric_cal_option_once' => wcpa_get_post_meta($id, 'pric_cal_option_once', false),
							'exclude_from_discount' => wcpa_get_post_meta($id, 'exclude_from_discount', false),
							'pric_use_as_fee' => wcpa_get_post_meta($id, 'pric_use_as_fee', false),
							'fee_label' => ($cont_global ? wcpa_get_option('fee_label', 'Fee', true) : wcpa_get_post_meta($id, 'fee_label', wcpa_get_option('fee_label', 'Fee'))),
							'render_after_acb' => wcpa_get_post_meta($id, 'render_after_acb', false),
							'disp_hide_options_price' => wcpa_get_post_meta($id, 'disp_hide_options_price', false),
						];


						if ($json_encoded && is_array($json_encoded)) {
							// check for external forms

							$json_encoded = $this->appendGlobalForm($json_encoded);

							foreach ($json_encoded as $_k => $v) {

								if ($this->has_custom_fields) {
									if (isset($v->label)) {
										$v->label = $this->replace_custom_field($v->label, $prod);
									}
									if (isset($v->value)) {
										$v->value = $this->replace_custom_field($v->value, $prod);
									}
									if (isset($v->placeholder)) {
										$v->placeholder = $this->replace_custom_field($v->placeholder, $prod);
									}
									if (isset($v->description)) {
										$v->description = $this->replace_custom_field($v->description, $prod);
									}
									if (isset($v->price)) {
										$v->price = $this->replace_custom_field($v->price, $prod);
									}
									if (isset($v->values) && is_array($v->values)) {
										foreach ($v->values as $e) {
											if (isset($e->label)) {
												$e->label = $this->replace_custom_field($e->label, $prod);
											}
											if (isset($e->value)) {
												$e->value = $this->replace_custom_field($e->value, $prod);
											}
											if (isset($e->price)) {
												$e->price = $this->replace_custom_field($e->price, $prod);
											}
										}
									}
								}

								if (isset($v->enableCl) && $v->enableCl && isset($v->relations) && is_array($v->relations)) {

									foreach ($v->relations as $val) {

										foreach ($val->rules as $k) {
											if (!empty($k->rules->cl_field)) {
												if (!isset($this->relations[$k->rules->cl_field])) {
													$this->relations[$k->rules->cl_field] = array();
												}
												if ($this->has_custom_fields && isset($k->rules->cl_val) && !empty($k->rules->cl_val)) {
													if (is_string($k->rules->cl_val)) {
														$k->rules->cl_val = $this->replace_custom_field($k->rules->cl_val, $prod);
													} else {
														if (isset($k->rules->cl_val->value) && is_string($k->rules->cl_val->value)) {
															$k->rules->cl_val->value = $this->replace_custom_field($k->rules->cl_val->value, $prod);
														}

													}

												}
												if ($k->rules->cl_field === 'attribute' && $k->rules->cl_relation) {
													$atr = wc_get_attribute($k->rules->cl_relation);
													if($atr){
														$term = get_term_by('id', $k->rules->cl_val->value, $atr->slug);
														$k->rules->cl_val = isset($term->slug) ? $term->slug : '';
														$k->rules->cl_relation = sanitize_title($atr->slug);
													}
												}
												$this->relations[$k->rules->cl_field][] = (isset($v->elementId) ? $v->elementId : false);
											}
										}
									}
								}
								if ($pric_use_as_fee === false) {
									if (isset($v->enablePrice) && $v->enablePrice && isset($v->use_as_fee) && $v->use_as_fee) {
										$pric_use_as_fee = true;
									}
								}

								/*
								 * paragraph formula support for label
								 * */
								if ($v->type === 'paragraph') {
									if ($matches = $this->check_field_price_dependency($v->label)) {
										foreach ($matches as $match) {
											if (!isset($this->label_depends[$match])) {
												$this->label_depends[$match] = array();
											}
											if (isset($v->elementId)) {
												if (!in_array($v->elementId, $this->label_depends[$match])) {
													$this->label_depends[$match][] = $v->elementId;
												}
											}
										}
									}
								}
								/**/

								if (isset($v->enablePrice) && $v->enablePrice && isset($v->pricingType) && $v->pricingType === 'custom') {

									if (isset($v->priceOptions) && $v->priceOptions == 'different_for_all') {

										foreach ($v->values as $e) {

											if ($matches = $this->check_field_price_dependency($e->price)) {
												foreach ($matches as $match) {
													if (!isset($this->price_depends[$match])) {
														$this->price_depends[$match] = array();
													}
													if (isset($v->elementId)) {
														if (!in_array($v->elementId, $this->price_depends[$match])) {
															$this->price_depends[$match][] = $v->elementId;
														}
													}
												}
											}
										}
									} else if (isset($v->price)) {
										if ($matches = $this->check_field_price_dependency($v->price)) {
											foreach ($matches as $match) {
												if (!isset($this->price_depends[$match])) {
													$this->price_depends[$match] = array();
												}
												if (isset($v->elementId)) {
													if (!in_array($v->elementId, $this->price_depends[$match])) {
														$this->price_depends[$match][] = $v->elementId;
													}
												}
											}
										}
									}
								}
								$v->form_id = $id;
								$v->form_rules = $form_rules;
							}

							$this->data = array_merge($this->data, $json_encoded);
						}
					}
				}

				if ($bind_quantity) {
					if ($matches = $this->check_field_price_dependency($quantity_bind_formula)) {
						foreach ($matches as $match) {
							if (!isset($this->price_depends[$match])) {
								$this->price_depends[$match] = array();
							}
							if (isset($v->elementId)) {
								if (!in_array($v->elementId, $this->price_depends[$match])) {
									$this->price_depends[$match][] = $v->elementId;
								}
							}
						}
					}
				}
			}


			$this->data = apply_filters('wcpa_product_form_fields', $this->data, $product_id);


			if (empty($this->settings) && isset($id)) {
				$dis_global = wcpa_get_post_meta($id, 'disp_use_global', true);
				$cont_global = wcpa_get_post_meta($id, 'cont_use_global', true);
				$this->settings = [
					'disp_use_global' => $dis_global,
					'disp_show_field_price' => ($dis_global ? wcpa_get_option('disp_show_field_price', true) : wcpa_get_post_meta($id, 'disp_show_field_price', wcpa_get_option('disp_show_field_price', true))),
					'disp_summ_show_total_price' => ($dis_global ? wcpa_get_option('disp_summ_show_total_price', true) : wcpa_get_post_meta($id, 'disp_summ_show_total_price', wcpa_get_option('disp_summ_show_total_price', true))),
					'disp_summ_show_product_price' => ($dis_global ? wcpa_get_option('disp_summ_show_product_price', true) : wcpa_get_post_meta($id, 'disp_summ_show_product_price', wcpa_get_option('disp_summ_show_product_price', true))),
					'disp_summ_show_option_price' => ($dis_global ? wcpa_get_option('disp_summ_show_option_price', true) : wcpa_get_post_meta($id, 'disp_summ_show_option_price', wcpa_get_option('disp_summ_show_option_price', true))),
					'pric_overide_base_price' => $pric_overide_base_price,
					'pric_overide_base_price_if_gt_zero' => $pric_overide_base_price_if_gt_zero,
					'pric_overide_base_price_fully' => $pric_overide_base_price_fully,
					'pric_cal_option_once' => $pric_cal_option_once,
					'pric_use_as_fee' => $pric_use_as_fee,
					'render_after_acb' => $render_after_acb,
					'enable_recaptcha' => ($enable_recaptcha ? $enable_recaptcha : wcpa_get_option('enable_recaptcha', false)),
					'bind_quantity' => $bind_quantity,
					'quantity_bind_formula' => $quantity_bind_formula,
					'disp_hide_options_price' => wcpa_get_post_meta($id, 'disp_hide_options_price', false),
					'cont_use_global' => $cont_global,
					'options_total_label' => ($cont_global ? wcpa_get_option('options_total_label', 'Options Price', true) : wcpa_get_post_meta($id, 'options_total_label', wcpa_get_option('options_total_label', 'Options Price'))),
					'options_product_label' => ($cont_global ? wcpa_get_option('options_product_label', 'Product Price', true) : wcpa_get_post_meta($id, 'options_product_label', wcpa_get_option('options_product_label', 'Product Price', true))),
					'total_label' => ($cont_global ? wcpa_get_option('total_label', 'Total', true) : wcpa_get_post_meta($id, 'total_label', wcpa_get_option('total_label', 'Total'))),
					'fee_label' => ($cont_global ? wcpa_get_option('fee_label', 'Fee', true) : wcpa_get_post_meta($id, 'fee_label', wcpa_get_option('fee_label', 'Fee'))),
					'thumb_image' => false
				];
			}
		}

		public function get_price_data($v, $val = false, $productData = false)
		{
			$data = false;
			//per character => per_car
			//percentage of total amount => percentage
			// multiply by number  => multiply
			$consider_tax = wcpa_get_option('consider_product_tax_conf', true);
			if (isset($v->enablePrice) && $v->enablePrice && (isset($v->price) || isset($val->price))) {

				if ($this->tax_per_unit === false) {
					if ($consider_tax) {
						$this->tax_per_unit = wcpa_get_price_shop($this->product, array(
							'qty' => 1,
							'price' => 1,
						));
					} else {
						$this->tax_per_unit = 1;
					}

				}
				$is_fee = false;
				if (isset($v->form_rules['pric_use_as_fee']) && $v->form_rules['pric_use_as_fee'] === true) {
					$is_fee = true;
				} else {
					$is_fee = isset($v->use_as_fee) && $v->use_as_fee;
				}

				$is_show_price = isset($v->is_show_price) && $v->is_show_price;

				if (in_array($v->type, array(
					'select',
					'checkbox-group',
					'radio-group',
					'image-group',
					'color-group',
					'productGroup'
				))) {
					$pricingType = ($v->priceOptions == 'product_price') ? 'fixed' : $v->pricingType;
					if ($v->priceOptions == 'different_for_all') {
						$price = $val->price;
					} else if ($v->priceOptions == 'fixed_for_all') {
						$price = $v->price;
					} else if ($v->priceOptions == 'product_price') {
						$price = $productData->get_price('edit');
					}
					if ($pricingType !== 'percentage' && $pricingType !== 'custom') {

						$price = wcpa_get_price_shop($this->product, array(
							'qty' => 1,
							'price' => $price,
						));

						$price = apply_filters('raw_woocommerce_price', $price);
						if ($this->get_con_unit(false) !== $this->get_con_unit(true)) { // it already may have applied the currncy
							$price /= $this->get_con_unit(false);
						}
					}
					if (in_array($v->type, array('productGroup')) && $productData){
						$data = 'data-price=\'' . json_encode(array(
							'priceoptions' => $v->priceOptions,
							'type' => $v->type,
							'value' => $price,
							'pricingType' => $pricingType,
							'excl_chars_frm_length' => (isset($v->excl_chars_frm_length) ? htmlspecialchars($v->excl_chars_frm_length, ENT_QUOTES) : ''),
							'excl_chars_frm_length_is_regex' => (isset($v->excl_chars_frm_length_is_regex) ? $v->excl_chars_frm_length_is_regex : false),
							'taxpu' => $this->tax_per_unit,
							'con_unit' => $this->get_con_unit(),
							'is_fee' => $is_fee,
							'is_show_price' => $is_show_price,
							'option_price' => $productData->get_price('edit'),
						)) . '\'';
					} else {
						$data = 'data-price=\'' . json_encode(array(
								'priceoptions' => $v->priceOptions,
								'type' => $v->type,
								'value' => $price,
								'pricingType' => $pricingType,
								'excl_chars_frm_length' => (isset($v->excl_chars_frm_length) ? htmlspecialchars($v->excl_chars_frm_length, ENT_QUOTES) : ''),
								'excl_chars_frm_length_is_regex' => (isset($v->excl_chars_frm_length_is_regex) ? $v->excl_chars_frm_length_is_regex : false),
								'taxpu' => $this->tax_per_unit,
								'con_unit' => $this->get_con_unit(),
								'is_fee' => $is_fee,
								'is_show_price' => $is_show_price
							)) . '\'';
					}
				} else {
					$price = $v->price;

					if ($v->pricingType !== 'percentage' && $v->pricingType !== 'custom') {// in such cases $price will be string or percentage value, not be actual price
						$price = wcpa_get_price_shop($this->product, array(
							'qty' => 1,
							'price' => $price,
						));
						$price = apply_filters('raw_woocommerce_price', $price);
						$price = apply_filters('wcml_raw_price_amount', $price);
						if ($this->get_con_unit(false) !== $this->get_con_unit(true)) { // it already may have applied the currncy
							$price /= $this->get_con_unit(false);
						}
					}

					$data = 'data-price=\'' . htmlspecialchars(json_encode(array(
							'value' => $price,
							'type' => $v->type,
							'pricingType' => $v->pricingType,
							'excl_chars_frm_length' => (isset($v->excl_chars_frm_length) ? ($v->excl_chars_frm_length) : ''),
							'excl_chars_frm_length_is_regex' => (isset($v->excl_chars_frm_length_is_regex) ? $v->excl_chars_frm_length_is_regex : false),
							'taxpu' => $this->tax_per_unit,
							'is_fee' => $is_fee,
							'is_show_price' => $is_show_price,
							'con_unit' => $this->get_con_unit()
						)), ENT_QUOTES) . '\'';
				}
			} 

			return $data;
		}
		
		public function get_pro_attr_list($pro = false)
		{
			if ($pro === false) {
				$pro = $this->product;
			}
			$attributes = $pro->get_attributes();

			$product_attributes = [];
			foreach ($attributes as $attribute) {
				$values = array();

				if ($attribute->is_taxonomy()) {
					$attribute_values = wc_get_product_terms($pro->get_id(), $attribute->get_name(), array('fields' => 'all'));

					foreach ($attribute_values as $attribute_value) {
						$value_slug = esc_html($attribute_value->slug);

						$values[] = $value_slug;

					}
				} else {
					$values = $attribute->get_options();

				}

				$product_attributes[sanitize_title_with_dashes($attribute->get_name())] = array(
					'label' => $attribute->get_name(),
					'value' => $values,
				);
			}

			return $product_attributes;
		}
		private function find_element_by_id($element_id)
		{

			if (count($this->data)) {
				foreach ($this->data as $v) {
					if ($element_id == $v->elementId) {
						return $v;
					}
				}
			}

			return false;
		}

		public function eval_relation($rules, $product_id)
		{
			$cf_prefix = wcpa_get_option('wcpa_cf_prefix', 'wcpa_pcf_');

			if (!isset($rules->cl_field) || empty($rules->cl_field)) {
				return false;
			}
			if ($rules->cl_relation === '0') {
				return false;
			}
			if ($rules->cl_field === 'quantity') {
	//            $field = 'quantity';
				$field = (object)['type' => 'quantity'];
			} else if ($rules->cl_field === 'attribute') {
	//            $field = 'attribute';
				$field = (object)['type' => 'attribute'];
				$product = wc_get_product($product_id);
			} else if ($rules->cl_field === 'stock_quantity') {
				$product = wc_get_product($product_id);
				$field = (object)['type' => 'stock_quantity'];
			} else if ($rules->cl_field === 'stock_status') {

				$product = wc_get_product($product_id);
				$field = (object)['type' => 'stock_status'];

			} else if ($rules->cl_field === 'product_ids') {
				$product = wc_get_product($product_id);

				$field = (object)['type' => 'product_ids'];
			} else if ($rules->cl_field === 'custom_field') {
				$product = wc_get_product($product_id);
				$field = (object)['type' => 'custom_field'];

			} else {
				$field = array_filter($this->data, function ($e) use ($rules) {
					if (isset($e->elementId) && !empty($e->elementId) && $rules->cl_field === $e->elementId) {
						return true;
					} else {
						return false;
					}
				});
			}


			if (is_array($field)) {
				$field = reset($field);
			} else if (!in_array($field->type, [
				'quantity',
				'attribute',
				'stock_status',
				'stock_quantity',
				'custom_field',
				'product_ids'
			])) {
				return false;
			}
			if ($field) {
				$val = array();
				$is_visible = true;
				if (isset($field->enableCl) && $field->enableCl) {
					if (isset($field->cl_status) && $field->cl_status === 'visible') {
						$is_visible = true;
					} else if (isset($field->cl_status) && $field->cl_status === 'hidden') {
						$is_visible = false;
					} else if ($field->cl_rule === 'show') {
						$is_visible = false;
					} else {
						$is_visible = true;
					}
				}

				if ($is_visible) {
					if ($field->type === 'quantity') {
						if (isset($_REQUEST['quantity'])) {
							$val[] = (int)$_REQUEST['quantity'];
						}
					} else if ($field->type === 'stock_status') {
						$val[] = $product->get_stock_status('edit');
					} else if ($field->type === 'product_ids') {
						$val[] = $product->get_id();
					} else if ($field->type === 'stock_quantity') {
						$val[] = $product->get_stock_quantity('edit');
					} else if ($field->type === 'custom_field') {

						$product_custom_fields = wcpa_get_option('product_custom_fields');
						$product_cfs = array();
						if (is_array($product_custom_fields)) {
							foreach ($product_custom_fields as $cf) {
								if (get_post_meta($product_id, $cf_prefix . $cf['name'], true)) {
									$product_cfs['wcpa_pcf_' . $cf['name']] = get_post_meta($product_id, $cf_prefix . $cf['name'], true);
								} else {
									$product_cfs['wcpa_pcf_' . $cf['name']] = $cf['value'];
								}
							}
						}
						if (isset($product_cfs['wcpa_pcf_' . $rules->cl_relation])) {
							$val[] = $product_cfs['wcpa_pcf_' . $rules->cl_relation];
						}

					} else if ($field->type === 'attribute') {
						$name = 'attribute_' . $rules->cl_relation;
						if (isset($_REQUEST[$name])) {
							$val[] = $_REQUEST[$name];
						}

						$product_attributes = $this->get_pro_attr_list($product);
						if (isset($product_attributes[$rules->cl_relation])) {
							$val = $product_attributes[$rules->cl_relation]['value'];
						}
						if (empty($val)) {
							return false;
						}
					} else if (in_array($field->type, ['text', 'color', 'hidden'])) {
						if (isset($_REQUEST[$field->name])) {
							$val[] = strtolower($_REQUEST[$field->name]);
						}
					} else if (in_array($field->type, ['file'])) {
						if (isset($field->ajax_upload) && $field->ajax_upload === true && isset($_REQUEST[$field->name . '_ajax']) && !empty($_REQUEST[$field->name . '_ajax'])) {
							$temp = explode('||', $_REQUEST[$field->name . '_ajax']);
							$val[] = strtolower($temp[1]);
						} else if ($_FILES[$field->name]["error"] != 4) {
							$val[] = strtolower($_FILES[$field->name]["name"]);
						}
					} else if (in_array($field->type, ['number'])) {
						if (isset($_REQUEST[$field->name])) {
							$val[] = (float)$_REQUEST[$field->name];
						}
					} else if (in_array($field->type, ['textarea'])) {
						if (isset($_REQUEST[$field->name])) {
							$val[] = strtolower($_REQUEST[$field->name]);
						}
					} else if (in_array($field->type, [
							'checkbox-group',
							'radio-group',
							'select',
							'image-group',
							'color-group'
						]) && isset($_REQUEST[$field->name])) {
						if (is_array($_REQUEST[$field->name])) {
							$_values = $_REQUEST[$field->name];

							if (in_array($rules->cl_relation, [
								'contains',
								'not_contains',
								'starts_with',
								'ends_with'
							])) {
								array_walk($_values, function (&$a, $b) {
									strtolower(str_replace('WCPAOTH ', '', $a));
								}); // using this array_walk method to preserve the keys
								$val = $_values;
							} else {
								foreach ($_values as $l => $v) {
									if (substr($v, 0, 8) === "WCPAOTH ") {
										$val[] = 'other';
									} else {
										$val[] = strtolower($v);
									}
								}
							}

						} else {
							if (in_array($rules->cl_relation, [
								'contains',
								'not_contains',
								'starts_with',
								'ends_with'
							])) {
								$val[] = strtolower(str_replace('WCPAOTH ', '', $_REQUEST[$field->name]));
							} else {
								if (substr($_REQUEST[$field->name], 0, 8) === "WCPAOTH ") {
									$val[] = 'other';
								} else {
									$val[] = strtolower($_REQUEST[$field->name]);
								}
							}
						}

					} else if (in_array($field->type, ['date', 'datetime-local'])) {
						if (isset($_REQUEST[$field->name])) {
							if (in_array($rules->cl_relation, [
								'contains',
								'not_contains',
								'starts_with',
								'ends_with'
							])) {
								$val[] = strtolower($_REQUEST[$field->name]);
							} else {
								$dateTemp = date_create_from_format(__(get_option('date_format'), 'wcpa-text-domain'), $_REQUEST[$field->name]);
								if ($dateTemp !== false) {
									if ($field->type == 'date') {
										$dateTemp->setTime(0, 0, 0);
									}
									$val[] = $dateTemp->getTimestamp();
								}
	//                            $val[] = strtotime($_REQUEST[$field->name]);

							}
						}
					} else if (in_array($field->type, ['time'])) {
						if (isset($_REQUEST[$field->name])) {
							if (in_array($rules->cl_relation, [
								'contains',
								'not_contains',
								'starts_with',
								'ends_with'
							])) {
								$val[] = strtolower($_REQUEST[$field->name]);
							} else {
								$val[] = strtotime($_REQUEST[$field->name]);
							}
						}
					}
				}
				$rel_val = false;
				if ($field->type === 'attribute') {
					$rel_val = isset($rules->cl_val->value) ? $rules->cl_val->value : $rules->cl_val;
					if (in_array($rel_val, $val)) {
						return true;
					} else {
						return false;
					}
				}
				if ($field->type === 'custom_field') {
					$rel_val = isset($rules->cl_val->value) ? $rules->cl_val->value : $rules->cl_val;
					if (in_array($rel_val, $val)) {
						return true;
					} else {
						return false;
					}
				}

				if (count($val) === 0) {
					switch ($rules->cl_relation) {
						case 'is_empty':
							return true;
						case 'is_not_empty':
							return false;
						default:
							return false;
					}
				}


				if (isset($rules->cl_val) && ($field->type == 'quantity' || $field->type == 'stock_quantity')) {
					$rel_val = (float)(((isset($rules->cl_val->value)) ? $rules->cl_val->value : $rules->cl_val));
				} else if (isset($rules->cl_val) && $field->type == 'product_ids') {
					$rel_val = (((isset($rules->cl_val->value)) ? $rules->cl_val->value : $rules->cl_val));
					$rel_val = preg_split('/[\ \n\,]+/', $rel_val);
					$rel_val = array_map('intval', $rel_val);
				} else if (isset($rules->cl_val) && $field->type == 'image-group') {
					$rel_val = strtolower(((isset($rules->cl_val->i)) ? $rules->cl_val->i : $rules->cl_val));
				} else if ($field->type == 'datetime-local' || $field->type == 'date' || $field->type == 'time') {
					if (in_array($rules->cl_relation, ['contains', 'not_contains', 'starts_with', 'ends_with'])) {
						$rel_val = strtolower($rules->cl_val);
					} else {
						$rel_val = strtotime($rules->cl_val);
					}
				} else if (isset($rules->cl_val) && $field->type == 'number') {
					$rel_val = (float)(((isset($rules->cl_val->value)) ? $rules->cl_val->value : $rules->cl_val));
				} else if (isset($rules->cl_val)) {
					$rel_val = strtolower((((isset($rules->cl_val->value)) ? $rules->cl_val->value : $rules->cl_val)));
				}
				$val = array_map(function ($v) {
					return wp_unslash($v);
				}, $val);


				switch ($rules->cl_relation) {
					case 'is':

						if (in_array($rel_val, $val)) {
							return true;
						} else {
							return false;
						}
					case 'is_not':
						if (in_array($rel_val, $val)) {
							return false;
						} else {
							return true;
						}
					case 'is_in':
						if (is_array($rel_val)) {
							foreach ($rel_val as $rel_v) {
								if (in_array($rel_v, $val)) {
									return true;
								}
							}
						}

						return false;

					case 'is_not_in':
						if (is_array($rel_val)) {
							foreach ($rel_val as $rel_v) {
								if (in_array($rel_v, $val)) {
									return false;
								}
							}
						} else {
							return false;
						}

						return true;

					case 'is_empty':
						if (count($val) === 0 || reset($val) === '') {
							return true;
						} else {
							return false;
						}
					case 'is_not_empty':
						if (count($val) === 0 || reset($val) === '') {
							return false;
						} else {
							return true;
						}
					case 'is_greater':
						foreach ($val as $v) {
							if ($v > $rel_val) {
								return true;
							}
						}

						return false;
					case 'is_lessthan':
						foreach ($val as $v) {
							if ($v >= $rel_val) {
								return false;
							}
						}

						return true;
					case 'is_greater_or_eqaul':
						foreach ($val as $v) {
							if ($v >= $rel_val) {
								return true;
							}
						}

						return false;
					case 'is_lessthan_or_eqal':
						foreach ($val as $v) {
							if ($v > $rel_val) {
								return false;
							}
						}

						return true;
					case 'contains':
						foreach ($val as $v) {
							if (strpos($v, $rel_val) !== false) {
								return true;
							}
						}

						return false;

					case 'not_contains':
						foreach ($val as $v) {
							if (strpos($v, $rel_val) !== false) {
								return false;
							}
						}

						return true;
					case 'starts_with':
						foreach ($val as $v) {
							if (strpos($v, $rel_val) === 0) {
								return true;
							}
						}

						return false;
					case 'ends_with':
						foreach ($val as $v) {
							$strlen = strlen($v);
							$testlen = strlen($rel_val);
							if ($testlen <= $strlen) {
								if (substr_compare($v, $rel_val, $strlen - $testlen, $testlen) === 0) {
									return true;
								}
							}
						}

						return false;
					case 'date_is':
					case 'time_is':
						if (in_array($rel_val, $val)) {
							return true;
						} else {
							return false;
						}

					case 'date_is_before':
					case 'time_is_before':
						foreach ($val as $v) {
							if ($v >= $rel_val) {
								return false;
							}
						}

						return true;
					case 'date_is_after':
					case 'time_is_after':
						foreach ($val as $v) {
							if ($v > $rel_val) {
								return true;
							}
						}

						return false;
				}
			} else {
				return false;
			}

			return false;
		}

		public function render($after_acb = false, $is_rest = false)
    	{

	        $cf_prefix = wcpa_get_option('wcpa_cf_prefix', 'wcpa_pcf_');

	        $qnty_related = '';
	        $attr_related = '';

	        $product_data = array();


	        if (isset($this->relations['quantity'])) {
	            $qnty_related = 'data-qntyrelated=\'' . json_encode($this->relations['quantity']) . '\'';
	        }
	        if (isset($this->relations['attribute'])
	            || isset($this->relations['stock_status'])
	            || isset($this->relations['stock_quantity'])
	            || isset($this->relations['product_ids'])
	            || isset($this->relations['custom_field'])) {

	            $attr_related = 'data-attrrelated=\'' . json_encode(array_merge(isset($this->relations['attribute']) ? $this->relations['attribute'] : [],
	                    isset($this->relations['stock_status']) ? $this->relations['stock_status'] : [],
	                    isset($this->relations['stock_quantity']) ? $this->relations['stock_quantity'] : [],
	                    isset($this->relations['product_ids']) ? $this->relations['product_ids'] : [],
	                    isset($this->relations['custom_field']) ? $this->relations['custom_field'] : []
	                )) . '\'';
	        }


	        if (!$this->product) {
	            global $product;
	            $this->product = $product;
	        }

	        $has_price = false;
	        if (count($this->data) === 0) {
	            return;
	        }

	        $filter_default     = false;  
	        $wcpa_price   = apply_filters( 'wcpa_product_price', $filter_default, $this->product );

	        $product_data['wc_product_price'] = $wcpa_price ? $wcpa_price : ( apply_filters('raw_woocommerce_price', wcpa_get_price_shop($this->product)) / $this->get_con_unit(true) );
	        // $product_data['wc_product_price'] = apply_filters('raw_woocommerce_price', wcpa_get_price_shop($this->product)) / $this->get_con_unit(true);
	        $product_data['wc_product_regular_price'] = apply_filters('raw_woocommerce_price', wcpa_get_price_shop($this->product, [], true)) / $this->get_con_unit(true);
	        $product_data['wc_product_price_default'] = (wcpa_get_option('variation_default_price', false) === false) ? $product_data['wc_product_price'] : wcpa_get_option('variation_default_price', false);// used  in js incase it product price has got changed by variations
	        $product_data['product_title'] = '';
	        $product_data['con_unit'] = $this->get_con_unit();
	        $product_data['product_id'] = $this->product->get_id();
	        $product_data['is_variable'] = $this->product->is_type('variable') ? true : false;
	        $product_data['stock_status'] = $this->product->get_stock_status('edit');
	        $product_data['stock_quantity'] = $this->product->get_stock_quantity('edit');

	        // $product_data['product_attributes'] = $this->product->is_type('simple') ? $this->get_pro_attr_list() : [];
	        $product_data['product_attributes'] = $this->get_pro_attr_list();

	        $product_custom_fields = wcpa_get_option('product_custom_fields');
	        $product_cfs = array();
	        if (is_array($product_custom_fields)) {
	            foreach ($product_custom_fields as $cf) {
	                if (get_post_meta($this->product->get_id(), $cf_prefix . $cf['name'], true)) {
	                    $product_cfs['wcpa_pcf_' . $cf['name']] = get_post_meta($this->product->get_id(), $cf_prefix . $cf['name'], true);
	                } else {
	                    $product_cfs['wcpa_pcf_' . $cf['name']] = $cf['value'];
	                }
	            }
	        }
	        $product_data['product_cfs'] = $product_cfs;

	        $rules = [
	            'pric_overide_base_price' => isset($this->settings['pric_overide_base_price']) ? $this->settings['pric_overide_base_price'] : false,
	            'pric_overide_base_price_if_gt_zero' => isset($this->settings['pric_overide_base_price_if_gt_zero']) ? $this->settings['pric_overide_base_price_if_gt_zero'] : false,
	            'pric_overide_base_price_fully' => isset($this->settings['pric_overide_base_price_fully']) ? $this->settings['pric_overide_base_price_fully'] : false,

	            'pric_cal_option_once' => isset($this->settings['pric_cal_option_once']) ? $this->settings['pric_cal_option_once'] : false,
	            'pric_use_as_fee' => isset($this->settings['pric_use_as_fee']) ? $this->settings['pric_use_as_fee'] : false,
	            'bind_quantity' => isset($this->settings['bind_quantity']) ? $this->settings['bind_quantity'] : false,
	            'quantity_bind_formula' => isset($this->settings['quantity_bind_formula']) ? $this->settings['quantity_bind_formula'] : false,
	        ];

	        if ($is_rest) {// REST api request
	            return [
	                'rules' => $rules,
	                'fields' => $this->data
	            ];
	        }

	        echo '<div class="wcpa_form_outer" ' . $qnty_related . ' ' . $attr_related . ' data-product=\'' . htmlspecialchars(wp_json_encode($product_data), ENT_QUOTES) . '\' data-rules=\'' . json_encode($rules) . '\'>';
	        $row_open = false;
	        $col_counter = 6;
	        $col = 6;


	        echo '<input type="hidden" name="wcpa_field_key_checker" value="wcpa" />';
	        // if (wcpa_get_option('ajax_add_to_cart', false)) { // if enabled ajax submissions
	            // echo '<input type="hidden" name="action" value="woocommerce_add_to_cart" />';
	            // echo '<input type="hidden" name="product_id" value="' . $this->product->get_id() . '" />';
	        // }


	        foreach ($this->data as $v) {


	            if (isset($v->col)) {
	                $col = (int)$v->col;
	            }
	            $col_counter += $col;
	            if ($col_counter > 6) {
	                if ($row_open) {
	                    echo '</div>';
	                    echo '<div class="wcpa_row">';
	                } else {
	                    echo '<div class="wcpa_row">';
	                    $row_open = true;
	                }
	                $col_counter = $col;
	            }

	            $parent_class = 'wcpa_form_item wcpa_type_' . $v->type . ' wcpa_form_id_' . $v->form_id . ' ';
	            if (isset($v->className)) {
	                $parent_class .= ' ' . $v->className . '_parent ';
	            }
	            if ($col < 6) {
	                $parent_class .= 'wcpa-col-' . $col . ' ';
	            }

	            $inline_css = '';
	            $relation_action = '';
	            if (isset($v->enableCl) && $v->enableCl) {
	                if ($v->cl_rule == 'show') {
	                    $inline_css = 'display:none;';
	                }
	            }
	            if ($v->type == 'hidden') {
	                $inline_css = 'display:none;';
	            }
	            if (!empty($inline_css)) {
	                $inline_css = 'style="' . $inline_css . '"';
	            }
	            $id_text = '';
	            if (isset($v->elementId) && !empty($v->elementId)) {
	                $id_text .= 'id="' . $v->elementId . '"';
	            }
	            $relation_data = $this->get_relation_data($v);

	            if (!empty($relation_data['related'])) {
	                $parent_class .= 'wcpa_has_relation ';
	            }
	            if (!empty($relation_data['rules'])) {
	                $parent_class .= 'wcpa_has_rules ';
	            }
	            if (isset($relation_data['price_related']) && !empty($relation_data['price_related'])) {
	                $parent_class .= 'wcpa_has_price_related ';
	            }
	            if (isset($relation_data['label_related']) && !empty($relation_data['label_related'])) {
	                $parent_class .= 'wcpa_has_label_related ';
	            }
	            // Validation Class
	            // if (isset($v->required) && $v->required) {
	                $parent_class .= 'wcpa_validate_field ';
	            // }

	            $data_type = $v->type;

	            if ( in_array($data_type, array('checkbox-group', 'radio-group', 'image-group', 'color-group') )) {
	                $data_type = 'select';
	            }

	            echo '<div class="' . $parent_class . '" ' . $inline_css . ' ' . $relation_data['related'] . ''
	                . ' ' . $relation_data['rules'] . ' ' . $relation_data['label_related'] . ' ' . $relation_data['price_related'] . '   ' . $id_text . ' data-type="' . $data_type . '" >';

	            switch ($v->type) {
	            	case 'select':
					case 'checkbox-group':
					case 'radio-group':
					case 'image-group':
					case 'color-group':
						$this->render_select($v);
	                    break;
	                case 'text':
	                    $this->render_text($v);
	                    break;
	                case 'hidden':
	                    $this->render_hidden($v);
	                    break;
	                case 'color':
	                    $this->render_color($v);
	                    $this->enqueue_colorpicker();
	                    break;
	                case 'number':
	                    $this->render_number($v);
	                    break;
	                case 'date':
	                    $this->render_date($v);

	                    $this->enqueue_detetimepicker();
	                    break;
	                case 'time':
	                    $this->render_time($v);
	                    $this->enqueue_detetimepicker();
	                    break;
	                case 'datetime-local':
	                    $this->render_datetime($v);
	                    $this->enqueue_detetimepicker();
	                    break;
	                case 'header':
	                    $this->render_header($v);
	                    break;
	                case 'file':
	                    $this->render_file($v);
	                    break;
	                case 'paragraph':
	                    $this->render_paragraph($v);
	                    break;
	                case 'statictext':
	                    $this->render_statictext($v);
	                    break;
	                case 'productGroup':
	                    $this->render_productGroup($v);
	                    break;
	                case 'separator':
	                    $this->render_separator($v);
	                    break;
	                case 'textarea':
	                    $this->render_textarea($v);
	                    break;
	                case 'placeselector':
	                    $this->render_place($v);
	                    $this->enqueue_googlemap();
	                    break;
	            }
	            //$this->{'render_' . $v->type}($v);
	            if (isset($v->enablePrice) && $v->enablePrice ) {
	                $has_price = true;
	                $visible = ($this->settings['disp_show_field_price'] ? '' : 'style="display:none"');
	                echo '<span class="wcpa_priceouter" ' . $visible . ' >' . wcpa_price(0) . '</span>';
	            }
	            echo '</div>';
	        }
	        if ($row_open) {
	            echo '</div>';
	            $row_open = false;
	        }

	        if ($this->settings['enable_recaptcha'] && $this->settings['enable_recaptcha'] === true) {
	            echo '<div class="wcpa_row">';
	            echo '<div class="g-recaptcha" data-sitekey="' . wcpa_get_option('recaptcha_site_key', '') . '"></div>';
	            echo '</div>';
	            $this->enqueue_recaptcha();
	        }


	        echo '</div>';
	        if ($has_price) {
	            $hook = get_wcpa_display_hook('price_summary');
	            add_action($hook[0], array($this, 'price_summary_box'), $hook[1]);
	        }

	        do_action('wcpa_price_summary_box');
	    }

		public function get_con_unit($toMultiplyWithShopPrice = false, $v = false)
		{
			if ($v) {
				if (isset($v->form_rules['exclude_from_discount']) && $v->form_rules['exclude_from_discount']) {
					return 1;
				}
			}
			$index = $toMultiplyWithShopPrice ? 0 : 1;
			// $toMultiplyWithShopPrice the response can be decided based on the currency switcher using
			if ($this->conversion_unit[$index] === false) {
				$mc = new WCPA_MC();
				$this->conversion_unit[$index] = $mc->get_con_unit($this->product, false, false, $toMultiplyWithShopPrice);

				return $this->conversion_unit[$index];
			} else {
				return $this->conversion_unit[$index];
			}
		}

		public function get_element_by_id( $id ) {
			
			foreach ($this->data as $v) {
				if ( $v->elementId == $id ) return $v;
			}
		}



		public function get_relation_data($v, $val = false)
		{
			$related = '';
			$rules = '';
			$price_related = '';
			$label_related = '';
			
			$field_fix = array('image-group', 'color-group');
			//print_r($v);
			//fix color and image group relation data
			if( is_array( $v->relations ) ) {
				foreach ($v->relations as $indx => $_relation) {
					foreach ($_relation->rules as $_indx => $__relation) {
						$_rules = $__relation->rules;
						foreach ($field_fix as $_field) {
							//if is url or color just set as index
							if ( strpos($_rules->cl_field, $_field ) !== false && filter_var($_rules->cl_val->value, FILTER_VALIDATE_URL)) {
								
								//$element = $this->get_element_by_id($_rules->cl_field);
								//$__value = $element->values[ $_rules->cl_val->i ]->label;

								$_rules->cl_val->value = $_rules->cl_val->i; 
								//$_rules->cl_val->value = $__value; 
							}
						}
						
					}
				}
			}

			//print_r($v->relations);

			if (isset($v->elementId) && isset($this->relations[$v->elementId])) {
				$related = 'data-related=\'' . json_encode($this->relations[$v->elementId]) . '\'';
			}
			if (isset($v->elementId) && isset($this->price_depends[$v->elementId])) {
				$price_related = 'data-price_depends=\'' . json_encode($this->price_depends[$v->elementId]) . '\'';
			}

			if (isset($v->elementId) && isset($this->label_depends[$v->elementId])) {
				$label_related = 'data-label_depends=\'' . json_encode($this->label_depends[$v->elementId]) . '\'';
			}
			if (isset($v->elementId) && isset($v->enableCl) && $v->enableCl) {

				$rules = 'data-rules=\'' . htmlspecialchars(json_encode(['rules' => $v->relations, 'action' => $v->cl_rule]), ENT_QUOTES) . '\'';
			}


			return ['related' => $related, 'rules' => $rules, 'price_related' => $price_related, 'label_related' => $label_related];
		}


		private function default_value($v)
		{

			$default_value = '';
			switch ($v->type) {
				case 'text':
				case 'date':
				case 'number':
				case 'color':
				case 'textarea':
				case 'hidden':
				case 'time':
				case 'datetime-local':
					if ($this->cart_error && (isset($v->name)) && isset($_POST[$v->name])) { // if there is a validation error, it has persist the user entered values,
						$default_value = $this->sanitize_values($v);
					} elseif ((isset($v->name)) && isset($_GET[$v->name])) { // using get if there is any value passed using url/get method
						$default_value = $this->sanitize_values($v);
					} else if (isset($v->value)) {
						$default_value = htmlspecialchars($v->value);
					}


					break;
				case 'file':
					$ajax_upload = (isset($v->ajax_upload) && $v->ajax_upload) ? true : false;
					if ($ajax_upload) {
						if ($this->cart_error && (isset($v->name)) && isset($_POST[$v->name . '_ajax'])) { // if there is a validation error, it has persist the user entered values,
							$default_value = $this->sanitize_values($_POST[$v->name . '_ajax']);
						}
					}
					break;
				case 'select':
				case 'image-group':
				case 'color-group':
				case 'radio-group':
				case 'checkbox-group':
					$default_value = array();
					if ($this->cart_error && (isset($v->name)) && isset($_POST[$v->name])) { // if there is a validation error, it has persist the user entered values,
						$default_value = $this->sanitize_values($v);
					} elseif ((isset($v->name)) && isset($_GET[$v->name])) {
						$default_value = $this->sanitize_values($v);
					} else if ($v->values && !(isset($_REQUEST['add-to-cart']) && $this->cart_error)) { // if it is direct product page load, not add-to-cart has set

						foreach ($v->values as $k => $val) {

							if (isset($val->selected)) {
								$default_value[$k] = $val->value;
								//$default_value[$k] = ( !isset($val->value) )? $val->label : $val->value;
							}
						}

					}

					break;
			   
				
				case 'placeselector':
					$default_value = array(
						'formated' => '',
						'splited' => array(),
						'cords' => array()
					);
					$splited = [
						'street_number',
						'route',
						'locality',
						'administrative_area_level_1',
						'postal_code',
						'country'
					];

					if ($this->cart_error && (isset($v->name)) && isset($_POST[$v->name])) { // if there is a validation error, it has persist the user entered values,
						$default_value['formated'] = $this->sanitize_values($v);
						foreach ($splited as $fl_name) {
							if (isset($_POST[$v->name . '_' . $fl_name])) {
								$default_value['splited'][$fl_name] = $_POST[$v->name . '_' . $fl_name];
							} else {
								$default_value['splited'][$fl_name] = '';
							}
						}
						if (isset($_POST[$v->name . '_lat'])) {
							$default_value['cords']['lat'] = $_POST[$v->name . '_lat'];
						} else {
							$default_value['cords']['lat'] = '';
						}
						if (isset($_POST[$v->name . '_lng'])) {
							$default_value['cords']['lng'] = $_POST[$v->name . '_lng'];
						} else {
							$default_value['cords']['lng'] = '';
						}
					} elseif ((isset($v->name)) && isset($_GET[$v->name])) {
						$default_value['formated'] = $this->sanitize_values($v);
						foreach ($splited as $fl_name) {
							if (isset($_POST[$v->name . '_' . $fl_name])) {
								$default_value['splited'][$fl_name] = $_POST[$v->name . '_' . $fl_name];
							} else {
								$default_value['splited'][$fl_name] = '';
							}
						}
						if (isset($_POST[$v->name . '_lat'])) {
							$default_value['cords']['lat'] = $_POST[$v->name . '_lat'];
						} else {
							$default_value['cords']['lat'] = '';
						}
						if (isset($_POST[$v->name . '_lng'])) {
							$default_value['cords']['lng'] = $_POST[$v->name . '_lng'];
						} else {
							$default_value['cords']['lng'] = '';
						}
					} else {
						$default_value['formated'] = isset($v->value) ? $v->value : '';
						foreach ($splited as $fl_name) {
							$default_value['splited'][$fl_name] = '';
						}
						$default_value['cords']['lat'] = '';

						$default_value['cords']['lng'] = '';
					}

					break;
			}

			return $default_value;
		}


		public function get_validation_rules($v)
		{
			$validation = array();
			if (isset($v->min_options) && !empty($v->min_options)) {
				$validation['selection']['min'] = $v->min_options;
			}
			if (isset($v->max_options) && !empty($v->max_options)) {
				$validation['selection']['max'] = $v->max_options;
			}
			if (!empty($validation)) {
				return 'data-val_rules=\'' . json_encode($validation) . '\'';
			} else {
				return '';
			}
		}

		public function render_select($v)
		{

			if ((isset($v->multiple) && $v->multiple)) {
				$is_multiple = true;
			} else {
				$is_multiple = false;
			}
			$name = (isset($v->name)) ? $v->name : '';
			if ($is_multiple) {
				$name = $name . '[]';
			}


			$sumo = wcpa_get_option('use_sumo_selector', false);
			if ($sumo && $is_multiple) {
				wp_enqueue_style($this->_token . '-sumoselector');
				wp_enqueue_script($this->_token . '-sumoselector');
			}

			$data = '';
			$default_value = $this->default_value($v);

			$sel_required = (isset($v->required)) ? 'required="required"' : '';
			$multiple = ($is_multiple) ? 'multiple="true"' : '';

			$className = '';
			if (isset($v->className)) {
				$className .= $v->className . ' ';
			}
			$price_data = '';
			if (isset($v->enablePrice) && $v->enablePrice) {
				$className .= 'wcpa_has_price ';
			}
			if (isset($v->enable_product_image) && $v->enable_product_image) {
				$className .= 'wcpa_update_product_image ';
				wp_enqueue_script('wc-add-to-cart-variation');
			}
			if ($sumo) {
				$className .= 'wcpa_use_sumo ';
			}
			if ($is_multiple) {
				$className .= 'wcpa_multiple ';
			}
			if (!empty($className)) {
				$className = 'class="' . $className . '"';
			}

			$this->label_section($v);


			if ($v->values && !empty($v->values)) {
				$sumoPlaceHolder = '';
				if ($sumo && isset($v->placeholder) && $v->placeholder != '') {
					$sumoPlaceHolder = $v->placeholder;
					$sumoPlaceHolder = 'data-placeholder="' . $sumoPlaceHolder . '"';
				}
				echo '<div class="select" ><select ' . $sumoPlaceHolder . '   name="' . $name . '" ' . $className . ' ' . $multiple . ' ' . $sel_required . '>';
				if ((!$is_multiple || !$sumo) && isset($v->placeholder) && $v->placeholder != '') {

					echo '<option value="" >' . $v->placeholder . '</option>';
				}

				$val_indx = 0;

				foreach ($v->values as $k => $val) {
					$label = $val->label;

					if ( !isset($val->value) ) $val->value = $label;

					if ( in_array($v->type, array('image-group') )) {
						$val->value = $val_indx;
					}


					$val_indx++;

					if (isset($v->enablePrice) && $v->enablePrice) {
						if ($v->pricingType === 'fixed' && (isset($v->form_rules['disp_hide_options_price']) && $v->form_rules['disp_hide_options_price'] === false)) {
							if ($v->priceOptions === 'different_for_all') {
								$price = $val->price;
							} else if ($v->priceOptions === 'fixed_for_all') {
								$price = $v->price;
							}
							$price = wcpa_get_price_shop($this->product, array(
								'qty' => 1,
								'price' => $price
							));
							if (($price - 0) < 0.0000001 && wcpa_get_option('wcpa_hide_option_price_zero', false)) {
								$label = $val->label;
							} else {
								$label = $val->label . ' ' . $this->field_option_price(wcpa_price($price * $this->get_con_unit(true), 1));
							}


						}

						$price_data = $this->get_price_data($v, $val);
					}

					$image_data = $this->get_pimage_data($v, $val);

					if (is_array($default_value)) {
						$is_selected = in_array($val->value, $default_value);
					} else {
						//$is_selected = $default_value === $this->sanitize_values($val->value);
						$is_selected = ($default_value === $this->sanitize_values($val->value)) ? true : false;
					}

					// $selectedchk = ($is_selected) ? 'selected="selected"' : '';
					// $selectedchk = ($val->selected)?'selected="selected"':'';

					$selectedchk = ($is_selected) ? 'selected="selected"' : '';


					$option_print = '<option ' . $image_data . ' ' . $price_data . ' value="' . htmlspecialchars($val->value) . '" ' . $selectedchk . '>' . $label . '</option>';
					$option_print = apply_filters('wcpa_select_option_print', $option_print, $label, $val->value);
					echo $option_print;
				}
				echo '</select>';

				if (!$is_multiple || $sumo) {
					echo '<div class="select_arrow"></div>';
				}
				echo '</div>';
			}
		}

		public function render_file($v)
	    {
	        $data = '';
	        $maxlength = '';
	        $txt_required = (isset($v->required)) ? 'required="required"' : '';
	        $placeholder = (isset($v->placeholder)) ? $v->placeholder : '';
	        $ajax_upload = isset($v->ajax_upload) && $v->ajax_upload;
	        $className = ''; $max_file_count = '';
	        $multiple_enabled = isset($v->multiple_upload) && $v->multiple_upload;
	        $droppable = isset($v->droppable) && $v->droppable;
	        
	        $multipleFile = ''; $multiple_fileName_postfix = '';
	        $multipleClass = ''; $DropContainerClass = 'wcpa_single_upload';
	        if($multiple_enabled){
	            $multipleFile = 'multiple';
	            $multiple_fileName_postfix = '[]';
	            $multipleClass = 'wcpa_multiple';
	            $DropContainerClass = 'wcpa_multiple_upload';
	            if(isset($v->max_file_count) && !empty($v->max_file_count)){
	                $max_file_count = ' data-maxFiles=\''.$v->max_file_count.'\' '; 
	            }
	        }
	        //if(isset($v->showUploadPreview) && $v->showUploadPreview) {
	            $DropContainerClass .= ' wcpa_drop_preview';
	        //}

	        if($droppable && $ajax_upload ){
	            $className .= 'wcpa_drag_file_input ';
	        }

	        if (isset($v->className)) {
	            $className .= $v->className . ' ';
	        }
	        $price_data = '';
	        if (isset($v->enablePrice) && $v->enablePrice) {
	            $className .= 'wcpa_has_price ';
	            $price_data = $this->get_price_data($v);
	        }
	        if($multipleClass) {
	            $className .= $multipleClass.' ';
	        }


	        $name = (isset($v->name)) ? $v->name : '';
	        $ajax_upload_data = '';
	        $custom_style = isset($v->custom_style) && $v->custom_style;
	        if ($ajax_upload) {
	            if($droppable){
	                $className .= 'wcpa_ajax_upload ';
	            } else {
	                $className .= 'wcpa_ajax_upload wcpa_file_custom ';
	            }
	            $ajax_upload_data = 'data-details=\'' . json_encode([
	                    'element_id' => $v->elementId,
	                    'name' => $name,
	                    'product_id' => $this->product->get_id(),
	                    'required' => (isset($v->required)) ? true : false
	                ]) . '\'';
	        } else if ($custom_style) {
	            $className .= 'wcpa_file_custom ';
	        } else {
	            $className .= 'wcpa_file_default ';
	        }

	        if (!empty($className)) {
	            $className = 'class="' . $className . '"';
	        }
	        //        if ($v->label) {
	        //            echo '<label for="' . $name . '">' . $v->label;
	        //            if (isset($v->required) && $v->required) {
	        //                echo '<span class="required_ast">*</span>';
	        //            }
	        //            echo '</label>';
	        //        }
	        $this->label_section($v);
	        if (isset($v->maxlength)) {
	            $maxlength = 'maxlength="' . $v->maxlength . '"';
	        }

	        $validation='';
	        if (
	            (isset($v->required) && $v->required) ||
	            (isset($v->max_file_count) && !empty($v->max_file_count)) ||
	            (isset($v->minuploadsize) && !empty($v->minuploadsize)) ||
	            (isset($v->uploadsize) && !empty($v->uploadsize)) ||
	            (isset($v->exts_supported) && !empty($v->exts_supported))
	        ) {
	            $validation_array= array();
	            $validation = 'data-validation=\'';
	            if (isset($v->required) && $v->required) {
	                $validation_array['required'] = true;
	                $validation_array['requiredMessage'] = htmlspecialchars(wcpa_get_validation_message('requiredError', $v), ENT_QUOTES);
	            }
	            if (isset($v->max_file_count) && !empty($v->max_file_count)) {
	                $validation_array['maxFileCount'] = $v->max_file_count;
	                $validation_array['maxFileCountMessage'] =  wcpa_get_validation_message('maxFileCountError', $v, $v->max_file_count);
	            }
	            if (isset($v->uploadsize) && !empty($v->uploadsize)) {
	                $validation_array['maxFileSize'] = $v->uploadsize * 1024 * 1024;
	                $validation_array['maxFileSizeMessage'] =  wcpa_get_validation_message('maxFileSizeError', $v, wcpa_formatBytes($v->uploadsize * 1024 *1024));
	            }
	            if (isset($v->minuploadsize) && !empty($v->minuploadsize)) {
	                $validation_array['minFileSize'] = $v->minuploadsize * 1024 * 1024;
	                $validation_array['minFileSizeMessage'] =  wcpa_get_validation_message('minFileSizeError', $v, wcpa_formatBytes($v->minuploadsize * 1024 *1024));
	            }
	            if (isset($v->exts_supported) && !empty($v->exts_supported)) {
	                $validation_array['extensionSupportEnable'] = true;
	                $validation_array['extensions'] = trim($v->exts_supported);
	                $validation_array['extensionsInvalidMessage'] = wcpa_get_validation_message('fileExtensionError', $v, str_replace(',', ', ', trim($v->exts_supported)));
	            }
	            $validation .=  json_encode($validation_array) . '\'';
	        }


	        if ($ajax_upload) {
	            $default_value = $this->default_value($v);
	            if (!empty($default_value)) {
	                $txt_required = '';
	                $temp = explode('||', $default_value);
	                $placeholder = $temp[1];
	            }
	            // Adding Drag And Drop Feature
	            if($droppable){
	                if($placeholder==''){
	                    $placeholder = __('Drag And Drop Files Here', 'wcpa-text-domain');
	                }
	                $action_text = wcpa_get_option('file_droppable_action_text', __( 'Browse', 'wcpa-text-domain' ));
	                $drop_desc = str_replace('{action}', '%s', wcpa_get_option('file_droppable_desc_text', __( 'or %s to choose a file', 'wcpa-text-domain' )));

	                echo '<div class="wcpa_drag_drop '.$DropContainerClass.'" ' . $ajax_upload_data . ' ' . $max_file_count . '>';
	                echo '<input type="hidden" id="' . $name . '" '.$className.'  name="' . $name . '_ajax'.$multipleFile.'"  value="' . $default_value . '" ' . $maxlength . ' ' . $txt_required . ' ' . $price_data . ' ' . $validation . ' />';
	                echo '<div class="wcpa-upload-area">';
	                echo '<div class="upload-area-title-thumb-style"><div class="upload-area-title-thumb-inner"><span>'.$action_text.'</span></div></div>';
	                echo '<div class="upload-area-title wcpa_center">'.$placeholder;
	                echo '<div class="wcpa_drop_text">'. __('Drop', 'wcpa-text-domain') .'</div>';
	                echo '<div class="upload-area-subtitle">'. str_replace('%s', '<span>' . $action_text . '</span>', $drop_desc) .'</div>';
	                echo '</div></div>';
	                echo '<div class="wcpa-upload-message"></div></div>';
	            } else if($multiple_enabled){
	                echo '<label class="wcpa_file_outer" for="sg-' . $name . '"><span class="wcpa_file_name">' . $placeholder . '</span><span class="wcpa_file_wrap" >' . wcpa_get_option('file_button_text', __('Choose File', 'wcpa-text-domain'), true) . '<input type="file"  id="sg-' . $name . '"  ' . $className . ' name="' . $name . '"  ' . $maxlength . ' ' . $txt_required . ' ' . $price_data . '  ' . $ajax_upload_data . ' ' . $multipleFile . ' ' . $max_file_count . ' /></span></label>';
	                echo '<input type="hidden" class="wcpa_file_hidden"  name="' . $name . '_ajaxmultiple"  value="' . $default_value . '" ' . $validation . ' />';
	                echo '<div class="wcpa_remove_file">'. __('Remove all', 'wcpa-text-domain') .'</div>';

	                // Removed Preview DIV from the common and added here seperately to achieve progress bar visible
	                $no_preview_class = (isset($v->showUploadPreview) && $v->showUploadPreview) ? '' : 'wcpa_no_preview_multiple';
	                echo '<div class="wcpa_upload_preview '.$no_preview_class.'"></div>';
	            } else {
	                echo '<label class="wcpa_file_outer" for="sg-' . $name . '"><span class="wcpa_file_name">' . $placeholder . '</span><span class="wcpa_file_wrap" >' . wcpa_get_option('file_button_text', __('Choose File', 'wcpa-text-domain'), true) . '<input type="file"  id="sg-' . $name . '"  ' . $className . ' name="' . $name . '"  ' . $maxlength . ' ' . $txt_required . ' ' . $price_data . '  ' . $ajax_upload_data  . ' /></span></label>';
	                echo '<input type="hidden" class="wcpa_file_hidden"  name="' . $name . '_ajax"  value="' . $default_value . '" ' . $validation . ' />';
	                echo '<div class="wcpa_progress" style="' . (empty($default_value) ? 'width:0;' : 'width:100%;') . '" ><span>' . __('Remove', 'wcpa-text-domain') . '</span></div>';
	            }
	        } else if ($custom_style) {
	            echo '<label class="wcpa_file_outer" for="sg-' . $name . '"><span class="wcpa_file_name">' . $placeholder . '</span><span class="wcpa_file_wrap" >' . wcpa_get_option('file_button_text', __('Choose File', 'wcpa-text-domain'), true) . '<input type="file"  id="sg-' . $name . '"  ' . $className . ' name="' . $name . $multiple_fileName_postfix . '"  ' . $maxlength . ' ' . $txt_required . ' ' . $price_data . ' '.$multipleFile.' ' . $max_file_count . ' ' . $validation . ' /></span></label>';
	        } else {
	            echo '<input type="file"  id="' . $name . '" ' . $placeholder . ' ' . $className . ' name="' . $name . $multiple_fileName_postfix . '"  ' . $maxlength . ' ' . $txt_required . ' ' . $price_data . '  ' . $ajax_upload_data . ' '.$multipleFile.' ' . $max_file_count . ' ' . $validation . ' />';
	        }
	        if (
	            isset($v->showUploadPreview) && 
	            $v->showUploadPreview && 
	            !( $droppable ) &&
	            !($ajax_upload && $multiple_enabled)
	        ) {
	            echo '<div class="wcpa_upload_preview"></div>';
	        }
	    }


		public function price_summary_box()
		{
			if (!$this->product) {
				global $product;
				$this->product = $product;
			}
			$html = '';

			if ($this->settings['disp_summ_show_option_price'] && $this->settings['pric_overide_base_price'] === false && $this->settings['pric_overide_base_price_if_gt_zero'] === false && $this->settings['pric_overide_base_price_fully'] === false) {
				$html .= '<li class="wcpa_options_total">
					<span>' . $this->settings['options_total_label'] . ':'
					. ' </span><span class="wcpa_price_outer ">' . wcpa_price(0) . '</span></li>';
			}
			if ($this->settings['disp_summ_show_product_price'] && $this->settings['pric_overide_base_price'] === false && $this->settings['pric_overide_base_price_if_gt_zero'] === false && $this->settings['pric_overide_base_price_fully'] === false) {

				$html .= ' <li class="wcpa_product_total">
					<span>' . $this->settings['options_product_label'] . ':'
					. ' </span><span class="wcpa_price_outer "> ' . ((wcpa_get_option('show_strike_product_price', false) && $this->product->is_on_sale()) ? '<span class="wcpa_price_strike_outer">' . wcpa_price(wcpa_get_price_shop($this->product, [], true), 0, [], 'wcpa_price_strike') . '</span>' : '') . ' ' . wcpa_price(wcpa_get_price_shop($this->product)) . '</span></li>';
			}
			if ($this->settings['disp_summ_show_total_price']) {
				$html .= ' <li class="wcpa_total">
					<span>' . $this->settings['total_label'] . ': </span><span class="wcpa_price_outer ">' . wcpa_price(0) . '</span></li>';
			}
			if ($html !== '') {
				echo '<div class="wcpa_price_summary"><ul>';
				echo $html;
				echo ' </ul></div>';
			}

			$hook = get_wcpa_display_hook('price_summary');
			remove_action($hook[0], array($this, 'price_summary_box'), $hook[1]);
		}


    public function get_wcpa_products()
    {
        global $wpdb;
        $pro_ids_main = get_transient('salesgen_wcpa_products');

        if (false === $pro_ids_main) {

            $post_ids_main = array('full' => [], 'direct_purchasable' => []);

            $post_ids_main['direct_purchasable'] = get_posts(
                array(
                    'fields' => 'ids',
                    'post_type' => WCPA_POST_TYPE,
                    'posts_per_page' => -1,
                    'meta_query' => array(
                        'relation' => 'OR',
                        array(
                            'key' => 'wcpa_drct_prchsble',
                            'value' => true,
                            'type' => 'BOOLEAN',
                        ),
                    ),
                )
            );

            $post_ids_main['full'] = get_posts(
                array(
                    'fields' => 'ids',
                    'post_type' => WCPA_POST_TYPE,
                    'posts_per_page' => -1,
                )
            );

            foreach ($post_ids_main as $key => $post_ids) {
                if ($post_ids && count($post_ids)) {

                    $query = "SELECT
distinct object_id from $wpdb->term_relationships
 where term_taxonomy_id"
                    . " in (select tr.term_taxonomy_id from $wpdb->term_relationships as tr left join $wpdb->term_taxonomy as tt on(tt.term_taxonomy_id=tr.term_taxonomy_id) where tr.object_id in (" . implode(',', $post_ids) . ")"
                        . "and  tt.taxonomy = 'product_cat')";

                    $pro_ids = $wpdb->get_col($query);

                    $exluded_ids = get_posts(
                        array(
                            'fields' => 'ids',
                            'post_type' => 'product',
                            'numberposts' => -1,
                            'meta_query' => array(
                                array(
                                    'key' => 'wcpa_exclude_global_forms',
                                    'value' => '1',
                                    'type' => 'BOOLEAN',
                                ),
                            ),
                        )
                    );

                    $pro_ids = array_diff($pro_ids, $exluded_ids);

                    $temp = array_reduce($post_ids, function ($a, $b) {
                        return $a . " `meta_value` LIKE '%:$b;%' OR";
                    });
                    $temp .= trim($temp, 'OR');
                    $pro_ids2 = $wpdb->get_col("SELECT post_id  from $wpdb->postmeta WHERE meta_key = '" . WCPA_PRODUCT_META_KEY . "'");

                    if ($pro_ids2) {
                        $pro_ids2 = array_map('intval', $pro_ids2);

                        $pro_ids = array_unique(array_merge($pro_ids, $pro_ids2));
                    }
                } else {
                    $pro_ids = array();
                }
                $pro_ids_main[$key] = $pro_ids;
            }
//            $pro_ids_main['offset'] = $offset;
            set_transient('salesgen_wcpa_products', $pro_ids_main, 12 * HOUR_IN_SECONDS);
        }

        return $pro_ids_main;
    }

		public function __call($name, $arguments)
		{
			return null;
		}

	}
}