<?php

if (!defined('ABSPATH')) {
	exit;
}
use Acowebs\WCPA\Render;
use Acowebs\WCPA\Product;
use Acowebs\WCPA\Main;
use Acowebs\WCPA\Config;
use Acowebs\WCPA\Currency;
use Acowebs\WCPA\Discounts;
use Acowebs\WCPA\ML;
use Acowebs\WCPA\Form;
use Acowebs\WCPA\Options;
use Acowebs\WCPA\FormSettings;
if ( ! class_exists( 'SG_WCPA_Product' ) ) {

	/**
	 * Class SG_WCPA_Render
	 */
	class SG_WCPA_Product extends Product
	{
		public function __construct()
		{
			parent::__construct();

		}

		public function setCache($product_id, $data)
	    {
	        set_transient('wcpa_sg_fields_' . $product_id, $data, 24 * HOUR_IN_SECONDS);
	    }

		public function get_fields($product_id = false)
	    {
	        if (($this->data !== null && !empty($this->data))) {
	            return ['fields' => $this->data, 'config' => $this->formConf];
	        }

	        $cacheKey = $product_id;
	        if ($this->ml && $this->ml->is_active()) {
	            $cacheKey = $cacheKey . '_' . $this->ml->current_language();
	        }


	        if (false !== ($data = $this->getCache($cacheKey))) {
	            //return $data;
	        }


	        $this->form = new Form();
	        $this->form->init(); // as it depends wpml
	        $this->options = new Options();

	        $this->data = array();
	        //      $this->cart_error = WCPA_Front_End::get_cart_error($product_id); // need to recheck


	        $post_ids = $this->get_form_ids($product_id);

	        $prod = wc_get_product($product_id);

	        $this->formConf = [
	            'price_override' => '',

	            'enable_recaptcha' => false,
	            'bind_quantity' => false,
	            'quantity_bind_formula' => false,

	            'disp_summ_show_option_price' => false,
	            'disp_summ_show_product_price' => false,
	            'disp_summ_show_total_price' => false,
	            'disp_summ_show_fee' => false,
	            'disp_summ_show_discount' => false,

	            'summary_title' => false,
	            'options_total_label' => false,
	            'total_label' => false,
	            'options_product_label' => false,
	            'fee_label' => false,
	            'discount_label' => false,
	            'has_price' => false,
	            'has_quantity_formula' => false,

	        ];

	        $scripts = [
	            'file' => false,
	            'datepicker' => false,
	            'color' => false,
	            'select' => false,
	            'productGallery' => false,
	            'googlemapplace' => false,
	            'recaptcha' => false,
	        ];

	        $formulas = [];


	//		if ( Config::get_config( 'form_loading_order_by_date' ) === true ) {
	        $post_ids = array_filter($post_ids);//remove null/empty elements
	        if (is_array($post_ids) && count($post_ids)) {
	            $post_ids = get_posts(
	                array(
	                    'include' => $post_ids,
	                    'fields' => 'ids',
	                    'post_type' => Form::$CPT,
	                    'lang' => '', // deactivates the Polylang filter
	                    'posts_per_page' => -1,
	                    'orderby' => 'post__in'
	                )
	            );
	        }
	//		}

	//        $post_ids = $this->re_order_forms($post_ids, $product_id);

	        foreach ($post_ids as $id) {
	            if (get_post_status(
	                    $id
	                ) == 'publish') {  // need to check if this check needed as post_ids will be published posts only
	                $json_encoded = $this->form->get_form_meta_data($id);
	                $formulas = array_merge($formulas, $this->form->get_formulas($id));


	                $form_settings = new FormSettings($id);

	                foreach ($this->formConf as $key => $v) {
	                    if ($key == 'bind_quantity' && ($v === false || $v == '')) {
	                        $this->formConf['bind_quantity'] = $form_settings->get('bind_quantity');
	                        if ($this->formConf['bind_quantity']) {
	                            $this->formConf['quantity_bind_formula'] = $form_settings->get('quantity_bind_formula');
	                            if (empty($this->formConf['quantity_bind_formula']) || trim(
	                                    $this->formConf['quantity_bind_formula']
	                                ) == '') {
	                                $this->formConf['bind_quantity'] = false;
	                            }
	                        }
	                    } elseif ($v === false || $v === '') {
	                        // once it is set as true for a for, it must be true even if the product has multiple forms assigned
	                        $this->formConf[$key] = $form_settings->get($key);
	                    }
	                }


	                $form_rules = [
	                    'exclude_from_discount' => (Config::get_config('remove_discount_from_fields') ? true : $form_settings->get('exclude_from_discount')),

	                    'fee_label' => $form_settings->get('fee_label'),

	                    'disp_hide_options_price' => $form_settings->get('disp_hide_options_price'),
	                    'disp_show_section_price' => $form_settings->get('disp_show_section_price'),
	                    'disp_show_field_price' => $form_settings->get('disp_show_field_price'),

	                    'layout_option' => $form_settings->get('layout_option'),
	                    'pric_use_as_fee' => $form_settings->get('pric_use_as_fee'),
	                    'process_fee_as' => $form_settings->get('process_fee_as')
	                ];


	                /**
	                 * @var keep track of connected global forms, remove if already imported to avoide infinite loop
	                 */
	                $globalForms = []; //
	                $rowsToResetIndex = [];
	                if ($json_encoded && is_object($json_encoded)) {
	                    $sectionReIterate = true;

	                    while ($sectionReIterate) {
	                        $sectionReIterate = false;
	                        foreach ($json_encoded as $sectionKey => $section) {
	                            $reIterate = true;
	                            if (!isset($rowsToResetIndex[$sectionKey])) {
	                                $rowsToResetIndex[$sectionKey] = [];
	                            }
	                            while ($reIterate) {
	                                $reIterate = false;


	                                /**
	                                 * Form rules&form_id will be taken from the parent form only, will not be considering form rules from other global form fields added in this form,
	                                 */
	                                $section->extra->form_id = $id;
	                                $section->extra->form_rules = $form_rules;

	                                $layOut = isset($section->extra->layout_option) ? $section->extra->layout_option : false;
	                                if ($layOut == false || $layOut == null || $layOut == 'default') {
	                                    $layOut = $form_rules['layout_option'];
	                                }
	                                $section->extra->layout_option = $layOut;

	                                $this->process_cl($section->extra, $prod);

	                                foreach ($section->fields as $rowIndex => $row) {
	                                	
	                                    foreach ($row as $colIndex => $field) {
	                                        if (isset($field->active) && $field->active === false) {
	                                            //TODO remove empty row, or section
	                                            unset($section->fields[$rowIndex][$colIndex]);
	                                            $rowsToResetIndex[$sectionKey][] = $rowIndex;
	                                            continue;
	                                        }

	                                        switch ($field->type) {
	                                        	case 'image-group':
	                                        	case 'color-group':
	                                        	case 'radio-group':
	                                        	case 'checkbox-group':
	                                        		$field->type = 'select';
	                                        		break;
	                                        }

	                                        if ($field->type == 'formselector') {
	                                            $globalFormFields = $this->getGlobalFormFields($field);
	                                            if ($globalFormFields) {
	                                                if ($field->type == 'formselector' && isset($field->form_id) && is_numeric($field->form_id)) {
	                                                    $formulas = array_merge($formulas, $this->form->get_formulas($field->form_id));
	                                                }

	                                                if (!in_array($globalFormFields['key'], $globalForms)) {
	                                                    $globalForms[] = $globalFormFields['key'];

	                                                    if ($globalFormFields['type'] == 'fields') {
	                                                        /**
	                                                         * If the global form fields are just fields without sections, just append fields
	                                                         */
	                                                        array_splice(
	                                                            $section->fields[$rowIndex],
	                                                            $colIndex,
	                                                            1,
	                                                            $globalFormFields['fields']
	                                                        );
	                                                        $newArr = fix_cols($section->fields[$rowIndex]);
	                                                        array_splice($section->fields, $rowIndex, 1, $newArr);
	                                                    } elseif ($globalFormFields['type'] == 'section') {
	                                                        /**
	                                                         *   if global form has multiple sections,
	                                                         * Split the main section here, and insert the sections after this,
	                                                         *  parent section will be split as two parts , part 1 will be as above, and part 2 will be appended after the globally added section
	                                                         */

	                                                        /** @var  $part1 split the fields as part 1 till the current row index */
	                                                        $part1 = array_slice($section->fields, 0, $rowIndex);

	                                                        /** split the current row if it has multiple columns, $part1Col, is the first split till current column */
	                                                        $part1Col = array_slice(
	                                                            $section->fields[$rowIndex],
	                                                            0,
	                                                            $colIndex
	                                                        );
	                                                        if (count($part1Col) > 0) {
	                                                            /* if the is a column , insert it as a new row  */
	                                                            $part1[] = $part1Col;
	                                                        }

	                                                        /** @var  $part1Col2 split columns after current column, and prepend it to the part2 */
	                                                        $part1Col2 = array_slice(
	                                                            $section->fields[$rowIndex],
	                                                            $colIndex + 1,
	                                                            null
	                                                        );

	                                                        // exclude field in between which will be the formselector
	                                                        $part2 = array_slice($section->fields, $rowIndex + 1, null);
	                                                        if (count($part1Col2) > 0) {
	                                                            $part1Col2[0] = $part1Col2;
	                                                            $part2 = array_merge($part1Col2, $part2);
	                                                        }

	                                                        if (count($part1) > 0) {
	                                                            $section->fields = $part1;
	                                                        }

	                                                        if (count($part2) > 0) {
	                                                            $_section = clone $section;
	                                                            $_section->extra = clone $section->extra;
	                                                            $newKey = $_section->extra->section_id . '_part2';
	                                                            $_section->extra->key = $newKey;
	                                                            $_section->extra->section_id = $newKey;
	                                                            $_section->fields = $part2;
	                                                        }


	                                                        $json_encoded_arr = (array)$json_encoded;
	                                                        $sectionsToAppend = (array)$globalFormFields['fields'];
	                                                        $split = array_search(
	                                                            $sectionKey,
	                                                            array_keys($json_encoded_arr)
	                                                        );

	                                                        if (count($part1) > 0 && count($part2) > 0) {

	                                                            $json_encoded_NewArr = array_merge(
	                                                                array_slice(
	                                                                    $json_encoded_arr,
	                                                                    0,
	                                                                    $split + 1,
	                                                                    true
	                                                                ),
	                                                                $sectionsToAppend,
	                                                                [$sectionKey . '_part2' => $_section],
	                                                                array_slice(
	                                                                    $json_encoded_arr,
	                                                                    $split + 1,
	                                                                    null,
	                                                                    true
	                                                                )
	                                                            );
	//                                                            $json_encoded_NewArr = array_slice(
	//                                                                    $json_encoded_arr,
	//                                                                    0,
	//                                                                    $split + 1,
	//                                                                    true
	//                                                                ) +
	//                                                                $sectionsToAppend +
	//                                                                [$sectionKey . '_part2' => $_section] +
	//                                                                array_slice(
	//                                                                    $json_encoded_arr,
	//                                                                    $split + 1,
	//                                                                    null,
	//                                                                    true
	//                                                                );
	                                                        } elseif (count($part1) > 0 && count($part2) == 0) {
	//                                                            $json_encoded_NewArr = array_slice(
	//                                                                    $json_encoded_arr,
	//                                                                    0,
	//                                                                    $split + 1,
	//                                                                    true
	//                                                                ) +
	//                                                                $sectionsToAppend +
	//                                                                array_slice(
	//                                                                    $json_encoded_arr,
	//                                                                    $split + 1,
	//                                                                    null,
	//                                                                    true
	//                                                                );

	                                                            $json_encoded_NewArr = array_merge(array_slice(
	                                                                $json_encoded_arr,
	                                                                0,
	                                                                $split + 1,
	                                                                true
	                                                            ), $sectionsToAppend, array_slice(
	                                                                $json_encoded_arr,
	                                                                $split + 1,
	                                                                null,
	                                                                true
	                                                            ));

	                                                        } elseif (count($part1) == 0 && count($part2) == 0) {
	                                                            $json_encoded_NewArr = array_merge(array_slice(
	                                                                $json_encoded_arr,
	                                                                0,
	                                                                $split,
	                                                                true
	                                                            ),
	                                                                $sectionsToAppend,
	                                                                array_slice(
	                                                                    $json_encoded_arr,
	                                                                    $split + 1,
	                                                                    null,
	                                                                    true
	                                                                )
	                                                            );
	                                                        } elseif (count($part1) == 0 && count($part2) > 0) {
	                                                            $json_encoded_NewArr = array_merge(array_slice(
	                                                                $json_encoded_arr,
	                                                                0,
	                                                                $split,
	                                                                true
	                                                            ), $sectionsToAppend,
	                                                                [$sectionKey . '_part2' => $_section],
	                                                                array_slice(
	                                                                    $json_encoded_arr,
	                                                                    $split + 1,
	                                                                    null,
	                                                                    true
	                                                                )
	                                                            );
	//                                                            $json_encoded_NewArr = array_slice(
	//                                                                    $json_encoded_arr,
	//                                                                    0,
	//                                                                    $split,
	//                                                                    true
	//                                                                ) +
	//                                                                $sectionsToAppend +
	//                                                                [$sectionKey . '_part2' => $_section] +
	//                                                                array_slice(
	//                                                                    $json_encoded_arr,
	//                                                                    $split,
	//                                                                    null,
	//                                                                    true
	//                                                                );
	                                                        }

	//                                                            $json_encoded_NewArr = array_slice($json_encoded_arr, 0, $split, true) +
	//                                                                $sectionsToAppend + array_slice($json_encoded_arr, $split, null, true);
	                                                        $json_encoded = (object)$json_encoded_NewArr;

	                                                        $sectionReIterate = true;
	                                                        break;
	                                                    }

	                                                    $reIterate = true;
	                                                    break;
	                                                } else {
	                                                    array_splice($section->fields[$rowIndex], $colIndex, 1);
	                                                }
	                                            } else {
	                                                array_splice($section->fields[$rowIndex], $colIndex, 1);
	                                            }
	                                        }

	                                        $this->find_price_dependency($field, $section->extra->form_id);
	                                        /** TODO  */
	                                        $this->update_global_options($field);
	                                        $this->replace_custom_fields($field, $prod);
	                                        $this->process_cl($field, $prod);
	                                        $this->processFields($field, $section->extra->form_id);
	                                        $this->setTranslationKeys($field);

	                                        $this->findScriptsRequired($field, $scripts);

	                                        if (!$this->formConf['has_price']) {
	                                            $this->formConf['has_price'] = true;
	                                        }
	                                    }
	                                    if ($reIterate || $sectionReIterate) {
	                                        break;
	                                    }
	                                }
	                                if ($sectionReIterate) {
	                                    break;
	                                }
	                            }
	                            if ($sectionReIterate) {
	                                break;
	                            }
	                        }
	                    }
	                    // check for external forms


	                    //   $json_encoded = $this->appendGlobalForm($json_encoded);
	                    /**
	                     * resetting array index when an column removed from row
	                     * @var  $rowIndexes
	                     */
	                    foreach ($rowsToResetIndex as $sec => $rowIndexes) {
	                        $resetSecFieldsIndex = false;
	                        foreach ($rowIndexes as $rowIndex) {
	                            if (isset($json_encoded->{$sec}->fields[$rowIndex])) {
	                                $json_encoded->{$sec}->fields[$rowIndex] = array_values(
	                                    $json_encoded->{$sec}->fields[$rowIndex]
	                                );
	                                if (count($json_encoded->{$sec}->fields[$rowIndex]) == 0) {
	                                    unset($json_encoded->{$sec}->fields[$rowIndex]);
	                                    $resetSecFieldsIndex = true;
	                                }
	                            }
	                        }
	                        if ($resetSecFieldsIndex) {
	                            $json_encoded->{$sec}->fields = array_values($json_encoded->{$sec}->fields);
	                        }
	                    }
	                    $this->data = array_merge($this->data, (array)$json_encoded);
	                }
	            }
	        }

	//            if ($bind_quantity) {
	//                if ($matches = $this->check_field_price_dependency($quantity_bind_formula)) {
	//                    foreach ($matches as $match) {
	//                        if (!isset($this->price_depends[$match])) {
	//                            $this->price_depends[$match] = array();
	//                        }
	//                        if (isset($v->elementId)) {
	//                            if (!in_array($v->elementId, $this->price_depends[$match])) {
	//                                $this->price_depends[$match][] = $v->elementId;
	//                            }
	//                        }
	//                    }
	//                }
	//            }
	        $totalFieldsCount = 0;
	        if ($this->data !== null) {
	            $this->data = (object)$this->data;
	            $totalFieldsCount = $this->map_dependencies();
	        }

	        if ($this->formConf['enable_recaptcha']) {
	            $scripts['recaptcha'] = true;
	        }

	        foreach ($formulas as $key => $f) {
	            $formulas[$key] = $this->replace_custom_field($f, $prod);
	        }


	        if (strpos(json_encode($this->data), "{quantity}") !== false || strpos(json_encode($formulas), "{quantity}") !== false) {
	            $this->formConf['has_quantity_formula'] = true;
	        }


	        $data = [
	            'fields' => $this->data,
	            'config' => $this->formConf,
	            'scripts' => $scripts,
	            'formulas' => $formulas,
	            'fieldsCount' => $totalFieldsCount
	        ];
	        $this->setCache($cacheKey, $data);

	        return $data;

	    }

	    public function getCache($product_id)
	    {
	        return get_transient('wcpa_sg_fields_' . $product_id);
	    }

	}
}