<?php

if (!defined('ABSPATH')) {
	exit;
}
use Acowebs\WCPA\Render;
use Acowebs\WCPA\Product;
use Acowebs\WCPA\Main;
use Acowebs\WCPA\Config;
use Acowebs\WCPA\Currency;
use Acowebs\WCPA\Discounts;
if ( ! class_exists( 'SG_WCPA_Render' ) ) {

	/**
	 * Class SG_WCPA_Render
	 */
	class SG_WCPA_Render extends Render
	{

		public function __construct()
	    {
	        $this->token = WCPA_TOKEN;

	        
	    }
		function emptyObj($obj)
		{
		    foreach ($obj as $prop) {
		        return false;
		    }

		    return true;
		}

		public function render_product_form( $product_id = false)
	    {
	//        if (!$this->product) {
	        if ($product_id) {
	            $product = wc_get_product($product_id);
	        } else {
	            global $product;
	        }
	        if (!is_a($product, 'WC_Product')) {
						
						return;
	        }
					
	        $product_id = $product->get_id();
	        $this->product = $product;
	        $this->product_id = $product_id;
	//        }

	        $wcpaProduct = new SG_WCPA_Product();

	        $data = $wcpaProduct->get_fields($this->product_id);


	        if ($data['fields'] && !$this->emptyObj($data['fields'])) {
	            /** checking fields not empty */
	            $fields = $data['fields'];


	            if (isset(Main::$cartError[$this->product_id]) && Main::$cartError[$this->product_id]) {
	                $this->cartError = true;
	            }


	            $this->processFields($fields);


	//            $currency = new Currency();

	            $cartEdit = $this->checkCartEdit($fields);
	            $loadMapApi = false;
	            if ($data['scripts']) {
	                foreach ($data['scripts'] as $tag => $status) {
	                    if ($status) {
	                        if ($tag == 'googlemapplace') {
	                            $loadMapApi = true;
	                        } else {

	                            wp_enqueue_script($this->token . '-' . $tag);

	                        }
	                    }
	                }
	            }

	            wp_enqueue_script($this->token . '-front');
	            if ($loadMapApi) {
	                wp_enqueue_script($this->token . '-googlemapplace');
	            }


	            $tax_rate = $this->getTaxRate($this->product);

	            $design = Config::get_config('active_design', false);

	            $wcpaData = [
	                'product' => $this->getProductData(),
	                'fields' => $data['fields'],
	                'config' => $data['config'],
	                'mc_unit' => Currency::getConUnit(),
	                'tax_rate' => $tax_rate,
	                'tax_rate_real' => $this->getRealTaxRate($this->product),
	                'discount' => Discounts::getDiscountRule($this->product),
	                'design' => $design['common'],
	                'formulas' => $data['formulas'],
	                'clones' => $cartEdit['clones'],
	                'cartKey' => $cartEdit['cart_key']

	            ];

	            if ($isRest) { // REST api request
	                return [
	                    'wcpaData' => $wcpaData
	                ];
	            }
	//
	//echo '<textarea>'.htmlspecialchars(wp_json_encode($wcpaData), ENT_QUOTES).'</textarea>';

	            $fieldsCount = min(5,isset($data['fieldsCount'])?$data['fieldsCount']:3);

	            $html = '<div class="wcpa_form_outer" data-wcpa-version="5.x" 
	           data-gt-translate-attributes=\'[{"attribute":"data-wcpa", "format":"json"}]\'
	            data-product=\'' . htmlspecialchars(wp_json_encode(['wc_product_price' => 'backward_comp_dont_use']), ENT_QUOTES) . '\'
					 data-wcpa=\'' . htmlspecialchars(wp_json_encode($wcpaData), ENT_QUOTES) . '\' >
				 <div class="wcpa_skeleton_loader_area">' . str_repeat(
	                    '<div class="wcpa_skeleton_loader">
					 <div class="wcpa_skeleton_label"></div>
					 <div class="wcpa_skeleton_field"></div>
				 </div>',
	                    $fieldsCount
	                ) . '
				
				</div>
				</div>';
	            return $html;
	        }
	    }


		/** return tax rate for addon, it will return 1 if the product is not taxable
		 * @param $product
		 * @param false $isCart
		 * @return float|int|string
		 */
		function getTaxRate($product, $isCart = false)
		{
		    if (!$product->is_taxable()) {
		        return 1;
		    }

		    $tax_for_addon = Config::get_config('tax_for_addon');

		    $rate = 1;
		    if ($tax_for_addon == 'product_tax') {
		        if ($isCart) {
		            if (WC()->cart && WC()->cart!==null && WC()->cart->display_prices_including_tax()) {
		                $rate = wc_get_price_including_tax(
		                    $product,
		                    array(
		                        'qty' => 1,
		                        'price' => 1,
		                    )
		                );
		            } else {
		                $rate = wc_get_price_excluding_tax(
		                    $product,
		                    array(
		                        'qty' => 1,
		                        'price' => 1,
		                    )
		                );
		            }
		        } else {
		            if ('incl' === get_option('woocommerce_tax_display_shop')) {
		                $rate = wc_get_price_including_tax(
		                    $product,
		                    array(
		                        'qty' => 1,
		                        'price' => 1,
		                    )
		                );
		            } else if ('excl' === get_option('woocommerce_tax_display_shop')) {
		                $rate = wc_get_price_excluding_tax(
		                    $product,
		                    array(
		                        'qty' => 1,
		                        'price' => 1,
		                    )
		                );
		            }
		        }
		        if ($rate !== false) {
		            return $rate;
		        }
		    } else if ($tax_for_addon !== 'no_tax') {

		        $base_tax_rates = WC_Tax::get_rates($tax_for_addon);
		        $rate = WC_Tax::calc_tax(1, $base_tax_rates, false);
		        $rate = array_sum($rate);
		        if ($isCart) {
		            if (WC()->cart && WC()->cart!==null && WC()->cart->display_prices_including_tax()) {
		                if (wc_prices_include_tax()) {
		                    return 1;
		                } else {
		                    return 1 + $rate;
		                }


		            } else {
		                if (wc_prices_include_tax()) {
		                    return 1 - $rate;
		                } else {
		                    return 1;
		                }

		            }
		        } else {
		            if ('incl' === get_option('woocommerce_tax_display_shop')) {
		                if (wc_prices_include_tax()) {
		                    return 1;
		                } else {
		                    return 1 + $rate;
		                }

		            } else if ('excl' === get_option('woocommerce_tax_display_shop')) {
		                if (wc_prices_include_tax()) {
		                    return 1 - $rate;
		                } else {
		                    return 1;
		                }

		            }
		        }
		        if ($rate !== false) {
		            return $rate;
		        }
		    }

		    return 1;
		}



		function getRealTaxRate($product, $isCart = false)
		{
		    if (!$product->is_taxable()) {
		        return 1;
		    }

		    $tax_for_addon = Config::get_config('tax_for_addon');

		    if ($tax_for_addon == 'product_tax') {
		        $tax_rates = WC_Tax::get_rates($product->get_tax_class());
		        $rate = WC_Tax::calc_tax(1, $tax_rates, false);
		        $rate = array_sum($rate);
		        if ($rate !== false) {
		            return $rate;
		        }
		    } else if ($tax_for_addon !== 'no_tax') {

		        $base_tax_rates = WC_Tax::get_rates($tax_for_addon);
		        $rate = WC_Tax::calc_tax(1, $base_tax_rates, false);
		        $rate = array_sum($rate);
		        if ($rate !== false) {
		            return $rate;
		        }
		    }

		    return 0;

		}

	}
}