<?php

if ( !function_exists('sg_count_inputs') ) {

	function sg_count_inputs( $text ) {
		$inputs = array("<select", "<input", "<textarea");
		$total  = 0;

		foreach ($inputs as $input) {
			$total += substr_count( $text, $input);
		}

		//check if product has product addons field
		if ( strpos($text, 'wcpa_form_outer') !== false ) {
			$total = substr_count( $text, 'wcpa_form_item');
			$disabled = substr_count( $text, 'style="display:none;"');

			$total = $total - $disabled;

		}

		return $total;
	}	
}

if ( !function_exists('sg_get_product_category_ids') ) {
	function sg_get_product_category_ids( $product_id ) {
		$terms 		= wp_get_post_terms( $product_id, 'product_cat' );
		$cats_array = array();

		foreach ( $terms as $term ) {
			$cats_array[] = $term->term_id;
		}

		return $cats_array;
	}
}

if ( !function_exists('sg_get_product_category_slug') ) {
	function sg_get_product_category_slug( $product_id ) {
		$terms 		= wp_get_post_terms( $product_id, 'product_cat' );
		$cats_array = array();

		foreach ( $terms as $term ) {
			$cats_array[] = $term->slug;
		}

		return $cats_array;
	}
}

if ( !function_exists('sg_get_product_tags_slug') ) {
	function sg_get_product_tags_slug( $product_id ) {
		$terms 		= wp_get_post_terms( $product_id, 'product_tag' );
		$tags_array = array();
		//Select only the category which doesn't have any children
		foreach ( $terms as $term ) {
			$tags_array[] = $term->slug;
			return $tags_array;
		}

		return $tags_array;
	}
}
?>