<?php

/**
 * Render classs for frontend
 */
class SG_UB_Render{
	
	public static function fifu_product_image( $product_id ) {
		global $product;

		$html = '';
		//compability with fifu_image_url
		$fifu_image_url = get_post_meta($product_id, 'fifu_image_url', true);
		

		if ( !empty($fifu_image_url) ) {
			
			$size_class = $size;

			if ( is_array( $size_class ) ) {
				$size_class = implode( 'x', $size_class );
			}

			$attr = array(
				'src'   => $fifu_image_url,
				'class' => "attachment-$size_class size-$size_class",
			);

			$html = rtrim( "<img " );

			foreach ( $attr as $name => $value ) {
				$html .= " $name=" . '"' . $value . '"';
			}

			$html .= ' />';

		}

		return $html;
	}

	public static function product_image( $size = 'woocommerce_thumbnail', $product_obj = null ) {
		global $product;
		$_product   = $product_obj != null? (is_object($product_obj)? $product_obj : wc_get_product($product_obj)) : $product;	
		$html       = $_product ? $_product->get_image( $size, array('class' => 'sgub-product-image sgub-product-image-main') ) : '';

		return $html;
	}

	public static function cross_sell_display( $products = array(), $variants = array(), $args = array()) {

		$class_wrp = isset($args['class_wrp'])? $args['class_wrp'] : 'sg-upsell-cart-content-items';
		$hide_options = isset($args['hide_options'])? $args['hide_options'] : 'no';
		
		$heading = isset($args['heading'])? $args['heading'] : '';
		$cols_classes = isset($args['cols_classes'])? $args['cols_classes'] : 'large-columns-3 medium-columns-3 small-columns-2';
		$popup_items = '';

		if ( count( $products ) > 0 ) {
					
			$popup_items .= '<div class="sg-upsell-cart-content-items">';

			$popup_items .= !empty($heading)? '<h3 class="sg-upsell-lightbox-heading-frequently">'. $heading .'</h3>' : '';
			$popup_items .= '<ul class="salesgen-upsell-cart-items row row-small '.$cols_classes.'">';

			$cart_url = wc_get_cart_url() ;
			
			foreach ( $products as $prod ) {

				//$attributes_empty = rawurlencode(json_encode($prod['attributes_empty'], JSON_FORCE_OBJECT));

				$html_attrs = array();

				$html_attrs[] = 'data-parent="' . $prod['parent_id'] . '"';
				$html_attrs[] = 'data-id="' . $prod['id'] . '"';
				$html_attrs[] = 'data-price="' . $prod['price'] . '"';
				$html_attrs[] = 'data-base-price="' . $prod['price'] . '"';
				$html_attrs[] = 'class="salesgen-upsell-popup-item-list product-small type-product product col"';

				if ( $prod['product_type'] == 'variable' ) {
					$html_attrs[] = "data-variants='" .json_encode($variants[ $prod['id'] ], JSON_FORCE_OBJECT) ."'";	
					$html_attrs[] = "data-default_attributes='" .json_encode($prod['default_attributes'], JSON_FORCE_OBJECT) ."'";	
				}

				$popup_items .= '<li '. implode(' ', $html_attrs).'>';
				$popup_items .= '<a href="' . $prod['url'] .'">' . $prod['thumbnail'] .'</a>';
				
				$popup_items .= '<div class="salesgen-upsell-item-info">';
				$popup_items .= '<form class="variations_form cart sgub" action="'. $cart_url .'" method="post" enctype="multipart/form-data">
';
				if ( $prod['product_type'] == 'variable' ) {
					$popup_items .= '<input name="variation_id" value="" type="hidden"/>';	
				}
				$popup_items .= '<input type="hidden" name="product_id" value="' . $prod['parent_id'] .'">';
				$popup_items .= '<input type="hidden" name="add-to-cart" value="' . $prod['parent_id'] .'">';
				$popup_items .= '<input type="hidden" name="quantity" value="1">';
				$popup_items .= '<p class="name product-title woocommerce-loop-product__title"><a href="'.$prod['url'] .'">' . $prod['default_name'] .'</a></p>';
				$popup_items .= '<div class="sgbmsm-price-checkbox">' . $prod['price_html'] . '</div>';	
				// add select options button
				$popup_items .= '<div class="sgbmsm-price-checkbox-wrp active-select-options"><a  class="salesgen-select-options button" href="#"> Select Options</a>';
				

				$popup_items .= '<div class="salesgen-upsell-options">';

				if ( $hide_options != 'yes' ) {
					$popup_items .= $prod['child_html'];
				}

				$popup_items .= '</div></div>';

				if ( $hide_options != 'yes' ) {
					$popup_items .= '<button type="submit" class="sg_single_add_to_cart_button button alt">Add to cart</button>';
				}
				/* else {
					$popup_items .= '<a href="'.$prod['url'] .'" class="button alt">Add to cart</a>';
				}
				*/
				
				$popup_items .= '</form></div></li>';
			}

			$popup_items .= '</ul></div>';

		}

		ob_start();
		

		echo $popup_items;
		$popup_items_html = ob_get_contents();
		ob_end_clean();
		return $popup_items_html;
	}


	public static function related_products_display( $products = array(), $variants = array(), $args = array()) {

		$class_wrp = isset($args['class_wrp'])? $args['class_wrp'] : 'sg-upsell-cart-content-items';
		$hide_options = isset($args['hide_options'])? $args['hide_options'] : 'no';
		
		$heading = isset($args['heading'])? $args['heading'] : '';
		$cols_classes = isset($args['cols_classes'])? $args['cols_classes'] : 'large-columns-3 medium-columns-3 small-columns-2';
		$popup_items = '';

		if ( count( $products ) > 0 ) {
					
			$popup_items .= '<div class="sg-upsell-cart-content-items"'. " data-variants='" . rawurlencode(json_encode( $variants, JSON_FORCE_OBJECT )) . "'" . '>';

			$popup_items .= !empty($heading)? '<h3 class="sg-upsell-lightbox-heading-frequently">'. $heading .'</h3>' : '';
			$popup_items .= '<ul class="salesgen-upsell-related-items salesgen-upsell-cart-items row row-small '.$cols_classes.'">';

			$cart_url = wc_get_cart_url() ;
			
			foreach ( $products as $prod ) {

				$attributes_empty = rawurlencode(json_encode($prod['attributes_empty'], JSON_FORCE_OBJECT));

				$html_attrs = array();

				$html_attrs[] = 'data-parent="' . $prod['parent_id'] . '"';
				$html_attrs[] = 'data-id="' . $prod['id'] . '"';
				$html_attrs[] = 'data-price="' . $prod['price'] . '"';
				$html_attrs[] = 'data-base-price="' . $prod['price'] . '"';
				$html_attrs[] = 'class="salesgen-upsell-popup-item-list product-small type-product product col"';

				if ( $prod['product_type'] == 'variable' ) {
					$html_attrs[] = "data-variants='" .json_encode($variants[ $prod['id'] ], JSON_FORCE_OBJECT) ."'";	
					$html_attrs[] = "data-default_attributes='" .json_encode($prod['default_attributes'], JSON_FORCE_OBJECT) ."'";	
				}

				$popup_items .= '<li '. implode(' ', $html_attrs).'>';


				//$popup_items .= '<li data-parent="' . $prod['parent_id'] . '" data-attributes_empty="' . $attributes_empty . '" data-id="' . $prod['id'] . '" data-price="' . $prod['price'] . '" class="salesgen-upsell-popup-item-list product-small type-product product col">';
				$popup_items .= '<a href="' . $prod['url'] .'">' . $prod['thumbnail'] .'</a>';
				
				$popup_items .= '<div class="salesgen-upsell-item-info">';
				$popup_items .= '<form class="variations_form cart sgub" action="'. $cart_url .'" method="post" enctype="multipart/form-data">
';

				if ( $prod['product_type'] == 'variable' ) {
					$popup_items .= '<input name="variation_id" value="" type="hidden"/>';	
				}
				$popup_items .= '<input type="hidden" name="product_id" value="' . $prod['parent_id'] .'">';
				$popup_items .= '<input type="hidden" name="add-to-cart" value="' . $prod['parent_id'] .'">';
				$popup_items .= '<input type="hidden" name="quantity" value="1">';
				$popup_items .= '<p class="name product-title woocommerce-loop-product__title"><a href="'.$prod['url'] .'">' . $prod['default_name'] .'</a></p><div class="sgbmsm-price-checkbox">' . $prod['price_html'] . '</div>';
				// add select options button
				$popup_items .= '<div class="sgbmsm-price-checkbox-wrp active-select-options"><a  class="salesgen-select-options button" href="#"> Select Options</a>';
				$popup_items .= '<div class="salesgen-upsell-options">';
				if ( $hide_options != 'yes' ) {
					$popup_items .= $prod['child_html'];
				}

				$popup_items .= '</div></div>';

				if ( $hide_options != 'yes' ) {
					$popup_items .= '<button type="submit" class="sg_single_add_to_cart_button button alt">Add to cart</button>';
				}

				/* else {
					$popup_items .= '<a href="'.$prod['url'] .'" class="button alt">Add to cart</a>';
				}
				*/
				
				$popup_items .= '</form></div></li>';
			}

			$popup_items .= '</ul></div>';

		}

		ob_start();
		

		echo $popup_items;
		$popup_items_html = ob_get_contents();
		ob_end_clean();
		return $popup_items_html;
	}

	public static function css( $field, $options ) {

		$custom_css = '';

		$data 		= explode( '|', $field['css'] );

		if ( $data[1] == 'background-color') {
			$background_colors[ $data[0] ] = $options[ $field['id'] ];
		}

		if ( $data[1] == 'background-pattern') {

			$custom_css .= $data[0].'{background-position: top center;background-repeat:repeat;';

			//is has background color
			if ( isset($background_colors[ $data[0] ]) ) {
				$overlay = SG_UB_Render::hex2rgba($background_colors[ $data[0] ], 0.4);

				$custom_css .= 'background-image:linear-gradient('.$overlay.', '.$overlay.'), ';
			} else $custom_css .= 'background-image:';

			$custom_css .= 'url("'. $field['path']. $options[ $field['id'] ] . '.png")' . (isset($data[2])? '!important': '').'}';

			return $custom_css;
		}

		if ( $data[1] == 'background-upload') {

			$custom_css .= $data[0].'{background-position: top center;background-repeat:repeat;';

			//is has background color
			if ( isset($background_colors[ $data[0] ]) ) {
				$overlay = SG_UB_Render::hex2rgba($background_colors[ $data[0] ], 0.4);

				$custom_css .= 'background-image:linear-gradient('.$overlay.', '.$overlay.'), ';
			} else $custom_css .= 'background-image:';

			$data_image = explode('##', $options[ $field['id'] ]);

			$custom_css .= 'url("'. $data_image[0] . '")' . (isset($data[2])? '!important': '').'}';

			return $custom_css;
		}

		return $data[0].'{'.$data[1].':'. $options[ $field['id'] ] . (isset($data[2])? '!important': '').'}';
	}

	public static function hex2rgba($color, $opacity = false) {

		$default = 'rgb(0,0,0)';
	
		//Return default if no color provided
		if(empty($color))
			  return $default; 
	
		//Sanitize $color if "#" is provided 
			if ($color[0] == '#' ) {
				$color = substr( $color, 1 );
			}
	
			//Check if color has 6 or 3 characters and get values
			if (strlen($color) == 6) {
					$hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
			} elseif ( strlen( $color ) == 3 ) {
					$hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
			} else {
					return $default;
			}
	
			//Convert hexadec to rgb
			$rgb =  array_map('hexdec', $hex);
	
			//Check if opacity is set(rgba or rgb)
			if($opacity){
				if(abs($opacity) > 1)
					$opacity = 1.0;
				$output = 'rgba('.implode(",",$rgb).','.$opacity.')';
			} else {
				$output = 'rgb('.implode(",",$rgb).')';
			}
	
			//Return rgb(a) color string
			return $output;
	}
}
?>