<?php
/**
 * Settings fields
 */
class SG_UB_Settings{

	private $assets_url = '';

	function __construct( $cfg = array() )
	{
		$this->assets_url = isset($cfg['assets_url'])? $cfg['assets_url'] : '';
	}
	
	public function options( $render = false ) {
		

		$settings = array(
			array(
				'id'   => 'salesgen_upsell_popup',
			),
			array(
				'id'       => 'salesgen_upsell_popup_enable',
				'default'  => 'no',
			),
			array(
				'id'       => 'salesgen_upsell_popup_limit',
				'default'  => '10',
			),
			array(
				'id'       => 'salesgen_upsell_bundle_discount_amount',
				'default'  => '',
			),
			array(
				'id'       => 'salesgen_upsell_popup_hide_items',
				'default'  => 'no',
			),
			array(
				'id'       => 'salesgen_upsell_popup_hide_options',
				'default'  => 'no',
			),
			
			array(
				'id'      => 'salesgen_upsell_popup_source',
				'default' => 'related',
			),
			array(
				'id'      => 'salesgen_upsell_popup_categories',
				'default' => array(),
			),
			
			array(
				'id'      => 'salesgen_upsell_popup_products_layout',
				'default' => 'default',
			),
			array(
				'id'      => 'salesgen_upsell_popup_heading_text',
				'default' => 'Frequently bought with [product_name]',
			),
			array(
				'id'      => 'salesgen_upsell_popup_add_action_label',
				'default' => 'Add To Cart',
			),
			
			array(
				'id'   => 'salesgen_upsell_bundle',
			),
			array(
				'id'       => 'salesgen_upsell_bundle_enable',
				'default'  => 'no',
			),
			array(
				'id'      => 'salesgen_upsell_bundle_position',
				'default' => 'woocommerce_after_add_to_cart_form',
			),
			array(
				'id'       => 'salesgen_upsell_bundle_priority',
				'default'  => '50',	
			),
			array(
				'id'       => 'salesgen_upsell_bundle_heading',
				'default'  => 'Frequently Bought Together:',
			),
			
			array(
				'id'      => 'salesgen_upsell_bundle_source',
				'default' => 'related',
			),
			array(
				'id'      => 'salesgen_upsell_bundle_categories',
				'default' => array(),
			),
			
			array(
				'id'      => 'salesgen_upsell_bundle_excludes_conditions_match',
				'default' => '',
			),
			array(
				'id'      => 'salesgen_upsell_bundle_excludes_conditions',
				'default' => '',
			),
			array(
				'id'       => 'salesgen_upsell_bundle_prefix',
				'default'  => '[FBT]',
			),
			array(
				'id'       => 'salesgen_upsell_bundle_hide_options_when',
				'default'  => '2',
			),
			array(
				'id'       => 'salesgen_upsell_bundle_layout',
				'default'  => '2',
			),
			
			array(
				'id'       => 'salesgen_upsell_bundle_add_action_label',
				'default'  => 'Add All To Cart',
			),
			
			array(
				'id'   => 'salesgen_buy_more_save_more',
			),
			array(
				'id'       => 'salesgen_bmsm_enable',
				'default'  => 'no',
			),
			
			array(
				'id'      => 'salesgen_bmsm_position',
				'default' => 'woocommerce_after_add_to_cart_form',
			),
			array(
				'id'       => 'salesgen_bmsm_priority',
				'default'  => '50',
			),
			array(
				'id'      => 'salesgen_bmsm_conditional',
				'default' => 'items',
			),
			array(
				'id'       => 'salesgen_buy_more_by_items',
				'default'  => '',		
			),
			array(
				'id'       => 'salesgen_buy_more_by_amounts',
				'default'  => '',	
			),
			array(
				'id'       => 'salesgen_bmsm_heading_enable',
				'default'  => 'yes',
			),
			array(
				'id'       => 'salesgen_bmsm_heading',
				'default'  => 'Buy More Save More!',
			),
			array(
				'id'       => 'salesgen_bmsm_subtitle',
				'default'  => 'It’s time to give thanks for all the little things.',
			),
			array(
				'id'      => 'salesgen_bmsm_heading_icon',
				'default' => 'thankyou',
			),
			array(
				'id'       => 'salesgen_bmsm_combie',
				'default'  => 'no',
			),
			
			array(
				'id'      => 'salesgen_bmsm_style',
				'default' => 'style1',
			),
			array(
				'id'       => 'salesgen_bmsm_hide_congrats',
				'default'  => 'no',
			),
			array(
				'id'       => 'salesgen_bmsm_categories',
				'default'  => array(),
			),			
			array(
				'id'       => 'salesgen_bmsm_hide_remain',
				'default'  => 'no',
			),
			array(
				'id'       => 'salesgen_bmsm_congrats_items',
				'default'  => 'Hooray! You got BIG discount <strong>[discount_amount]% OFF</strong> for [items_count] items in your cart!',
			),
			array(
				'id'       => 'salesgen_bmsm_congrats_subtotal',
				'default'  => 'Hooray! You got BIG discount <strong>[discount_amount]% OFF</strong>  on each products in your cart!',
			),
			array(
				'id'       => 'salesgen_bmsm_remain_items',
				'default'  => 'Just buy more [remain] & GET discount <strong>[discount_amount]% OFF</strong> on each products!',
			),
			array(
				'id'       => 'salesgen_bmsm_remain_subtotal',
				'default'  => 'Spend [remain] more and GET discount <strong>[discount_amount]% OFF</strong> on your order today!',
			),
			array(
				'id'   => 'salesgen_cart_upsell',
			),
			array(
				'id'       => 'salesgen_cart_upsell_enable',
				'default'  => 'no',
			),
			array(
				'id'      => 'salesgen_cart_upsell_source',
				'default' => 'related',
			),
			array(
				'id'      => 'salesgen_cart_upsell_categories',
				'default' => array(),
			),
			array(
				'id'       => 'salesgen_cart_upsell_hide_options',
				'default'  => 'no',
			),
			array(
				'id'      => 'salesgen_cart_upsell_excludes_conditions',
				'default' => '',
			),
			
			array(
				'id'       => 'salesgen_cart_upsell_limit',
				'default'  => '4',
			),
			array(
				'id'   => 'salesgen_thankyou_upsell',
			),
			array(
				'name'     => __( 'Enable', 'woocommerce' ),
				'id'       => 'salesgen_thankyou_upsell_enable',
				'type'     => 'checkbox',
				'default'  => 'no',
			),
			array(
				'id'      => 'salesgen_thankyou_upsell_source',
				'default' => 'related',
			),
			array(
				'id'      => 'salesgen_thankyou_upsell_categories',
				'default' => array(),
			),
			array(
				'id'       => 'salesgen_thankyou_upsell_hide_options',
				'default'  => 'no',
			),
			array(
				'id'      => 'salesgen_thankyou_upsell_excludes_conditions',
				'default' => '',
			),
			
			array(
				'id'       => 'salesgen_thankyou_upsell_limit',
				'default'  => '4',
			),
			array(
				'id'       => 'salesgen_related_enable',
				'default'  => 'no',
			),
			array(
				'id'      => 'salesgen_related_source',
				'default' => 'related',
			),
			array(
				'id'      => 'salesgen_related_categories',
				'default' => array(),
			),
			array(
				'id'       => 'salesgen_related_hide_options',
				'default'  => 'no',
			),
			array(
				'id'      => 'salesgen_related_excludes_conditions',
				'default' => '',
			),
			
			array(
				'id'       => 'salesgen_related_limit',
				'default'  => '4',
			),
			array(
				'id'       => 'salesgen_related_position',
				'default'  => 'woocommerce_after_single_product_summary',
			),
			array(
				'id'       => 'salesgen_related_priority',
				'default'  => '50',
			),
			array(
				'id'   => 'salesgen_advanced_coupons',
			),
			array(
				'id'       => 'salesgen_advanced_coupons_one',
				'default'  => 'no',
			),
			array(
				'id'   => 'salesgen_coupon_thankyou',
			),
			array(
				'id'       => 'salesgen_coupon_enable',
				'default'  => 'no',
			),
			array(
				'id'       => 'salesgen_bmsm_add_cart_button',
				'default'  => 'no',
			),
			array(
				'id'       => 'salesgen_bmsm_add_action_label',
				'default'  => 'Buy {quantity}',
			),
			
			array(
				'id'       => 'salesgen_coupon_amount',
				'default'  => '15',
			),
			array(
				'id'       => 'salesgen_coupon_code',
				'default'  => '',
			),
			
			array(
				'id'       => 'salesgen_coupon_email_subject',
				'default'  => 'Congrats! You unlocked special discount on {{site.name}}!',
			),
			array(					
				'id'       => 'salesgen_coupon_email_content',
				'default'  => 'Hi {{customer.name}},

Thank you for your order on our site {{site.name}}.

You just unlocked {{discount.amount}}% discount. Use code below to received {{discount.amount}}% OFF on next orders.

Code: {{discount.code}}

If you have any questions or concerns, please contact us by reply this email.

Happy a nice day!',
			),

			//color options

			array(
				'id'       => 'salesgen_upsell_product_title_color',
				'default'  => '#033c05',
				'css' => 'body .salesgen-upsell-item-list-heading-wrp>a, body .salesgen-upsell-popup-items li a|color'
			),
			array(
				'id'       => 'salesgen_upsell_product_regular_price_color',
				'default'  => '#033c05',
				'css' => '.sgbmsm-price-checkbox del .woocommerce-Price-amount.amount, .salesgen-total .woocommerce-Price-amount.amount|color'
			),
			array(
				'id'       => 'salesgen_upsell_product_sale_price_color',
				'default'  => '#f44336',
				'css' => 'body .sgbmsm-price-checkbox ins .woocommerce-Price-amount.amount, body .salesgen-total .woocommerce-Price-amount.amount, body .sgbmsm-price-checkbox>.woocommerce-Price-amount.amount|color'
			),
			array(
				'id'       => 'salesgen_upsell_add_action_color',
				'default'  => '#40b705',
				'css'	=> array(
					'body .salesgen-add-bundle.button, body .salesgen-upsell-item-info .sg_single_add_to_cart_button.button, span.salesgen-bmsm-items-add|background-color|1',
					'body .button.salesgen-select-options|border-color|1',
					'body .button.salesgen-select-options|color|1',
					'body .button.salesgen-select-options:hover|background-color|1'
				)
			),
			array(
				'id'       => 'salesgen_upsell_add_action_label_color',
				'default'  => '#FFFFFF',
				'css'	=> array(
					'body .salesgen-add-bundle.button, body .salesgen-upsell-item-info .sg_single_add_to_cart_button.button, span.salesgen-bmsm-items-add|color|1',
					'body .button.salesgen-select-options:hover|color|1',
				)
			),
			array(
				'id'       => 'salesgen_upsell_checkout_button_color',
				'default'  => '#2196f3',
				'css' => 'body .sg-modal-buttons .sg-proceed-checkout|background-color'
			),
			array(
				'id'       => 'salesgen_upsell_checkout_button_text_color',
				'default'  => '#FFFFFF',
				'css' => 'body .sg-modal-buttons .sg-proceed-checkout|color'
			),
			array(
				'id'       => 'salesgen_upsell_viewcart_button_color',
				'default'  => '#FFFFFF',
				'css' => 'body .sg-modal-buttons .sg-view-cart-btn|background-color'
			),
			array(
				'id'       => 'salesgen_upsell_viewcart_button_text_color',
				'default'  => '#2196f3',
				'css' => 'body .sg-modal-buttons .sg-view-cart-btn|color'
			),
			array(
				'id'       => 'salesgen_upsell_popup_product_title_size',
				'default'  => 'default',
				'css' => 'body .salesgen-upsell-popup-items li a|font-size'
			),
			array(
				'id'       => 'salesgen_upsell_image_variants',
				'default'  => 'no'
			),
			//announcement
			array(
				'id'       => 'salesgen_upsell_announcement_topbar',
				'default'  => 'no'
			),
			array(
				'id'       => 'salesgen_upsell_announcement_topbar_text',
				'default'  => ''
			),
			array(
				'id'       => 'salesgen_upsell_announcement_topbar_bgcolor',
				'default'  => '#FFFFFF',
				'css' => 'body .salesgen-ub-announcement-top|background-color'
			),
			array(
				'id'       => 'salesgen_upsell_announcement_topbar_text_color',
				'default'  => '#FFFFFF',
				'css' => 'body .salesgen-ub-announcement-top|color'
			),
			array(
				'id'       => 'salesgen_upsell_announcement_topbar_text_size',
				'default'  => 'default',
				'css' => 'body .salesgen-ub-announcement-top|font-size'
			),
			
			array(
				'id'       => 'salesgen_upsell_announcement_topbar_bgpattern',
				'default'  => 'default',
				'css' => 'body .salesgen-ub-announcement-top|background-pattern',
				'path' => $this->assets_url .'/images/announcement/'
			),
			array(
				'id'       => 'salesgen_upsell_announcement_topbar_bgimage',
				'default'  => '',
				'css' => 'body .salesgen-ub-announcement-top|background-upload',
			),
			array(
				'id'       => 'salesgen_upsell_announcement_product',
				'default'  => 'no'
			),
			array(
				'id'       => 'salesgen_upsell_announcement_product_text',
				'default'  => ''
			),
			array(
				'id'       => 'salesgen_upsell_announcement_product_bgcolor',
				'default'  => '#FFFFFF',
				'css' => 'body .salesgen-ub-announcement-product|background-color'
			),
			array(
				'id'       => 'salesgen_upsell_announcement_product_text_color',
				'default'  => '#FFFFFF',
				'css' => 'body .salesgen-ub-announcement-product|color'
			),
			array(
				'id'       => 'salesgen_upsell_announcement_product_bgpattern',
				'default'  => 'default',
				'css' => 'body .salesgen-ub-announcement-product|background-pattern',
				'path' => $this->assets_url .'/images/announcement/'
			),
			array(
				'id'       => 'salesgen_upsell_announcement_product_bgimage',
				'default'  => '',
				'css' => 'body .salesgen-ub-announcement-product|background-upload',
			),
			array(
				'id'       => 'salesgen_upsell_announcement_product_text_size',
				'default'  => 'default',
				'css' => 'body .salesgen-ub-announcement-product|font-size'
			),
			array(
				'id'       => 'salesgen_upsell_announcement_product_text_align',
				'default'  => '',
				'css' => 'body .salesgen-ub-announcement-product|text-align'
			),
			
			array(
				'id'       => 'salesgen_upsell_announcement_product_priority',
				'default'  => '20',
			),

			
		);

		$res_settings = apply_filters( 'salesgen_ub_settings_fields', $settings, $render );

		return $res_settings;    

	}
}
?>