<div class="salesgen-upsell-bundle sg-upsell-layout-4">
	
	<h2><?php echo $heading;?></h2>
	
	<div class="<?php echo implode(' ', $classes);?>" data-current-price="<?php echo $product->get_price();?>" data-cart-total="<?php echo $total_cart_item;?>" data-variants='<?php echo $variants_json;?>'>
		<div class="col <?php echo $items_cols;?> small-12 sg-bundle-preview-wrp">
			<div class="salesgen-upsell-items row">
				<?php

				$total       = count($products);
				$total_price = 0;
				$cols        = round(12 / $total, 0);
				$ind         = 0;
				$quickview   = false;
				$render_ids  = array();

				foreach ( $products as $prod ) {

					$render_ids[] = $prod['id'];

					$total_price += floatval( $prod['price'] );						

					$class_str = "medium-{$cols} small-{$cols} large-{$cols} col sgbmsm-item-{$prod['id']} salesgen-upsell-item salesgen-upsell-selected";
					
					if( $ind == $total) $class_str .= ' last';

					$post_object = get_post( $prod['parent_id'] );
					
					$product_title = $prod['default_name'];

					$ind++;

					$html_attrs = array();
					$html_attrs[] = 'data-parent="' . $prod['parent_id'] .'"';
					$html_attrs[] = 'data-type="' . $prod['product_type'] .'"';
					$html_attrs[] = 'data-price="' . $prod['price'] .'"';
					$html_attrs[] = 'data-base-price="' . $prod['price'] .'"';
					$html_attrs[] = 'data-id="' . $prod['id'] .'"';
					if ( $prod['product_type'] == 'variable' ) {
						$html_attrs[] = "data-variants='" .json_encode($variants[ $prod['id'] ], JSON_FORCE_OBJECT) ."'";	
						$html_attrs[] = "data-default_attributes='" .json_encode($prod['default_attributes'], JSON_FORCE_OBJECT) ."'";	
					}
					?>
					<div <?php echo implode(' ', $html_attrs);?> class="salesgen-upsell-item-list-selected salesgen-upsell-item-list <?php echo $class_str;?>">
						<label class="salesgen-upsell-item-checkbox-wrp">
							<?php echo '<input data-change=".sgbmsm-item-' . $prod['id'] . '" class="salesgen-upsell-item-checkbox" type="checkbox" checked="checked" name="upsells[]" value="' . $prod['id'] . '" id="salesgen-upsell-item-handler-' . $prod['id'] . '"  aria-label="' . $prod['default_name'] .'"/>';?>
						</label>
						<div <?php wc_product_class( $hashover, $product ); ?>>
							<div class="box-image">
								<div class="image-fade_in_back">
									<a href="<?php echo $prod['url'];?>" target="_blank" rel="nofollow">
										<?php echo $prod['thumbnail'];?>
									</a>
								</div>
								<?php if( $quickview == true ):?>
								<div class="image-tools grid-tools text-center hide-for-small bottom hover-slide-in show-on-hover">
									<a class="quick-view" rel="nofollow" data-prod="<?php echo $prod['parent_id'];?>" href="#quick-view">Select Options</a>
								</div>
								<?php endif;?>
							</div>
							<a href="<?php echo $prod['url'];?>" target="_blank" rel="nofollow" class="salesgen-upsell-item-title">
								<?php echo $product_title;?>
							</a>

							<span class="sgbmsm-price-checkbox"><?php echo $prod['price_html'];?></span>
							<div class="sgbmsm-price-checkbox-wrp active-select-options">
								<span class="salesgen-select-options button">Select Options</span>
								<div class="salesgen-upsell-options">
									<form>
										<?php echo $prod['child_html'];?>
									</form>
								</div>
							</div>
						</div>
					</div>
					<?php
				}
				?>
			</div>
		</div>
		<div class="col large-4 small-12">
			<div class="salesgen-total-wrp">
				<div class="salesgen-total">
					Total Price: <?php echo wc_price( $total_price );?>
				</div>
				<div class="salesgen-saved">
					(Saved <span class="salesgen-saved-amount"><?php echo wc_price(0);?></span>)
				</div>
			</div>
			<a rel="nofollow" class="salesgen-add-bundle button alt" href="javascript:void(0);"><?php echo $add_action_label;?></a>
			
		</div>
	</div>
</div>