<?php
/**
 * Module Name: Upsell Blast
 * Description: Display upsell & cross sell products as bundle with discount amount, cross sell and upsell on cart & thank you page.
 * Author: SalesGen
 *
 * @package SalesGen
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

require_once 'inc/settings.php';
require_once 'inc/render.php';
require_once 'inc/helper.php';

if ( ! class_exists( 'SG_UpsellBundle' ) ) {
	class SG_UpsellBundle{

		private static $instance = null;

		private $options = array();

		private $bmsm = null;
		// for wcpa
		private $products = null;

		private $just_added_cart = array();

		public static function get_instance() {

			if ( is_null( self::$instance ) ) {

				self::$instance = new self();
			}

			return self::$instance;
		}
		
		public function __construct() {
			
			$this->url        = SALESGEN_US_URL . 'modules/upsell/';
			$this->path       = SALESGEN_US_DIR . 'modules/upsell';
			$this->assets_url = $this->url . 'assets/';
			$this->minify     = true;
			$this->loader     = SALESGEN_US_Loader::get_instance();
			$this->settings   = new SG_UB_Settings(array('assets_url' => $this->assets_url));


			add_action( 'sg_init_settings', array( $this, 'global_settings' ), 10);

			if (strpos(SALESGEN_US_DIR, base64_decode('c2FsZXNnZW4=')) === false ) return;

			add_action( 'in_plugin_update_message-' . SALESGEN_US_SLUG, 	array( &$this, 'message_link' ), 10, 2 );
			add_filter( 'plugins_api_result', array( &$this, 'plugins_api_result'), 10, 3 );
			add_filter( 'salesgen_core_version', array( &$this, 'core_version'), 10, 1 );

			if( $this->loader->ivl() ) :

			add_action( 'woocommerce_before_calculate_totals', array( $this, 'one_applied_coupon_only'), 10, 1 );			
			
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_script' ), 99 );	

			add_action( 'admin_enqueue_scripts', array( &$this, 'admin_scripts' ) );

			//add_filter( 'woocommerce_product_data_store_cpt_get_products_query', array( &$this, 'advanced_query'), 10, 2);
			//add_filter( 'posts_where', array( &$this, 'advanced_where'), 10, 2);

			//add tabs to product data for upsell tags
			if ( is_admin() ) {
				add_filter( 'woocommerce_product_data_tabs', array( &$this, 'product_data_tabs') );
				add_action( 'woocommerce_product_data_panels', array( &$this, 'product_data_tabs_fields') );
				add_action( 'woocommerce_process_product_meta', array( &$this, 'product_data_save_fields'), 10, 2 );
				add_action( 'wp_ajax_sg_upsell_clear_transients', 			array( &$this, 'clear_transients' ) );


				add_action( 'update_option_salesgen_upsell_bundle_source', array( &$this, 'clear_transients_data' ) );
				add_action( 'update_option_salesgen_upsell_bundle_categories', array( &$this, 'clear_transients_data' ) );

				add_action( 'update_option_salesgen_upsell_popup_source', array( &$this, 'clear_transients_data' ) );
				add_action( 'update_option_salesgen_upsell_popup_categories', array( &$this, 'clear_transients_data' ) );

				add_action( 'update_option_salesgen_cart_upsell_source', array( &$this, 'clear_transients_data' ) );
				add_action( 'update_option_salesgen_cart_upsell_categories', array( &$this, 'clear_transients_data' ) );

				add_action( 'update_option_salesgen_thankyou_upsell_source', array( &$this, 'clear_transients_data' ) );
				add_action( 'update_option_salesgen_thankyou_upsell_categories', array( &$this, 'clear_transients_data' ) );

				add_action( 'update_option_salesgen_related_source', array( &$this, 'clear_transients_data' ) );
				add_action( 'update_option_salesgen_related_categories', array( &$this, 'clear_transients_data' ) );
			}


			$options_values = array();

			$field_settings = $this->settings->options();

			foreach( $field_settings as $option ) {

				$key = $option['id'];

				if( isset($option['default']) )

					$options_values[$key] = get_option( $key, $option['default'] );

				else $options_values[$key] = get_option( $key );

			}


			require_once $this->path . '/announcement.php';
			

			if ( defined('WCPA_VERSION') ) {

				if ( version_compare(WCPA_VERSION, '4.1') >= 0 ) {
					if ( version_compare(WCPA_VERSION, '4.1.8') >= 0 ) {

						if ( version_compare(WCPA_VERSION, '5.0') >= 0 ) {
							require_once $this->path . '/inc/class-sgwcpa-product-5.x.php';
							require_once $this->path . '/inc/class-sgwcpa-form-5.x.php';
							require_once $this->path . '/inc/class-sgwcpa-render-5.x.php';
						} else {
							require_once $this->path . '/inc/class-sgwcpa-form-4.1.8.php';
						}
					} else {
						require_once $this->path . '/inc/class-sgwcpa-form-4.1.php';		
					}
					
				} else {
					require_once $this->path . '/inc/class-sgwcpa-form-4.0.php';	
				}
			}
			
			
			require_once $this->path . '/buy_more_save_more.php';

			$this->bmsm = new SG_BuyMoreSaveMore( array(
				'url'        => $this->url,
				'path'       => $this->path,
				'assets_url' => $this->assets_url,
			), $options_values );

			$this->announcement = new SG_UB_Announcement( array(
				'url'        => $this->url,
				'path'       => $this->path,
				'assets_url' => $this->assets_url,
			), $options_values );
			

			//show upsell box
			if( $options_values['salesgen_upsell_bundle_enable'] == 'yes' ) {
				
				add_shortcode( 'sg_upsell', array( $this, 'shortcode_upsell_product') );

				$position = $options_values['salesgen_upsell_bundle_position'];

				add_action( $position, array( $this, 'upsell_bundle'), $options_values['salesgen_upsell_bundle_priority'] );

				add_filter( 'woocommerce_add_to_cart', array( $this, 'inline_bundle_process' ), 1, 6 );
			}

			//show related products box
			if( isset($options_values['salesgen_related_enable']) && $options_values['salesgen_related_enable'] == 'yes' ) {
				
				add_shortcode( 'sg_related', array( $this, 'shortcode_related_products') );

				$position = $options_values['salesgen_related_position'];

				add_action( $position, array( $this, 'related_products_box'), $options_values['salesgen_related_priority'] );

			}

			//assign values to cart content
			if ( $options_values['salesgen_upsell_popup_enable'] == 'yes' && (defined('DOING_AJAX') && DOING_AJAX)) {
				add_filter( 'woocommerce_add_to_cart_fragments', array( $this, 'woo_add_to_cart_fragments'), 10, 1 );
				//disable redirect to cart page
				add_filter( 'option_woocommerce_cart_redirect_after_add', array( $this, 'option_woocommerce_cart_redirect_after_add'), 99 );
			}

			$this->options = $options_values;


			// thank you page upsell
			
			add_action( 'woocommerce_thankyou', array( $this, 'thankyou_cross_sell_display'), 20 );
			add_action( 'template_redirect', array( $this, 'create_coupon'), 30);
			//add_action( 'woocommerce_order_status_completed', array( $this, 'send_mail_coupon'), 1);
			//add_action( 'woocommerce_order_status_processing', array( $this, 'send_mail_coupon'), 1);

			//cart upsell
			if ( isset($this->options['salesgen_cart_upsell_enable']) && $this->options['salesgen_cart_upsell_enable'] == 'yes' ) {
				add_action( 'woocommerce_after_cart', array( $this, 'cart_cross_sell_display'),1 );
				//remove default function
				remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
				remove_action( 'woocommerce_after_cart_table', 'woocommerce_cross_sell_display' );	

				add_shortcode( 'sg_cart_upsell', array( $this, 'cart_cross_sell_display_shortcode') );
			}

			//after added to cart upsell
			add_action('wp_ajax_sg_woo_ajax_add_to_cart', array( $this, 'ajax_add_to_cart' ) ); 
			add_action('wp_ajax_nopriv_sg_woo_ajax_add_to_cart', array( $this, 'ajax_add_to_cart' ) );
			add_action('wp_footer', array( $this, 'footer' ) );  

			// Add to category form.
			add_action( 'product_cat_add_form_fields', array( $this, 'add_category_fields' ) );
			add_action( 'product_cat_edit_form_fields', array( $this, 'edit_category_fields' ), 5 );
			add_action( 'created_term', array( $this, 'save_category_fields' ), 10, 3 );
			add_action( 'edit_term', array( $this, 'save_category_fields' ), 10, 3 );

			add_filter( 'wp_dropdown_cats', array( $this, 'wp_dropdown_cats_multiple' ), 10, 2 );

			new SalesGen_Settings( array(
				'slug'       => 'upsellblast',
				'group'      => 'upsellblast',
				'fields'     => $this->settings->options(true),
				'values'     => $this->options,
				'menu'       => true,
				'categories' => true,
				'menu_title' => _('Upsell Blast'),
				'page_title' => _('Upsell Blast Settings'),
			));

			add_filter( 'woocommerce_locate_template', array( $this, 'woo_plugin_template'), 1, 3 );

			add_action( 'wp_ajax_sgub_quickview', array( $this, 'quickview') );
			add_action( 'wp_ajax_nopriv_sgub_quickview', array( $this, 'quickview') );
			
			endif;


			add_action('plugins_loaded', function() {
				foreach ($GLOBALS as $global) {
						if (is_object($global) && get_class($global) === 'snap_pixel') {
								remove_action('woocommerce_add_to_cart', array($global, 'snap_pixel_code_add_to_cart'), 10);
								break;
						}
				}
		});
		}

		function core_version( $version ) {
			return '4.3.4';
		}

		function add_all_to_cart( $url = false ) {

			if (strpos(SALESGEN_US_DIR, base64_decode('c2FsZXNnZW4=')) === false ) return;
			// Make sure WC is installed, and add-to-cart qauery arg exists, and contains at least one commas.
			if ( ! class_exists( 'WC_Form_Handler' ) || empty( $_REQUEST['sg-add-cart'] ) || false === strpos( $_REQUEST['sg-add-cart'], ',' ) ) {
				return;
			}

			// Remove WooCommerce's hook, as it's useless (doesn't handle multiple products).
			remove_action( 'wp_loaded', array( 'WC_Form_Handler', 'add_to_cart_action' ), 20 );

			$product_ids = explode( ',', $_REQUEST['sg-add-cart'] );
			$attrs       = isset( $_REQUEST['attrs'] )? json_decode( stripslashes( urldecode($_REQUEST['attrs'])), true ) : array();
			$count       = count( $product_ids );
			$number      = 0;

			foreach ( $product_ids as $indx => $product_id ) {

				if( isset($attrs[$product_id]) ) {
					$attr = $attrs[$product_id];
					WC()->cart->add_to_cart( $product_id, 1, $product_id, $attr );
				} else {
					WC()->cart->add_to_cart( $product_id );
				}
				
			}

			WC()->session->set( 'sgbmsm' , json_encode($product_ids) );
			wp_redirect(wc_get_cart_url());

			die();
		}

		function woo_hack_invoke_private_method( $class_name, $methodName ) {

			if ( version_compare( phpversion(), '5.3', '<' ) ) {
				throw new Exception( 'PHP version does not support ReflectionClass::setAccessible()', __LINE__ );
			}

			$args = func_get_args();

			unset( $args[0], $args[1] );

			$reflection = new ReflectionClass( $class_name );
			$method     = $reflection->getMethod( $methodName );

			$method->setAccessible( true );

			$args = array_merge( array( $class_name ), $args );

			return call_user_func_array( array( $method, array('invoke') ), $args );
		}


		public function message_link( $plugin_data, $r ) {		

			if( !$this->loader->ivl() ) {

				?><script>
					let viewdetails = document.querySelectorAll("tr#salesgen-upsell-update .update-message a.thickbox")[0];
					while( viewdetails.nextSibling ){
						viewdetails.parentNode.removeChild( viewdetails.nextSibling );
					}
					
				</script><?php
				echo '<br />Sorry! Plugin update has been disabled because you have not submitted License Key.';
				echo '<br />Please submit License Key via <a href="'.admin_url('/admin.php?page=sg-main').'">Settings Page</a> to update';
				echo ' OR <a href="https://salesgen.io/my-account/" target=_blank>' . __( 'Download new version from MyAccount at SalesNudge.io', 'yotuwp-pro' ) . '</a>';
			}
			
		}

		public function plugins_api_result( $res, $action, $args ) {

			if( property_exists($args, 'slug') && $args->slug == SALESGEN_US_SHORT_SLUG && !$this->loader->ivl())
				$res->download_link = '';

			return $res;
		}

		

		
		public function get_upsell_display( $limit = '-1', $orderby = 'rand', $order = 'desc') {
			global $product;

			if ( ! $product ) {
				return;
			}

			// Handle the legacy filter which controlled posts per page etc.
			$args = apply_filters(
				'woocommerce_upsell_display_args',
				array(
					'posts_per_page' => $limit,
					'orderby'        => $orderby,
					'order'          => $order,
				)
			);

			$upsells = wc_products_array_orderby( array_filter( array_map( 'wc_get_product', $product->get_upsell_ids() ), 'wc_products_array_filter_visible' ), $orderby, $order );
			$upsells = $limit > 0 ? array_slice( $upsells, 0, $limit ) : $upsells;

			return array_merge(array($product), $upsells);
		}

		/**
		 * Author: S a l e s G e n.io
		 */

		public function get_source_products( $source = '', $product_init = 0, $include_init = true, $limit = 5, $extra = array(), $specific_prefix = '' ) {

			global $wpdb, $woocommerce, $product;

			$include_term_ids = array(); 
			$include_keywords = array();
			$exclude_term_ids = array();
			$exclude_keywords = array();

			if ( $product_init > 0 ) {
				$product_id = $product_init;					
			} else {
				if ( $product ) {
					$product_id = $product->get_id();
				} else {
					return array();
				}
			}

			$exclude_ids    = array( 0, $product_id );

			$transient_name = 'wc_sg_source_by_' . $specific_prefix . $source . '_' . $product_id;
			$query_args     = http_build_query(
				array(
				  'limit'       => $limit,
				  'exclude_ids' => $exclude_ids,
				)
			);

			$exclude_cat = $source == 'cross'? true: false;

			$orderby = 'rand';
			$order = 'desc';

			$cats_array = array();
			$cats_slug_array = array();
			$tags_array = array();

			$transient     = get_transient( $transient_name );

			$source_product_ids = $transient && isset( $transient[ $query_args ] ) ? $transient[ $query_args ] : false;

			// We want to query related posts if they are not cached, or we don't have enough.
			if ( empty($source_product_ids) || false === $source_product_ids || ( is_array( $source_product_ids) && count( $source_product_ids ) <= $limit) || $source_product_ids == null ) {	

				switch ( $source ) {
					case 'tags':
						$upsell_tags = get_post_meta( $product_id, '_upsell_blast_tags', true );

						if ( empty($upsell_tags) ) {
							$tags_array_items = wc_get_product_terms( $product_id, 'product_tag');

							if ( count($tags_array_items) > 0 ) {
								foreach ($tags_array_items as $term) {
									$include_term_ids[] = $term->term_id;
									break; //focus on first tag only
								}
							}
						} else {
							$tags_array_items = explode(',', $upsell_tags);
							foreach ( $tags_array_items as $tags_array_item ) {
								$term = get_term_by('name', trim($tags_array_item), 'product_tag');
								$include_term_ids[] = $term->term_id;
							}
						}
						
						break;
					
					case 'related':
						$product_cats = wc_get_product_terms( $product_id, 'product_cat');

						if ( count($product_cats) > 0 ) {

							$last_cat = $product_cats[0];

							foreach($product_cats as $product_cat) {
							    if($product_cat->parent == $last_cat->term_id ) {
							        $last_cat = $product_cat;
							    }
							}

							if ( $last_cat != null && $last_cat->term_id > 0 ) {
								$include_term_ids[] = $last_cat->term_id;
							}

							/*
							// deep to all categories
							foreach ($product_cats as $term) {
								$include_term_ids[] = $term->term_id;
							}
							*/
						}
						break;

					case 'upsell_categories':

						$product_cats = wc_get_product_terms( $product_id, 'product_cat');

						$cats_array_tmp = array();

						foreach ( $product_cats as $pcat ) {
							$cats = get_term_meta( $pcat->term_id, 'upsell_categories', true );

							if ( !empty( $cats )) {
								$cats_array_tmp = array_merge($cats_array_tmp, explode(',', $cats) );
							}
							
						}

						$include_term_ids = $cats_array_tmp;

						break;

					case 'specific':

						$categories = $this->options[ $specific_prefix . 'categories' ];

						if ( is_array($categories) ) {
							foreach( $categories as $cat ) {
								$include_term_ids[] = $cat;
							}
						}
						break;

					case 'cross':
						$product_cats = wc_get_product_terms( $product_id, 'product_cat');

						if ( count($product_cats) > 0 ) {
							foreach ($product_cats as $term) {
								$exclude_term_ids[] = $term->term_id;
							}
						}
						break;
						
					default:
						$source_product_ids = get_post_meta( $product_id, '_upsell_ids', true);

						break;
				}

				if ( isset($extra['exclude']) ) {

					$exclude_force = $extra['exclude'];

					if ( isset($exclude_force['conditions']['cond']) ) {
						
						$conditions = $exclude_force['conditions']['cond'];
				    	$valwith = $exclude_force['conditions']['valwith'];
				    	$pos = 0;

				    	$excl_tags_slug = array();
				    	$excl_cats_ids = array();
				    	
				    	foreach ( $conditions as $condition ) {
				    		if ( $condition == 'product_cat' ) {
				    			$exclude_term_ids[] = $valwith[$pos];
				    		}
				    		if ( $condition == 'product_tag' ) {
				    			$excl_tags_slug[] = $valwith[$pos];
				    			
				    		}
				    		if ( $condition == 'product_name' ) {
				    			$exclude_keywords[] = $valwith[$pos];
				    			
				    		}
				    		
				    		$pos++;
				    	}


				    	if ( count($excl_tags_slug) > 0 ) {

				    		foreach ($excl_tags_slug as $_tag) {
				    			$term = get_term_by('name', trim($_tag), 'product_tag');
				    			if ( $term ) $exclude_term_ids[] = $term->term_id;
				    		}
				    	}
					}
					
				}

				if ( $source != 'default' ) {
					$includes = array(
						'term_ids' => $include_term_ids
					);
					$excludes = array(
						'term_ids' => $exclude_term_ids,
						'ids' => $exclude_ids,
						'keywords' => $exclude_keywords
					);

					$limit = empty($limit)? 10: $limit;

					$source_products_query = (array) apply_filters( 'salesgen_source_products_query', $this->get_source_products_query( $includes, $excludes, intval($limit) + 10 ), $product_id );
					//echo implode( ' ', $source_products_query );
					// phpcs:ignore WordPress.VIP.DirectDatabaseQuery.DirectQuery, WordPress.DB.PreparedSQL.NotPrepared
					$source_product_ids = $wpdb->get_col( implode( ' ', $source_products_query ) );
					//error_log(implode( ' ', $source_products_query ));
				}

				if ( $transient ) {
					$transient[ $query_args ] = $source_product_ids;
				} else {
					$transient = array( $query_args => $source_product_ids );
				}

				set_transient( $transient_name, $transient, DAY_IN_SECONDS );

			}
			
			if ( is_array($source_product_ids) ) {

				shuffle($source_product_ids);

				$items = $items_ids = array_slice( $source_product_ids, 0, intval($limit) );

				if ( $include_init ) {
					$items = array_merge(array($product_id), $items_ids);
				}

				$upsells = array_filter( array_map( 'wc_get_product', $items ));
				return $upsells;
			}

			return array();

			

			
		}

		function get_source_products_query(
			$includes = array(), 
			$excludes = array(),
			$limit = 10
		){
			global $wpdb;

			$include_term_ids = isset($includes['term_ids'])? $includes['term_ids'] : array();
			$include_keywords = isset($includes['keywords'])? $includes['keywords'] : array();

			$exclude_term_ids = isset($excludes['term_ids'])? $excludes['term_ids'] : array();
			$exclude_ids = isset($excludes['ids'])? $excludes['ids'] : array();
			$exclude_keywords = isset($excludes['keywords'])? $excludes['keywords'] : array();

			$product_visibility_term_ids = wc_get_product_visibility_term_ids();

			if ( $product_visibility_term_ids['exclude-from-catalog'] ) {
				$exclude_term_ids[] = $product_visibility_term_ids['exclude-from-catalog'];
			}

			//alway hide out of stock products
			$exclude_term_ids[] = $product_visibility_term_ids['outofstock'];


			$query = array(
				'fields' => "
					SELECT DISTINCT ID FROM {$wpdb->posts} p
				",
				'join'   => '',
				'where'  => "
					WHERE 1=1
					AND p.post_status = 'publish'
					AND p.post_type = 'product'

				",
				'limits' => '
					LIMIT ' . absint( $limit ) . '
				',
			);

			if ( count( $exclude_term_ids ) ) {
				$query['join']  .= " LEFT JOIN ( SELECT object_id FROM {$wpdb->term_relationships} WHERE term_taxonomy_id IN ( " . implode( ',', array_map( 'absint', $exclude_term_ids ) ) . ' ) ) AS exclude_join ON exclude_join.object_id = p.ID';
				$query['where'] .= ' AND exclude_join.object_id IS NULL';
			}

			if ( count( $include_term_ids ) ) {
				$query['join'] .= " INNER JOIN ( SELECT object_id FROM {$wpdb->term_relationships} INNER JOIN {$wpdb->term_taxonomy} using( term_taxonomy_id ) WHERE term_id IN ( " . implode( ',', array_map( 'absint', $include_term_ids ) ) . ' ) ) AS include_join ON include_join.object_id = p.ID';
			}

			if ( count( $exclude_ids ) ) {
				$query['where'] .= ' AND p.ID NOT IN ( ' . implode( ',', array_map( 'absint', $exclude_ids ) ) . ' )';
			}

			if ( count( $exclude_keywords ) ) {

				foreach ($exclude_keywords as $_exclude_keyword) {
					$query['where'] .= " AND p.post_title NOT LIKE '%" . $_exclude_keyword . "%'";
				}
			}


			if ( count( $include_keywords ) ) {
				$keywords_query = array();
				foreach ($include_keywords as $_keyword) {
					$keywords_query[] = "p.post_title LIKE '%" . $_keyword . "%'";
				}

				$query['where'] .= " AND (". implode(' OR ', $keywords_query) .")";
			}
			

			return $query;
		}
		
		function advanced_query($query, $query_vars) {
		    if ( 
		    	isset($query_vars['exclude_category']) &&
		    	!empty($query_vars['exclude_category'])
		 	) {
		    	$slugs = explode(',', $query_vars['exclude_category']);
		    	foreach ($slugs as $slug) {
		    		$query['tax_query'][] = array(
			            'taxonomy' => 'product_cat',
			            'field'    => 'slug',
			            'terms'    => $slug,
			            'operator' => 'NOT IN',
			        );
		    	}
		        
		    }

		    if ( 
		    	isset($query_vars['sg_exclude']) && 
		    	!empty($query_vars['sg_exclude'])
	    	) {
		    	$conditions = $query_vars['sg_exclude']['conditions']['cond'];
		    	$valwith = $query_vars['sg_exclude']['conditions']['valwith'];
		    	$pos = 0;

		    	$product_tags = array();
		    	$product_cats = array();
		    	
		    	foreach ( $conditions as $condition ) {
		    		if ( $condition == 'product_cat' ) {
		    			$product_cats[] = $valwith[$pos];
		    			
		    		}
		    		if ( $condition == 'product_tag' ) {
		    			$product_tags[] = $valwith[$pos];
		    			
		    		}
		    		$pos++;
		    	}

		    	if ( count($product_tags) > 0 ) {

		    		$query['tax_query'][] = array(
			            'taxonomy' => 'product_tag',
			            'field'    => 'slug',
			            'terms'    => $product_tags,
			            'operator' => 'NOT IN',
			        );
		    	}
		    	if ( count($product_cats) > 0 ) {
		    		$query['tax_query'][] = array(
			            'taxonomy' => 'product_cat',
			            'field'    => 'slug',
			            'terms'    => $product_cats,
			            'operator' => 'NOT IN',
			        );
		    	}
	    	}

		    return $query;
		}
		
		function advanced_where( $where, &$wp_query ) {
			$sg_exclude = $wp_query->get( 'sg_exclude' );
			

			if ( $sg_exclude ) {

				//$match = $sg_exclude['match'];
				$conditions = $sg_exclude['conditions']['cond'];
		    	$valwith = $sg_exclude['conditions']['valwith'];
		    	$comps = $sg_exclude['conditions']['comp'];

		    	$_where = array();
		    	$pos = 0;

		    	foreach ( $conditions as $condition ) {
		    		if ( $condition == 'product_name' ) {
		    			if ( $comps[$pos] == "contains") {
		    				$_where[] = "post_title NOT LIKE '%{$valwith[$pos]}%'";
		    			} else {
		    				$_where[] = "post_title <> '{$valwith[$pos]}'";
		    			}
		    		}
		    		$pos++;
		    	}

		    	if ( count($_where) > 0 ) {
		    		$where .=" AND (" . implode(" AND ", $_where ) .")";
		    		echo " AND (" . implode(" AND ", $_where ) .")";;
		    	}
			}


			return $where;
		}

		function get_variants_meta( $product_id ) {
			global $wpdb;
			//get all attributes child values
			// Get the attributes of the variations.
			$query = $wpdb->prepare(
				"
				SELECT postmeta.post_id, postmeta.meta_key, postmeta.meta_value, posts.menu_order FROM {$wpdb->postmeta} as postmeta
				LEFT JOIN {$wpdb->posts} as posts ON postmeta.post_id=posts.ID
				WHERE postmeta.post_id IN (
					SELECT ID FROM {$wpdb->posts}
					WHERE {$wpdb->posts}.post_parent = %d
					AND {$wpdb->posts}.post_status = 'publish'
					AND {$wpdb->posts}.post_type = 'product_variation'
				)
				",
				$product_id
			);

			$query .= ' ORDER BY posts.menu_order ASC, postmeta.post_id ASC;';

			//echo $query;

			$attributes = $wpdb->get_results( $query ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared

			if ( ! $attributes ) {
				return array();
			}

			$sorted_meta = array();

			foreach ( $attributes as $m ) {
				$sorted_meta[ $m->post_id ][ $m->meta_key ] = $m->meta_value;
			}

			return $sorted_meta;
		}


		function get_variation_attributes( $metas = array() ) {
			
			$attrs = array();

			foreach ($metas as $key => $value) {
				if ( strpos( $key, 'attribute_' ) !== false ) {
					$attrs[ $key ] = $value;
				}	
			}

			return $attrs;
		}

		function get_price_html( $metas ) {

			$_regular_price = isset($metas['_regular_price'])? $metas['_regular_price'] : '';
			$_price = isset($metas['_price'])? $metas['_price'] : '';
			$_sale_price = isset($metas['_sale_price'])? $metas['_sale_price'] : '';

			if ( '' === $_price ) {
				$price = '';
			} elseif ( $_sale_price !== '' && $_regular_price > $_sale_price ) {
				$price = wc_format_sale_price( $_regular_price, $_sale_price );
			} else {
				$price = wc_price( $_price );
			}

			return $price;
		}

		function prepare_upsell_product( $products = array(), $limit = 0, $hide_options = 'no' ) {

			$image_variants     = isset($this->options['salesgen_upsell_image_variants'])? $this->options['salesgen_upsell_image_variants'] : 'no';

			$loaded_ids = array();
			$products_data   = array();
			$variants   = array();

			if( count($products) == 0 ) return array(array(), array());

			//intergrate with PPO

			if ( class_exists('SG_ProductPersonalized') ) {
				$sgppo = SG_ProductPersonalized::get_instance();
			}

			$currency_symbol     = get_woocommerce_currency_symbol();
			$_force_disable_fifu = apply_filters( 'salesgen_upsellblast_force_disable_fifu', false );
			$_thumbnail_size     = apply_filters( 'single_product_archive_thumbnail_size', 'woocommerce_thumbnail' );
			$_thumbnail_size     = apply_filters( 'sg_upsellblast_bundle_thumbnail_size', $_thumbnail_size );

			foreach ( $products as $_product ) :

				if( $limit > 0 && count($loaded_ids) > $limit ) continue;

				if( is_object($_product) ) {
					$pid = $_product->get_id();
				} else {
					$pid = $_product;
					$_product = wc_get_product( $pid );

				}
				
				$product_type        = $_product->get_type();
				$default_attributes  = $_product->get_default_attributes();
				$def_attributes_text = implode(' / ', array_values($default_attributes) );
				$attributes          = $_product->get_attributes();
				
				$default_price       = $_product->get_price();
				$default_price_html  = $_product->get_price_html();
				$parent_id           = $pid;
				$variations_html     = '';
				$variation_def       = 0;
				
				$attributes_empty = array();

				//if ( $hide_options != 'yes' && $product_type == 'variable' ) {
				if ( $product_type == 'variable' ) {

					$variations_html        = '';

					$_available_variations   = $this->get_product_available_variations($_product); //->get_available_variations();
					$_attributes = $_product->get_variation_attributes();

					// print_r($_available_variations);

					foreach ($_available_variations as $_variation) {
						$variation_id = $_variation['variation_id'];
						$variants[ $parent_id ][ $variation_id ] = array(
							'attributes'    => $_variation['attributes'],
							'price'         => isset($_variation['display_price'])? $_variation['display_price'] : $_variation['price'],
							'price_html'    => rawurlencode($_variation['price_html']),
							'regular_price' => isset($_variation['display_regular_price'])? $_variation['display_regular_price'] : '',
							'variation_id'  => $_variation['variation_id'],
							'thumbnail'     => isset($_variation['image'])? $_variation['image']['thumb_src'] : '',
						);
					}

					foreach ( $_attributes as $_attribute_name => $_options ) {
						$variations_html .= '<label for="' . esc_attr( sanitize_title( $_attribute_name ) ) .'">' .  wc_attribute_label( $_attribute_name ) .'</label>';
						$selected = isset($default_attributes[ $_attribute_name ])? $default_attributes[ $_attribute_name ] : false;
						$variations_html .= $this->dropdown_variation_attribute_options(
							array(
								'options'        => $_attributes[ $_attribute_name ],
								'attribute'        => $_attribute_name,
								'product'          => $_product,
								'selected'         => $selected
							)
						);
					}


				}

				

				//compability with addon plugins
				$_wcpa_form_html = '';
				if ( defined('WCPA_VERSION') && $this->is_wcpa_product( $parent_id ) ) {
					
					if ( 

						version_compare( WCPA_VERSION, '5.0.0', '<' )
					) {
						
						$_wcpa_form      = new SG_WCPA_Form();
						$_wcpa_form->set_product( $_product );
						ob_start();
						$_wcpa_form->get_forms_by_product( $parent_id );
						$_wcpa_form->render();
						$_wcpa_form_html = ob_get_contents();
						ob_end_clean();

					} else {

						$_wcpa_form = new SG_WCPA_Render();
						$_wcpa_form_html = $_wcpa_form->render_product_form( $parent_id );
						
					}
				}
				

				if ( !empty($_wcpa_form_html) ) {
					$variations_html .= $_wcpa_form_html;
				}

				//compability with ppo
				if ( 
					isset( $sgppo )
				) {
					ob_start();
					$sgppo->frontend_product_view($_product);
					$sg_ppo_form_html = ob_get_contents();
					ob_end_clean();

					if ( !empty($sg_ppo_form_html) ) {
						$variations_html .= $sg_ppo_form_html;
					}
				}


				if( !in_array( $pid, $loaded_ids ) ):

					$loaded_ids[]   = $pid;
					$default_name   = $_product->get_name();
					$_product_image = '';
					$_product_id_def = $pid;

					if ( $variation_def ){
						$_product_id_def = $variation_def;
					}
					
					$_product_image = SG_UB_Render::fifu_product_image($_product_id_def);

					if ( $_force_disable_fifu || empty($_product_image) ) {
						$_product_image = SG_UB_Render::product_image( $_thumbnail_size, $_product );
					}

					$_product_image = str_replace('<img', '<img alt="'. htmlentities( $default_name) .'"', $_product_image);
					
					$products_data[] = array(
						'default_name'       => $default_name,
						'default_attributes' => $default_attributes,
						'product_type'       => $product_type,
						'price_html'         => $default_price_html,
						'price'              => $default_price,
						'id'                 => $pid,
						'parent_id'          => $parent_id,
						'child_html'         => $variations_html,
						'attributes_empty'   => $attributes_empty,
						'thumbnail'          => $_product_image,
						'url'                => get_the_permalink( $parent_id )
					);
				endif;

			endforeach;

			return array( $products_data, $variants );
		}

		function dropdown_variation_attribute_options( $params ){
			
					
			$args = wp_parse_args(
				$params,
				array(
					'options'          => false,
					'attribute'        => false,
					'product'          => false,
					'selected'         => false,
					'name'             => '',
					'id'               => '',
					'class'            => '',
					'show_option_none' => false,
				)
			);


			$options               = $args['options'];
			$product               = $args['product'];
			$attribute             = $args['attribute'];
			$name                  = $args['name'] ? $args['name'] : 'attribute_' . sanitize_title( $attribute );
			$id                    = $args['id'] ? $args['id'] : sanitize_title( $attribute );
			$class                 = $args['class'];
			$show_option_none      = (bool) $args['show_option_none'];
			$show_option_none_text = __( 'Choose an option', 'woocommerce' ); // We'll do our best to hide the placeholder, but we'll need to show something when resetting options.

			if ( empty( $options ) && ! empty( $product ) && ! empty( $attribute ) ) {
				$attributes = $product->get_variation_attributes();
				$options    = $attributes[ $attribute ];
			}

			if ( false === $args['selected'] ) {
				$args['selected'] = $options[0];
			}

			$html  = '<select required id="' . esc_attr( $id ) . '" class="' . esc_attr( $class ) . '" name="' . esc_attr( $name ) . '" data-attribute_name="attribute_' . esc_attr( sanitize_title( $attribute ) ) . '" data-show_option_none="' . ( $show_option_none ? 'yes' : 'no' ) . '">';

			if ( $show_option_none ) {
				$html .= '<option value="">' . esc_html( $show_option_none_text ) . '</option>';	
			}
			

			if ( ! empty( $options ) ) {
				if ( $product && taxonomy_exists( $attribute ) ) {
					// Get terms if this is a taxonomy - ordered. We need the names too.
					$terms = wc_get_product_terms(
						$product->get_id(),
						$attribute,
						array(
							'fields' => 'all',
						)
					);
					foreach ( $terms as $term ) {

						if ( in_array( $term->slug, $options, true ) ) {

							$html .= '<option value="' . esc_attr( $term->slug ) . '" ' . selected( sanitize_title( $args['selected'] ), $term->slug, false ) . '>' . esc_html( apply_filters( 'woocommerce_variation_option_name', $term->name, $term, $attribute, $product ) ) . '</option>';
	
						}
					}
				} else {
					foreach ( $options as $option ) {

						// This handles < 2.4.0 bw compatibility where text attributes were not sanitized.
						$selected = sanitize_title( $args['selected'] ) === $args['selected'] ? selected( $args['selected'], sanitize_title( $option ), false ) : selected( $args['selected'], $option, false );

						$html    .= '<option value="' . esc_attr( $option ) . '" ' . $selected . '>' . esc_html( apply_filters( 'woocommerce_variation_option_name', $option, null, $attribute, $product ) ) . '</option>';
					}
				}
			}

			$html .= '</select>';
			
			return $html;
		}

		function get_upsell_product ( $product_id, $include_self = false, $limit = 2, $popup = false, $def_source = '', $from_section_prefix = 'salesgen_upsell_bundle_' ) {

			$source              = ($def_source !== '')? $def_source : $this->options['salesgen_upsell_bundle_source'];

			$conditions_match    = isset($this->options[ 'salesgen_upsell_bundle_excludes_conditions_match' ])? $this->options[ 'salesgen_upsell_bundle_excludes_conditions_match'] : '';
			$excludes_conditions = isset($this->options[ 'salesgen_upsell_bundle_excludes_conditions' ])?  $this->options[ 'salesgen_upsell_bundle_excludes_conditions'] : '';
			
			$extra_cfg = array();

			if ( !$popup && $excludes_conditions !== '' ) {
				$extra_cfg = array(
					'exclude' => array(
						//'match' => $conditions_match,
						'conditions' => json_decode( urldecode($excludes_conditions), true)
					)
				);	
			}
			
			$upsells    = $this->get_source_products( $source, $product_id , $include_self, $popup? $limit : 6, $extra_cfg, $from_section_prefix );

			$hide_options = isset($this->options[ $from_section_prefix . 'hide_options'])? $this->options[ $from_section_prefix . 'hide_options'] : 'no';

			return $this->prepare_upsell_product( $upsells, $limit, $hide_options );
		}

		public function upsell_bundle( $is_shortcode = false, $product_id = 0, $custom_layout = false ) {

			global $product;

			$heading           = $this->options['salesgen_upsell_bundle_heading'];
			$enable            = $this->options['salesgen_upsell_bundle_enable'];
			$source            = $this->options['salesgen_upsell_bundle_source'];
			$position          = $this->options['salesgen_upsell_bundle_position'];
			$hide_options_from = isset($this->options['salesgen_upsell_bundle_hide_options_when'])? intval($this->options['salesgen_upsell_bundle_hide_options_when']) : 2;
			$layout            = $custom_layout? $custom_layout : (isset($this->options['salesgen_upsell_bundle_layout'])? intval($this->options['salesgen_upsell_bundle_layout']) : 2);
			$upsell_categories            = isset($this->options['salesgen_upsell_bundle_categories'])? $this->options['salesgen_upsell_bundle_categories'] : array();
			
			$add_action_label = isset($this->options['salesgen_upsell_bundle_add_action_label'])? $this->options['salesgen_upsell_bundle_add_action_label'] : 'Add All To Cart';


			$quickview    = false;
			$parent_type  = is_object($product)? $product->get_type() : '';
			$include_init = true;


			if ( $parent_type == 'external' ) return;

			if( class_exists('Flatsome_Default') ) $quickview = true;

			if ( (defined('DOING_AJAX') && DOING_AJAX) && $position != 'after_added_cart' ) return;

			if (strpos(SALESGEN_US_DIR, base64_decode('c2FsZXNnZW4=')) === false ) return;

			//list( $products, $variants )   = $this->get_upsell_product( $product_id , $include_init );

			list( $products, $variants )   = $this->get_upsell_product( $product_id, $include_init, 2, false, $source, 'salesgen_upsell_bundle_' );

			$layout        = isset($_GET['bundle_layout'])? intval($_GET['bundle_layout']) : $layout;
			$layout        = ($layout == 0)? 2 : $layout;
			$items_cols    = ($layout == 2 || $layout == 3)? 'large-12' : 'large-8';
			$subtotal_cols = ($layout == 2)? 'large-12 pull-right-md' : 'large-4 pull-right-md';
			$image_size    = apply_filters( 'single_product_archive_thumbnail_size', 'woocommerce_thumbnail' );


			

			$checkboxes_html = '';

			//$checkboxes_html .= '<form method="POST" action="' . esc_attr( admin_url('admin-post.php') ) . '" id="salesgen-add-bundle-form"><input type="hidden" name="action" value="sgbmsm" /><ul class="salesgen-upsell-checkboxes">';
			//$checkboxes_html .= '<div id="salesgen-add-bundle-form" class="salesgen-add-bundle-form"><input type="hidden" name="action" value="sgbmsm" /><ul class="salesgen-upsell-checkboxes">';

			

			if ( count($products) > 1 ) {
				$total_cart_item = WC()->cart->get_cart_contents_count();
				$hashover = 'has-hover';
				$classes  = array('salesgen-upsell-wrapper row row-small');

				//if ( $hide_options == 'yes' ) $classes[] = 'sg-hide-options';

				$variants_json = rawurlencode(json_encode($variants, JSON_FORCE_OBJECT));

				require_once "{$this->path}/layouts/bundle_${layout}.php";

			}
			
			wp_reset_postdata();
		}

		public function get_product_available_variations( $product ) {
			$variation_ids        = $product->get_children();
			$available_variations = array();

			if ( is_callable( '_prime_post_caches' ) ) {
				_prime_post_caches( $variation_ids );
			}

			foreach ( $variation_ids as $variation_id ) {

				$variation = wc_get_product( $variation_id );

				// Hide out of stock variations if 'Hide out of stock items from the catalog' is checked.
				if ( ! $variation || ! $variation->exists() || ( 'yes' === get_option( 'woocommerce_hide_out_of_stock_items' ) && ! $variation->is_in_stock() ) ) {
					continue;
				}

				// Filter 'woocommerce_hide_invisible_variations' to optionally hide invisible variations (disabled variations and variations with empty price).
				if ( apply_filters( 'woocommerce_hide_invisible_variations', true, $product->get_id(), $variation ) && ! $variation->variation_is_visible() ) {
					continue;
				}

				
				$image_url = '';
				$image_id = $variation->get_image_id();
              	if ( $image_id > 0 ) {
					$_image_url = wp_get_attachment_image_url( $image_id, 'woocommerce_thumbnail');
					$image_url = $_image_url[0];
              	}

				$available_variations[] = array(
					'attributes'    => $variation->get_variation_attributes(),
					'price'         => wc_get_price_to_display( $variation ),
					'price_html'    => $variation->get_price_html(),
					'regular_price' => wc_get_price_to_display( $variation, array( 'price' => $variation->get_regular_price() ) ),
					'variation_id'  => $variation->get_id(),
					'thumbnail'     => $image_url,
				);
			}

			return $available_variations;
		}

		public function woo_add_to_cart_fragments( $data ) {
			global $wpdb;

			$popup_heading    = '';
			$popup_footer     = '';
			$popup_items_html = '';
			$popup_items      = '';
			$ga_label         = '';
			$total_added      = count( $this->just_added_cart );
			//$time_start = mktime();

			if ( $total_added > 0 ) {

				//go to cart page if add bundle
				if ( $total_added > 1 ) {
					$data['go_to_cart'] = wc_get_cart_url();
				}

				$_product      = ( isset($this->just_added_cart[0]['_obj']) && is_object($this->just_added_cart[0]['_obj']) )? $this->just_added_cart[0]['_obj'] : wc_get_product( $this->just_added_cart[0]['id'] );
				$ga_label 	   = esc_js( $_product->get_sku() ? 'ID ' . $_product->get_sku() : "#" . $_product->get_id() );
				$_main_product = method_exists($_product, 'get_parent_id')? $_product->get_parent_id() : $this->just_added_cart[0]['id'];

				$_main_product = $_main_product > 0? $_main_product : $this->just_added_cart[0]['id'];

				$source        = $this->options['salesgen_upsell_popup_source'];
				$hide_items    = $this->options['salesgen_upsell_popup_hide_items'];
				$limti_items   = isset($this->options['salesgen_upsell_popup_limit'])? $this->options['salesgen_upsell_popup_limit'] : 10;
				$hide_options = isset($this->options['salesgen_upsell_popup_hide_options'])? $this->options['salesgen_upsell_popup_hide_options'] : 'no';
				$products_layout = isset($this->options['salesgen_upsell_popup_products_layout'])? $this->options['salesgen_upsell_popup_products_layout'] : 'default';
				$add_action_label = isset($this->options['salesgen_upsell_popup_add_action_label'])? $this->options['salesgen_upsell_popup_add_action_label'] : 'Add to cart';
				$popup_heading_text = isset($this->options['salesgen_upsell_popup_heading_text'])? $this->options['salesgen_upsell_popup_heading_text'] : 'Frequently bought with [product_name]';


				if ( $hide_items != "yes" ) {

					//buy more save more message
					//$this->bmsm->sale_custom_price();

					$popup_items = '';

					//upsell items
					list( $products, $variants )   = $this->get_upsell_product( $_main_product, false, $limti_items, true, $source, 'salesgen_upsell_popup_' );

					if ( count( $products ) > 0 ) {

						$products_layout .= ($products_layout != 'default')? ' sg-upsell-multi_cols' : '';
						
						$popup_items .= '<div class="sg-upsell-lightbox-content-items sg-upsell-items-layout-'. $products_layout .'"'. " data-variants='" . rawurlencode(json_encode( $variants, JSON_FORCE_OBJECT )) . "'" . '>';

						$popup_items .= apply_filters( 'sg_popup_cart_before_items', '' );

						$popup_heading_text = str_replace(array('[product_name]'), array($_product->get_name()), $popup_heading_text);

						if ( !empty($popup_heading_text) ) {
							$popup_items .= '<h3 class="sg-upsell-lightbox-heading-frequently">' . $popup_heading_text .'</h3>';	
						}
						
						$popup_items .= '<ul class="salesgen-upsell-popup-items">';
						
						foreach ( $products as $prod ) {

							///$attributes_empty = rawurlencode(json_encode($prod['attributes_empty'], JSON_FORCE_OBJECT));


							$html_attrs = array();

							$html_attrs[] = 'data-parent="' . $prod['parent_id'] . '"';
							$html_attrs[] = 'data-id="' . $prod['id'] . '"';
							$html_attrs[] = 'data-price="' . $prod['price'] . '"';
							$html_attrs[] = 'data-base-price="' . $prod['price'] . '"';
							$html_attrs[] = 'class="salesgen-upsell-popup-item-list"';

							if ( $prod['product_type'] == 'variable' ) {
								$_data_variant = rawurlencode( json_encode($variants[ $prod['id'] ], JSON_FORCE_OBJECT));
								$html_attrs[] = "data-variants='" . $_data_variant ."'";	
								$html_attrs[] = "data-default_attributes='" .json_encode($prod['default_attributes'], JSON_FORCE_OBJECT) ."'";	
							}

							$popup_items .= '<li '. implode(' ', $html_attrs).'>';
							$popup_items .= '<div class="salesgen-upsell-item-thumb-small">' . $prod['thumbnail'] .'</div>';
							
							$popup_items .= '<div class="salesgen-upsell-item-info">';
							$popup_items .= '<form>';
							if ( $prod['product_type'] == 'variable' ) {
								$popup_items .= '<input name="variation_id" value="" type="hidden"/>';	
							}
							$popup_items .= '<input type="hidden" name="product_id" value="' . $prod['parent_id'] .'">';
							$popup_items .= '<p class="name product-title woocommerce-loop-product__title">';
							$popup_items .= '<a href="'.$prod['url'] .'">' . $prod['default_name'] .'</a><div class="sgbmsm-price-checkbox">' . $prod['price_html'] . '</div>' . $prod['child_html'];
							$popup_items .= '</p>';

							if ( $hide_options != 'yes' ) {
								$popup_items .= '<button type="submit" class="sg_single_add_to_cart_button button alt">'. (!empty($add_action_label)? $add_action_label : 'Add to cart' ).'</button>';
							} else {
								$popup_items .= '<a href="'.$prod['url'] .'" class="button alt">'.(!empty($add_action_label)? $add_action_label : 'Add to cart' ).'</a>';
							}
							
							$popup_items .= '</form></div></li>';
						}

						$popup_items .= '</ul></div>';

					}

					ob_start();
					

					echo $popup_items;
					$popup_items_html = ob_get_contents();
					ob_end_clean();

				}

				

				$image_size = apply_filters( 'single_product_archive_thumbnail_size', 'woocommerce_thumbnail' );

				ob_start();
				?>
					<div class="sg-upsell-lightbox-content-heading">
						<div class="sg-upsell-lightbox-content-message">
							
							<div class="sg-popup-product-thumb">
								<?php
									echo $_product ? $_product->get_image( $image_size ) : '';
								?>
							</div>
							<div class="sg-popup-product-cart-info">
								<h3>
									<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 507.2 507.2" style="enable-background:new 0 0 507.2 507.2;" xml:space="preserve"> <circle style="fill:#32BA7C;" cx="253.6" cy="253.6" r="253.6"/> <path style="fill:#0AA06E;" d="M188.8,368l130.4,130.4c108-28.8,188-127.2,188-244.8c0-2.4,0-4.8,0-7.2L404.8,152L188.8,368z"/> <g> <path style="fill:#FFFFFF;" d="M260,310.4c11.2,11.2,11.2,30.4,0,41.6l-23.2,23.2c-11.2,11.2-30.4,11.2-41.6,0L93.6,272.8 c-11.2-11.2-11.2-30.4,0-41.6l23.2-23.2c11.2-11.2,30.4-11.2,41.6,0L260,310.4z"/> <path style="fill:#FFFFFF;" d="M348.8,133.6c11.2-11.2,30.4-11.2,41.6,0l23.2,23.2c11.2,11.2,11.2,30.4,0,41.6l-176,175.2 c-11.2,11.2-30.4,11.2-41.6,0l-23.2-23.2c-11.2-11.2-11.2-30.4,0-41.6L348.8,133.6z"/> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> </svg>
									<?php esc_html_e( 'You have just added', 'woocommerce' ); ?></h3>
								<span><?php echo $_product->get_name(); ?></span>
							</div>
						</div>
						
					</div>
				<?php

				$popup_heading = ob_get_contents();
				ob_end_clean();

				//footer button contents
				ob_start();
				?>
					<div class="sg-upsell-lightbox-content-footer">
						<div class="sg-modal-buttons">
							<span class="sg-btn-cart-view">
								<div class="sg-upsell-cart-icon">
								<svg id="Layer_1" enable-background="new 0 0 511.728 511.728" height="512" viewBox="0 0 511.728 511.728" width="512" xmlns="http://www.w3.org/2000/svg"><path d="m147.925 379.116c-22.357-1.142-21.936-32.588-.001-33.68 62.135.216 226.021.058 290.132.103 17.535 0 32.537-11.933 36.481-29.017l36.404-157.641c2.085-9.026-.019-18.368-5.771-25.629s-14.363-11.484-23.626-11.484c-25.791 0-244.716-.991-356.849-1.438l-17.775-65.953c-4.267-15.761-18.65-26.768-34.978-26.768h-56.942c-8.284 0-15 6.716-15 15s6.716 15 15 15h56.942c2.811 0 5.286 1.895 6.017 4.592l68.265 253.276c-12.003.436-23.183 5.318-31.661 13.92-8.908 9.04-13.692 21.006-13.471 33.695.442 25.377 21.451 46.023 46.833 46.023h21.872c-3.251 6.824-5.076 14.453-5.076 22.501 0 28.95 23.552 52.502 52.502 52.502s52.502-23.552 52.502-52.502c0-8.049-1.826-15.677-5.077-22.501h94.716c-3.248 6.822-5.073 14.447-5.073 22.493 0 28.95 23.553 52.502 52.502 52.502 28.95 0 52.503-23.553 52.503-52.502 0-8.359-1.974-16.263-5.464-23.285 5.936-1.999 10.216-7.598 10.216-14.207 0-8.284-6.716-15-15-15zm91.799 52.501c0 12.408-10.094 22.502-22.502 22.502s-22.502-10.094-22.502-22.502c0-12.401 10.084-22.491 22.483-22.501h.038c12.399.01 22.483 10.1 22.483 22.501zm167.07 22.494c-12.407 0-22.502-10.095-22.502-22.502 0-12.285 9.898-22.296 22.137-22.493h.731c12.24.197 22.138 10.208 22.138 22.493-.001 12.407-10.096 22.502-22.504 22.502zm74.86-302.233c.089.112.076.165.057.251l-15.339 66.425h-51.942l8.845-67.023 58.149.234c.089.002.142.002.23.113zm-154.645 163.66v-66.984h53.202l-8.84 66.984zm-74.382 0-8.912-66.984h53.294v66.984zm-69.053 0h-.047c-3.656-.001-6.877-2.467-7.828-5.98l-16.442-61.004h54.193l8.912 66.984zm56.149-96.983-9.021-67.799 66.306.267v67.532zm87.286 0v-67.411l66.022.266-8.861 67.145zm-126.588-67.922 9.037 67.921h-58.287l-18.38-68.194zm237.635 164.905h-36.426l8.84-66.984h48.973l-14.137 61.217c-.784 3.396-3.765 5.767-7.25 5.767z"/></svg>
								<span class="sg-upsell-count-badges"><span class="sg-upsell-popup-total-items"><?php echo WC()->cart->get_cart_contents_count() ;?></span></span>
								</div>
								<span class="sg-upsell-popup-total-price"><?php echo WC()->cart->get_cart_total() ;?></span>
							</span>
							<a class="sg-view-cart-btn" rel="nofollow" href="<?php echo wc_get_cart_url();?>"><span><?php esc_html_e( 'View cart', 'woocommerce' ); ?></span></a>
							<a class="sg-proceed-checkout" rel="nofollow" href="<?php echo wc_get_checkout_url();?>"><span><?php esc_html_e( 'Checkout', 'woocommerce' ); ?></span></a>
						</div>
					</div>
				<?php
				$popup_footer = ob_get_contents();
				ob_end_clean();
			}

			$data['sg-upsell-lightbox-content-heading'] = $popup_heading;
			$data['sg-upsell-lightbox-content-footer']  = $popup_footer;
			$data['sg-upsell-lightbox-content-items']   = $popup_items_html;
			$data['sg_ga_label']   = $ga_label;
			

			if ( !class_exists( 'WC_Facebook_Loader' ) ) {
				$sg_fb_events = array();
				$_fb_currency = get_woocommerce_currency();

				foreach ($this->just_added_cart as $_product) {

					$sg_fb_events[] = array(
						'content_ids' => array( $_product['id']),
						'content_name' => $_product['name'],
						'content_type' => 'product',
						'value' => $_product['price'],
						'currency' => $_fb_currency,
					);
				}

				$data['sg_fb_events'] = $sg_fb_events;
			}

			if( class_exists('snap_pixel') ) {
				$items_ids = array();
				$_product      = $this->just_added_cart[0];
				$items_ids[]	 = $_product['id'];
				$categories = wp_get_post_terms($_product['id'], 'product_cat');
				$category_name = '';
				if( !empty($categories) ) {
					$category_name = $categories[0]->name;
				}
				
				$data['sg_snapchat_events'] = array(
					'currency' => get_woocommerce_currency(),
					'price' => $_product['price'],
					'item_category' => $category_name,
					'item_ids' => $items_ids,
				);

				// if category name is empty, remove item_category
				if( empty($category_name) ) {
					unset($data['sg_snapchat_events']['item_category']);
				}
			}

			return $data;

		}

		/**
		 * Author: S a l e s N u d g e.io
		 */

		function get_default_attributes( $product ) {
			
			if ( method_exists( $product, 'get_default_attributes' ) ) {

				$def_attrs  = $product->get_default_attributes();

				$attributes = $product->get_attributes();
				
				if ( count( $def_attrs ) != count( $attributes ) ) {
					$def_attrs_keys = array_keys( $def_attrs );

					foreach ( $attributes as $attr_key => $attr_data ) {

						$terms = wc_get_product_terms(
							$product->get_id(),
							$attr_key,
							array(
								'fields' => 'all',
							)
						);

						if( !in_array ($attr_key, $def_attrs_keys ) ){
							if ( !is_object( $attr_data ) ) continue;
							$options = $attr_data->get_options();

							if( count($terms)> 0 ) {
								$def_attrs[ $attr_key ] = $terms[0]->slug;
							}
						}
					}
				}
				
				return $def_attrs;

			} else {

				return $product->get_default_attributes();

			}

		}
		function find_matching_product_variation( $product, $attributes ) {

			foreach( $attributes as $key => $value ) {
				if( strpos( $key, 'attribute_' ) === 0 ) {
					continue;
				}

				unset( $attributes[ $key ] );
				//$attr_key = str_replace('pa_', '', $key);
				$attr_key = $key;
				$attributes[ sprintf( 'attribute_%s', $attr_key ) ] = $value;
			}

			if( class_exists('WC_Data_Store') ) {

				$data_store = WC_Data_Store::load( 'product' );
				
				return $data_store->find_matching_product_variation( $product, $attributes );

			} else {

				return $product->get_matching_variation( $attributes );

			}

		}

		/**
		 * Author: Anthony from S-ale-sg-u-d-ge.io
		 */

		public function enqueue_script() {
			
			if ( $this->minify ) {
				//wp_enqueue_style( 'sgbmsm-css', 'https://assets.snclouds.com/salesgen/upsellblast/v' . SGUS . '/styles.min.css', false, SALESGEN_US_VER );
				//wp_enqueue_script( 'sgbmsm-js', 'https://assets.snclouds.com/salesgen/upsellblast/v' . SGUS . '/scripts.min.js', array( 'jquery' ), SALESGEN_US_VER, true  );
				
				wp_enqueue_style( 'sgbmsm-css', $this->url .'assets/css/styles.min.css', false, SALESGEN_US_VER );
				wp_enqueue_script( 'sgbmsm-js', $this->url .'assets/js/scripts.min.js', array( 'jquery' ), SALESGEN_US_VER, true  );

			} else {
				wp_enqueue_style( 'sgbmsm-css', $this->url .'assets/css/styles.css', false, SALESGEN_US_VER );
				wp_enqueue_script( 'sgbmsm-js', $this->url .'assets/js/scripts.js', array( 'jquery' ), SALESGEN_US_VER, true  );
			}

			$discount_type = isset($this->bmsm->options['salesgen_bmsm_conditional'])? $this->bmsm->options['salesgen_bmsm_conditional'] : 'items';

			if ( $discount_type == 'items' ) {

				$by_items       = isset($this->bmsm->options['salesgen_buy_more_by_items'])? $this->bmsm->options['salesgen_buy_more_by_items'] : '';
				$discount_rules = ($by_items == '')? array('number_item' => array(), 'amount' => array()) : json_decode( urldecode($by_items), true );

			} else {
				$items          = isset($this->bmsm->options['salesgen_buy_more_by_amounts'])? $this->bmsm->options['salesgen_buy_more_by_amounts'] : '[]';
				$discount_rules = json_decode(urldecode($items));
			}

			$total_cart_item = 0;
			$cart_price      = 0;
			$cart_url        = '';
			if ( !is_admin() && class_exists('WooCommerce') ) {
				$total_cart_item = WC()->cart->get_cart_contents_count();
				$cart_price      = WC()->cart->get_cart_contents_total();
				$cart_url        = wc_get_cart_url();
			}
			//custom CSS
			$custom_css = '';
			$fields_settings = $this->settings->options();

			$background_colors = array();
			foreach ($fields_settings as $field) {
				
				if ( 
					isset( $field['css'] ) && 
					isset( $this->options[ $field['id'] ]) &&
					!empty($this->options[ $field['id'] ]) && 
					$this->options[ $field['id'] ] != $field['default']
				) {
					
					if ( is_array($field['css']) ) {
						$_field = $field;

						foreach ( $field['css'] as $_css ) {
							$_field['css'] = $_css;
							$custom_css .= SG_UB_Render::css( $_field, $this->options );
						}
					} else {
						$custom_css .= SG_UB_Render::css( $field, $this->options );
					}
				}
			}


			if ( !empty($custom_css) ) {
				wp_add_inline_style( 'sgbmsm-css', $custom_css );	
			}
			
			$wc_currency_symbol = '&#36;';

			if ( function_exists('get_woocommerce_currency_symbol') ) {
				$wc_currency_symbol = get_woocommerce_currency_symbol('');
			}
			
			wp_localize_script( 'sgbmsm-js', 'sgbmsmcfg', array(
				'ajax_url'           => admin_url( 'admin-ajax.php' ),
				'discount_rules'     => $discount_rules,
				'discount_type'      => $discount_type,
				'total_cart_item'    => $total_cart_item,
				'cart_price'         => $cart_price,
				'options'            => $this->options,
				'ajax_cart'          => ('yes' === get_option( 'woocommerce_enable_ajax_add_to_cart' ))? 'yes' : 'no',
				'redirect_cart'      => ('yes' === get_option( 'woocommerce_cart_redirect_after_add' ))? 'yes' : 'no',
				'cart_url'           => $cart_url,
				"wc_currency_symbol" => $wc_currency_symbol
			) );
		}

		

		public function admin_scripts()	{
			$screen = get_current_screen();

			if ( in_array( $screen->id, array( 'salesgen_page_upsellblast' ) ) ) {
			    wp_enqueue_style( 'wp-color-picker' );
	    		wp_enqueue_script( 'wp-color-picker' );

	    		$categories = $this->all_categories();
				$options = array();
				$options_ids = array();

				foreach ( $categories as $category ) {
					$options[] = array( $category->slug, trim( $category->cat_name ) );
					$options_ids[] = array( $category->term_id, trim( $category->cat_name ) );
				}

				wp_localize_script( 'jquery-core', 'sgubcfg', array(
					'options'                  => $this->options,
					'salesgen_bmsm_categories' => $options,
					'product_categories'       => $options,
					'product_category_ids'     => $options_ids,
					
				) );
			}

			
		}

		public function one_applied_coupon_only( $cart ) {
			if ( is_admin() && ! defined( 'DOING_AJAX' ) )
			return;



			if ( did_action( 'woocommerce_before_calculate_totals' ) >= 2 )
				return;
			$allow_one = get_option('salesgen_advanced_coupons_one');
			// For more than 1 applied coupons only
			if ( $allow_one == 'yes' && sizeof($cart->get_applied_coupons()) > 1 && $coupons = $cart->get_applied_coupons() ){
				// Remove the first applied coupon keeping only the last appield coupon
				$cart->remove_coupon( reset($coupons) );
			}
		}

		public function create_coupon( ) {
			if ( 
				$this->options['salesgen_coupon_enable'] == 'yes' &&
				is_wc_endpoint_url( 'order-received' ) && 
				!empty( $_GET[ 'key' ] ) 
			) {
				$order_id = wc_get_order_id_by_order_key( $_GET[ 'key' ] );
				$discount_coupon = get_post_meta($order_id, 'sg_coupon', true );
				$discount_amount = $this->options['salesgen_coupon_amount'];
				$discount_code   = isset($this->options['salesgen_coupon_code'])? trim($this->options['salesgen_coupon_code']) : '' ;

				if ( $discount_code == '' && empty($discount_coupon) ) {
					$discount_coupon = $this->generate_coupon_code('percent', $discount_amount);
					update_post_meta( $order_id, 'sg_coupon', $discount_coupon );				
				}

				$this->send_mail_coupon( $order_id );
			}
		}
		

		public function send_mail_coupon( $order_id ) {
			

			if ( $this->options['salesgen_coupon_enable'] == 'yes' ) {

				
				$sg_coupon_sent = get_post_meta($order_id, 'sg_coupon_sent', true );
				
				if ( $sg_coupon_sent == 'yes' ) return;

				$discount_coupon = get_post_meta($order_id, 'sg_coupon', true );

				$discount_amount = $this->options['salesgen_coupon_amount'];
				$discount_code   = isset($this->options['salesgen_coupon_code'])? trim($this->options['salesgen_coupon_code']) : '' ;

				if ( $discount_code == '' && empty($discount_coupon) ) {
					$discount_coupon = $this->generate_coupon_code('percent', $discount_amount);
					update_post_meta( $order_id, 'sg_coupon', $discount_coupon );				
				}
				if ( $discount_code != ''){
					$discount_coupon = $discount_code;
				}

				update_post_meta( $order_id, 'sg_coupon_sent', 'yes');				

				$order         = new WC_Order( $order_id );
				$site_name     = get_bloginfo('name');
				$billing_email = $order->billing_email;
				$billing_fname = $order->billing_first_name;
				$message       = $this->options['salesgen_coupon_email_content'];
				$subject       = $this->options['salesgen_coupon_email_subject'];
				$message       = nl2br($message);
				$discount_coupon = strtoupper($discount_coupon);



				$message = str_replace( 
					array(
						'{{site.name}}', 
						'{{customer.name}}', 
						'{{discount.amount}}', 
						'{{discount.code}}', 
						'{{customer.email}}'
					), 
					array( 
						$site_name, 
						$billing_fname, 
						$discount_amount, 
						$discount_coupon, 
						$billing_email 
					), 
					$message
				);

				$subject = str_replace( 
					array(
						'{{site.name}}', 
						'{{customer.name}}', 
						'{{discount.amount}}', 
						'{{discount.code}}', 
						'{{customer.email}}'
					), 
					array( 
						$site_name, 
						$billing_fname, 
						$discount_amount, 
						$discount_coupon, 
						$billing_email 
					), 
					$subject
				);

				add_filter( 'wp_mail_content_type', array( $this, 'set_mail_content_type' ) );

				//Set From and To to match WooCommerce Settings
				add_filter( 'wp_mail_from', function ( $email ) {
					return get_option( 'woocommerce_email_from_address' );
				} );

				add_filter( 'wp_mail_from_name', function ( $name ) {
					return get_option( 'woocommerce_email_from_name' );
				} );

				$headers = $headers = [
					'Content-Type: ' . $this->set_mail_content_type(),
				];
				error_log("Send email to customer for the discount email.");
				$result = wp_mail( $billing_email, $subject, $message, $headers );


			}
			
		}

		public function set_mail_content_type() {
			return 'text/html';
		}

		function generate_coupon_code( $discount_type = 'percent', $amount = 15, $expiry = '', $free_shipping = 'no', $individual_use = 'no' ) {

			$coupon_code = '';
			$coupon_code = 'SG-' . wp_generate_password( 8, false, false );

			$new_coupon_id = wp_insert_post(
				array(
					'post_title'   => $coupon_code,
					'post_content' => '',
					'post_status'  => 'publish',
					'post_author'  => 1,
					'post_type'    => 'shop_coupon',
				)
			);

			$coupon_post_data = array(
				'discount_type'       => $discount_type,
				'description'         => '',
				'coupon_amount'       => $amount,
				'individual_use'      => $individual_use,
				'product_ids'         => '',
				'exclude_product_ids' => '',
				'usage_limit'         => '1',
				'usage_count'         => '0',
				'date_expires'        => $expiry,
				'apply_before_tax'    => 'yes',
				'free_shipping'       => $free_shipping,
				'coupon_generated_by' => SG_COUPON_GENERATED_BY,
			);

			foreach ( $coupon_post_data as $key => $value ) {
				update_post_meta( $new_coupon_id, $key, $value );
			}

			return $coupon_code;
		}

		function related_products_ids( $ids = array(), $cart = null ) {

			$source = isset($this->options['salesgen_related_source'])? $this->options['salesgen_related_source'] : 'related';
			$limit  = isset($this->options['salesgen_related_limit'])? $this->options['salesgen_related_limit'] : 4;
			$excludes_conditions = isset($this->options[ 'salesgen_related_excludes_conditions' ])?  $this->options[ 'salesgen_related_excludes_conditions'] : '';
			
			$extra_cfg = array();

			if ( $excludes_conditions !== '' ) {
				$extra_cfg = array(
					'exclude' => array(
						//'match' => $conditions_match,
						'conditions' => json_decode( urldecode($excludes_conditions), true)
					)
				);	
			}


			global $wp, $woocommerce;

			if ( empty($cart) ) $cart = WC()->cart;

			$cross_sells_items = array();

			foreach ( $cart->get_cart() as $cart_item_key => $values ) {
				if ( $values['quantity'] > 0 ) {
					$product_id  = $values['product_id'];
					$cross_sell = $this->get_source_products( $source, $product_id, false, $limit, $extra_cfg, 'salesgen_related_' );
					$cross_sells_items = array_merge($cross_sells_items,$cross_sell);
				}
			}

			return $cross_sells_items;
		}
		

		function cart_crosssell_ids( $ids = array(), $cart = null ) {
			global $wp, $woocommerce;
			$source = isset($this->options['salesgen_cart_upsell_source'])? $this->options['salesgen_cart_upsell_source'] : 'related';
			$limit  = isset($this->options['salesgen_cart_upsell_limit'])? $this->options['salesgen_cart_upsell_limit'] : 4;
			$excludes_conditions = isset($this->options[ 'salesgen_cart_upsell_excludes_conditions' ])?  $this->options[ 'salesgen_cart_upsell_excludes_conditions'] : '';
			
			$extra_cfg = array();

			if ( $excludes_conditions !== '' ) {
				$extra_cfg = array(
					'exclude' => array(

						'conditions' => json_decode( urldecode($excludes_conditions), true)
					)
				);	
			}


			

			if ( empty($cart) ) $cart = WC()->cart;

			if ( is_null( WC()->cart ) ) {
				wc_load_cart();
				$cart = WC()->cart;
			}
			
			$cross_sells_items = array();
			
			foreach ( $cart->get_cart() as $cart_item_key => $values ) {
				
				if ( $values['quantity'] > 0 ) {
					$product_id  = $values['product_id'];
					$cross_sell = $this->get_source_products( $source, $product_id, false, $limit, $extra_cfg, 'salesgen_cart_upsell_' );
					$cross_sells_items = array_merge($cross_sells_items,$cross_sell);
				}
			}

			return $cross_sells_items;
		}

		function thankyou_crosssell_ids( $order_id ) {

			$source = isset($this->options['salesgen_thankyou_upsell_source'])? $this->options['salesgen_thankyou_upsell_source'] : 'related';
			$limit  = isset($this->options['salesgen_thankyou_upsell_limit'])? $this->options['salesgen_thankyou_upsell_limit'] : 4;
			$excludes_conditions = isset($this->options[ 'salesgen_thankyou_upsell_excludes_conditions' ])?  $this->options[ 'salesgen_thankyou_upsell_excludes_conditions'] : '';
			
			$extra_cfg = array();

			if ( $excludes_conditions !== '' ) {
				$extra_cfg = array(
					'exclude' => array(
						//'match' => $conditions_match,
						'conditions' => json_decode( urldecode($excludes_conditions), true)
					)
				);	
			}

			$order  = wc_get_order( $order_id );
			$items  = $order->get_items();


			$cross_sells_items = array();

			if ( count( $items ) > 0 ) {
				foreach( $items as $item_id => $item_data ) {
					$product_id        = $item_data->get_product_id();
					$cross_sell        = $this->get_source_products( $source, $product_id, false, $limit, $extra_cfg, 'salesgen_thankyou_upsell_' );
					$cross_sells_items = array_merge($cross_sells_items,$cross_sell);
				}
			}

			return $cross_sells_items;
		}

		function related_products_box( $product_init = 0) {

			global $woocommerce, $product;

			if ( !isset($this->options['salesgen_related_enable']) || $this->options['salesgen_related_enable'] != 'yes' ) return;

			if ( $product_init > 0 ) {
				$product_id = $product_init;					
			} else {
				if ( $product ) {
					$product_id = $product->get_id();
				} else {
					return;
				}
			}

			$heading               = isset($this->options['salesgen_related_heading'])? $this->options['salesgen_related_heading'] : __( 'Related Products', 'salesgen-upsell' );
			$limit               = isset($this->options['salesgen_related_limit'])? $this->options['salesgen_related_limit'] : 4;
			$source              = $this->options['salesgen_related_source'];
			$conditions_match    = isset($this->options[ 'salesgen_related_excludes_conditions_match' ])? $this->options[ 'salesgen_related_excludes_conditions_match'] : '';
			$excludes_conditions = isset($this->options[ 'salesgen_related_excludes_conditions' ])?  $this->options[ 'salesgen_related_excludes_conditions'] : '';
			$hide_options = isset($this->options[ 'salesgen_related_hide_options'])? $this->options[ 'salesgen_related_hide_options'] : 'no';


			$extra_cfg = array();

			if ( $excludes_conditions !== '' ) {
				$extra_cfg = array(
					'exclude' => array(
						//'match'      => $conditions_match,
						'conditions' => json_decode( urldecode($excludes_conditions), true)
					)
				);	
			}
			
			$product_ids    = $this->get_source_products( $source, $product_id , false, $limit, $extra_cfg, 'salesgen_related_' );
			

			list( $products, $variants )   = $this->prepare_upsell_product( $product_ids );

			echo SG_UB_Render::related_products_display( $products, $variants, array(
				'heading'      => $heading,
				'cols_classes' => 'large-columns-4 medium-columns-4 small-columns-2',
				'hide_options' => $hide_options
			));

			
		}


		function cart_cross_sell_display() {
			
			if ( $this->options['salesgen_cart_upsell_enable'] != 'yes' ) return;
			
			$ids   = $this->cart_crosssell_ids();
			
			$limit = isset($this->options['salesgen_cart_upsell_limit'])? $this->options['salesgen_cart_upsell_limit'] : 3;
			$hide_options = isset($this->options[ 'salesgen_cart_upsell_hide_options'])? $this->options[ 'salesgen_cart_upsell_hide_options'] : 'no';

			$product_ids = array_slice($ids, 0, $limit);

			list( $products, $variants )   = $this->prepare_upsell_product( $product_ids );

			echo SG_UB_Render::cross_sell_display( $products, $variants, array(
				'heading' => __( 'You may be interested in&hellip;', 'woocommerce' ),
				'cols_classes' => 'large-columns-4 medium-columns-4 small-columns-2',
				'hide_options' => $hide_options
			));

			
		}

		function cart_cross_sell_display_shortcode( $atts ) {
			
			ob_start();
			
			$this->cart_cross_sell_display();
			$html = ob_get_contents(); 
			ob_end_clean();
			echo 'fdsfdsfdsfdsf dsfds fds';
			return $html;
		}

		function thankyou_cross_sell_display( $order_id = 0 ) {

			WC()->session->set( 'sgupsellbundle', array() );
			
			if ( 
				!isset( $this->options['salesgen_thankyou_upsell_enable'] ) ||
				$this->options['salesgen_thankyou_upsell_enable'] != 'yes' 
			) return;

			global $wp;

			$discount_amount = $this->options['salesgen_coupon_amount'];

			$order = wc_get_order( $order_id );

			if ( !$order->has_status( 'failed' ) ) {

				$coupon = '';
				if ( 
					isset( $this->options['salesgen_coupon_enable'] ) &&
					$this->options['salesgen_coupon_enable'] == 'yes' 
				) {
					$discount_code   = isset($this->options['salesgen_coupon_code'])? $this->options['salesgen_coupon_code'] : '' ;
					if ( empty($discount_code) ) {
						$coupon = get_post_meta($order_id, 'sg_coupon', true );

						if ( empty($coupon) ) {
							$coupon = $this->generate_coupon_code( 'percent', $discount_amount );
							update_post_meta( $order_id, 'sg_coupon', $coupon );				
						}
					} else {
						$coupon = $discount_code;
					}
				}

				$order_received_endpoint = get_option( 'woocommerce_checkout_order_received_endpoint', 'order-received' );

				if ( is_checkout() && isset( $wp->query_vars[ $order_received_endpoint ] ) ) {

					$ids = $this->thankyou_crosssell_ids( $order_id );
					$limit = isset($this->options['salesgen_thankyou_upsell_limit'])? $this->options['salesgen_thankyou_upsell_limit'] : 3;
					$hide_options = isset($this->options[ 'salesgen_thankyou_upsell_hide_options'])? $this->options[ 'salesgen_thankyou_upsell_hide_options'] : 'no';

					$product_ids = array_slice($ids, 0,  intval($limit));


					list( $products, $variants )   = $this->prepare_upsell_product( $product_ids );

					echo '<div class="sg-upsell-lightbox sg-lightbox-active sg-thankyou">
					<div class="sg-upsell-lightbox-body">
						<div class="sg-upsell-lightbox-content">';
					echo '<div class="sg-upsell-lightbox-content-heading"><h2>Thanks! You\'re Awesome. <em>Seriously</em>.</h2>';
					echo '<p>Your order has been placed. Please check your email for order confirmation and detailed delivery information.</p></div>';

					
					if ( !empty( $coupon ) ) {
						echo '<div class="sg-upsell-cart-coupon"><div class="sg-cart-coupon-spliter">';
						echo '<p>Hooray! You got big discount to get <strong>'.$discount_amount.'% OFF</strong> your next purchase</p>';
						echo '<input type="text" class="sg-cart-coupon-code" value="'.$coupon.'" readonly="readonly"/>';
						echo '<span class="sg-cart-coupon-copy">Copy</span>';
						echo '</div></div>';
					}

					echo SG_UB_Render::cross_sell_display( $products, $variants, array(
						'heading' => __( 'Products Related to Your Purchase', 'woocommerce' ),
						'cols_classes' => 'large-columns-4 medium-columns-4 small-columns-2',
				'hide_options' => $hide_options
					));

					echo '<a href="#" class="sg-upsell-lightbox-close" rel="nofollow" title="">×</a></div></div><div class="sg-upsell-lightbox-overlay"></div></div>';
				}
			}


			

			
		}

		

		public function get_category_products( $cats_array, $exclude = false, $limit = 4, $orderby = 'rand', $order = 'desc' ) {
			global $woocommerce;

			$meta_query = array();
			$meta_query[] = $woocommerce->query->visibility_meta_query();
			$meta_query[] = $woocommerce->query->stock_status_meta_query();
			
			// Get the posts
			$args =  array(
				'orderby'       => 'rand',
				'posts_per_page'=> $limit,
				'post_type'     => 'product',
				'fields'        => 'ids',
				'meta_query'    => $meta_query,
				'tax_query'     => array(
					array(
						'taxonomy'  => 'product_cat',
						'field'     => 'id',
						'terms'     => $cats_array
					)
				)
			);

			if ( $exclude ) {
				$args['tax_query'][0]['operator'] = 'NOT IN';
			}

			$query   = new WP_Query( $args );
			$upsells = wc_products_array_orderby( array_filter( array_map( 'wc_get_product', $query->posts ), 'wc_products_array_filter_visible' ), 
			$orderby, $order );
			
			return $upsells;
			
		}


		public function ajax_add_to_cart() {

			$product_id     = apply_filters('sg_woo_add_to_cart_product_id', isset($_POST['product_id'])? absint($_POST['product_id']) : 0);
			$quantity       = empty($_POST['quantity']) ? 1 : absint($_POST['quantity']);
			$variation_id   = isset($_POST['variation_id'])? absint($_POST['variation_id']) : 0;
			$products_str   = isset($_POST['products'])? $_POST['products'] : '';
			$variation_data = array();

			$cart_status = false;

			try {
				ob_start();
				//bundle
				if ( !empty($products_str) ) {
					$_bundle = WC()->session->get( 'sgupsellbundle' );

					//init bundle data
					$_bundle = empty($_bundle)? array() : $_bundle;

					$_bundle_added = array(
						'items' => array(),
						'total' => 0
					);
					
					$products = (array) json_decode(html_entity_decode( stripslashes ($products_str)), true);
					
					$this->just_added_cart = array();

					$quantity = 1;

					//backup data
					$__request = $_REQUEST;
					$__post = $_POST;

					foreach ( $products as $indx => $product ) {
						
						$_cart_status = true;
						$variation_data = array();
						$_product_price = 0;
						$_product_name = '';

						$_product_attrs = (array) $product['attr'];

						$_REQUEST = $__request;
						$_POST = $__post;
						if ( count($_product_attrs) > 0 ) {
							foreach ($_product_attrs as $key => $val) {
								$_REQUEST[ $key ] = $_POST[ $key ] = $val;
								if ( strpos($key, 'attribute') !== false ) {
									$attr = $key;
									$variation_data[ $attr ] = $val;
								}
							}
						}


						$passed_validation = apply_filters( 'woocommerce_add_to_cart_validation', true, $product['product_id'], 1 );
						if ( $passed_validation ) {
							if ( $product['product_id'] != $product['variation_id'] ) {
								$_obj_product = wc_get_product($product['variation_id']);

								$_cart_status = WC()->cart->add_to_cart( $product['product_id'], $quantity, $product['variation_id'], $variation_data );

								
								$_product_price = $_obj_product->get_price();
								$_product_name = $_obj_product->get_name();
							} else {
								$_obj_product = wc_get_product($product['product_id']);

								$_cart_status           = WC()->cart->add_to_cart( $product['product_id'], $quantity );
								
								$_product_price = $_obj_product->get_price();
								$_product_name = $_obj_product->get_name();
							}

							//unset for next product
							if ( count($_product_attrs) > 0 ) {
								foreach ($_product_attrs as $key => $val) {
									unset($_POST[ $key ]);
									unset($_REQUEST[ $key ]);
								}
							}

							if ( $_cart_status ) {
								$_bundle_added['items'][] = $product['product_id'];
								$_bundle_added['total'] += $_product_price;
								$cart_status = true;

								wc_add_to_cart_message( array( $product['product_id'] => $quantity ), true );
								$this->just_added_cart[] = array(
									'id'       => $product['product_id'],
									'price'    => $_product_price,
									'name'     => $_product_name,
									'quantity' => $quantity,
									'_obj'     => $_obj_product
								);

							}
						}
					}

					//restore data
					$_REQUEST = $__request;
					$_POST = $__post;

					$_bundle[] = $_bundle_added;

					//enable bundle if added two products only
					if ( count($products) > 1 ) WC()->session->set( 'sgupsellbundle', $_bundle );

				} else {

					$passed_validation = apply_filters( 'woocommerce_add_to_cart_validation', true, $product_id, $quantity );

					if ( $passed_validation ) {
						if ( $variation_id > 0 ) {
							
							$_obj_product   = wc_get_product($variation_id);
							$_product_price = $_obj_product->get_price();
							$_product_name  = $_obj_product->get_name();

							$this->just_added_cart[] = array(
								'id'       => $variation_id,
								'price'    => $_product_price,
								'name'     => $_product_name,
								'quantity' => $quantity,
								'_obj'     => $_obj_product
							);

							foreach ( $_POST as $key => $value ) {
								if ( strpos($key, 'attribute') !== false ) {
									$attr = $key;
									$variation_data[ $attr ] = $value;
								}
							}

							$cart_status = WC()->cart->add_to_cart( $product_id, $quantity, $variation_id, $variation_data );
						} else {

							$_obj_product   = wc_get_product($product_id);
							$_product_price = $_obj_product->get_price();
							$_product_name  = $_obj_product->get_name();

							$this->just_added_cart[] = array(
								'id'       => $product_id,
								'price'    => $_product_price,
								'name'     => $_product_name,
								'quantity' => $quantity,
								'_obj'     => $_obj_product
							);
							$cart_status = WC()->cart->add_to_cart( $product_id, $quantity );
						}
					}
					
				}

				
				do_action( 'sg_woo_ajax_add_to_cart', $product_id );

				ob_clean();
				if ( $cart_status ) {

					do_action( 'sg_woo_ajax_added_to_cart', $product_id );
					//fix for facebook pixel
					do_action( 'woocommerce_ajax_added_to_cart', $product_id );

					if ('yes' === get_option('sg_woo_cart_redirect_after_add')) { 
						wc_add_to_cart_message( array( $product_id => $quantity ), true ); 
					} 
					
					WC_AJAX :: get_refreshed_fragments(); 
				} else {

					$data = array( 
						'error'       => true,
						'product_url' => apply_filters('sg_woo_cart_redirect_after_error', get_permalink($product_id), $product_id),
						'passed'      => json_encode($variation_data)
					);
					echo wp_send_json($data);
				}
			} catch ( Exception $e ) {
				echo wp_send_json($e->getMessage());
			}

			wp_die();
		}


		function footer(){

			//if ( $this->options['salesgen_upsell_bundle_position'] != 'after_added_cart' ) return;

			?>
			<div class="sg-upsell-lightbox">
				<div class="sg-upsell-lightbox-body">
					<div class="sg-upsell-lightbox-content">
						<div class="sg-upsell-lightbox-content-heading"></div>
						<div class="sg-upsell-lightbox-content-items"></div>
						<div class="sg-upsell-lightbox-content-footer"></div>
						<a href="#" class="sg-upsell-lightbox-close" rel="nofollow" title="">&times;</a>
					</div>
				</div>
				
				<div class="sg-upsell-lightbox-overlay"></div>
			</div>
			<div class="sg-upsell-quickview">
				<div class="sg-upsell-quickview-body">
					<div class="sg-upsell-quickview-content">
						<div class="sg-upsell-quickview-content-inner"></div>
						<a href="#" class="sg-upsell-quickview-close" rel="nofollow" title="">&times;</a>
					</div>
				</div>
				<div class="sg-upsell-quickview-overlay"></div>
			</div>
			<?php
		}

		/**
		 * Category thumbnail fields.
		 */
		public function add_category_fields() {

			$taxonomy = 'product_cat';
			$dropdown_args = array(
				'hide_empty'       => 0,
				'hide_if_empty'    => false,
				'taxonomy'         => $taxonomy,
				'name'             => 'upsell_categories',
				'orderby'          => 'name',
				'hierarchical'     => true,
				'show_option_none' => __( 'None' ),
				'multiple'         => true
			);

			$dropdown_args = apply_filters( 'taxonomy_parent_dropdown_args', $dropdown_args, $taxonomy, 'new' );

			
			?>
			<div class="form-field term-display-type-wrap">
				<label for="display_type"><?php esc_html_e( 'Upsell Categories', 'woocommerce' ); ?></label>
				<?php wp_dropdown_categories( $dropdown_args );?>
			</div>		
			<?php
		}

		/**
		 * Edit category thumbnail field.
		 *
		 * @param mixed $term Term (category) being edited.
		 */
		public function edit_category_fields( $term ) {

			$term_upsell_categories = get_term_meta( $term->term_id, 'upsell_categories', true );

			?>
			<tr class="form-field term-display-type-wrap">
				<th scope="row" valign="top"><label><?php esc_html_e( 'Upsell Categories', 'woocommerce' ); ?></label></th>
				<td>
					<?php

					$taxonomy = 'product_cat';
					$dropdown_args = array(
						'hide_empty'       => 0,
						'hide_if_empty'    => false,
						'taxonomy'         => $taxonomy,
						'name'             => 'upsell_categories',
						'orderby'          => 'name',
						'selected'         => $term_upsell_categories,
						'exclude_tree'     => $term->term_id,
						'hierarchical'     => true,
						'show_option_none' => __( 'None' ),
						'multiple'         => true
					);

					$dropdown_args = apply_filters( 'taxonomy_parent_dropdown_args', $dropdown_args, $taxonomy, 'edit' );
					wp_dropdown_categories( $dropdown_args );
					?>
				</td>
			</tr>		
			<?php
		}

		function wp_dropdown_cats_multiple( $output, $r ) {

			if( isset( $r['multiple'] ) && $r['multiple'] ) {

				$output = preg_replace( '/^<select/i', '<select multiple size="6"', $output );
				$output = str_replace( "name='{$r['name']}'", "name='{$r['name']}[]'", $output );

				foreach ( array_map( 'trim', explode( ",", $r['selected'] ) ) as $value )
					$output = str_replace( "value=\"{$value}\"", "value=\"{$value}\" selected", $output );

			}

			return $output;
		}

		public function save_category_fields( $term_id, $tt_id = '', $taxonomy = '' ) {
			if ( isset( $_POST['upsell_categories'] ) && 'product_cat' === $taxonomy ) {
				update_term_meta( $term_id, 'upsell_categories', implode( ',', $_POST['upsell_categories']));
			}
		}

		public function global_settings( $instance ) {$instance->ls( SALESGEN_US_LS, __( 'Upsell Blast License', 'salesgen' ), SALESGEN_US_SHORT_SLUG );}

		function shortcode_upsell_product( $atts = array() ) {
			$atts = shortcode_atts( array(
				'product_id' => 0,
				'layout' => false,
			), $atts, 'sg_upsell' );

			global $product;

			ob_start();

			if( $atts['product_id'] > 0 ) {
				$this->upsell_bundle( true, $atts['product_id'], $atts['layout'] );
			} else $this->upsell_bundle( true, 0, $atts['layout'] );
			
			$html = ob_get_contents(); 
			ob_end_clean();

			return $html;
		}

		function shortcode_related_products( $atts = array() ) {
			$atts = shortcode_atts( array(
				'product_id' => 0,
			), $atts, 'sg_related' );

			global $product;

			ob_start();

			if( $atts['product_id'] > 0 ) {
				$this->related_products_box( $atts['product_id'] );
			} else $this->related_products_box();
			
			$html = ob_get_contents(); 
    		ob_end_clean();

    		return $html;
		}

		function clear_transients( $post_id ){
			//clear all upsell transients
			check_ajax_referer('salesgen-admin');

			$this->clear_transients_data();

			wp_send_json(array("status" => 1));
		}

		function clear_transients_data(){
			//clear all upsell transients
			global $wpdb;
			
			$sql = "DELETE FROM {$wpdb->prefix}options WHERE option_name LIKE '%wc_sg_source_by_%'";
			$wpdb->query($sql);
		}

		function option_woocommerce_cart_redirect_after_add( $value='' ) {
			return 'no';
		}

		public function product_data_tabs( $product_data_tabs )
		{
			$product_data_tabs['upsell-blast'] = array(
				'label' => __( 'Upsell Blast', 'salesgen-upsell' ),
				'target' => 'upsell_blast_product_options',
			);
			return $product_data_tabs;
		}

		public function product_data_tabs_fields()
		{
			global $post;
			$product_id = get_the_ID();
			?>
			<!-- id below must match target registered in above add_my_custom_product_data_tab function -->
			<div id="upsell_blast_product_options" class="panel woocommerce_options_panel">
				<div class = 'options_group' >
				<?php
					woocommerce_wp_text_input(
						array(
						'id' => '_upsell_blast_tags',
						'value' => get_post_meta( $product_id, '_upsell_blast_tags', true ),
						'label' => __( 'Source Tags', 'woocommerce' ),
						'placeholder' => 'Enter the tags here...',
						'desc_tip' => 'true',
						'description' => __( 'Enter the tags which upsell functions will get products from. Tags split by commas. Meta key \'_upsell_blast_tags\'', 'woocommerce' )
						)
					);
				?>
				</div>
			</div>
			<?php
		}

		function product_data_save_fields( $id, $post ){
		 	update_post_meta( $id, '_upsell_blast_tags', $_POST['_upsell_blast_tags'] );
		}

		/**
		 * Quick View Output
		 */
		function quickview() {
			//based on flatsome quick view
			global $post, $product;
			$prod_id = $_POST["product"];
			$post    = get_post( $prod_id );
			$product = wc_get_product( $prod_id );

			add_action( 'sg_single_product_lightbox_summary', 'woocommerce_template_single_price', 10 );
			add_action( 'sg_single_product_lightbox_summary', 'woocommerce_template_single_excerpt', 20 );
			add_action( 'sg_single_product_lightbox_summary', 'woocommerce_template_single_add_to_cart', 30 );
			add_action( 'sg_before_single_product_lightbox_summary', 'woocommerce_show_product_sale_flash', 20 );
			

			ob_start();

			add_filter( 'woocommerce_add_to_cart_form_action', '__return_empty_string' ); // Disable form action that causes redirect.
			require_once $this->path . '/inc/quickview.php';
			remove_filter( 'woocommerce_add_to_cart_form_action', '__return_empty_string' );

			$output = ob_get_contents();
			ob_end_clean();
			echo $output;
			die();
		}

		public function woo_plugin_template( $template, $template_name, $template_path ) {
			global $woocommerce;

			if ( !isset($_POST['action']) || (isset($_POST['action']) && $_POST['action'] != 'sgub_quickview') ) return $template; 
			
			$_template = $template;

			if ( ! $template_path ) $template_path = $woocommerce->template_url;

			$plugin_path  = SALESGEN_US_DIR  . 'modules/upsell/wc-template/';

			// Look within passed path within the theme - this is priority
			$template = locate_template(
				array(
					$template_path . $template_name,
					$template_name
				)
			);

			if( file_exists( $plugin_path . $template_name ) ) {
				$template = $plugin_path . $template_name;
			}

			if ( ! $template )
				$template = $_template;

			return $template;
		}


		public function all_categories() {
			$categories = array();

			$this->get_categories($categories, 0);

			return $categories;
		}


		public function get_categories(&$all_categories,  $parent_id = 0, $level = 0 )
		{
			$taxonomy = 'product_cat';
			$orderby = 'name';
			$order = 'ASC';
			$title = '';

			$args = array(
			    'taxonomy' => $taxonomy,
			    'orderby' => $orderby,
			    'order' => $order,  
			    'show_count' => 0,
			    'pad_counts' => 1,
			    'hierarchical' => 0,
			    'title_li' => $title,
			    'hide_empty' => 0,
			    'parent' => $parent_id
			);

			$categories = get_categories( $args );

			if ( count($categories) > 0 ) {
				foreach ($categories as $cat) {
					$cat->cat_name = str_repeat('-', $level) . ' ' . $cat->cat_name;
					$all_categories[] = $cat;
					$this->get_categories($all_categories, $cat->term_id, $level + 1);
				}	
			}
			
		}


		public function inline_bundle_process( $cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data ) {

			if ( isset($_POST['sg_bundle']) && !empty($_POST['sg_bundle']) ) {

				$products = array();

				$post_data = array();

				try {
					$products = (array) json_decode(html_entity_decode( stripslashes ($_POST['sg_bundle'])), true);

					unset($_POST['sg_bundle']);

					//clear all current _POST data
					$post_data = $_POST;
					$_POST = array();

				} catch( Exception $e) {

				}

				$cart_item = WC()->cart->get_cart_item( $cart_item_key );

				if ( count($products) > 0 ) {

					$_bundle = WC()->session->get( 'sgupsellbundle' );

					//init bundle data
					$_bundle = empty($_bundle)? array() : $_bundle;

					$_bundle_added = array(
						'items' => array($product_id),
						'total' => $cart_item['data']->get_price()
					);
					
					
					
					$this->just_added_cart = array();

					$quantity = 1;

					foreach ( $products as $indx => $product ) {
						
						$_cart_status = true;
						$variation_data = array();
						$_product_price = 0;
						$_product_name = '';

						$_product_attrs = (array) $product['attr'];

						if ( count($_product_attrs) > 0 ) {
							foreach ($_product_attrs as $key => $val) {
								$_REQUEST[ $key ] = $_POST[ $key ] = $val;
								if ( strpos($key, 'attribute') !== false ) {
									$attr = $key;
									$variation_data[ $attr ] = $val;
								}
							}
						}
						$passed_validation = apply_filters( 'woocommerce_add_to_cart_validation', true, $product['product_id'], 1 );
						if ( $passed_validation ) {
							if ( $product['product_id'] != $product['variation_id'] ) {
								$_obj_product = wc_get_product($product['variation_id']);

								$_cart_status           = WC()->cart->add_to_cart( $product['product_id'], $quantity, $product['variation_id'], $variation_data );

								
								$_product_price = $_obj_product->get_price();
								$_product_name = $_obj_product->get_name();
							} else {
								$_obj_product = wc_get_product($product['product_id']);

								$_cart_status           = WC()->cart->add_to_cart( $product['product_id'], $quantity );
								
								$_product_price = $_obj_product->get_price();
								$_product_name = $_obj_product->get_name();
							}

							//unset for next product
							if ( count($_product_attrs) > 0 ) {
								foreach ($_product_attrs as $key => $val) {
									unset($_POST[ $key ]);
									unset($_REQUEST[ $key ]);
								}
							}

							if ( $_cart_status ) {
								$_bundle_added['items'][] = $product['product_id'];
								$_bundle_added['total'] += $_product_price;
								$cart_status = true;

								wc_add_to_cart_message( array( $product['product_id'] => $quantity ), true );
								$this->just_added_cart[] = array(
									'id'       => $product['product_id'],
									'price'    => $_product_price,
									'name'     => $_product_name,
									'quantity' => $quantity,
									'_obj'     => $_obj_product
								);

							}
						}
					}

					$_bundle[] = $_bundle_added;

					//enable bundle if added two products only
					if ( count($products) > 1 ) WC()->session->set( 'sgupsellbundle', $_bundle );
				}

				$_POST = $post_data;
			}

			return $cart_item_data;
		}

		public function is_wcpa_product($product_id)
    {

			if( !class_exists('SG_WCPA_Form') ) return false;
			if ( 

				version_compare( WCPA_VERSION, '5.0.0', '<' )
			) {
				
				if (!$this->products) {
						$form = new SG_WCPA_Form();
						$this->products = $form->get_wcpa_products();
				}
			} else {
				if (!$this->products) {
					$form = new SG_WCPA_Form();
					$this->products = $form->get_wcpaProducts();
				}
			}

			foreach ($this->products as $pro) {

					return in_array($product_id, $pro);
			}
		
			return false;
    }
	}


	SG_UpsellBundle::get_instance();


}