<?php
defined( 'ABSPATH' ) or die( 'Something went wrong.' );

if ( version_compare( $GLOBALS['wp_version'], '6.2' ) < 0 && ! function_exists( 'wp_set_password' ) ) :
	/**
	 * Updates the user's password with a new encrypted one.
	 *
	 * @since 1.0
	 * @author Grégory Viguier
	 * @global (object) $wpdb WordPress database abstraction object.
	 *
	 * @param (string) $password The plaintext new user password.
	 * @param (int)    $user_id  User ID.
	 */
	function wp_set_password( 
		#[\SensitiveParameter] 
		$password, 
		$user_id
	) {
		global $wpdb;

		$old_user_data = get_userdata( $user_id );

		$hash = wp_hash_password( $password );
		$wpdb->update(
			$wpdb->users,
			array(
				'user_pass'           => $hash, 
				'user_activation_key' => ''
			), 
			array( 'ID' => $user_id )
		);

		clean_user_cache( $user_id );

		/**
		 * Triggers right after the user password has changed.
		 *
		 * @since 1.0
		 * @deprecated 2.2.6
		 * @param (int) $user_id  User ID.
		 */
		_deprecated_hook( 'secupress.pluggable.user_password_changed', '2.2.6', 'wp_set_password' );
		do_action( 'secupress.pluggable.user_password_changed', $user_id );

		// WP 6.2
		do_action( 'wp_set_password', $password, $user_id, $old_user_data );
	}
endif;
