<?php
defined( 'ABSPATH' ) or die( 'Something went wrong.' );

/** --------------------------------------------------------------------------------------------- */
/** ON MODULE SETTINGS SAVE ===================================================================== */
/** --------------------------------------------------------------------------------------------- */

add_filter( 'secupress_users-login_settings_callback', 'secupress_pro_move_login_settings_callback', 10, 2 );
/**
 *  Move Login Pro plugin. Sanitize and validate Pro settings.
 *
 * @since 1.4.9
 *
 * @param (array) $settings  The module settings.
 */
function secupress_pro_move_login_settings_callback( $settings, $activate ) {
	if ( isset( $_POST['reset-all-passwords'] ) ) {
		$user_ids  = get_users( ['fields' => 'ID', 'exclude' => get_current_user_id() ] );
		foreach( $user_ids as $user_id ) {
			$_user = get_user_by( 'ID', $user_id );
			secupress_pro_reset_passwords( $_user, isset( $_POST['secupress_users-login_settings']['password-policy_send-emails'] ) );
		}
		secupress_add_transient_notice( __( 'Passwords have been reset.', 'secupress' ) );
		wp_safe_redirect( wp_get_referer() );
		die();
	}

	if ( isset( $_POST['disconnect-everyone'] ) ) {
		secupress_pro_sessions_control_destroy_all_sessions( true );
		secupress_add_transient_notice( __( 'You are now logged out everywhere else and all other users have been logged out.', 'secupress' ), 'updated' );
		wp_safe_redirect( wp_get_referer() );
		die();
	}

	if ( isset( $activate['move-login_activated'] ) ) {
		$allowed_slugs                               = [ 'sperror' => 1, 'custom_error' => 1, 'custom_page' => 1, 'honeypot' => 1 ];
		$settings['move-login_whattodo']             = isset( $allowed_slugs[ $settings['move-login_whattodo'] ] ) ? $settings['move-login_whattodo'] : 'sperror';
		$settings['move-login_custom_error_content'] = wp_kses_post( wpautop( $settings['move-login_custom_error_content'] ) );
		$settings['move-login_custom_page_url']      = isset( $settings['move-login_custom_page_url'] ) ? wp_validate_redirect( $settings['move-login_custom_page_url'], home_url() ) : home_url();
	}
	return $settings;
}


/**
 * Double authentication plugins.
 *
 * @since 2.3.12 PasswordLess is back on the menu...
 * @since 2.2.6 You cannot activate PasswordLess anymore, we let the module for legacy purpose.
 * @since 1.0
 *
 * @param (string)     $modulenow Current module.
 * @param (array)      $settings  The module settings, passed by reference.
 * @param (array|bool) $activate  An array containing the fields related to the sub-module being activated. False if not on this module page.
 */
function secupress_pro_double_auth_settings_callback( $modulenow, &$settings, $activate ) {

	if ( ! empty( $activate['double-auth_type'] ) && ! secupress_is_submodule_active( 'users-login', 'passwordless' ) ) {
		secupress_manage_submodule( $modulenow, 'passwordless', '1' === $activate['double-auth_type'] );
	} elseif ( ! isset( $activate['double-auth_type'] ) && secupress_is_submodule_active( 'users-login', 'passwordless' ) ) {
		secupress_deactivate_submodule( $modulenow, array( 'passwordless' ) );
	}

	// Affected roles.
	secupress_manage_affected_roles( $settings, $modulenow, 'double-auth' );

	return $settings;
	secupress_manage_submodule( $modulenow, 'passwordless', isset( $activate['double-auth_type'] ) && 'passwordless' === $activate['double-auth_type'] );
	secupress_manage_affected_roles( $settings, $modulenow, 'double-auth' );
	
	//// TODO 2.3+
	if ( empty( $activate['double-auth_type'] ) ) {
		secupress_deactivate_submodule( $modulenow, 'passwordless' );
		secupress_deactivate_submodule( $modulenow, 'otp-auth' );
	}
	$is_new_otp = isset( $activate['double-auth_type'][0] ) && 'otp-auth' === $activate['double-auth_type'][0];
	secupress_manage_submodule( $modulenow, 'otp-auth', $is_new_otp );
	if ( $is_new_otp ) {
		secupress_deactivate_submodule( $modulenow, 'passwordless' );
	}
	$settings['double-auth_otp-mail']   = (int) isset( $settings['double-auth_otp-mail'] );
	$settings['double-auth_otp-mobile'] = (int) isset( $settings['double-auth_otp-mobile'] );
	
	// Affected roles.
	secupress_manage_affected_roles( $settings, $modulenow, 'double-auth' );
}
