if (typeof _ !== 'function') {
	_ = function() {};
}
if (typeof _.defer !== 'function') {
	_.defer = function() {};
}
if (typeof _.isUndefined !== 'function') {
	_.isUndefined = function() {};
}
jQuery( document ).ready( function($) {
	var observer = new MutationObserver(function(mutations) {
		mutations.forEach(function(mutation) {
			if (mutation.attributeName === "class") {
				var classList = mutation.target.classList;
				if (classList.contains("strong")) {
					$("[type='submit']").prop("disabled", false).removeClass('disabled');
				} else {
					$("[type='submit']").prop("disabled", true).addClass('disabled');
				}
			}
		});
	});

	var $target = $('#secupress-pass-strength-result');
	if ($target.length) {
		observer.observe($target[0], {
			attributes: true
		});
	}

	var $wpGeneratePw = $('.wp-generate-pw');
	var $theSubmit = $('#thesubmit');
	if ($wpGeneratePw.length && $theSubmit.length) {
		$wpGeneratePw.on('click', function() {
			$theSubmit.show();
		});
	}

	if ($theSubmit.length) {
		$theSubmit.hide();
	}
});