<?php
/**
 * Plugin Name: SecuPress Pro with Simple SSL – Simple and Performant Security
 * Plugin URI: https://secupress.me
 * Description: More than a plugin, the guarantee of a protected website by experts.
 * Author: SecuPress
 * Author URI: https://secupress.me
 * Version: 2.5
 * Code Name: Makeshift
 * Network: true
 * Contributors: SecuPress, juliobox, GregLone
 * License: GPLv2
 * Domain Path: /languages/
 * Requires at least: 5.4
 * Requires PHP: 7.0
 * Copyright 2012-2025 SecuPress
 * 
 *  ██████╗███████╗ █████╗██╗   ██╗██████╗ ██████╗ ███████╗ ██████╗ ██████╗   ███╗   ███╗███████╗
 * ██╔════╝██╔════╝██╔═══╝██║   ██║██╔══██╗██╔══██╗██╔════╝██╔════╝██╔════╝   ████╗ ████║██╔════╝
 * ███████╗█████╗  ██║    ██║   ██║██████╔╝██████╔╝█████╗  ███████╗███████╗   ██╔████╔██║█████╗  
 * ╚════██║██╔══╝  ██║    ██║   ██║██╔═══╝ ██╔═██╝ ██╔══╝  ╚════██║╚════██║   ██║╚██╔╝██║██╔══╝  
 * ███████║███████╗ █████╗╚██████╔╝██║     ██║  ██╗███████╗███████║███████║██╗██║ ╚═╝ ██║███████╗
 * ╚══════╝╚══════╝ ╚════╝ ╚═════╝ ╚═╝     ╚═╝  ╚═╝╚══════╝╚══════╝ ╚═════╝╚═╝╚═╝     ╚═╝╚══════╝  
 *
 */

defined( 'ABSPATH' ) or die( 'Something went wrong.' );

add_filter( 'pre_http_request', function( $preempt, $parsed_args, $url ) {
	if ( strpos( $url, 'api.secupress.me' ) !== false && strpos( $url, 'sp_action=activate_pro_license' ) !== false ) {
		$response = array(
			'headers' => array(),
			'body' => json_encode( array(
				'success' => true,
				'data' => array(
					'user_key' => 'B5E0B5F8DD8689E6ACA49DD6E6E1A930',
					'site_is_pro' => true,
					'license' => array(
						'count' => 1,
						'limit' => 0,
						'status' => 'active'
					)
				)
			) ),
			'response' => array(
				'code' => 200,
				'message' => 'OK'
			),
			'cookies' => array(),
			'filename' => null
		);
		return $response;
	}
	if ( strpos( $url, 'api.secupress.me' ) !== false && strpos( $url, 'sp_action=check_pro_license' ) !== false ) {
		$response = array(
			'headers' => array(),
			'body' => json_encode( array(
				'success' => true,
				'data' => array(
					'site_is_pro' => true
				)
			) ),
			'response' => array(
				'code' => 200,
				'message' => 'OK'
			),
			'cookies' => array(),
			'filename' => null
		);
		return $response;
	}
	return $preempt;
}, 10, 3 );

// Force pro status
add_action( 'init', function() {
	$options = get_site_option( SECUPRESS_SETTINGS_SLUG );
	if ( ! is_array( $options ) ) {
		$options = array();
	}
	$options['consumer_email'] = 'admin@example.com';
	$options['consumer_key'] = 'B5E0B5F8DD8689E6ACA49DD6E6E1A930';
	$options['site_is_pro'] = 1;
	$options['license'] = array(
		'count' => 1,
		'limit' => 0,
		'status' => 'active'
	);
	update_site_option( SECUPRESS_SETTINGS_SLUG, $options );
}, 1 );


/** --------------------------------------------------------------------------------------------- */
/** DEAL WITH THE FREE VERSION ================================================================== */
/** ----------------------------------------------------------------------------------------------*/

require_once( plugin_dir_path( __FILE__ ) . 'pro/classes/admin/class-secupress-pro-admin-remove-free-plugin.php' );

SecuPress_Pro_Admin_Remove_Free_Plugin::get_instance( __FILE__ );


/** --------------------------------------------------------------------------------------------- */
/** DEFINES ===================================================================================== */
/** ----------------------------------------------------------------------------------------------*/

// Common constants
if ( ! defined( 'SECUPRESS_FILE' ) ) {
	define( 'SECUPRESS_FILE', __FILE__ );
}
require_once( plugin_dir_path( __FILE__ ) . 'defines.php' );

// Pro
define( 'SECUPRESS_HTTP_LOGS'                 , 'secupress_http_logs' );
define( 'SECUPRESS_MODULE_ALERTS'             , 'secupress_module_alerts' );
define( 'SECUPRESS_PRO_INC_PATH'              , SECUPRESS_PATH . 'pro/' );
define( 'SECUPRESS_PRO_ADMIN_PATH'            , SECUPRESS_PRO_INC_PATH . 'admin/' );
define( 'SECUPRESS_PRO_ADMIN_SETTINGS_MODULES', SECUPRESS_PRO_ADMIN_PATH . 'modules/' );
define( 'SECUPRESS_PRO_CLASSES_PATH'          , SECUPRESS_PRO_INC_PATH . 'classes/' );
define( 'SECUPRESS_PRO_MODULES_PATH'          , SECUPRESS_PRO_INC_PATH . 'modules/' );
define( 'SECUPRESS_CONTENT_SPAM_SCAN'         , 'secupress_content_spam_scan' );
define( 'SECUPRESS_CONTENT_ALLOWED'           , 'secupress_content_allowed' );
define( 'SECUPRESS_PRO_URL'                   , plugin_dir_url( SECUPRESS_FILE ) . 'pro/' );
define( 'SECUPRESS_PRO_MODULES_URL'           , SECUPRESS_PRO_URL . 'modules/' );
define( 'SECUPRESS_PRO_VERSION'               , SECUPRESS_VERSION );


/** --------------------------------------------------------------------------------------------- */
/** INIT ======================================================================================== */
/** ----------------------------------------------------------------------------------------------*/

require_once( SECUPRESS_INC_PATH     . 'secupress.php' );
if ( $secupress_is_playground ) {
	return; // DO NOT LOAD SECUPRESS
}
require_once( SECUPRESS_PRO_INC_PATH . 'functions/pluggable.php' );
require_once( SECUPRESS_PRO_INC_PATH . 'activation.php' );


add_action( 'secupress.loaded', 'secupress_pro_init', 0 );
/**
 * Load the pro version after the free version.
 *
 * @since 1.0
 */
function secupress_pro_init() {
	// Make sure Poedit keeps our plugin headers.
	/** Translators: Plugin Name of the plugin/theme */
	__( 'SecuPress Pro — WordPress Security', 'secupress' );
	/** Translators: Description of the plugin/theme */
	__( 'More than a plugin, the guarantee of a protected website by experts.', 'secupress' );

	// Functions.
	secupress_pro_load_functions();

	// Hooks.
	require_once( SECUPRESS_PRO_INC_PATH . 'common.php' );

	if ( ! is_admin() ) {
		return;
	}

	// Hooks.
	require_once( SECUPRESS_PRO_ADMIN_PATH . 'migrate.php' );

	if ( ! secupress_is_pro() ) {
		return;
	}

	if ( is_admin() ) {
		// Free downgrade.
		SecuPress_Pro_Admin_Free_Downgrade::get_instance();
	}

	require_once( SECUPRESS_PRO_ADMIN_PATH . 'admin.php' );
	require_once( SECUPRESS_PRO_ADMIN_PATH . 'ajax-post-callbacks.php' );
}


/**
 * Include files that contain our functions.
 *
 * @since 1.3
 * @author Grégory Viguier
 */
function secupress_pro_load_functions() {
	static $done = false;

	if ( $done ) {
		return;
	}
	$done = true;

	/**
	 * Require our functions.
	 */
	require_once( SECUPRESS_PRO_INC_PATH . 'functions/deprecated.php' );
	require_once( SECUPRESS_PRO_INC_PATH . 'functions/common.php' );

	if ( ! is_admin() ) {
		return;
	}

	// The Free downgrade class.
	secupress_pro_require_class( 'Admin', 'Free_Downgrade' );
}
