<?php
/**
 * Cloud Firewall IP Management
 * 
 * This file contains the IP management form content for the Cloud Firewall module.
 */

namespace WPSecurityNinja\Plugin;

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Ensure we have access to the main class
if (!class_exists('Wf_sn_cf')) {
    return;
}

/**
 * Render the IP management form content
 * 
 * @param array $options Current options
 */
function wf_sn_cf_render_ip_management_content($options) {
    ?>

<table class="form-table">
					<tbody>
						<?php

						$current_user_ip = \WPSecurityNinja\Plugin\wf_sn_cf::get_user_ip();

						echo '<tr valign="top"><th scope="row"><label for="wf_sn_cf_blacklist"><h3>' . __('BLACKLIST IPs', 'security-ninja') . '</label></h3>';

						echo '<p class="description">' . esc_html__('Manually block these IPs. Write one IP or subnet mask per line.', 'security-ninja') . '</p>';
						?>
						</th>
						<td></td>
						</tr>
						<?php

						echo '<tr><td class="fullwidth" colspan="2"><textarea id="wf_sn_cf_blacklist" name="' . esc_attr(WF_SN_CF_OPTIONS_KEY) . '[blacklist]" rows="5" cols="50">' . (is_array($options['blacklist']) ? implode(PHP_EOL, $options['blacklist']) : '') . '</textarea>';

						echo '</td></tr>';

						echo '<tr valign="top"><th scope="row"><label for="wf_sn_cf_whitelist"><h3>' . __('Whitelist IPs', 'security-ninja') . '</h3>';
						echo '<p class="description">' . esc_html__('These IPs are never blocked. Write one IP or subnet mask per line.', 'security-ninja') . '</p>';

						echo '</label></th><td></td></tr>';

						echo '<tr><td class="fullwidth" colspan="2"><textarea id="wf_sn_cf_whitelist" name="' . esc_attr(WF_SN_CF_OPTIONS_KEY) . '[whitelist]" rows="5">' . (is_array($options['whitelist']) ? implode(PHP_EOL, $options['whitelist']) : '') . '</textarea>';

						echo '<p>' . sprintf(esc_html__('Your IP address is: %s', 'security-ninja'), esc_html($current_user_ip)) . ' ' . esc_html__('Your webserver is:', 'security-ninja') . ' ' . esc_html($server_host = gethostname()) . ' (' . esc_html($server_ip = $server_host ? gethostbyname($server_host) : '') . ')</p>';
						?>
						</td>
						</tr>
						<tr valign="top">
							<th scope="row"><label for="<?php echo esc_attr(WF_SN_CF_OPTIONS_KEY) . '_whitelist_wprocket'; ?>">
									<h3><?php esc_html_e('Whitelist WP Rocket IPs', 'security-ninja'); ?></h3>
									<p class="description"><?php esc_html_e('Enable this option to automatically whitelist IP addresses associated with WP Rocket, ensuring uninterrupted service.', 'security-ninja'); ?></p>
								</label></th>
							<td class="sn-cf-options">
								<?php
								\WPSecurityNinja\Plugin\Utils::create_toggle_switch(
									WF_SN_CF_OPTIONS_KEY . '_whitelist_wprocket',
									array(
										'saved_value' => $options['whitelist_wprocket'],
										'option_key'  => WF_SN_CF_OPTIONS_KEY . '[whitelist_wprocket]',
									)
								);
								?>
							</td>
						</tr>

						<tr valign="top">
							<th scope="row"><label for="<?php echo esc_attr(WF_SN_CF_OPTIONS_KEY) . '_whitelist_uptimia'; ?>">
									<h3><?php esc_html_e('Whitelist Uptimia IPs', 'security-ninja'); ?></h3>
									<p class="description"><?php esc_html_e('Enable this feature to whitelist IP addresses used by Uptimia.', 'security-ninja'); ?></p>
								</label></th>
							<td class="sn-cf-options">
								<?php
								\WPSecurityNinja\Plugin\Utils::create_toggle_switch(
									WF_SN_CF_OPTIONS_KEY . '_whitelist_uptimia',
									array(
										'saved_value' => $options['whitelist_uptimia'],
										'option_key'  => WF_SN_CF_OPTIONS_KEY . '[whitelist_uptimia]',
									)
								);
								?>

							</td>
						</tr>

						<tr valign="top">
							<th scope="row"><label for="<?php echo esc_attr(WF_SN_CF_OPTIONS_KEY) . '_whitelist_uptimerobot'; ?>">
									<h3><?php esc_html_e('Whitelist UptimeRobot IPs', 'security-ninja'); ?></h3>
									<p class="description"><?php esc_html_e('Enable this feature to whitelist IP addresses used by UptimeRobot.', 'security-ninja'); ?></p>
								</label></th>
							<td class="sn-cf-options">
								<?php
								\WPSecurityNinja\Plugin\Utils::create_toggle_switch(
									WF_SN_CF_OPTIONS_KEY . '_whitelist_uptimerobot',
									array(
										'saved_value' => $options['whitelist_uptimerobot'],
										'option_key'  => WF_SN_CF_OPTIONS_KEY . '[whitelist_uptimerobot]',
									)
								);
								?>
							</td>
						</tr>
						<tr valign="top">
							<th scope="row"><label for="<?php echo esc_attr(WF_SN_CF_OPTIONS_KEY) . '_whitelist_managewp'; ?>">
									<h3><?php esc_html_e('Whitelist ManageWP IPs', 'security-ninja'); ?></h3>
									<p class="description"><?php esc_html_e('Enable this feature to whitelist IP addresses used by ManageWP, facilitating seamless integration and maintenance tasks.', 'security-ninja'); ?></p>
								</label></th>
							<td class="sn-cf-options">
								<?php
								\WPSecurityNinja\Plugin\Utils::create_toggle_switch(
									WF_SN_CF_OPTIONS_KEY . '_whitelist_managewp',
									array(
										'saved_value' => $options['whitelist_managewp'],
										'option_key'  => WF_SN_CF_OPTIONS_KEY . '[whitelist_managewp]',
									)
								);
								?>
							</td>
						</tr>
						<tr valign="top">
							<td colspan="2">
								<p class="description"><?php esc_html_e('Some services make it possible to validate their crawlers automatically. We allow traffic from Baidu, Bing (MSN), Google, Yahoo, Yandex, Petal Search, and Applebot if they can be successfully validated.', 'security-ninja'); ?></p>
							</td>
						</tr>
						<tr valign="top">
							<th colspan="2">
								<h3><?php esc_html_e('Locally Banned IPs', 'security-ninja'); ?></h3>
							</th>
						</tr>
						<?php
						echo '<tr valign="top"><th scope="row"><label for="wf-cf-ip-test"><h3>' . esc_html__('Test IP', 'security-ninja') . '</h3>';
						echo '<p class="description">Enter an IP address in order to test if it\'s banned. Your IP address is: ' . esc_html($current_user_ip) . '</p>';
						echo '</label></th><td></td></tr>';

						echo '<tr><td id="sn-firewall-test-ip" class="fullwidth">';
						echo '<input type="text" placeholder="' . esc_html__('IP address, ie: 213.45.66.12', 'security-ninja') . '" class="regular-text" value="" id="wf-cf-ip-test">&nbsp; &nbsp;';
						echo '<a href="#" id="wf-cf-do-test-ip" class="button js-action">' . esc_html__('Test if IP is Banned', 'security-ninja') . '</a>';
						echo '<p id="wf-cf-do-test-ip-result"></p></td></tr>';

						$banned_ips = \WPSecurityNinja\Plugin\wf_sn_cf::get_banned_ips();
						$banned_ips = array_values($banned_ips);
						$banned_ips = array_filter($banned_ips);

						if (0 < count($banned_ips)) {
							echo '<tr valign="top"><th scope="row"><label for="">' . esc_html__('Currently Banned', 'security-ninja') . '</label></th><td id="sn-firewall-blacklist">';
							echo '<ul style="margin-top: 5px;">';
							foreach ($banned_ips as $banned_ip => $ban_time) {
								$message = sprintf(
									/* translators: 1: IP address, 2: Time until ban expires */
									__('%1$s; time till ban expires: %2$s', 'security-ninja'),
									$banned_ip,
									human_time_diff(current_time('timestamp'), $ban_time)
								);
								if (strlen($message) > 85) {
									$message = substr($message, 0, 82) . '...';
								}
								echo '<li>' . $message . '</li>';
							}
							echo '</ul>';
							echo '<br><input type="button" value="' . esc_html__('Clear list of banned IPs', 'security-ninja') . '" id="sn-firewall-blacklist-clear" style="background: #cc0000;" class="button button-primary" />';
							echo '</td></tr>';
						} else {
							echo '<div class="sncard settings-card success"><p>' . esc_html__('No locally banned IPs', 'security-ninja') . '</p></div>';
						}
						?>


						<input type="hidden" id="wf_sn_cf_active" name="wf_sn_cf[active]" value="<?php echo esc_attr($options['active']); ?>" />

						<input type="hidden" id="wf_sn_cf_unblock_url" name="wf_sn_cf[unblock_url]" value="<?php echo esc_attr($options['unblock_url']); ?>" />


				</table>

<?php
}