<?php
/**
 * View: JCB logo.
 *
 * @since 4.25.0
 * @version 4.25.0
 *
 * @var string[] $classes        Additional classes to add to the svg icon.
 * @var string   $label          The label for the icon.
 * @var bool     $is_aria_hidden Whether the icon is hidden from screen readers. Default false to show the icon.
 * @var Template $this           The template instance.
 *
 * @package LearnDash\Core
 */

use LearnDash\Core\Template\Template;

$svg_classes = [ 'ld-svgicon__jcb' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}

if ( empty( $label ) ) {
	$label = __( 'JCB logo', 'learndash' );
}

$this->template(
	'components/icons/icon/start',
	[
		'classes' => $svg_classes,
		'height'  => 24,
		'label'   => $label,
		'width'   => 40,
	],
);

?>

<g clip-path="url(#clip0_11282_39291)">
	<path d="M38.833 24H2.167C1.25 24 0.5 23.28 0.5 22.4V1.6C0.5 0.72 1.25 0 2.167 0H38.833C39.75 0 40.5 0.72 40.5 1.6V22.4C40.5 23.28 39.75 24 38.833 24Z" fill="white"/>
	<path d="M33.7725 2.00985H33.7855V19.0718C33.7815 20.1498 33.2725 21.1748 32.4135 21.8178C31.7835 22.2878 31.0475 22.4878 30.2735 22.4878C29.8365 22.4878 25.4405 22.5138 25.4185 22.4878C25.4085 22.4778 25.4185 22.4178 25.4185 22.4058V15.5858C25.4185 15.5458 25.4225 15.5218 25.4515 15.5218H30.7045C31.5715 15.5218 32.0485 15.2648 32.3965 14.9118C32.8365 14.4638 32.9705 13.7498 32.6905 13.1798C32.4505 12.6918 31.9545 12.3998 31.4465 12.2668C31.2885 12.2268 31.1265 12.1988 30.9635 12.1838C30.9535 12.1838 30.8995 12.1838 30.8935 12.1778C30.8635 12.1438 30.9165 12.1378 30.9315 12.1318C31.0335 12.0988 31.1465 12.0898 31.2515 12.0588C31.7835 11.8948 32.2445 11.5118 32.3885 10.9538C32.5385 10.3768 32.3385 9.75985 31.8645 9.40185C31.5245 9.14485 31.0965 9.02585 30.6775 8.98885C30.2475 8.95085 25.9035 8.96685 25.4675 8.96685C25.3955 8.96685 25.4175 8.94685 25.4175 8.87685V5.62985C25.4175 5.31985 25.4275 5.01385 25.4905 4.70985C25.6165 4.11785 25.9005 3.56585 26.3055 3.11985C26.8635 2.50485 27.6425 2.10985 28.4655 2.02685C28.9435 1.97885 33.3555 2.00985 33.7705 2.00985H33.7725ZM29.7125 10.6258C29.7725 10.8978 29.7025 11.1928 29.5085 11.3958C29.3355 11.5718 29.1015 11.6458 28.8605 11.6488C28.6655 11.6518 27.1355 11.6488 27.0725 11.6488L27.0755 10.0038C27.0875 9.97685 27.0955 9.98585 27.1355 9.98585C27.2325 9.98585 28.8485 9.98185 28.9585 9.99085C29.1905 10.0108 29.4085 10.1108 29.5565 10.2968C29.6325 10.3928 29.6845 10.5048 29.7115 10.6248L29.7125 10.6258ZM27.0765 12.6638H29.0205C29.2625 12.6658 29.4905 12.7268 29.6725 12.8918C29.8985 13.0958 29.9995 13.4068 29.9555 13.7068C29.9155 13.9698 29.7615 14.2068 29.5335 14.3408C29.3465 14.4528 29.1435 14.4658 28.9335 14.4658H27.0765V12.6658V12.6638Z" fill="#53B230"/>
	<path d="M7.07544 13.89C7.01544 13.86 7.01544 13.872 7.00544 13.83C6.99944 13.804 7.00044 5.46504 7.00844 5.27204C7.04844 4.32204 7.49544 3.41504 8.21844 2.80204C8.73544 2.36804 9.37844 2.09204 10.0484 2.02404C10.4444 1.98404 10.8514 2.00604 11.2484 2.00604C11.9384 2.00604 15.3584 1.99304 15.3684 2.00604C15.3764 2.01404 15.3704 18.764 15.3684 19.08C15.3654 20.036 14.9654 20.958 14.2634 21.603C13.7574 22.068 13.1134 22.373 12.4334 22.463C12.0234 22.519 7.41344 22.495 7.07044 22.495C7.00444 22.495 7.01644 22.508 7.00444 22.471C6.99444 22.446 7.00444 15.471 7.00444 15.301C7.66444 15.479 8.35444 15.581 9.03444 15.649C9.69644 15.716 10.3644 15.742 11.0274 15.711C11.9574 15.667 12.9744 15.519 13.7394 14.949C14.0594 14.711 14.3134 14.396 14.4694 14.027C14.6174 13.674 14.6694 13.291 14.6694 12.91C14.6694 12.562 14.6754 8.98004 14.6534 8.96804C14.6304 8.95404 11.7684 8.95304 11.7534 8.98004C11.7414 9.00204 11.7534 12.85 11.7534 12.93C11.7504 13.4 11.5934 13.863 11.2394 14.182C10.7714 14.602 10.1294 14.652 9.53244 14.605C8.84544 14.55 8.17544 14.36 7.53944 14.097C7.38244 14.032 7.22744 13.962 7.07344 13.889L7.07544 13.89Z" fill="#006CB9"/>
	<path d="M16.4503 9.83527C16.4253 9.85527 16.4003 9.87527 16.3783 9.89527V6.05027C16.3783 5.75527 16.3663 5.45627 16.3883 5.16227C16.5083 3.56927 17.7613 2.23927 19.3323 2.03627C19.7143 1.98627 24.7293 1.99427 24.7423 2.01027C24.7523 2.02027 24.7423 2.07227 24.7423 2.08427V19.0413C24.7423 20.3453 24.0173 21.5613 22.8523 22.1413C22.3483 22.3913 21.8073 22.4913 21.2473 22.4913C20.9253 22.4913 16.4903 22.5063 16.4133 22.4913C16.3633 22.4813 16.3903 22.5013 16.3783 22.4713C16.3713 22.4493 16.3783 15.9233 16.3783 15.0313V14.6093C16.9323 15.0893 17.6343 15.3593 18.3383 15.5173C18.8743 15.6373 19.4223 15.6933 19.9683 15.7133C20.5053 15.7333 21.0443 15.7233 21.5783 15.6763C22.1243 15.6263 22.6663 15.5403 23.2033 15.4323C23.3403 15.4043 23.4773 15.3753 23.6133 15.3423C23.6463 15.3363 23.7833 15.3253 23.8003 15.2983C23.8133 15.2783 23.8003 15.2013 23.8003 15.1783V13.8543C23.2183 14.1463 22.6103 14.3793 21.9703 14.5063C21.1923 14.6613 20.3303 14.7043 19.5853 14.3833C18.8333 14.0573 18.3853 13.3593 18.3113 12.5463C18.2353 11.7093 18.4843 10.8303 19.1943 10.3343C19.9303 9.82127 20.8943 9.81727 21.7473 9.95427C22.3813 10.0543 22.9923 10.2593 23.5723 10.5343C23.6503 10.5713 23.7263 10.6093 23.8023 10.6473V9.32227C23.8023 9.30227 23.8153 9.22227 23.8023 9.20427C23.7823 9.17627 23.6503 9.16627 23.6143 9.15827C23.5483 9.14227 23.4813 9.12827 23.4143 9.11327C22.8803 9.00027 22.3403 8.90827 21.8003 8.85027C21.2673 8.79027 20.7323 8.77327 20.1973 8.78427C19.6553 8.79427 19.1113 8.83827 18.5773 8.93827C17.9153 9.06327 17.2573 9.27527 16.6943 9.65427C16.6093 9.71027 16.5273 9.77127 16.4493 9.83427L16.4503 9.83527Z" fill="#E20138"/>
</g>
<defs>
	<clipPath id="clip0_11282_39291">
		<rect width="40" height="24" fill="white" transform="translate(0.5)"/>
	</clipPath>
</defs>

<?php
$this->template( 'components/icons/icon/end' );
