<?php
/**
 * View: Mastercard logo.
 *
 * @since 4.25.0
 * @version 4.25.0
 *
 * @var string[] $classes        Additional classes to add to the svg icon.
 * @var string   $label          The label for the icon.
 * @var bool     $is_aria_hidden Whether the icon is hidden from screen readers. Default false to show the icon.
 * @var Template $this           The template instance.
 *
 * @package LearnDash\Core
 */

use LearnDash\Core\Template\Template;

$svg_classes = [ 'ld-svgicon__mastercard' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}

if ( empty( $label ) ) {
	$label = __( 'Mastercard logo', 'learndash' );
}

$this->template(
	'components/icons/icon/start',
	[
		'classes' => $svg_classes,
		'height'  => 24,
		'label'   => $label,
		'width'   => 40,
	],
);

?>

<g clip-path="url(#clip0_11282_39268)">
	<path d="M0.5 1.927C0.5 0.863 1.392 0 2.492 0H38.508C39.608 0 40.5 0.863 40.5 1.927V22.073C40.5 23.137 39.608 24 38.508 24H2.492C1.392 24 0.5 23.137 0.5 22.073V1.927Z" fill="white"/>
	<path d="M11.5884 22.2001V20.8401C11.5884 20.3181 11.2704 19.9771 10.7244 19.9771C10.4524 19.9771 10.1564 20.0671 9.95138 20.3631C9.79138 20.1131 9.56537 19.9771 9.22437 19.9771C8.99637 19.9771 8.76937 20.0451 8.58737 20.2951V20.0231H8.10938V22.2001H8.58737V20.9981C8.58737 20.6121 8.79138 20.4311 9.11038 20.4311C9.42838 20.4311 9.58838 20.6361 9.58838 20.9991V22.2001H10.0654V20.9981C10.0654 20.6121 10.2954 20.4311 10.5894 20.4311C10.9094 20.4311 11.0674 20.6361 11.0674 20.9991V22.2001H11.5904H11.5884ZM18.6634 20.0231H17.8894V19.3651H17.4114V20.0231H16.9794V20.4531H17.4114V21.4511C17.4114 21.9511 17.6164 22.2461 18.1614 22.2461C18.3674 22.2461 18.5944 22.1781 18.7534 22.0861L18.6174 21.6791C18.4814 21.7691 18.3214 21.7931 18.2074 21.7931C17.9804 21.7931 17.8894 21.6561 17.8894 21.4301V20.4541H18.6634V20.0231ZM22.7114 19.9771C22.4384 19.9771 22.2574 20.1131 22.1434 20.2951V20.0231H21.6654V22.2001H22.1434V20.9751C22.1434 20.6121 22.3034 20.4081 22.5984 20.4081C22.6884 20.4081 22.8024 20.4311 22.8934 20.4541L23.0304 20.0001C22.9404 19.9771 22.8034 19.9771 22.7114 19.9771ZM16.5934 20.2041C16.3654 20.0441 16.0474 19.9771 15.7054 19.9771C15.1594 19.9771 14.7954 20.2491 14.7954 20.6801C14.7954 21.0431 15.0694 21.2471 15.5454 21.3151L15.7754 21.3381C16.0254 21.3831 16.1604 21.4511 16.1604 21.5651C16.1604 21.7251 15.9784 21.8371 15.6604 21.8371C15.3404 21.8371 15.0904 21.7241 14.9324 21.6101L14.7044 21.9731C14.9544 22.1531 15.2944 22.2451 15.6364 22.2451C16.2734 22.2451 16.6364 21.9501 16.6364 21.5421C16.6364 21.1571 16.3414 20.9521 15.8864 20.8841L15.6594 20.8621C15.4544 20.8391 15.2954 20.7941 15.2954 20.6581C15.2954 20.4981 15.4554 20.4081 15.7054 20.4081C15.9774 20.4081 16.2504 20.5221 16.3874 20.5901L16.5934 20.2041ZM29.2854 19.9771C29.0124 19.9771 28.8304 20.1131 28.7174 20.2951V20.0231H28.2394V22.2001H28.7174V20.9751C28.7174 20.6121 28.8774 20.4081 29.1724 20.4081C29.2624 20.4081 29.3754 20.4311 29.4664 20.4541L29.6034 20.0001C29.5134 19.9771 29.3764 19.9771 29.2854 19.9771ZM23.1894 21.1111C23.1894 21.7711 23.6444 22.2461 24.3494 22.2461C24.6694 22.2461 24.8954 22.1781 25.1234 21.9961L24.8954 21.6111C24.7134 21.7471 24.5314 21.8151 24.3254 21.8151C23.9404 21.8151 23.6674 21.5431 23.6674 21.1121C23.6674 20.7051 23.9404 20.4321 24.3274 20.4101C24.5314 20.4101 24.7134 20.4781 24.8954 20.6141L25.1234 20.2291C24.8954 20.0471 24.6684 19.9791 24.3494 19.9791C23.6444 19.9791 23.1894 20.4561 23.1894 21.1131V21.1111ZM27.6024 21.1111V20.0241H27.1224V20.2961C26.9644 20.0921 26.7374 19.9781 26.4424 19.9781C25.8274 19.9781 25.3494 20.4551 25.3494 21.1121C25.3494 21.7721 25.8274 22.2471 26.4414 22.2471C26.7584 22.2471 26.9864 22.1341 27.1214 21.9301V22.2021H27.6014V21.1121L27.6024 21.1111ZM25.8494 21.1111C25.8494 20.7271 26.0994 20.4091 26.5094 20.4091C26.8964 20.4091 27.1694 20.7041 27.1694 21.1121C27.1694 21.4991 26.8964 21.8161 26.5094 21.8161C26.0994 21.7941 25.8494 21.4991 25.8494 21.1131V21.1111ZM20.1394 19.9781C19.5034 19.9781 19.0494 20.4321 19.0494 21.1121C19.0494 21.7941 19.5034 22.2471 20.1634 22.2471C20.4834 22.2471 20.8014 22.1571 21.0514 21.9521L20.8234 21.6121C20.6434 21.7481 20.4134 21.8391 20.1874 21.8391C19.8914 21.8391 19.5954 21.7031 19.5274 21.3171H21.1424V21.1371C21.1644 20.4331 20.7544 19.9791 20.1404 19.9791L20.1394 19.9781ZM20.1394 20.3881C20.4364 20.3881 20.6414 20.5681 20.6864 20.9081H19.5494C19.5944 20.6131 19.7994 20.3881 20.1394 20.3881ZM31.9914 21.1121V19.1621H31.5114V20.2971C31.3534 20.0931 31.1264 19.9791 30.8314 19.9791C30.2164 19.9791 29.7384 20.4561 29.7384 21.1131C29.7384 21.7731 30.2164 22.2481 30.8304 22.2481C31.1484 22.2481 31.3754 22.1351 31.5104 21.9311V22.2031H31.9904V21.1131L31.9914 21.1121ZM30.2394 21.1121C30.2394 20.7281 30.4894 20.4101 30.8994 20.4101C31.2854 20.4101 31.5594 20.7051 31.5594 21.1131C31.5594 21.5001 31.2854 21.8171 30.8994 21.8171C30.4894 21.7951 30.2394 21.5001 30.2394 21.1141V21.1121ZM14.2694 21.1121V20.0251H13.7934V20.2971C13.6334 20.0931 13.4064 19.9791 13.1104 19.9791C12.4954 19.9791 12.0174 20.4561 12.0174 21.1131C12.0174 21.7731 12.4954 22.2481 13.1094 22.2481C13.4274 22.2481 13.6544 22.1351 13.7914 21.9311V22.2031H14.2684V21.1131L14.2694 21.1121ZM12.4964 21.1121C12.4964 20.7281 12.7464 20.4101 13.1564 20.4101C13.5424 20.4101 13.8164 20.7051 13.8164 21.1131C13.8164 21.5001 13.5424 21.8171 13.1564 21.8171C12.7464 21.7951 12.4964 21.5001 12.4964 21.1141V21.1121Z" fill="black"/>
	<path d="M23.5947 3.49023H16.4297V16.3262H23.5947" fill="#FF5F00"/>
	<path d="M16.8808 9.91109C16.8808 7.30109 18.1108 4.98909 19.9978 3.49109C18.6078 2.40409 16.8578 1.74609 14.9478 1.74609C10.4198 1.74609 6.75781 5.39609 6.75781 9.91009C6.75781 14.4201 10.4198 18.0721 14.9478 18.0721C16.8578 18.0721 18.6078 17.4151 19.9978 16.3261C18.1078 14.8521 16.8798 12.5161 16.8798 9.90909L16.8808 9.91109Z" fill="#EB001B"/>
<path d="M33.2556 9.91014C33.2556 14.4201 29.5916 18.0721 25.0656 18.0721C23.1556 18.0721 21.4036 17.4151 20.0156 16.3261C21.9256 14.8301 23.1316 12.5161 23.1316 9.90914C23.1316 7.29914 21.9036 4.98714 20.0156 3.48914C21.4036 2.40214 23.1556 1.74414 25.0656 1.74414C29.5916 1.74414 33.2556 5.41814 33.2556 9.90814V9.91014Z" fill="#F79E1B"/>
</g>
<defs>
	<clipPath id="clip0_11282_39268">
		<rect width="40" height="24" fill="white" transform="translate(0.5)"/>
	</clipPath>
</defs>

<?php
$this->template( 'components/icons/icon/end' );
