<?php
/**
 * View: Unionpay logo.
 *
 * @since 4.25.0
 * @version 4.25.0
 *
 * @var string[] $classes        Additional classes to add to the svg icon.
 * @var string   $label          The label for the icon.
 * @var bool     $is_aria_hidden Whether the icon is hidden from screen readers. Default false to show the icon.
 * @var Template $this           The template instance.
 *
 * @package LearnDash\Core
 */

use LearnDash\Core\Template\Template;

$svg_classes = [ 'ld-svgicon__unionpay' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}

if ( empty( $label ) ) {
	$label = __( 'Unionpay logo', 'learndash' );
}

$this->template(
	'components/icons/icon/start',
	[
		'classes' => $svg_classes,
		'height'  => 24,
		'label'   => $label,
		'width'   => 40,
	],
);

?>

<g clip-path="url(#clip0_11282_39275)">
	<path d="M38.833 24H2.167C1.25 24 0.5 23.28 0.5 22.4V1.6C0.5 0.72 1.25 0 2.167 0H38.833C39.75 0 40.5 0.72 40.5 1.6V22.4C40.5 23.28 39.75 24 38.833 24Z" fill="white"/>
	<path d="M10.3771 2H18.5031C19.6381 2 20.3431 2.93 20.0781 4.077L16.2951 20.427C16.0281 21.569 14.8921 22.5 13.7571 22.5H5.63008C4.49608 22.5 3.79008 21.57 4.05608 20.427L7.84008 4.076C8.10708 2.93 9.24008 2 10.3781 2H10.3771Z" fill="#E21836"/>
	<path d="M17.8284 2H27.1734C28.3074 2 27.7964 2.93 27.5294 4.077L23.7464 20.427C23.4814 21.569 23.5644 22.5 22.4264 22.5H13.0834C11.9464 22.5 11.2434 21.57 11.5094 20.427L15.2924 4.077C15.5594 2.93 16.6934 2 17.8274 2H17.8284Z" fill="#00447B"/>
	<path d="M26.7957 2H34.9217C36.0577 2 36.7617 2.93 36.4967 4.077L32.7147 20.427C32.4487 21.569 31.3127 22.5 30.1747 22.5H22.0527C20.9157 22.5 20.2107 21.57 20.4787 20.427L24.2587 4.077C24.5257 2.93 25.6617 2 26.7987 2H26.7957Z" fill="#007B84"/>
	<path d="M28.1311 14.0725L27.1411 17.3725H27.4071L27.1991 18.0525H26.9331L26.8711 18.2645H25.9291L25.9931 18.0545H24.0781L24.2711 17.4225H24.4651L25.4701 14.0725L25.6701 13.3965H26.6321L26.5321 13.7365C26.5321 13.7365 26.7871 13.5525 27.0301 13.4885C27.2721 13.4245 28.6661 13.4005 28.6661 13.4005L28.4601 14.0725H28.1311ZM26.4361 14.0725L26.1821 14.9155C26.1821 14.9155 26.4671 14.7855 26.6221 14.7435C26.7821 14.7035 27.0171 14.6865 27.0171 14.6865L27.1991 14.0725H26.4361ZM26.0561 15.3345L25.7931 16.2115C25.7931 16.2115 26.0831 16.0615 26.2401 16.0155C26.3971 15.9785 26.6361 15.9495 26.6361 15.9495L26.8211 15.3355H26.0551L26.0561 15.3345ZM25.4421 17.3805H26.2091L26.4311 16.6405H25.6661L25.4421 17.3805Z" fill="#FEFEFE"/>
	<path d="M28.5555 13.3995H29.5825L29.5925 13.7845C29.5875 13.8495 29.6425 13.8805 29.7625 13.8805H29.9705L29.7805 14.5175H29.2255C28.7455 14.5525 28.5635 14.3455 28.5755 14.1115L28.5555 13.4015V13.3995ZM28.6935 16.4145H27.7155L27.8825 15.8485H29.0005L29.1605 15.3315H28.0565L28.2465 14.6935H31.3185L31.1255 15.3315H30.0955L29.9355 15.8475H30.9675L30.7975 16.4125H29.6805L29.4805 16.6525H29.9345L30.0445 17.3645C30.0575 17.4345 30.0585 17.4805 30.0805 17.5115C30.1035 17.5375 30.2385 17.5495 30.3185 17.5495H30.4555L30.2455 18.2435H29.8975C29.8435 18.2435 29.7645 18.2395 29.6545 18.2335C29.5495 18.2255 29.4745 18.1635 29.4045 18.1285C29.3405 18.0985 29.2445 18.0185 29.2225 17.8885L29.1125 17.1765L28.6055 17.8765C28.4435 18.0985 28.2255 18.2665 27.8575 18.2665H27.1455L27.3315 17.6465H27.6045C27.6825 17.6465 27.7545 17.6165 27.8045 17.5905C27.8565 17.5675 27.9025 17.5405 27.9545 17.4645L28.6935 16.4145ZM17.9785 14.8665H20.5685L20.3785 15.4885H19.3405L19.1805 16.0185H20.2405L20.0465 16.6585H18.9865L18.7305 17.5215C18.7005 17.6165 18.9805 17.6295 19.0835 17.6295L19.6135 17.5575L19.4015 18.2675H18.2085C18.1125 18.2675 18.0405 18.2545 17.9365 18.2305C17.8365 18.2075 17.7915 18.1605 17.7465 18.0925C17.7035 18.0225 17.6365 17.9645 17.6825 17.8145L18.0255 16.6715H17.4375L17.6325 16.0215H18.2245L18.3805 15.4915H17.7925L17.9805 14.8685L17.9785 14.8665ZM19.7235 13.7495H20.7865L20.5925 14.3995H19.1405L18.9835 14.5355C18.9165 14.6015 18.8935 14.5735 18.8035 14.6225C18.7235 14.6625 18.5495 14.7455 18.3265 14.7455H17.8605L18.0505 14.1205H18.1905C18.3085 14.1205 18.3885 14.1105 18.4285 14.0845C18.4745 14.0545 18.5265 13.9885 18.5855 13.8815L18.8525 13.3945H19.9095L19.7225 13.7505L19.7235 13.7495ZM21.2405 13.3995H22.1455L22.0135 13.8595C22.0135 13.8595 22.2995 13.6295 22.5005 13.5465C22.7005 13.4715 23.1505 13.4035 23.1505 13.4035L24.6145 13.3965L24.1165 15.0685C24.0315 15.3545 23.9335 15.5405 23.8725 15.6235C23.8175 15.7105 23.7525 15.7835 23.6245 15.8535C23.5005 15.9195 23.3885 15.9575 23.2845 15.9685C23.1885 15.9755 23.0405 15.9785 22.8345 15.9805H21.4245L21.0245 17.3045C20.9875 17.4345 20.9695 17.4985 20.9945 17.5345C21.0145 17.5645 21.0625 17.6005 21.1295 17.6005L21.7495 17.5405L21.5395 18.2665H20.8415C20.6215 18.2665 20.4585 18.2625 20.3465 18.2535C20.2385 18.2435 20.1265 18.2535 20.0515 18.1955C19.9865 18.1375 19.8875 18.0625 19.8895 17.9855C19.8965 17.9125 19.9265 17.7935 19.9715 17.6295L21.2405 13.3995ZM23.1625 15.0895H21.6785L21.5885 15.3895H22.8715C23.0235 15.3715 23.0555 15.3935 23.0675 15.3865L23.1625 15.0895ZM21.7605 14.8175C21.7605 14.8175 22.0505 14.5515 22.5465 14.4645C22.6585 14.4425 23.3665 14.4495 23.3665 14.4495L23.4725 14.0925H21.9765L21.7605 14.8175Z" fill="#FEFEFE"/>
	<path d="M23.8773 16.1007L23.7933 16.5027C23.7573 16.6277 23.7263 16.7227 23.6333 16.8047C23.5333 16.8887 23.4173 16.9767 23.1453 16.9767L22.6433 16.9967L22.6392 17.4517C22.6333 17.5817 22.6672 17.5687 22.6873 17.5897C22.7113 17.6117 22.7323 17.6217 22.7543 17.6297L22.9113 17.6217L23.3913 17.5937L23.1933 18.2567H22.6413C22.2563 18.2567 21.9713 18.2487 21.8763 18.1727C21.7843 18.1157 21.7713 18.0407 21.7733 17.9127L21.8083 16.1427H22.6883L22.6753 16.5047H22.8873C22.9593 16.5047 23.0073 16.4977 23.0373 16.4787C23.0643 16.4587 23.0843 16.4307 23.0972 16.3857L23.1842 16.1037H23.8763L23.8773 16.1007ZM11.3353 7.22266C11.3033 7.36566 10.7392 9.98566 10.7372 9.98666C10.6172 10.5167 10.5273 10.8967 10.2293 11.1387C10.0573 11.2787 9.85925 11.3487 9.62925 11.3487C9.25925 11.3487 9.04225 11.1637 9.00525 10.8117L8.99825 10.6917L9.11125 9.97966C9.11125 9.97966 9.70425 7.59166 9.81125 7.27666C9.81325 7.25966 9.81625 7.25066 9.81825 7.24166C8.66625 7.25166 8.46125 7.24166 8.44825 7.22366C8.44125 7.24766 8.41125 7.39666 8.41125 7.39666L7.80625 10.0847L7.75625 10.3147L7.65625 11.0607C7.65625 11.2807 7.69825 11.4607 7.78625 11.6137C8.06125 12.0987 8.84625 12.1707 9.29025 12.1707C9.86325 12.1707 10.4003 12.0477 10.7603 11.8257C11.3903 11.4507 11.5572 10.8637 11.7042 10.3457L11.7713 10.0787C11.7713 10.0787 12.3812 7.59866 12.4872 7.27566C12.4902 7.25866 12.4932 7.24966 12.4973 7.24066C11.6623 7.25066 11.4173 7.24066 11.3373 7.22266H11.3353ZM14.7053 12.1447C14.2983 12.1387 14.1553 12.1387 13.6753 12.1627L13.6572 12.1267C13.6992 11.9447 13.7442 11.7637 13.7842 11.5787L13.8443 11.3287C13.9303 10.9387 14.0173 10.4857 14.0283 10.3487C14.0353 10.2647 14.0643 10.0587 13.8283 10.0587C13.7283 10.0587 13.6253 10.1067 13.5213 10.1547C13.4633 10.3617 13.3472 10.9447 13.2912 11.2097C13.1732 11.7677 13.1653 11.8297 13.1133 12.1067L13.0773 12.1437C12.6572 12.1377 12.5113 12.1377 12.0272 12.1617L12.0033 12.1217C12.0833 11.7897 12.1653 11.4537 12.2433 11.1237C12.4463 10.2237 12.4933 9.87866 12.5503 9.42166L12.5903 9.39366C13.0603 9.32666 13.1753 9.31366 13.6873 9.20866L13.7302 9.25566L13.6533 9.54266C13.7393 9.49066 13.8212 9.43866 13.9103 9.39266C14.1523 9.27266 14.4202 9.23766 14.5683 9.23766C14.7913 9.23766 15.0363 9.29966 15.1382 9.56066C15.2362 9.79266 15.1722 10.0807 15.0443 10.6447L14.9783 10.9317C14.8482 11.5587 14.8263 11.6747 14.7533 12.1057L14.7033 12.1417L14.7053 12.1447ZM16.3652 12.1447C16.1202 12.1447 15.9602 12.1387 15.8053 12.1447C15.6523 12.1447 15.5023 12.1527 15.2733 12.1627L15.2603 12.1427L15.2453 12.1227C15.3073 11.8847 15.3423 11.8007 15.3733 11.7167C15.4033 11.6327 15.4333 11.5467 15.4883 11.3067C15.5603 10.9917 15.6043 10.7717 15.6353 10.5787C15.6683 10.3917 15.6873 10.2327 15.7103 10.0487L15.7302 10.0347L15.7502 10.0167C15.9943 9.98066 16.1502 9.95966 16.3102 9.93466C16.4702 9.91066 16.6303 9.87966 16.8843 9.83166L16.8923 9.85466L16.9003 9.87666C16.8533 10.0717 16.8062 10.2667 16.7603 10.4647C16.7133 10.6617 16.6663 10.8567 16.6233 11.0517C16.5303 11.4657 16.4933 11.6217 16.4713 11.7317C16.4513 11.8367 16.4453 11.8947 16.4083 12.1087L16.3862 12.1287L16.3633 12.1457L16.3652 12.1447ZM20.0373 10.7287C20.1803 10.0957 20.0703 9.80066 19.9293 9.61866C19.7163 9.34566 19.3393 9.25866 18.9513 9.25866C18.7163 9.25866 18.1583 9.28166 17.7213 9.68866C17.4093 9.97866 17.2633 10.3757 17.1753 10.7547C17.0873 11.1417 16.9853 11.8407 17.6223 12.0987C17.8203 12.1837 18.1023 12.2067 18.2843 12.2067C18.7502 12.2067 19.2293 12.0767 19.5883 11.6937C19.8663 11.3817 19.9943 10.9187 20.0373 10.7287ZM18.9673 10.6827C18.9473 10.7887 18.8543 11.1857 18.7273 11.3557C18.6413 11.4787 18.5373 11.5537 18.4223 11.5537C18.3893 11.5537 18.1873 11.5537 18.1842 11.2537C18.1812 11.1037 18.2113 10.9497 18.2473 10.7837C18.3553 10.3057 18.4833 9.90366 18.8073 9.90366C19.0623 9.90366 19.0773 10.2007 18.9673 10.6827ZM30.0312 12.1877C29.5382 12.1837 29.3962 12.1837 28.9412 12.2027L28.9113 12.1657C29.0353 11.6937 29.1593 11.2227 29.2693 10.7457C29.4113 10.1257 29.4443 9.86366 29.4923 9.50166L29.5293 9.47166C30.0193 9.40166 30.1543 9.38166 30.6643 9.28566L30.6793 9.32966C30.5863 9.71766 30.4933 10.1067 30.4043 10.4957C30.2143 11.3117 30.1463 11.7257 30.0743 12.1537L30.0303 12.1887L30.0312 12.1877Z" fill="#FEFEFE"/>
	<path d="M30.2677 10.7839C30.4117 10.1539 29.8357 10.7279 29.7427 10.5199C29.6027 10.1969 29.6907 9.53994 29.1227 9.31994C28.9027 9.23494 28.3907 9.34494 27.9527 9.74794C27.6427 10.0379 27.4947 10.4309 27.4087 10.8099C27.3207 11.1899 27.2187 11.8879 27.8527 12.1379C28.0527 12.2229 28.2367 12.2479 28.4197 12.2409C29.0577 12.2069 29.5437 11.2389 29.9027 10.8549C30.1797 10.5519 30.2287 10.9699 30.2707 10.7849L30.2677 10.7839ZM29.2937 10.7369C29.2697 10.8369 29.1767 11.2399 29.0497 11.4069C28.9667 11.5239 28.7667 11.5989 28.6527 11.5989C28.6207 11.5989 28.4207 11.5989 28.4127 11.2989C28.4127 11.1529 28.4427 10.9989 28.4797 10.8319C28.5897 10.3619 28.7147 9.96194 29.0397 9.96194C29.2937 9.96194 29.4027 10.2549 29.2937 10.7359V10.7369ZM22.8297 12.1439C22.4197 12.1379 22.2797 12.1379 21.7997 12.1619L21.7817 12.1259C21.8217 11.9439 21.8687 11.7629 21.9117 11.5779L21.9687 11.3279C22.0587 10.9379 22.1447 10.4849 22.1547 10.3479C22.1627 10.2639 22.1907 10.0579 21.9567 10.0579C21.8567 10.0579 21.7537 10.1059 21.6487 10.1539C21.5917 10.3609 21.4737 10.9439 21.4167 11.2089C21.3017 11.7669 21.2927 11.8289 21.2407 12.1059L21.2057 12.1429C20.7857 12.1369 20.6397 12.1369 20.1557 12.1609L20.1337 12.1209L20.3717 11.1229C20.5747 10.2229 20.6217 9.87794 20.6787 9.42094L20.7167 9.39294C21.1887 9.32594 21.3037 9.31294 21.8147 9.20794L21.8547 9.25494L21.7817 9.54194C21.8657 9.48994 21.9517 9.43794 22.0387 9.39194C22.2787 9.27194 22.5487 9.23694 22.6937 9.23694C22.9177 9.23694 23.1637 9.29894 23.2687 9.55994C23.3637 9.79194 23.2987 10.0799 23.1707 10.6439L23.1057 10.9309C22.9727 11.5579 22.9517 11.6739 22.8807 12.1049L22.8307 12.1409L22.8297 12.1439ZM26.8177 8.75594C26.7477 9.08194 26.5357 9.35894 26.2637 9.49194C26.0387 9.60594 25.7657 9.61494 25.4837 9.61494H25.3007L25.3137 9.54094L25.6497 8.07294L25.6597 7.99694L25.6667 7.93894L25.7987 7.95394L26.5087 8.01594C26.7837 8.12094 26.8957 8.39594 26.8177 8.75594ZM26.3777 7.21994L26.0377 7.22294C25.1547 7.23294 24.7997 7.22894 24.6547 7.21094L24.6177 7.39294L24.3027 8.87094L23.5097 12.1589C24.2797 12.1489 24.5977 12.1489 24.7297 12.1629L24.9397 11.1389C24.9397 11.1389 25.0927 10.4949 25.1027 10.4719C25.1027 10.4719 25.1497 10.4059 25.1987 10.3799H25.2687C25.9337 10.3799 26.6857 10.3799 27.2737 9.94294C27.6737 9.64494 27.9487 9.20294 28.0707 8.66894C28.1007 8.53694 28.1247 8.37894 28.1247 8.22294C28.1247 8.01794 28.0847 7.81294 27.9647 7.65494C27.6647 7.23194 27.0687 7.22494 26.3767 7.22194L26.3777 7.21994ZM34.0697 9.27994L34.0297 9.23694C33.5277 9.33694 33.4357 9.35494 32.9717 9.41694L32.9377 9.45094L32.9327 9.47394L32.9297 9.46694C32.5847 10.2699 32.5957 10.0969 32.3147 10.7269C32.3117 10.6969 32.3117 10.6789 32.3107 10.6499L32.2407 9.27994L32.1967 9.23694C31.6667 9.33694 31.6547 9.35494 31.1667 9.41694L31.1267 9.45094L31.1207 9.50694L31.1237 9.51394C31.1837 9.82894 31.1707 9.75794 31.2317 10.2519C31.2617 10.4959 31.2967 10.7419 31.3247 10.9819C31.3747 11.3819 31.4017 11.5819 31.4587 12.1919C31.1307 12.7419 31.0507 12.9489 30.7367 13.4299L30.7537 13.4739C31.2317 13.4559 31.3407 13.4559 31.6937 13.4559L31.7737 13.3679C32.0387 12.7899 34.0687 9.28294 34.0687 9.28294L34.0697 9.27994ZM16.8157 9.61994C17.0857 9.42994 17.1197 9.16994 16.8917 9.03394C16.6617 8.89694 16.2577 8.93994 15.9857 9.12894C15.7127 9.31494 15.6817 9.57894 15.9107 9.71494C16.1387 9.84894 16.5437 9.80994 16.8157 9.61994Z" fill="#FEFEFE"/>
	<path d="M31.7414 13.4151L31.3444 14.0991C31.2204 14.3311 30.9874 14.5061 30.6164 14.5091L29.9844 14.4991L30.1684 13.8811H30.2924C30.3564 13.8811 30.4024 13.8771 30.4404 13.8591C30.4704 13.8491 30.4944 13.8241 30.5204 13.7871L30.7534 13.4141H31.7414V13.4151Z" fill="#FEFEFE"/>
</g>
<defs>
	<clipPath id="clip0_11282_39275">
		<rect width="40" height="24" fill="white" transform="translate(0.5)"/>
	</clipPath>
</defs>

<?php
$this->template( 'components/icons/icon/end' );
