<?php
/**
 * View: Group icon.
 *
 * @since 4.22.0
 * @version 4.24.0
 *
 * @var string[] $classes        Additional classes to add to the svg icon.
 * @var string   $label          The label for the icon.
 * @var bool     $is_aria_hidden Whether the icon is hidden from screen readers. Default false to show the icon.
 * @var Template $this           The template instance.
 *
 * @package LearnDash\Core
 */

use LearnDash\Core\Template\Template;

$svg_classes = [ 'ld-svgicon__group' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}

if ( empty( $label ) ) {
	$label = sprintf(
		// translators: %s: Group label.
		__( '%s icon', 'learndash' ),
		learndash_get_custom_label( 'group' )
	);
}

$this->template(
	'components/icons/icon/start',
	[
		'classes' => $svg_classes,
		'height'  => 24,
		'label'   => $label,
		'width'   => 24,
	],
);
?>

<path fill-rule="evenodd" clip-rule="evenodd" d="M10 5.875C8.69254 5.875 7.675 6.89921 7.675 8.11111C7.675 9.32301 8.69254 10.3472 10 10.3472C11.3075 10.3472 12.325 9.32301 12.325 8.11111C12.325 6.89921 11.3075 5.875 10 5.875ZM5.925 8.11111C5.925 5.88657 7.77284 4.125 10 4.125C12.2272 4.125 14.075 5.88657 14.075 8.11111C14.075 10.3357 12.2272 12.0972 10 12.0972C7.77284 12.0972 5.925 10.3357 5.925 8.11111ZM13.9858 4.90571C14.1628 4.45603 14.6708 4.23496 15.1204 4.41193C16.6051 4.99622 17.675 6.42216 17.675 8.11111C17.675 9.80006 16.6051 11.226 15.1204 11.8103C14.6708 11.9873 14.1628 11.7662 13.9858 11.3165C13.8088 10.8668 14.0299 10.3588 14.4796 10.1819C15.3404 9.8431 15.925 9.03345 15.925 8.11111C15.925 7.18877 15.3404 6.37912 14.4796 6.04036C14.0299 5.86339 13.8088 5.35539 13.9858 4.90571ZM8.76998 13.4583H11.23C11.9501 13.4583 12.5335 13.4583 13.0088 13.4899C13.4982 13.5223 13.9354 13.5909 14.3514 13.7585C15.3459 14.159 16.1437 14.9304 16.5614 15.9109C16.7372 16.3235 16.8087 16.7565 16.8424 17.2365C16.875 17.7011 16.875 18.2704 16.875 18.9686V19C16.875 19.4832 16.4832 19.875 16 19.875C15.5168 19.875 15.125 19.4832 15.125 19C15.125 18.2629 15.1245 17.7551 15.0967 17.359C15.0695 16.9712 15.0192 16.756 14.9514 16.5968C14.7196 16.0527 14.2715 15.6129 13.6977 15.3818C13.5257 15.3125 13.2962 15.2628 12.893 15.236C12.4824 15.2088 11.9571 15.2083 11.2 15.2083H8.8C8.04285 15.2083 7.5176 15.2088 7.10702 15.236C6.70383 15.2628 6.47429 15.3125 6.30227 15.3818C5.72854 15.6129 5.28039 16.0527 5.04857 16.5968C4.98078 16.756 4.93052 16.9712 4.9033 17.359C4.8755 17.7551 4.875 18.2629 4.875 19C4.875 19.4832 4.48325 19.875 4 19.875C3.51675 19.875 3.125 19.4832 3.125 19L3.125 18.9686C3.12499 18.2705 3.12499 17.7011 3.1576 17.2365C3.19128 16.7565 3.26281 16.3235 3.4386 15.9109C3.85635 14.9304 4.65411 14.159 5.64855 13.7585C6.06461 13.5909 6.50185 13.5223 6.99119 13.4899C7.46654 13.4583 8.04994 13.4583 8.76998 13.4583ZM16.7512 14.2189C16.8685 13.7501 17.3436 13.4652 17.8124 13.5825C19.5574 14.0192 20.875 15.5685 20.875 17.4444V19C20.875 19.4832 20.4832 19.875 20 19.875C19.5168 19.875 19.125 19.4832 19.125 19V17.4444C19.125 16.421 18.4029 15.5342 17.3876 15.2802C16.9188 15.1629 16.6339 14.6877 16.7512 14.2189Z" fill="currentColor"/>

<?php
$this->template( 'components/icons/icon/end' );
