<?php
/**
 * View: Unionpay logo small.
 *
 * @since 4.25.0
 * @version 4.25.0
 *
 * @var string[] $classes        Additional classes to add to the svg icon.
 * @var string   $label          The label for the icon.
 * @var bool     $is_aria_hidden Whether the icon is hidden from screen readers. Default false to show the icon.
 * @var Template $this           The template instance.
 *
 * @package LearnDash\Core
 */

use LearnDash\Core\Template\Template;

$svg_classes = [ 'ld-svgicon__unionpay-small' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}

if ( empty( $label ) ) {
	$label = __( 'Unionpay logo', 'learndash' );
}

$this->template(
	'components/icons/icon/start',
	[
		'classes' => $svg_classes,
		'height'  => 17,
		'label'   => $label,
		'width'   => 26,
	],
);

?>

<g clip-path="url(#clip0_16085_26096)">
	<path d="M24.9164 16.8047H1.08355C0.4875 16.8047 0 16.3247 0 15.738V1.87135C0 1.28469 0.4875 0.804688 1.08355 0.804688H24.9164C25.5125 0.804688 26 1.28469 26 1.87135V15.738C26 16.3247 25.5125 16.8047 24.9164 16.8047Z" fill="white"/>
	<path d="M6.42049 2.13818H11.7024C12.4401 2.13818 12.8984 2.75818 12.7261 3.52285L10.2672 14.4229C10.0936 15.1842 9.35524 15.8049 8.61749 15.8049H3.33494C2.59784 15.8049 2.13894 15.1849 2.31184 14.4229L4.77144 3.52218C4.94499 2.75818 5.68144 2.13818 6.42114 2.13818H6.42049Z" fill="#E21836"/>
	<path d="M11.263 2.13818H17.3373C18.0744 2.13818 17.7422 2.75818 17.5687 3.52285L15.1097 14.4229C14.9375 15.1842 14.9914 15.8049 14.2517 15.8049H8.17879C7.43974 15.8049 6.98279 15.1849 7.15569 14.4229L9.61464 3.52285C9.78819 2.75818 10.5253 2.13818 11.2624 2.13818H11.263Z" fill="#00447B"/>
	<path d="M17.0922 2.13818H22.3741C23.1125 2.13818 23.5701 2.75818 23.3979 3.52285L20.9396 14.4229C20.7667 15.1842 20.0283 15.8049 19.2886 15.8049H14.0093C13.2702 15.8049 12.812 15.1849 12.9862 14.4229L15.4432 3.52285C15.6167 2.75818 16.3551 2.13818 17.0942 2.13818H17.0922Z" fill="#007B84"/>
	<path d="M17.9606 10.1865L17.3171 12.3865H17.49L17.3548 12.8398H17.1819L17.1416 12.9812H16.5293L16.5709 12.8412H15.3262L15.4516 12.4198H15.5777L16.231 10.1865L16.361 9.73584H16.9863L16.9213 9.96251C16.9213 9.96251 17.087 9.83984 17.245 9.79717C17.4023 9.75451 18.3084 9.73851 18.3084 9.73851L18.1745 10.1865H17.9606ZM16.8589 10.1865L16.6938 10.7485C16.6938 10.7485 16.879 10.6618 16.9798 10.6338C17.0838 10.6072 17.2365 10.5958 17.2365 10.5958L17.3548 10.1865H16.8589ZM16.6119 11.0278L16.4409 11.6125C16.4409 11.6125 16.6294 11.5125 16.7315 11.4818C16.8335 11.4572 16.9889 11.4378 16.9889 11.4378L17.1091 11.0285H16.6112L16.6119 11.0278ZM16.2128 12.3918H16.7113L16.8556 11.8985H16.3584L16.2128 12.3918Z" fill="#FEFEFE"/>
	<path d="M18.2365 9.73771H18.904L18.9105 9.99437C18.9073 10.0377 18.943 10.0584 19.021 10.0584H19.1562L19.0327 10.483H18.672C18.36 10.5064 18.2417 10.3684 18.2495 10.2124L18.2365 9.73904V9.73771ZM18.3262 11.7477H17.6905L17.799 11.3704H18.5257L18.6297 11.0257H17.9121L18.0356 10.6004H20.0324L19.907 11.0257H19.2375L19.1335 11.3697H19.8043L19.6938 11.7464H18.9677L18.8377 11.9064H19.1328L19.2043 12.381C19.2128 12.4277 19.2134 12.4584 19.2277 12.479C19.2427 12.4964 19.3304 12.5044 19.3824 12.5044H19.4715L19.335 12.967H19.1088C19.0737 12.967 19.0223 12.9644 18.9508 12.9604C18.8826 12.955 18.8338 12.9137 18.7883 12.8904C18.7467 12.8704 18.6843 12.817 18.67 12.7304L18.5985 12.2557L18.269 12.7224C18.1637 12.8704 18.022 12.9824 17.7828 12.9824H17.32L17.4409 12.569H17.6183C17.669 12.569 17.7158 12.549 17.7483 12.5317C17.7821 12.5164 17.812 12.4984 17.8458 12.4477L18.3262 11.7477ZM11.3614 10.7157H13.0449L12.9214 11.1304H12.2467L12.1427 11.4837H12.8317L12.7056 11.9104H12.0166L11.8502 12.4857C11.8307 12.549 12.0127 12.5577 12.0797 12.5577L12.4242 12.5097L12.2864 12.983H11.5109C11.4485 12.983 11.4017 12.9744 11.3341 12.9584C11.2691 12.943 11.2399 12.9117 11.2106 12.8664C11.1827 12.8197 11.1391 12.781 11.169 12.681L11.392 11.919H11.0098L11.1365 11.4857H11.5213L11.6227 11.1324H11.2405L11.3627 10.717L11.3614 10.7157ZM12.4957 9.97104H13.1866L13.0605 10.4044H12.1167L12.0147 10.495C11.9711 10.539 11.9562 10.5204 11.8977 10.553C11.8457 10.5797 11.7326 10.635 11.5876 10.635H11.2847L11.4082 10.2184H11.4992C11.5759 10.2184 11.6279 10.2117 11.6539 10.1944C11.6838 10.1744 11.7176 10.1304 11.756 10.059L11.9295 9.73438H12.6166L12.495 9.97171L12.4957 9.97104ZM13.4817 9.73771H14.07L13.9842 10.0444C13.9842 10.0444 14.1701 9.89104 14.3007 9.83571C14.4307 9.78571 14.7232 9.74037 14.7232 9.74037L15.6748 9.73571L15.3511 10.8504C15.2959 11.041 15.2322 11.165 15.1925 11.2204C15.1568 11.2784 15.1145 11.327 15.0313 11.3737C14.9507 11.4177 14.8779 11.443 14.8103 11.4504C14.7479 11.455 14.6517 11.457 14.5178 11.4584H13.6013L13.3413 12.341C13.3173 12.4277 13.3056 12.4704 13.3218 12.4944C13.3348 12.5144 13.366 12.5384 13.4096 12.5384L13.8126 12.4984L13.6761 12.9824H13.2224C13.0794 12.9824 12.9734 12.9797 12.9006 12.9737C12.8304 12.967 12.7576 12.9737 12.7089 12.935C12.6666 12.8964 12.6023 12.8464 12.6036 12.795C12.6081 12.7464 12.6276 12.667 12.6569 12.5577L13.4817 9.73771ZM14.731 10.8644H13.7664L13.7079 11.0644H14.5419C14.6407 11.0524 14.6615 11.067 14.6693 11.0624L14.731 10.8644ZM13.8197 10.683C13.8197 10.683 14.0082 10.5057 14.3306 10.4477C14.4034 10.433 14.8636 10.4377 14.8636 10.4377L14.9325 10.1997H13.9601L13.8197 10.683Z" fill="#FEFEFE"/>
	<path d="M15.195 11.5383L15.1404 11.8063C15.117 11.8896 15.0969 11.953 15.0364 12.0076C14.9714 12.0636 14.896 12.1223 14.7192 12.1223L14.3929 12.1356L14.3903 12.439C14.3864 12.5256 14.4085 12.517 14.4215 12.531C14.4371 12.5456 14.4508 12.5523 14.4651 12.5576L14.5671 12.5523L14.8791 12.5336L14.7504 12.9756H14.3916C14.1414 12.9756 13.9561 12.9703 13.8944 12.9196C13.8346 12.8816 13.8261 12.8316 13.8274 12.7463L13.8502 11.5663H14.4222L14.4137 11.8076H14.5515C14.5983 11.8076 14.6295 11.803 14.649 11.7903C14.6666 11.777 14.6796 11.7583 14.688 11.7283L14.7446 11.5403H15.1944L15.195 11.5383ZM7.04272 5.61963C7.02192 5.71496 6.65532 7.46163 6.65402 7.4623C6.57602 7.81563 6.51752 8.06896 6.32382 8.2303C6.21202 8.32363 6.08332 8.3703 5.93382 8.3703C5.69332 8.3703 5.55227 8.24696 5.52822 8.0123L5.52367 7.9323L5.59712 7.45763C5.59712 7.45763 5.98257 5.86563 6.05212 5.65563C6.05342 5.6443 6.05537 5.6383 6.05667 5.6323C5.30787 5.63896 5.17462 5.6323 5.16617 5.6203C5.16162 5.6363 5.14212 5.73563 5.14212 5.73563L4.74887 7.52763L4.71637 7.68096L4.65137 8.1783C4.65137 8.32496 4.67867 8.44496 4.73587 8.54696C4.91462 8.8703 5.42487 8.9183 5.71347 8.9183C6.08592 8.9183 6.43497 8.8363 6.66897 8.6883C7.07847 8.4383 7.18702 8.04696 7.28257 7.70163L7.32612 7.52363C7.32612 7.52363 7.72262 5.8703 7.79152 5.65496C7.79347 5.64363 7.79542 5.63763 7.79802 5.63163C7.25527 5.6383 7.09602 5.63163 7.04402 5.61963H7.04272ZM9.23322 8.90096C8.96867 8.89696 8.87572 8.89696 8.56372 8.91296L8.55202 8.88896C8.57932 8.76763 8.60857 8.64696 8.63457 8.52363L8.67357 8.35696C8.72947 8.09696 8.78602 7.79496 8.79317 7.70363C8.79772 7.64763 8.81657 7.5103 8.66317 7.5103C8.59817 7.5103 8.53122 7.5423 8.46362 7.5743C8.42592 7.7123 8.35052 8.10096 8.31412 8.27763C8.23742 8.64963 8.23222 8.69096 8.19842 8.87563L8.17502 8.9003C7.90202 8.8963 7.80712 8.8963 7.49252 8.9123L7.47692 8.88563C7.52892 8.6643 7.58222 8.4403 7.63292 8.2203C7.76487 7.6203 7.79542 7.3903 7.83247 7.08563L7.85847 7.06696C8.16397 7.0223 8.23872 7.01363 8.57152 6.94363L8.59947 6.97496L8.54942 7.1663C8.60532 7.13163 8.65862 7.09696 8.71647 7.0663C8.87377 6.9863 9.04797 6.96296 9.14417 6.96296C9.28912 6.96296 9.44837 7.0043 9.51467 7.1783C9.57837 7.33296 9.53677 7.52496 9.45357 7.90096L9.41067 8.0923C9.32617 8.5103 9.31187 8.58763 9.26442 8.87496L9.23192 8.89896L9.23322 8.90096ZM10.3122 8.90096C10.153 8.90096 10.049 8.89696 9.94822 8.90096C9.84877 8.90096 9.75127 8.9063 9.60242 8.91296L9.59397 8.89963L9.58422 8.8863C9.62452 8.72763 9.64727 8.67163 9.66742 8.61563C9.68692 8.55963 9.70642 8.5023 9.74217 8.3423C9.78897 8.1323 9.81757 7.98563 9.83772 7.85696C9.85917 7.7323 9.87152 7.6263 9.88647 7.50363L9.89947 7.4943L9.91247 7.4823C10.0711 7.4583 10.1725 7.4443 10.2765 7.42763C10.3805 7.41163 10.4845 7.39096 10.6496 7.35896L10.6548 7.3743L10.66 7.38896C10.6294 7.51896 10.5989 7.64896 10.569 7.78096C10.5384 7.9123 10.5079 8.0423 10.4799 8.1723C10.4195 8.4483 10.3954 8.5523 10.3811 8.62563C10.3681 8.69563 10.3642 8.7343 10.3402 8.87696L10.3259 8.8903L10.3109 8.90163L10.3122 8.90096ZM12.699 7.95696C12.792 7.53496 12.7205 7.3383 12.6288 7.21696C12.4904 7.03496 12.2453 6.97696 11.9931 6.97696C11.8404 6.97696 11.4777 6.9923 11.1936 7.26363C10.9908 7.45696 10.8959 7.72163 10.8387 7.9743C10.7815 8.2323 10.7152 8.6983 11.1293 8.8703C11.258 8.92696 11.4413 8.9423 11.5596 8.9423C11.8625 8.9423 12.1738 8.85563 12.4072 8.6003C12.5879 8.3923 12.6711 8.08363 12.699 7.95696ZM12.0035 7.9263C11.9905 7.99696 11.9301 8.26163 11.8475 8.37496C11.7916 8.45696 11.724 8.50696 11.6493 8.50696C11.6278 8.50696 11.4965 8.50696 11.4946 8.30696C11.4926 8.20696 11.5121 8.1043 11.5355 7.99363C11.6057 7.67496 11.6889 7.40696 11.8995 7.40696C12.0653 7.40696 12.075 7.60496 12.0035 7.9263ZM19.1951 8.92963C18.8747 8.92696 18.7824 8.92696 18.4866 8.93963L18.4671 8.91496C18.5477 8.6003 18.6283 8.2863 18.6998 7.9683C18.7921 7.55496 18.8136 7.3803 18.8448 7.13896L18.8688 7.11896C19.1873 7.0723 19.2751 7.05896 19.6066 6.99496L19.6163 7.0243C19.5559 7.28296 19.4954 7.5423 19.4376 7.80163C19.3141 8.34563 19.2699 8.62163 19.2231 8.90696L19.1945 8.9303L19.1951 8.92963Z" fill="#FEFEFE"/>
	<path d="M19.3494 7.99382C19.443 7.57382 19.0686 7.95648 19.0081 7.81782C18.9171 7.60248 18.9743 7.16448 18.6051 7.01782C18.4621 6.96115 18.1293 7.03448 17.8446 7.30315C17.6431 7.49648 17.5469 7.75848 17.491 8.01115C17.4338 8.26448 17.3675 8.72982 17.7796 8.89648C17.9096 8.95315 18.0292 8.96982 18.1482 8.96515C18.5629 8.94248 18.8788 8.29715 19.1121 8.04115C19.2922 7.83915 19.324 8.11782 19.3513 7.99448L19.3494 7.99382ZM18.7163 7.96248C18.7007 8.02915 18.6402 8.29782 18.5577 8.40915C18.5037 8.48715 18.3737 8.53715 18.2996 8.53715C18.2788 8.53715 18.1488 8.53715 18.1436 8.33715C18.1436 8.23982 18.1631 8.13715 18.1872 8.02582C18.2587 7.71248 18.3399 7.44582 18.5512 7.44582C18.7163 7.44582 18.7871 7.64115 18.7163 7.96182V7.96248ZM14.5147 8.90048C14.2482 8.89648 14.1572 8.89648 13.8452 8.91248L13.8335 8.88848C13.8595 8.76715 13.89 8.64648 13.918 8.52315L13.955 8.35648C14.0135 8.09648 14.0694 7.79448 14.0759 7.70315C14.0811 7.64715 14.0993 7.50982 13.9472 7.50982C13.8822 7.50982 13.8153 7.54182 13.747 7.57382C13.71 7.71182 13.6333 8.10048 13.5962 8.27715C13.5215 8.64915 13.5156 8.69048 13.4818 8.87515L13.4591 8.89982C13.1861 8.89582 13.0912 8.89582 12.7766 8.91182L12.7623 8.88515L12.917 8.21982C13.0489 7.61982 13.0795 7.38982 13.1165 7.08515L13.1412 7.06648C13.448 7.02182 13.5228 7.01315 13.8549 6.94315L13.8809 6.97448L13.8335 7.16582C13.8881 7.13115 13.944 7.09648 14.0005 7.06582C14.1565 6.98582 14.332 6.96248 14.4263 6.96248C14.5719 6.96248 14.7318 7.00382 14.8 7.17782C14.8618 7.33248 14.8195 7.52448 14.7363 7.90048L14.6941 8.09182C14.6076 8.50982 14.594 8.58715 14.5478 8.87448L14.5153 8.89848L14.5147 8.90048ZM17.1069 6.64182C17.0614 6.85915 16.9236 7.04382 16.7468 7.13248C16.6005 7.20848 16.4231 7.21448 16.2398 7.21448H16.1208L16.1293 7.16515L16.3477 6.18648L16.3542 6.13582L16.3587 6.09715L16.4445 6.10715L16.906 6.14848C17.0848 6.21848 17.1576 6.40182 17.1069 6.64182ZM16.8209 5.61782L16.5999 5.61982C16.0259 5.62648 15.7952 5.62382 15.7009 5.61182L15.6769 5.73315L15.4721 6.71848L14.9567 8.91048C15.4572 8.90382 15.6639 8.90382 15.7497 8.91315L15.8862 8.23048C15.8862 8.23048 15.9856 7.80115 15.9921 7.78582C15.9921 7.78582 16.0227 7.74182 16.0545 7.72448H16.1C16.5323 7.72448 17.0211 7.72448 17.4033 7.43315C17.6633 7.23448 17.842 6.93982 17.9213 6.58382C17.9408 6.49582 17.9564 6.39048 17.9564 6.28648C17.9564 6.14982 17.9304 6.01315 17.8524 5.90782C17.6574 5.62582 17.27 5.62115 16.8202 5.61915L16.8209 5.61782ZM21.8207 6.99115L21.7947 6.96248C21.4684 7.02915 21.4086 7.04115 21.107 7.08248L21.0849 7.10515L21.0816 7.12048L21.0797 7.11582C20.8554 7.65115 20.8626 7.53582 20.6799 7.95582C20.678 7.93582 20.678 7.92382 20.6773 7.90448L20.6318 6.99115L20.6032 6.96248C20.2587 7.02915 20.2509 7.04115 19.9337 7.08248L19.9077 7.10515L19.9038 7.14248L19.9058 7.14715C19.9448 7.35715 19.9363 7.30982 19.976 7.63915C19.9955 7.80182 20.0182 7.96582 20.0364 8.12582C20.0689 8.39248 20.0865 8.52582 20.1235 8.93248C19.9103 9.29915 19.8583 9.43715 19.6542 9.75782L19.6653 9.78715C19.976 9.77515 20.0468 9.77515 20.2763 9.77515L20.3283 9.71648C20.5005 9.33115 21.82 6.99315 21.82 6.99315L21.8207 6.99115ZM10.6056 7.21782C10.7811 7.09115 10.8032 6.91782 10.655 6.82715C10.5055 6.73582 10.2429 6.76448 10.0661 6.89048C9.88862 7.01448 9.86847 7.19048 10.0173 7.28115C10.1655 7.37048 10.4288 7.34448 10.6056 7.21782Z" fill="#FEFEFE"/>
	<path d="M20.3071 9.74823L20.049 10.2042C19.9684 10.3589 19.817 10.4756 19.5758 10.4776L19.165 10.4709L19.2846 10.0589H19.3652C19.4068 10.0589 19.4367 10.0562 19.4614 10.0442C19.4809 10.0376 19.4965 10.0209 19.5134 9.99623L19.6649 9.74756H20.3071V9.74823Z" fill="#FEFEFE"/>
</g>
<defs>
	<clipPath id="clip0_16085_26096">
		<rect width="26" height="16" fill="white" transform="translate(0 0.804688)"/>
	</clipPath>
</defs>

<?php
$this->template( 'components/icons/icon/end' );
