<?php

namespace WPML\PostHog\Event;

use WPML\Core\Component\PostHog\Application\Service\Config\ConfigService;
use WPML\Core\Component\PostHog\Application\Service\Event\CaptureEventService;
use WPML\Core\Component\PostHog\Domain\Event\EventInterface;

class CaptureEvent {

	public static function capture( EventInterface $event, $personProps = [] ) {
		$postHogConfig = ( new ConfigService() )->create();

		global $wpml_dic;

		/** @var CaptureEventService $postHogCaptureEventService */
		$postHogCaptureEventService = $wpml_dic->make( CaptureEventService::class );

		$postHogCaptureEventService->capture(
			$postHogConfig,
			$event,
			$personProps
		);
	}

}
