<?php

namespace WPML\UserInterface\Web\Core\Port\Remote;

use WPML\PHP\Exception\JsonEncodeException;
use WPML\PHP\Exception\RemoteException;

interface RemoteInterface {


  /**
   * @param string $url
   * @param array<string, mixed> $data
   * @param bool $asJson
   * @param array<string, string> $headers
   *
   * @return mixed
   *
   * @throws RemoteException
   */
  public function post( $url, $data, $asJson = true, $headers = [] );


  /**
   * @param array<string, mixed> $data
   * @return string
   *
   * @throws JsonEncodeException
   */
  public function jsonEncode( $data );


}
