<?php
/**
 * Speaker
 * Create an audio version of your posts, with a selection of more than 340 voices across more than 52 languages and variants.
 * Exclusively on https://1.envato.market/speaker
 *
 * @encoding        UTF-8
 * @version         4.1.10
 * @copyright       (C) 2018 - 2023 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 **/

namespace Merkulove\Speaker;

use Merkulove\Speaker\Unity\ReporterServer;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

/**
 * @package Merkulove/Speaker
 */
final class Actions {

	/**
	 * @access private
	 * @var Actions
	 **/
	private static $instance;

	/**
	 * Register hooks.
	 * @return void
	 */
	private function __construct() {

		// Check if plugin meet server requirements. Disable plugin and show notice if not.
		add_action( 'speaker_settings_checks', [ $this, 'settings_checks' ] );

	}

	/**
	 * Additional checks before show plugin settings.
	 * @param $CheckCompatibility
	 *
	 * @return void
	 */
	public function settings_checks( $CheckCompatibility ) {

		$default_recommendation = esc_html__( 'One or more required PHP extensions are disabled or unavailable. Please contact support to enable this extension.', 'speaker' );

		/** Plugin require cURL extension. */
		$curl_installed = ReporterServer::get_instance()->get_curl_installed();
		$check = ! $curl_installed['warning'];
		if ( false === $check ) {
			$CheckCompatibility->admin_messages[] = $curl_installed['recommendation'] ?? $default_recommendation;
			$CheckCompatibility::$settings_checks_pass = false;
		}

		/** Plugin require DOM extension. */
		$dom_installed = ReporterServer::get_instance()->get_dom_installed();
		$check = ! $dom_installed['warning'];
		if ( false === $check ) {
			$CheckCompatibility->admin_messages[] = $dom_installed['recommendation'] ?? $default_recommendation;
			$CheckCompatibility::$settings_checks_pass = false;
		}

		/** Plugin require XML extension. */
		$xml_installed = ReporterServer::get_instance()->get_xml_installed();
		$check = ! $xml_installed['warning'];
		if ( false === $check ) {
			$CheckCompatibility->admin_messages[] = $xml_installed['recommendation'] ?? $default_recommendation;
			$CheckCompatibility::$settings_checks_pass = false;
		}

		/** Plugin require BCMath extension. */
		$bcmath_installed = ReporterServer::get_instance()->get_bcmath_installed();
		$check = ! $bcmath_installed['warning'];
		if ( false === $check ) {
			$CheckCompatibility->admin_messages[] = $bcmath_installed['recommendation'] ?? $default_recommendation;
			$CheckCompatibility::$settings_checks_pass = false;
		}

		/** Plugin require mbstring extension. */
		$mbstring_installed = ReporterServer::get_instance()->get_mbstring_installed();
		$check = ! $mbstring_installed['warning'];
		if ( false === $check ) {
			$CheckCompatibility->admin_messages[] = $mbstring_installed['recommendation'] ?? $default_recommendation;
			$CheckCompatibility::$settings_checks_pass = false;
		}

		/** Plugin require correct Server Time. */
//		$server_time = ReporterServer::get_instance()->get_server_time();
//		$check = ! $server_time['warning'];
//		if ( false === $check ) {
//			$CheckCompatibility->admin_messages[] = $server_time['recommendation'] ?? $default_recommendation;
//			$CheckCompatibility::$settings_checks_pass = false;
//		}

		/** Show notices in admin area */
		$CheckCompatibility->admin_notices( true );

	}

	/**
	 * Main Instance.
	 *
	 * @return Actions
	 **/
	public static function get_instance(): Actions {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {

			self::$instance = new self;

		}

		return self::$instance;

	}

}
