<?php
/**
 * Speaker
 * Create an audio version of your posts, with a selection of more than 340 voices across more than 52 languages and variants.
 * Exclusively on https://1.envato.market/speaker
 *
 * @encoding        UTF-8
 * @version         4.0.0
 * @copyright       (C) 2018 - 2023 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 **/

namespace Merkulove\Speaker;

use Merkulove\Speaker\Unity\Plugin;
use Merkulove\Speaker\Unity\Settings;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

/**
 * @package Merkulove\Speaker
 **/
final class TabAnalytics {

	/**
	 * Controls for Design tab.
	 * @return void
	 */
	public static function controls() {

		$tabs = Plugin::get_tabs();

		$options = Settings::get_instance()->options;

		$fields = array();
		$fields = self::fields( $fields, $options );

		$tabs[ 'analytics' ][ 'fields' ] = $fields;

		Plugin::set_tabs( $tabs );

	}

	/**
	 * General player style
	 *
	 * @param array $fields
	 * @param array $options
	 *
	 * @return array
	 */
	private static function fields( array $fields, array $options ): array {

		$fields[ 'analytics' ] = [
			'type'              => 'switcher',
			'label'             => esc_html__( 'Analytics', 'speaker' ),
			'description'       => esc_html__( 'Collect data for analytics and display it in the admin panel', 'speaker' ),
			'default'           => 'on',
		];

		$default_analytics_precision = $options[ 'analytics_precision' ] ?? 5;
		$fields[ 'analytics_precision' ] = [
			'type' => 'slider',
			'label' => esc_html__( 'Analytics precision', 'speaker' ),
			'description' => wp_sprintf(
				/* translators: %s: precision */
				esc_html__( 'The number of seconds after which the data will be sent to the server. Values that are too small can cause additional load on your database. Current precision: %s seconds.', 'speaker' ),
				'<strong>' . esc_attr( $default_analytics_precision ) . '</strong>'
			),
			'default' => $default_analytics_precision,
			'min' => 1,
			'max' => 60,
			'step' => 1,
		];

		$fields[ 'analytics_dashboard_widget' ] = [
			'type' => 'switcher',
			'label' => esc_html__( 'Analytics dashboard widget', 'speaker' ),
			'description' => esc_html__( 'Display analytics results in dashboard widget', 'speaker' ),
			'default' => 'on',
		];

		$fields[ 'analytics_metabox' ] = [
			'type' => 'switcher',
			'label' => esc_html__( 'Analytics metabox', 'speaker' ),
			'description' => esc_html__( 'Display analytics results in metabox on post edit page', 'speaker' ),
			'default' => 'on',
		];

		$fields[ 'analytics_column' ] = [
			'type' => 'switcher',
			'label' => esc_html__( 'Analytics column', 'speaker' ),
			'description' => esc_html__( 'Display analytics results in column on post list', 'speaker' ),
			'default' => 'on',
		];

		$fields[ 'analytics_column_data' ] = [
			'type'          => 'chosen',
			'label'         => esc_html__( 'Columns data', 'speaker' ),
			'description'   => esc_html__( 'Analytics columns data types in column on post list', 'speaker' ),
			'default'       => [ 'play_rate', 'average_time' ],
			'options'       => [
				'play_rate'     => esc_html__( 'Playback ratio', 'speaker' ),
				'time_average'  => esc_html__( 'Average played', 'speaker' ),
				'init'  => esc_html__( 'Ready', 'speaker' ),
				'play'  => esc_html__( 'Played', 'speaker' ),
				'pause' => esc_html__( 'Paused', 'speaker' ),
				'time'          => esc_html__( 'Total played', 'speaker' ),
				'bounce_rate'   => esc_html__( 'Bounce rate', 'speaker' )
			],
			'attr'          => [
				'multiple' => 'multiple',
			]
		];

		return $fields;

	}

}
