<?php
/**
 * Speaker
 * Create an audio version of your posts, with a selection of more than 340 voices across more than 52 languages and variants.
 * Exclusively on https://1.envato.market/speaker
 *
 * @encoding        UTF-8
 * @version         4.0.0
 * @copyright       (C) 2018 - 2023 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 **/

namespace Merkulove\Speaker;

use Merkulove\Speaker\Unity\Plugin;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

/**
 * @package Merkulove\Speaker
 **/
final class TabSchema {

	/**
	 * Controls for Schema tab.
	 * @return void
	 */
	public static function controls() {

		$tabs = Plugin::get_tabs();
		$fields = array();

		$fields[ 'schema' ] = [
			'type'              => 'switcher',
			'label'             => esc_html__( 'Speakable Markup', 'speaker' ),
			'description'       => esc_html__( 'Add speakable markup according to', 'speaker' ) . ' <a href="https://schema.org/speakable" target="_blank">schema.org</a> ' . esc_html__( 'rules', 'speaker' ),
			'default'           => 'off',
		];

		$fields[ 'schema_for_all' ] = [
			'type'              => 'switcher',
			'label'             => esc_html__( 'For all posts', 'speaker' ),
			'description'       => esc_html__( 'Add speakable markup for posts without audio generated', 'speaker' ),
			'default'           => 'on',
		];

		$fields[ 'json_ld' ] = [
			'type'              => 'textarea',
			'label'             => esc_html__( 'JSON+LD markup', 'speaker' ),
			'description'       => esc_html__( 'Modify JSON+LD markup regards to the', 'speaker' ) .' <a href="https://developers.google.com/search/docs/appearance/structured-data/speakable" target="_blank">' .  esc_html__( 'Speakable Markup Guide', 'speaker' ) . '</a>.' .
			esc_html__( 'The following variables are available: ', 'speaker' ) .
			'<br><strong>[title]</strong>' . ' — ' . esc_html__( 'Post Title', 'speaker' ) .
			'<br><strong>[type]</strong>' . ' — ' . esc_html__( 'WebPage for Pages or Article for the rest post types', 'speaker' ) .
			'<br><strong>[permalink]</strong>' . ' — ' . esc_html__( 'Direct post link', 'speaker' ),
			'default'           => '{
    "@context": "https://schema.org/",
    "@type": "[type]",
    "name": "[title]",
    "speakable":
        {
            "@type": "SpeakableSpecification",
            "cssSelector": [
                "main h1",
                ".entry-content > p:first-of-type"
            ]
        },
    "url": "[permalink]"
}',
			'atts'              => [
				'spellcheck'    => 'false',
			]
		];

		$tabs[ 'schema' ][ 'fields' ] = $fields;
		Plugin::set_tabs( $tabs );

	}

}
